/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.internal.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.elements.DomainInheritance;
import org.eclipse.ocl.examples.domain.elements.DomainOperation;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.library.LibraryFeature;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.types.IdResolver;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.validation.ValidationWarning;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.OrderedSetValue;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;
import org.eclipse.ocl.examples.library.classifier.OclTypeConformsToOperation;
import org.eclipse.ocl.examples.library.collection.CollectionSizeOperation;
import org.eclipse.ocl.examples.library.ecore.EcoreExecutorManager;
import org.eclipse.ocl.examples.library.iterator.ClosureIteration;
import org.eclipse.ocl.examples.library.iterator.SortedByIteration;
import org.eclipse.ocl.examples.library.logical.BooleanImpliesOperation;
import org.eclipse.ocl.examples.library.logical.BooleanOrOperation;
import org.eclipse.ocl.examples.library.oclany.OclAnyEqualOperation;
import org.eclipse.ocl.examples.library.oclany.OclAnyOclAsTypeOperation;
import org.eclipse.ocl.examples.library.oclany.OclAnyOclIsKindOfOperation;
import org.eclipse.ocl.examples.library.oclany.OclComparableCompareToOperation;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.IteratorExp;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.PivotTables;
import org.eclipse.ocl.examples.pivot.ReferringElement;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.internal.impl.LoopExpImpl;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.ocl.examples.pivot.util.Visitor;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IteratorExpImpl
extends LoopExpImpl
implements IteratorExp {
    protected IteratorExpImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return PivotPackage.Literals.ITERATOR_EXP;
    }

    @Override
    public boolean validateClosureBodyTypeIsConformanttoIteratorType(DiagnosticChain diagnostics, Map<Object, Object> context) {
        HashMap<TemplateParameter, ParameterableElement> bindings;
        Type iteratorType;
        Type bodyType2;
        if (this.getReferredIteration().getImplementation() != ClosureIteration.INSTANCE) {
            return true;
        }
        ValidationWarning diagnostic = null;
        MetaModelManager metaModelManager = PivotUtil.getMetaModelManager((Resource)DomainUtil.nonNullState((Object)this.eResource()));
        Type bodyType = this.getBody().getType();
        if (bodyType instanceof CollectionType) {
            bodyType = ((CollectionType)bodyType).getElementType();
        }
        if (!metaModelManager.conformsTo(bodyType2 = (Type)DomainUtil.nonNullState((Object)bodyType), iteratorType = (Type)DomainUtil.nonNullState((Object)this.getIterator().get(0).getType()), bindings = new HashMap<TemplateParameter, ParameterableElement>())) {
            if (diagnostics == null) {
                return false;
            }
            diagnostic = new ValidationWarning(OCLMessages.IncompatibleBodyType_WARNING_, new Object[]{bodyType2, iteratorType});
        }
        if (diagnostic == null) {
            return true;
        }
        diagnostics.add(diagnostic);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean validateSortedByIteratorTypeIsComparable(DiagnosticChain diagnostics, Map<Object, Object> context) {
        ValidationWarning diagnostic;
        block10: {
            if (this.getReferredIteration().getImplementation() != SortedByIteration.INSTANCE) {
                return true;
            }
            diagnostic = null;
            MetaModelManager metaModelManager = PivotUtil.getMetaModelManager((Resource)DomainUtil.nonNullState((Object)this.eResource()));
            try {
                DomainInheritance selfType;
                ParameterableElement resolvedTemplateParameter;
                Map<TemplateParameter, ParameterableElement> templateParameterSubstitutions;
                Type type = (Type)DomainUtil.nonNullPivot((Object)this.getBody().getType());
                TemplateParameter templateParameter = type.getOwningTemplateParameter();
                if (templateParameter != null && (templateParameterSubstitutions = PivotUtil.getAllTemplateParameterSubstitutions(null, this.getSource().getType())) != null && (resolvedTemplateParameter = templateParameterSubstitutions.get(templateParameter)) instanceof Type) {
                    type = (Type)resolvedTemplateParameter;
                }
                type = PivotUtil.getType(type);
                DomainInheritance comparableType = metaModelManager.getOclComparableType().getInheritance((DomainStandardLibrary)metaModelManager);
                DomainOperation staticOperation = comparableType.lookupLocalOperation((DomainStandardLibrary)metaModelManager, "compareTo", new DomainInheritance[]{selfType = metaModelManager.getOclSelfType().getInheritance((DomainStandardLibrary)metaModelManager)});
                if (staticOperation == null) {
                    if (diagnostics == null) {
                        return false;
                    }
                    diagnostic = new ValidationWarning(OCLMessages.UnresolvedOperation_ERROR_, new Object[]{"compareTo", String.valueOf(comparableType)});
                    break block10;
                }
                LibraryFeature implementation = type.lookupImplementation((DomainStandardLibrary)metaModelManager, staticOperation);
                if (implementation == OclComparableCompareToOperation.INSTANCE) {
                    if (diagnostics == null) {
                        return false;
                    }
                    diagnostic = new ValidationWarning(OCLMessages.UnresolvedOperation_ERROR_, new Object[]{"compareTo", String.valueOf(type)});
                }
            }
            catch (Exception e) {
                if (diagnostics == null) {
                    return false;
                }
                diagnostic = new ValidationWarning(e.getLocalizedMessage(), new Object[0]);
            }
        }
        if (diagnostic == null) {
            return true;
        }
        diagnostics.add((Diagnostic)diagnostic);
        return false;
    }

    @Override
    public boolean validateAnyHasOneIterator(DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object CAUGHT_implies;
        IteratorExpImpl self = this;
        EcoreExecutorManager evaluator = new EcoreExecutorManager((Object)this, PivotTables.LIBRARY);
        IdResolver idResolver = evaluator.getIdResolver();
        try {
            Object CAUGHT_eq_0;
            Object CAUGHT_eq;
            try {
                String name = self.getName();
                Boolean eq = OclAnyEqualOperation.INSTANCE.evaluate((Object)name, (Object)"any");
                CAUGHT_eq = eq;
            }
            catch (Exception e) {
                CAUGHT_eq = ValuesUtil.createInvalidValue((Exception)e);
            }
            try {
                List<Variable> iterator = self.getIterator();
                OrderedSetValue BOXED_iterator = idResolver.createOrderedSetOfAll(PivotTables.ORD_CLSSid_Variable, iterator);
                IntegerValue size = CollectionSizeOperation.INSTANCE.evaluate((Object)BOXED_iterator);
                Boolean eq_0 = OclAnyEqualOperation.INSTANCE.evaluate((Object)size, (Object)PivotTables.INT_1);
                CAUGHT_eq_0 = eq_0;
            }
            catch (Exception e) {
                CAUGHT_eq_0 = ValuesUtil.createInvalidValue((Exception)e);
            }
            Boolean implies = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_eq, CAUGHT_eq_0);
            CAUGHT_implies = implies;
        }
        catch (Exception e) {
            CAUGHT_implies = ValuesUtil.createInvalidValue((Exception)e);
        }
        if (CAUGHT_implies == ValuesUtil.TRUE_VALUE) {
            return true;
        }
        if (diagnostics != null) {
            int severity = CAUGHT_implies == null ? 4 : 2;
            String message = NLS.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"IteratorExp", "AnyHasOneIterator", EObjectValidator.getObjectLabel((EObject)this, context)});
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.ocl.examples.pivot", 28, message, new Object[]{this}));
        }
        return false;
    }

    @Override
    public boolean validateAnyTypeIsSourceElementType(DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object CAUGHT_implies;
        IteratorExpImpl self = this;
        EcoreExecutorManager evaluator = new EcoreExecutorManager((Object)this, PivotTables.LIBRARY);
        IdResolver idResolver = evaluator.getIdResolver();
        DomainType TYP_pivot_c_c_CollectionType = idResolver.getType((TypeId)PivotTables.CLSSid_CollectionType, null);
        try {
            Object CAUGHT_eq_0;
            Object CAUGHT_eq;
            try {
                String name = self.getName();
                Boolean eq = OclAnyEqualOperation.INSTANCE.evaluate((Object)name, (Object)"any");
                CAUGHT_eq = eq;
            }
            catch (Exception e) {
                CAUGHT_eq = ValuesUtil.createInvalidValue((Exception)e);
            }
            try {
                Type type = self.getType();
                OCLExpression source = self.getSource();
                if (source == null) {
                    throw new InvalidValueException("Null source", new Object[0]);
                }
                DomainType type_0 = source.getType();
                CollectionType oclAsType = (CollectionType)OclAnyOclAsTypeOperation.INSTANCE.evaluate((DomainEvaluator)evaluator, (Object)type_0, (Object)TYP_pivot_c_c_CollectionType);
                if (oclAsType == null) {
                    throw new InvalidValueException("Null source", new Object[0]);
                }
                Type elementType = oclAsType.getElementType();
                Boolean eq_0 = OclAnyEqualOperation.INSTANCE.evaluate((Object)type, (Object)elementType);
                CAUGHT_eq_0 = eq_0;
            }
            catch (Exception e) {
                CAUGHT_eq_0 = ValuesUtil.createInvalidValue((Exception)e);
            }
            Boolean implies = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_eq, CAUGHT_eq_0);
            CAUGHT_implies = implies;
        }
        catch (Exception e) {
            CAUGHT_implies = ValuesUtil.createInvalidValue((Exception)e);
        }
        if (CAUGHT_implies == ValuesUtil.TRUE_VALUE) {
            return true;
        }
        if (diagnostics != null) {
            int severity = CAUGHT_implies == null ? 4 : 2;
            String message = NLS.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"IteratorExp", "AnyTypeIsSourceElementType", EObjectValidator.getObjectLabel((EObject)this, context)});
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.ocl.examples.pivot", 23, message, new Object[]{this}));
        }
        return false;
    }

    @Override
    public boolean validateAnyBodyTypeIsBoolean(DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object CAUGHT_implies;
        IteratorExpImpl self = this;
        try {
            Object CAUGHT_eq_0;
            Object CAUGHT_eq;
            try {
                String name = self.getName();
                Boolean eq = OclAnyEqualOperation.INSTANCE.evaluate((Object)name, (Object)"any");
                CAUGHT_eq = eq;
            }
            catch (Exception e) {
                CAUGHT_eq = ValuesUtil.createInvalidValue((Exception)e);
            }
            try {
                OCLExpression body = self.getBody();
                DomainType type = body.getType();
                Boolean eq_0 = OclAnyEqualOperation.INSTANCE.evaluate((Object)type, (Object)"Boolean");
                CAUGHT_eq_0 = eq_0;
            }
            catch (Exception e) {
                CAUGHT_eq_0 = ValuesUtil.createInvalidValue((Exception)e);
            }
            Boolean implies = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_eq, CAUGHT_eq_0);
            CAUGHT_implies = implies;
        }
        catch (Exception e) {
            CAUGHT_implies = ValuesUtil.createInvalidValue((Exception)e);
        }
        if (CAUGHT_implies == ValuesUtil.TRUE_VALUE) {
            return true;
        }
        if (diagnostics != null) {
            int severity = CAUGHT_implies == null ? 4 : 2;
            String message = NLS.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"IteratorExp", "AnyBodyTypeIsBoolean", EObjectValidator.getObjectLabel((EObject)this, context)});
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.ocl.examples.pivot", 29, message, new Object[]{this}));
        }
        return false;
    }

    @Override
    public boolean validateClosureHasOneIterator(DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object CAUGHT_implies;
        IteratorExpImpl self = this;
        EcoreExecutorManager evaluator = new EcoreExecutorManager((Object)this, PivotTables.LIBRARY);
        IdResolver idResolver = evaluator.getIdResolver();
        try {
            Object CAUGHT_eq_0;
            Object CAUGHT_eq;
            try {
                String name = self.getName();
                Boolean eq = OclAnyEqualOperation.INSTANCE.evaluate((Object)name, (Object)"closure");
                CAUGHT_eq = eq;
            }
            catch (Exception e) {
                CAUGHT_eq = ValuesUtil.createInvalidValue((Exception)e);
            }
            try {
                List<Variable> iterator = self.getIterator();
                OrderedSetValue BOXED_iterator = idResolver.createOrderedSetOfAll(PivotTables.ORD_CLSSid_Variable, iterator);
                IntegerValue size = CollectionSizeOperation.INSTANCE.evaluate((Object)BOXED_iterator);
                Boolean eq_0 = OclAnyEqualOperation.INSTANCE.evaluate((Object)size, (Object)PivotTables.INT_1);
                CAUGHT_eq_0 = eq_0;
            }
            catch (Exception e) {
                CAUGHT_eq_0 = ValuesUtil.createInvalidValue((Exception)e);
            }
            Boolean implies = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_eq, CAUGHT_eq_0);
            CAUGHT_implies = implies;
        }
        catch (Exception e) {
            CAUGHT_implies = ValuesUtil.createInvalidValue((Exception)e);
        }
        if (CAUGHT_implies == ValuesUtil.TRUE_VALUE) {
            return true;
        }
        if (diagnostics != null) {
            int severity = CAUGHT_implies == null ? 4 : 2;
            String message = NLS.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"IteratorExp", "ClosureHasOneIterator", EObjectValidator.getObjectLabel((EObject)this, context)});
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.ocl.examples.pivot", 38, message, new Object[]{this}));
        }
        return false;
    }

    @Override
    public boolean validateClosureTypeIsUniqueCollection(DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object CAUGHT_implies;
        IteratorExpImpl self = this;
        EcoreExecutorManager evaluator = new EcoreExecutorManager((Object)this, PivotTables.LIBRARY);
        IdResolver idResolver = evaluator.getIdResolver();
        DomainType TYP_pivot_c_c_OrderedSetType = idResolver.getType((TypeId)PivotTables.CLSSid_OrderedSetType, null);
        DomainType TYP_pivot_c_c_SequenceType = idResolver.getType((TypeId)PivotTables.CLSSid_SequenceType, null);
        DomainType TYP_pivot_c_c_SetType = idResolver.getType((TypeId)PivotTables.CLSSid_SetType, null);
        try {
            Object CAUGHT_symbol_0;
            Object CAUGHT_eq;
            try {
                String name = self.getName();
                Boolean eq = OclAnyEqualOperation.INSTANCE.evaluate((Object)name, (Object)"closure");
                CAUGHT_eq = eq;
            }
            catch (Exception e) {
                CAUGHT_eq = ValuesUtil.createInvalidValue((Exception)e);
            }
            try {
                Boolean symbol_0;
                Object CAUGHT_oclIsKindOf_0;
                Object CAUGHT_oclIsKindOf;
                try {
                    OCLExpression source = self.getSource();
                    if (source == null) {
                        throw new InvalidValueException("Null source", new Object[0]);
                    }
                    DomainType type = source.getType();
                    Boolean oclIsKindOf = OclAnyOclIsKindOfOperation.INSTANCE.evaluate((DomainEvaluator)evaluator, (Object)type, (Object)TYP_pivot_c_c_SequenceType);
                    CAUGHT_oclIsKindOf = oclIsKindOf;
                }
                catch (Exception e) {
                    CAUGHT_oclIsKindOf = ValuesUtil.createInvalidValue((Exception)e);
                }
                try {
                    OCLExpression source_0 = self.getSource();
                    if (source_0 == null) {
                        throw new InvalidValueException("Null source", new Object[0]);
                    }
                    DomainType type_0 = source_0.getType();
                    Boolean oclIsKindOf_0 = OclAnyOclIsKindOfOperation.INSTANCE.evaluate((DomainEvaluator)evaluator, (Object)type_0, (Object)TYP_pivot_c_c_OrderedSetType);
                    CAUGHT_oclIsKindOf_0 = oclIsKindOf_0;
                }
                catch (Exception e) {
                    CAUGHT_oclIsKindOf_0 = ValuesUtil.createInvalidValue((Exception)e);
                }
                Boolean or = BooleanOrOperation.INSTANCE.evaluate(CAUGHT_oclIsKindOf, CAUGHT_oclIsKindOf_0);
                if (or == null) {
                    throw new InvalidValueException("Null source", new Object[0]);
                }
                if (or.booleanValue()) {
                    Boolean oclIsKindOf_1;
                    Type type_1 = self.getType();
                    symbol_0 = oclIsKindOf_1 = OclAnyOclIsKindOfOperation.INSTANCE.evaluate((DomainEvaluator)evaluator, (Object)type_1, (Object)TYP_pivot_c_c_OrderedSetType);
                } else {
                    Boolean oclIsKindOf_2;
                    Type type_2 = self.getType();
                    symbol_0 = oclIsKindOf_2 = OclAnyOclIsKindOfOperation.INSTANCE.evaluate((DomainEvaluator)evaluator, (Object)type_2, (Object)TYP_pivot_c_c_SetType);
                }
                CAUGHT_symbol_0 = symbol_0;
            }
            catch (Exception e) {
                CAUGHT_symbol_0 = ValuesUtil.createInvalidValue((Exception)e);
            }
            Boolean implies = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_eq, CAUGHT_symbol_0);
            CAUGHT_implies = implies;
        }
        catch (Exception e) {
            CAUGHT_implies = ValuesUtil.createInvalidValue((Exception)e);
        }
        if (CAUGHT_implies == ValuesUtil.TRUE_VALUE) {
            return true;
        }
        if (diagnostics != null) {
            int severity = CAUGHT_implies == null ? 4 : 2;
            String message = NLS.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"IteratorExp", "ClosureTypeIsUniqueCollection", EObjectValidator.getObjectLabel((EObject)this, context)});
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.ocl.examples.pivot", 20, message, new Object[]{this}));
        }
        return false;
    }

    @Override
    public boolean validateClosureSourceElementTypeIsBodyElementType(DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object CAUGHT_implies;
        IteratorExpImpl self = this;
        EcoreExecutorManager evaluator = new EcoreExecutorManager((Object)this, PivotTables.LIBRARY);
        IdResolver idResolver = evaluator.getIdResolver();
        DomainType TYP_pivot_c_c_CollectionType = idResolver.getType((TypeId)PivotTables.CLSSid_CollectionType, null);
        try {
            Object CAUGHT_eq_0;
            Object CAUGHT_eq;
            try {
                String name = self.getName();
                Boolean eq = OclAnyEqualOperation.INSTANCE.evaluate((Object)name, (Object)"closure");
                CAUGHT_eq = eq;
            }
            catch (Exception e) {
                CAUGHT_eq = ValuesUtil.createInvalidValue((Exception)e);
            }
            try {
                DomainType symbol_0;
                OCLExpression source = self.getSource();
                if (source == null) {
                    throw new InvalidValueException("Null source", new Object[0]);
                }
                DomainType type = source.getType();
                CollectionType oclAsType = (CollectionType)OclAnyOclAsTypeOperation.INSTANCE.evaluate((DomainEvaluator)evaluator, (Object)type, (Object)TYP_pivot_c_c_CollectionType);
                if (oclAsType == null) {
                    throw new InvalidValueException("Null source", new Object[0]);
                }
                Type elementType = oclAsType.getElementType();
                OCLExpression body = self.getBody();
                DomainType type_0 = body.getType();
                Boolean oclIsKindOf = OclAnyOclIsKindOfOperation.INSTANCE.evaluate((DomainEvaluator)evaluator, (Object)type_0, (Object)TYP_pivot_c_c_CollectionType);
                if (oclIsKindOf.booleanValue()) {
                    OCLExpression body_0 = self.getBody();
                    DomainType type_1 = body_0.getType();
                    CollectionType oclAsType_0 = (CollectionType)OclAnyOclAsTypeOperation.INSTANCE.evaluate((DomainEvaluator)evaluator, (Object)type_1, (Object)TYP_pivot_c_c_CollectionType);
                    if (oclAsType_0 == null) {
                        throw new InvalidValueException("Null source", new Object[0]);
                    }
                    Type elementType_0 = oclAsType_0.getElementType();
                    symbol_0 = elementType_0;
                } else {
                    DomainType type_2;
                    OCLExpression body_1 = self.getBody();
                    symbol_0 = type_2 = body_1.getType();
                }
                Boolean eq_0 = OclAnyEqualOperation.INSTANCE.evaluate((Object)elementType, (Object)symbol_0);
                CAUGHT_eq_0 = eq_0;
            }
            catch (Exception e) {
                CAUGHT_eq_0 = ValuesUtil.createInvalidValue((Exception)e);
            }
            Boolean implies = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_eq, CAUGHT_eq_0);
            CAUGHT_implies = implies;
        }
        catch (Exception e) {
            CAUGHT_implies = ValuesUtil.createInvalidValue((Exception)e);
        }
        if (CAUGHT_implies == ValuesUtil.TRUE_VALUE) {
            return true;
        }
        if (diagnostics != null) {
            int severity = CAUGHT_implies == null ? 4 : 2;
            String message = NLS.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"IteratorExp", "ClosureSourceElementTypeIsBodyElementType", EObjectValidator.getObjectLabel((EObject)this, context)});
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.ocl.examples.pivot", 17, message, new Object[]{this}));
        }
        return false;
    }

    @Override
    public boolean validateClosureElementTypeIsSourceElementType(DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object CAUGHT_implies;
        IteratorExpImpl self = this;
        EcoreExecutorManager evaluator = new EcoreExecutorManager((Object)this, PivotTables.LIBRARY);
        IdResolver idResolver = evaluator.getIdResolver();
        DomainType TYP_pivot_c_c_CollectionType = idResolver.getType((TypeId)PivotTables.CLSSid_CollectionType, null);
        try {
            Object CAUGHT_eq_0;
            Object CAUGHT_eq;
            try {
                String name = self.getName();
                Boolean eq = OclAnyEqualOperation.INSTANCE.evaluate((Object)name, (Object)"closure");
                CAUGHT_eq = eq;
            }
            catch (Exception e) {
                CAUGHT_eq = ValuesUtil.createInvalidValue((Exception)e);
            }
            try {
                Type type = self.getType();
                CollectionType oclAsType = (CollectionType)OclAnyOclAsTypeOperation.INSTANCE.evaluate((DomainEvaluator)evaluator, (Object)type, (Object)TYP_pivot_c_c_CollectionType);
                if (oclAsType == null) {
                    throw new InvalidValueException("Null source", new Object[0]);
                }
                Type elementType = oclAsType.getElementType();
                OCLExpression source = self.getSource();
                if (source == null) {
                    throw new InvalidValueException("Null source", new Object[0]);
                }
                DomainType type_0 = source.getType();
                CollectionType oclAsType_0 = (CollectionType)OclAnyOclAsTypeOperation.INSTANCE.evaluate((DomainEvaluator)evaluator, (Object)type_0, (Object)TYP_pivot_c_c_CollectionType);
                if (oclAsType_0 == null) {
                    throw new InvalidValueException("Null source", new Object[0]);
                }
                Type elementType_0 = oclAsType_0.getElementType();
                Boolean eq_0 = OclAnyEqualOperation.INSTANCE.evaluate((Object)elementType, (Object)elementType_0);
                CAUGHT_eq_0 = eq_0;
            }
            catch (Exception e) {
                CAUGHT_eq_0 = ValuesUtil.createInvalidValue((Exception)e);
            }
            Boolean implies = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_eq, CAUGHT_eq_0);
            CAUGHT_implies = implies;
        }
        catch (Exception e) {
            CAUGHT_implies = ValuesUtil.createInvalidValue((Exception)e);
        }
        if (CAUGHT_implies == ValuesUtil.TRUE_VALUE) {
            return true;
        }
        if (diagnostics != null) {
            int severity = CAUGHT_implies == null ? 4 : 2;
            String message = NLS.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"IteratorExp", "ClosureElementTypeIsSourceElementType", EObjectValidator.getObjectLabel((EObject)this, context)});
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.ocl.examples.pivot", 36, message, new Object[]{this}));
        }
        return false;
    }

    @Override
    public boolean validateCollectHasOneIterator(DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object CAUGHT_implies;
        IteratorExpImpl self = this;
        EcoreExecutorManager evaluator = new EcoreExecutorManager((Object)this, PivotTables.LIBRARY);
        IdResolver idResolver = evaluator.getIdResolver();
        try {
            Object CAUGHT_eq_0;
            Object CAUGHT_eq;
            try {
                String name = self.getName();
                Boolean eq = OclAnyEqualOperation.INSTANCE.evaluate((Object)name, (Object)"collect");
                CAUGHT_eq = eq;
            }
            catch (Exception e) {
                CAUGHT_eq = ValuesUtil.createInvalidValue((Exception)e);
            }
            try {
                List<Variable> iterator = self.getIterator();
                OrderedSetValue BOXED_iterator = idResolver.createOrderedSetOfAll(PivotTables.ORD_CLSSid_Variable, iterator);
                IntegerValue size = CollectionSizeOperation.INSTANCE.evaluate((Object)BOXED_iterator);
                Boolean eq_0 = OclAnyEqualOperation.INSTANCE.evaluate((Object)size, (Object)PivotTables.INT_1);
                CAUGHT_eq_0 = eq_0;
            }
            catch (Exception e) {
                CAUGHT_eq_0 = ValuesUtil.createInvalidValue((Exception)e);
            }
            Boolean implies = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_eq, CAUGHT_eq_0);
            CAUGHT_implies = implies;
        }
        catch (Exception e) {
            CAUGHT_implies = ValuesUtil.createInvalidValue((Exception)e);
        }
        if (CAUGHT_implies == ValuesUtil.TRUE_VALUE) {
            return true;
        }
        if (diagnostics != null) {
            int severity = CAUGHT_implies == null ? 4 : 2;
            String message = NLS.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"IteratorExp", "CollectHasOneIterator", EObjectValidator.getObjectLabel((EObject)this, context)});
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.ocl.examples.pivot", 35, message, new Object[]{this}));
        }
        return false;
    }

    @Override
    public boolean validateCollectTypeIsUnordered(DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object CAUGHT_implies;
        IteratorExpImpl self = this;
        EcoreExecutorManager evaluator = new EcoreExecutorManager((Object)this, PivotTables.LIBRARY);
        IdResolver idResolver = evaluator.getIdResolver();
        DomainType TYP_pivot_c_c_BagType = idResolver.getType((TypeId)PivotTables.CLSSid_BagType, null);
        DomainType TYP_pivot_c_c_OrderedSetType = idResolver.getType((TypeId)PivotTables.CLSSid_OrderedSetType, null);
        DomainType TYP_pivot_c_c_SequenceType = idResolver.getType((TypeId)PivotTables.CLSSid_SequenceType, null);
        try {
            Object CAUGHT_symbol_0;
            Object CAUGHT_eq;
            try {
                String name = self.getName();
                Boolean eq = OclAnyEqualOperation.INSTANCE.evaluate((Object)name, (Object)"collect");
                CAUGHT_eq = eq;
            }
            catch (Exception e) {
                CAUGHT_eq = ValuesUtil.createInvalidValue((Exception)e);
            }
            try {
                Boolean symbol_0;
                Object CAUGHT_oclIsKindOf_0;
                Object CAUGHT_oclIsKindOf;
                try {
                    OCLExpression source = self.getSource();
                    if (source == null) {
                        throw new InvalidValueException("Null source", new Object[0]);
                    }
                    DomainType type = source.getType();
                    Boolean oclIsKindOf = OclAnyOclIsKindOfOperation.INSTANCE.evaluate((DomainEvaluator)evaluator, (Object)type, (Object)TYP_pivot_c_c_SequenceType);
                    CAUGHT_oclIsKindOf = oclIsKindOf;
                }
                catch (Exception e) {
                    CAUGHT_oclIsKindOf = ValuesUtil.createInvalidValue((Exception)e);
                }
                try {
                    OCLExpression source_0 = self.getSource();
                    if (source_0 == null) {
                        throw new InvalidValueException("Null source", new Object[0]);
                    }
                    DomainType type_0 = source_0.getType();
                    Boolean oclIsKindOf_0 = OclAnyOclIsKindOfOperation.INSTANCE.evaluate((DomainEvaluator)evaluator, (Object)type_0, (Object)TYP_pivot_c_c_OrderedSetType);
                    CAUGHT_oclIsKindOf_0 = oclIsKindOf_0;
                }
                catch (Exception e) {
                    CAUGHT_oclIsKindOf_0 = ValuesUtil.createInvalidValue((Exception)e);
                }
                Boolean or = BooleanOrOperation.INSTANCE.evaluate(CAUGHT_oclIsKindOf, CAUGHT_oclIsKindOf_0);
                if (or == null) {
                    throw new InvalidValueException("Null source", new Object[0]);
                }
                if (or.booleanValue()) {
                    Boolean oclIsKindOf_1;
                    Type type_1 = self.getType();
                    symbol_0 = oclIsKindOf_1 = OclAnyOclIsKindOfOperation.INSTANCE.evaluate((DomainEvaluator)evaluator, (Object)type_1, (Object)TYP_pivot_c_c_SequenceType);
                } else {
                    Boolean oclIsKindOf_2;
                    Type type_2 = self.getType();
                    symbol_0 = oclIsKindOf_2 = OclAnyOclIsKindOfOperation.INSTANCE.evaluate((DomainEvaluator)evaluator, (Object)type_2, (Object)TYP_pivot_c_c_BagType);
                }
                CAUGHT_symbol_0 = symbol_0;
            }
            catch (Exception e) {
                CAUGHT_symbol_0 = ValuesUtil.createInvalidValue((Exception)e);
            }
            Boolean implies = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_eq, CAUGHT_symbol_0);
            CAUGHT_implies = implies;
        }
        catch (Exception e) {
            CAUGHT_implies = ValuesUtil.createInvalidValue((Exception)e);
        }
        if (CAUGHT_implies == ValuesUtil.TRUE_VALUE) {
            return true;
        }
        if (diagnostics != null) {
            int severity = CAUGHT_implies == null ? 4 : 2;
            String message = NLS.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"IteratorExp", "CollectTypeIsUnordered", EObjectValidator.getObjectLabel((EObject)this, context)});
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.ocl.examples.pivot", 19, message, new Object[]{this}));
        }
        return false;
    }

    @Override
    public boolean validateCollectElementTypeIsSourceElementType(DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object CAUGHT_implies;
        IteratorExpImpl self = this;
        EcoreExecutorManager evaluator = new EcoreExecutorManager((Object)this, PivotTables.LIBRARY);
        IdResolver idResolver = evaluator.getIdResolver();
        DomainType TYP_pivot_c_c_CollectionType = idResolver.getType((TypeId)PivotTables.CLSSid_CollectionType, null);
        try {
            Object CAUGHT_eq_0;
            Object CAUGHT_eq;
            try {
                String name = self.getName();
                Boolean eq = OclAnyEqualOperation.INSTANCE.evaluate((Object)name, (Object)"collect");
                CAUGHT_eq = eq;
            }
            catch (Exception e) {
                CAUGHT_eq = ValuesUtil.createInvalidValue((Exception)e);
            }
            try {
                Type type = self.getType();
                CollectionType oclAsType = (CollectionType)OclAnyOclAsTypeOperation.INSTANCE.evaluate((DomainEvaluator)evaluator, (Object)type, (Object)TYP_pivot_c_c_CollectionType);
                if (oclAsType == null) {
                    throw new InvalidValueException("Null source", new Object[0]);
                }
                Type elementType = oclAsType.getElementType();
                OCLExpression body = self.getBody();
                DomainType type_0 = body.getType();
                CollectionType oclAsType_0 = (CollectionType)OclAnyOclAsTypeOperation.INSTANCE.evaluate((DomainEvaluator)evaluator, (Object)type_0, (Object)TYP_pivot_c_c_CollectionType);
                if (oclAsType_0 == null) {
                    throw new InvalidValueException("Null source", new Object[0]);
                }
                Type elementType_0 = oclAsType_0.getElementType();
                Boolean eq_0 = OclAnyEqualOperation.INSTANCE.evaluate((Object)elementType, (Object)elementType_0);
                CAUGHT_eq_0 = eq_0;
            }
            catch (Exception e) {
                CAUGHT_eq_0 = ValuesUtil.createInvalidValue((Exception)e);
            }
            Boolean implies = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_eq, CAUGHT_eq_0);
            CAUGHT_implies = implies;
        }
        catch (Exception e) {
            CAUGHT_implies = ValuesUtil.createInvalidValue((Exception)e);
        }
        if (CAUGHT_implies == ValuesUtil.TRUE_VALUE) {
            return true;
        }
        if (diagnostics != null) {
            int severity = CAUGHT_implies == null ? 4 : 2;
            String message = NLS.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"IteratorExp", "CollectElementTypeIsSourceElementType", EObjectValidator.getObjectLabel((EObject)this, context)});
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.ocl.examples.pivot", 37, message, new Object[]{this}));
        }
        return false;
    }

    @Override
    public boolean validateCollectNestedHasOneIterator(DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object CAUGHT_implies;
        IteratorExpImpl self = this;
        EcoreExecutorManager evaluator = new EcoreExecutorManager((Object)this, PivotTables.LIBRARY);
        IdResolver idResolver = evaluator.getIdResolver();
        try {
            Object CAUGHT_eq_0;
            Object CAUGHT_eq;
            try {
                String name = self.getName();
                Boolean eq = OclAnyEqualOperation.INSTANCE.evaluate((Object)name, (Object)"collectNested");
                CAUGHT_eq = eq;
            }
            catch (Exception e) {
                CAUGHT_eq = ValuesUtil.createInvalidValue((Exception)e);
            }
            try {
                List<Variable> iterator = self.getIterator();
                OrderedSetValue BOXED_iterator = idResolver.createOrderedSetOfAll(PivotTables.ORD_CLSSid_Variable, iterator);
                IntegerValue size = CollectionSizeOperation.INSTANCE.evaluate((Object)BOXED_iterator);
                Boolean eq_0 = OclAnyEqualOperation.INSTANCE.evaluate((Object)size, (Object)PivotTables.INT_1);
                CAUGHT_eq_0 = eq_0;
            }
            catch (Exception e) {
                CAUGHT_eq_0 = ValuesUtil.createInvalidValue((Exception)e);
            }
            Boolean implies = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_eq, CAUGHT_eq_0);
            CAUGHT_implies = implies;
        }
        catch (Exception e) {
            CAUGHT_implies = ValuesUtil.createInvalidValue((Exception)e);
        }
        if (CAUGHT_implies == ValuesUtil.TRUE_VALUE) {
            return true;
        }
        if (diagnostics != null) {
            int severity = CAUGHT_implies == null ? 4 : 2;
            String message = NLS.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"IteratorExp", "CollectNestedHasOneIterator", EObjectValidator.getObjectLabel((EObject)this, context)});
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.ocl.examples.pivot", 16, message, new Object[]{this}));
        }
        return false;
    }

    @Override
    public boolean validateCollectNestedTypeIsBag(DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object CAUGHT_implies;
        IteratorExpImpl self = this;
        EcoreExecutorManager evaluator = new EcoreExecutorManager((Object)this, PivotTables.LIBRARY);
        IdResolver idResolver = evaluator.getIdResolver();
        DomainType TYP_pivot_c_c_BagType = idResolver.getType((TypeId)PivotTables.CLSSid_BagType, null);
        try {
            Object CAUGHT_oclIsKindOf;
            Object CAUGHT_eq;
            try {
                String name = self.getName();
                Boolean eq = OclAnyEqualOperation.INSTANCE.evaluate((Object)name, (Object)"collectNested");
                CAUGHT_eq = eq;
            }
            catch (Exception e) {
                CAUGHT_eq = ValuesUtil.createInvalidValue((Exception)e);
            }
            try {
                Type type = self.getType();
                Boolean oclIsKindOf = OclAnyOclIsKindOfOperation.INSTANCE.evaluate((DomainEvaluator)evaluator, (Object)type, (Object)TYP_pivot_c_c_BagType);
                CAUGHT_oclIsKindOf = oclIsKindOf;
            }
            catch (Exception e) {
                CAUGHT_oclIsKindOf = ValuesUtil.createInvalidValue((Exception)e);
            }
            Boolean implies = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_eq, CAUGHT_oclIsKindOf);
            CAUGHT_implies = implies;
        }
        catch (Exception e) {
            CAUGHT_implies = ValuesUtil.createInvalidValue((Exception)e);
        }
        if (CAUGHT_implies == ValuesUtil.TRUE_VALUE) {
            return true;
        }
        if (diagnostics != null) {
            int severity = CAUGHT_implies == null ? 4 : 2;
            String message = NLS.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"IteratorExp", "CollectNestedTypeIsBag", EObjectValidator.getObjectLabel((EObject)this, context)});
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.ocl.examples.pivot", 27, message, new Object[]{this}));
        }
        return false;
    }

    @Override
    public boolean validateCollectNestedTypeIsBodyType(DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object CAUGHT_implies;
        IteratorExpImpl self = this;
        try {
            Object CAUGHT_eq_0;
            Object CAUGHT_eq;
            try {
                String name = self.getName();
                Boolean eq = OclAnyEqualOperation.INSTANCE.evaluate((Object)name, (Object)"collectNested");
                CAUGHT_eq = eq;
            }
            catch (Exception e) {
                CAUGHT_eq = ValuesUtil.createInvalidValue((Exception)e);
            }
            try {
                Type type = self.getType();
                OCLExpression body = self.getBody();
                DomainType type_0 = body.getType();
                Boolean eq_0 = OclAnyEqualOperation.INSTANCE.evaluate((Object)type, (Object)type_0);
                CAUGHT_eq_0 = eq_0;
            }
            catch (Exception e) {
                CAUGHT_eq_0 = ValuesUtil.createInvalidValue((Exception)e);
            }
            Boolean implies = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_eq, CAUGHT_eq_0);
            CAUGHT_implies = implies;
        }
        catch (Exception e) {
            CAUGHT_implies = ValuesUtil.createInvalidValue((Exception)e);
        }
        if (CAUGHT_implies == ValuesUtil.TRUE_VALUE) {
            return true;
        }
        if (diagnostics != null) {
            int severity = CAUGHT_implies == null ? 4 : 2;
            String message = NLS.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"IteratorExp", "CollectNestedTypeIsBodyType", EObjectValidator.getObjectLabel((EObject)this, context)});
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.ocl.examples.pivot", 41, message, new Object[]{this}));
        }
        return false;
    }

    @Override
    public boolean validateExistsTypeIsBoolean(DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object CAUGHT_implies;
        IteratorExpImpl self = this;
        EcoreExecutorManager evaluator = new EcoreExecutorManager((Object)this, PivotTables.LIBRARY);
        IdResolver idResolver = evaluator.getIdResolver();
        DomainType TYP_Boolean = idResolver.getType((TypeId)TypeId.BOOLEAN, null);
        try {
            Object CAUGHT_eq_0;
            Object CAUGHT_eq;
            try {
                String name = self.getName();
                Boolean eq = OclAnyEqualOperation.INSTANCE.evaluate((Object)name, (Object)"exists");
                CAUGHT_eq = eq;
            }
            catch (Exception e) {
                CAUGHT_eq = ValuesUtil.createInvalidValue((Exception)e);
            }
            try {
                Type type = self.getType();
                Boolean eq_0 = OclAnyEqualOperation.INSTANCE.evaluate((Object)type, (Object)TYP_Boolean);
                CAUGHT_eq_0 = eq_0;
            }
            catch (Exception e) {
                CAUGHT_eq_0 = ValuesUtil.createInvalidValue((Exception)e);
            }
            Boolean implies = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_eq, CAUGHT_eq_0);
            CAUGHT_implies = implies;
        }
        catch (Exception e) {
            CAUGHT_implies = ValuesUtil.createInvalidValue((Exception)e);
        }
        if (CAUGHT_implies == ValuesUtil.TRUE_VALUE) {
            return true;
        }
        if (diagnostics != null) {
            int severity = CAUGHT_implies == null ? 4 : 2;
            String message = NLS.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"IteratorExp", "ExistsTypeIsBoolean", EObjectValidator.getObjectLabel((EObject)this, context)});
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.ocl.examples.pivot", 18, message, new Object[]{this}));
        }
        return false;
    }

    @Override
    public boolean validateExistsBodyTypeIsBoolean(DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object CAUGHT_implies;
        IteratorExpImpl self = this;
        EcoreExecutorManager evaluator = new EcoreExecutorManager((Object)this, PivotTables.LIBRARY);
        IdResolver idResolver = evaluator.getIdResolver();
        DomainType TYP_Boolean = idResolver.getType((TypeId)TypeId.BOOLEAN, null);
        try {
            Object CAUGHT_eq_0;
            Object CAUGHT_eq;
            try {
                String name = self.getName();
                Boolean eq = OclAnyEqualOperation.INSTANCE.evaluate((Object)name, (Object)"exists");
                CAUGHT_eq = eq;
            }
            catch (Exception e) {
                CAUGHT_eq = ValuesUtil.createInvalidValue((Exception)e);
            }
            try {
                OCLExpression body = self.getBody();
                DomainType type = body.getType();
                Boolean eq_0 = OclAnyEqualOperation.INSTANCE.evaluate((Object)type, (Object)TYP_Boolean);
                CAUGHT_eq_0 = eq_0;
            }
            catch (Exception e) {
                CAUGHT_eq_0 = ValuesUtil.createInvalidValue((Exception)e);
            }
            Boolean implies = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_eq, CAUGHT_eq_0);
            CAUGHT_implies = implies;
        }
        catch (Exception e) {
            CAUGHT_implies = ValuesUtil.createInvalidValue((Exception)e);
        }
        if (CAUGHT_implies == ValuesUtil.TRUE_VALUE) {
            return true;
        }
        if (diagnostics != null) {
            int severity = CAUGHT_implies == null ? 4 : 2;
            String message = NLS.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"IteratorExp", "ExistsBodyTypeIsBoolean", EObjectValidator.getObjectLabel((EObject)this, context)});
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.ocl.examples.pivot", 15, message, new Object[]{this}));
        }
        return false;
    }

    @Override
    public boolean validateForAllTypeIsBoolean(DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object CAUGHT_implies;
        IteratorExpImpl self = this;
        EcoreExecutorManager evaluator = new EcoreExecutorManager((Object)this, PivotTables.LIBRARY);
        IdResolver idResolver = evaluator.getIdResolver();
        DomainType TYP_Boolean = idResolver.getType((TypeId)TypeId.BOOLEAN, null);
        try {
            Object CAUGHT_eq_0;
            Object CAUGHT_eq;
            try {
                String name = self.getName();
                Boolean eq = OclAnyEqualOperation.INSTANCE.evaluate((Object)name, (Object)"forAll");
                CAUGHT_eq = eq;
            }
            catch (Exception e) {
                CAUGHT_eq = ValuesUtil.createInvalidValue((Exception)e);
            }
            try {
                Type type = self.getType();
                Boolean eq_0 = OclAnyEqualOperation.INSTANCE.evaluate((Object)type, (Object)TYP_Boolean);
                CAUGHT_eq_0 = eq_0;
            }
            catch (Exception e) {
                CAUGHT_eq_0 = ValuesUtil.createInvalidValue((Exception)e);
            }
            Boolean implies = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_eq, CAUGHT_eq_0);
            CAUGHT_implies = implies;
        }
        catch (Exception e) {
            CAUGHT_implies = ValuesUtil.createInvalidValue((Exception)e);
        }
        if (CAUGHT_implies == ValuesUtil.TRUE_VALUE) {
            return true;
        }
        if (diagnostics != null) {
            int severity = CAUGHT_implies == null ? 4 : 2;
            String message = NLS.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"IteratorExp", "ForAllTypeIsBoolean", EObjectValidator.getObjectLabel((EObject)this, context)});
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.ocl.examples.pivot", 34, message, new Object[]{this}));
        }
        return false;
    }

    @Override
    public boolean validateForAllBodyTypeIsBoolean(DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object CAUGHT_implies;
        IteratorExpImpl self = this;
        EcoreExecutorManager evaluator = new EcoreExecutorManager((Object)this, PivotTables.LIBRARY);
        IdResolver idResolver = evaluator.getIdResolver();
        DomainType TYP_Boolean = idResolver.getType((TypeId)TypeId.BOOLEAN, null);
        try {
            Object CAUGHT_eq_0;
            Object CAUGHT_eq;
            try {
                String name = self.getName();
                Boolean eq = OclAnyEqualOperation.INSTANCE.evaluate((Object)name, (Object)"forAll");
                CAUGHT_eq = eq;
            }
            catch (Exception e) {
                CAUGHT_eq = ValuesUtil.createInvalidValue((Exception)e);
            }
            try {
                OCLExpression body = self.getBody();
                DomainType type = body.getType();
                Boolean eq_0 = OclAnyEqualOperation.INSTANCE.evaluate((Object)type, (Object)TYP_Boolean);
                CAUGHT_eq_0 = eq_0;
            }
            catch (Exception e) {
                CAUGHT_eq_0 = ValuesUtil.createInvalidValue((Exception)e);
            }
            Boolean implies = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_eq, CAUGHT_eq_0);
            CAUGHT_implies = implies;
        }
        catch (Exception e) {
            CAUGHT_implies = ValuesUtil.createInvalidValue((Exception)e);
        }
        if (CAUGHT_implies == ValuesUtil.TRUE_VALUE) {
            return true;
        }
        if (diagnostics != null) {
            int severity = CAUGHT_implies == null ? 4 : 2;
            String message = NLS.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"IteratorExp", "ForAllBodyTypeIsBoolean", EObjectValidator.getObjectLabel((EObject)this, context)});
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.ocl.examples.pivot", 44, message, new Object[]{this}));
        }
        return false;
    }

    @Override
    public boolean validateIsUniqueHasOneIterator(DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object CAUGHT_implies;
        IteratorExpImpl self = this;
        EcoreExecutorManager evaluator = new EcoreExecutorManager((Object)this, PivotTables.LIBRARY);
        IdResolver idResolver = evaluator.getIdResolver();
        try {
            Object CAUGHT_eq_0;
            Object CAUGHT_eq;
            try {
                String name = self.getName();
                Boolean eq = OclAnyEqualOperation.INSTANCE.evaluate((Object)name, (Object)"isUnique");
                CAUGHT_eq = eq;
            }
            catch (Exception e) {
                CAUGHT_eq = ValuesUtil.createInvalidValue((Exception)e);
            }
            try {
                List<Variable> iterator = self.getIterator();
                OrderedSetValue BOXED_iterator = idResolver.createOrderedSetOfAll(PivotTables.ORD_CLSSid_Variable, iterator);
                IntegerValue size = CollectionSizeOperation.INSTANCE.evaluate((Object)BOXED_iterator);
                Boolean eq_0 = OclAnyEqualOperation.INSTANCE.evaluate((Object)size, (Object)PivotTables.INT_1);
                CAUGHT_eq_0 = eq_0;
            }
            catch (Exception e) {
                CAUGHT_eq_0 = ValuesUtil.createInvalidValue((Exception)e);
            }
            Boolean implies = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_eq, CAUGHT_eq_0);
            CAUGHT_implies = implies;
        }
        catch (Exception e) {
            CAUGHT_implies = ValuesUtil.createInvalidValue((Exception)e);
        }
        if (CAUGHT_implies == ValuesUtil.TRUE_VALUE) {
            return true;
        }
        if (diagnostics != null) {
            int severity = CAUGHT_implies == null ? 4 : 2;
            String message = NLS.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"IteratorExp", "IsUniqueHasOneIterator", EObjectValidator.getObjectLabel((EObject)this, context)});
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.ocl.examples.pivot", 42, message, new Object[]{this}));
        }
        return false;
    }

    @Override
    public boolean validateIsUniqueTypeIsBoolean(DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object CAUGHT_implies;
        IteratorExpImpl self = this;
        EcoreExecutorManager evaluator = new EcoreExecutorManager((Object)this, PivotTables.LIBRARY);
        IdResolver idResolver = evaluator.getIdResolver();
        DomainType TYP_Boolean = idResolver.getType((TypeId)TypeId.BOOLEAN, null);
        try {
            Object CAUGHT_eq_0;
            Object CAUGHT_eq;
            try {
                String name = self.getName();
                Boolean eq = OclAnyEqualOperation.INSTANCE.evaluate((Object)name, (Object)"isUnique");
                CAUGHT_eq = eq;
            }
            catch (Exception e) {
                CAUGHT_eq = ValuesUtil.createInvalidValue((Exception)e);
            }
            try {
                Type type = self.getType();
                Boolean eq_0 = OclAnyEqualOperation.INSTANCE.evaluate((Object)type, (Object)TYP_Boolean);
                CAUGHT_eq_0 = eq_0;
            }
            catch (Exception e) {
                CAUGHT_eq_0 = ValuesUtil.createInvalidValue((Exception)e);
            }
            Boolean implies = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_eq, CAUGHT_eq_0);
            CAUGHT_implies = implies;
        }
        catch (Exception e) {
            CAUGHT_implies = ValuesUtil.createInvalidValue((Exception)e);
        }
        if (CAUGHT_implies == ValuesUtil.TRUE_VALUE) {
            return true;
        }
        if (diagnostics != null) {
            int severity = CAUGHT_implies == null ? 4 : 2;
            String message = NLS.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"IteratorExp", "IsUniqueTypeIsBoolean", EObjectValidator.getObjectLabel((EObject)this, context)});
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.ocl.examples.pivot", 45, message, new Object[]{this}));
        }
        return false;
    }

    @Override
    public boolean validateOneHasOneIterator(DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object CAUGHT_implies;
        IteratorExpImpl self = this;
        EcoreExecutorManager evaluator = new EcoreExecutorManager((Object)this, PivotTables.LIBRARY);
        IdResolver idResolver = evaluator.getIdResolver();
        try {
            Object CAUGHT_eq_0;
            Object CAUGHT_eq;
            try {
                String name = self.getName();
                Boolean eq = OclAnyEqualOperation.INSTANCE.evaluate((Object)name, (Object)"one");
                CAUGHT_eq = eq;
            }
            catch (Exception e) {
                CAUGHT_eq = ValuesUtil.createInvalidValue((Exception)e);
            }
            try {
                List<Variable> iterator = self.getIterator();
                OrderedSetValue BOXED_iterator = idResolver.createOrderedSetOfAll(PivotTables.ORD_CLSSid_Variable, iterator);
                IntegerValue size = CollectionSizeOperation.INSTANCE.evaluate((Object)BOXED_iterator);
                Boolean eq_0 = OclAnyEqualOperation.INSTANCE.evaluate((Object)size, (Object)PivotTables.INT_1);
                CAUGHT_eq_0 = eq_0;
            }
            catch (Exception e) {
                CAUGHT_eq_0 = ValuesUtil.createInvalidValue((Exception)e);
            }
            Boolean implies = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_eq, CAUGHT_eq_0);
            CAUGHT_implies = implies;
        }
        catch (Exception e) {
            CAUGHT_implies = ValuesUtil.createInvalidValue((Exception)e);
        }
        if (CAUGHT_implies == ValuesUtil.TRUE_VALUE) {
            return true;
        }
        if (diagnostics != null) {
            int severity = CAUGHT_implies == null ? 4 : 2;
            String message = NLS.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"IteratorExp", "OneHasOneIterator", EObjectValidator.getObjectLabel((EObject)this, context)});
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.ocl.examples.pivot", 31, message, new Object[]{this}));
        }
        return false;
    }

    @Override
    public boolean validateOneTypeIsBoolean(DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object CAUGHT_implies;
        IteratorExpImpl self = this;
        EcoreExecutorManager evaluator = new EcoreExecutorManager((Object)this, PivotTables.LIBRARY);
        IdResolver idResolver = evaluator.getIdResolver();
        DomainType TYP_Boolean = idResolver.getType((TypeId)TypeId.BOOLEAN, null);
        try {
            Object CAUGHT_eq_0;
            Object CAUGHT_eq;
            try {
                String name = self.getName();
                Boolean eq = OclAnyEqualOperation.INSTANCE.evaluate((Object)name, (Object)"one");
                CAUGHT_eq = eq;
            }
            catch (Exception e) {
                CAUGHT_eq = ValuesUtil.createInvalidValue((Exception)e);
            }
            try {
                Type type = self.getType();
                Boolean eq_0 = OclAnyEqualOperation.INSTANCE.evaluate((Object)type, (Object)TYP_Boolean);
                CAUGHT_eq_0 = eq_0;
            }
            catch (Exception e) {
                CAUGHT_eq_0 = ValuesUtil.createInvalidValue((Exception)e);
            }
            Boolean implies = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_eq, CAUGHT_eq_0);
            CAUGHT_implies = implies;
        }
        catch (Exception e) {
            CAUGHT_implies = ValuesUtil.createInvalidValue((Exception)e);
        }
        if (CAUGHT_implies == ValuesUtil.TRUE_VALUE) {
            return true;
        }
        if (diagnostics != null) {
            int severity = CAUGHT_implies == null ? 4 : 2;
            String message = NLS.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"IteratorExp", "OneTypeIsBoolean", EObjectValidator.getObjectLabel((EObject)this, context)});
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.ocl.examples.pivot", 32, message, new Object[]{this}));
        }
        return false;
    }

    @Override
    public boolean validateOneBodyTypeIsBoolean(DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object CAUGHT_implies;
        IteratorExpImpl self = this;
        EcoreExecutorManager evaluator = new EcoreExecutorManager((Object)this, PivotTables.LIBRARY);
        IdResolver idResolver = evaluator.getIdResolver();
        DomainType TYP_Boolean = idResolver.getType((TypeId)TypeId.BOOLEAN, null);
        try {
            Object CAUGHT_eq_0;
            Object CAUGHT_eq;
            try {
                String name = self.getName();
                Boolean eq = OclAnyEqualOperation.INSTANCE.evaluate((Object)name, (Object)"one");
                CAUGHT_eq = eq;
            }
            catch (Exception e) {
                CAUGHT_eq = ValuesUtil.createInvalidValue((Exception)e);
            }
            try {
                OCLExpression body = self.getBody();
                DomainType type = body.getType();
                Boolean eq_0 = OclAnyEqualOperation.INSTANCE.evaluate((Object)type, (Object)TYP_Boolean);
                CAUGHT_eq_0 = eq_0;
            }
            catch (Exception e) {
                CAUGHT_eq_0 = ValuesUtil.createInvalidValue((Exception)e);
            }
            Boolean implies = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_eq, CAUGHT_eq_0);
            CAUGHT_implies = implies;
        }
        catch (Exception e) {
            CAUGHT_implies = ValuesUtil.createInvalidValue((Exception)e);
        }
        if (CAUGHT_implies == ValuesUtil.TRUE_VALUE) {
            return true;
        }
        if (diagnostics != null) {
            int severity = CAUGHT_implies == null ? 4 : 2;
            String message = NLS.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"IteratorExp", "OneBodyTypeIsBoolean", EObjectValidator.getObjectLabel((EObject)this, context)});
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.ocl.examples.pivot", 26, message, new Object[]{this}));
        }
        return false;
    }

    @Override
    public boolean validateRejectOrSelectHasOneIterator(DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object CAUGHT_implies;
        IteratorExpImpl self = this;
        EcoreExecutorManager evaluator = new EcoreExecutorManager((Object)this, PivotTables.LIBRARY);
        IdResolver idResolver = evaluator.getIdResolver();
        try {
            Object CAUGHT_eq_1;
            Object CAUGHT_or;
            try {
                Object CAUGHT_eq_0;
                Object CAUGHT_eq;
                try {
                    String name = self.getName();
                    Boolean eq = OclAnyEqualOperation.INSTANCE.evaluate((Object)name, (Object)"reject");
                    CAUGHT_eq = eq;
                }
                catch (Exception e) {
                    CAUGHT_eq = ValuesUtil.createInvalidValue((Exception)e);
                }
                try {
                    String name_0 = self.getName();
                    Boolean eq_0 = OclAnyEqualOperation.INSTANCE.evaluate((Object)name_0, (Object)"select");
                    CAUGHT_eq_0 = eq_0;
                }
                catch (Exception e) {
                    CAUGHT_eq_0 = ValuesUtil.createInvalidValue((Exception)e);
                }
                Boolean or = BooleanOrOperation.INSTANCE.evaluate(CAUGHT_eq, CAUGHT_eq_0);
                CAUGHT_or = or;
            }
            catch (Exception e) {
                CAUGHT_or = ValuesUtil.createInvalidValue((Exception)e);
            }
            try {
                List<Variable> iterator = self.getIterator();
                OrderedSetValue BOXED_iterator = idResolver.createOrderedSetOfAll(PivotTables.ORD_CLSSid_Variable, iterator);
                IntegerValue size = CollectionSizeOperation.INSTANCE.evaluate((Object)BOXED_iterator);
                Boolean eq_1 = OclAnyEqualOperation.INSTANCE.evaluate((Object)size, (Object)PivotTables.INT_1);
                CAUGHT_eq_1 = eq_1;
            }
            catch (Exception e) {
                CAUGHT_eq_1 = ValuesUtil.createInvalidValue((Exception)e);
            }
            Boolean implies = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_or, CAUGHT_eq_1);
            CAUGHT_implies = implies;
        }
        catch (Exception e) {
            CAUGHT_implies = ValuesUtil.createInvalidValue((Exception)e);
        }
        if (CAUGHT_implies == ValuesUtil.TRUE_VALUE) {
            return true;
        }
        if (diagnostics != null) {
            int severity = CAUGHT_implies == null ? 4 : 2;
            String message = NLS.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"IteratorExp", "RejectOrSelectHasOneIterator", EObjectValidator.getObjectLabel((EObject)this, context)});
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.ocl.examples.pivot", 43, message, new Object[]{this}));
        }
        return false;
    }

    @Override
    public boolean validateRejectOrSelectTypeIsSourceType(DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object CAUGHT_implies;
        IteratorExpImpl self = this;
        try {
            Object CAUGHT_eq_1;
            Object CAUGHT_or;
            try {
                Object CAUGHT_eq_0;
                Object CAUGHT_eq;
                try {
                    String name = self.getName();
                    Boolean eq = OclAnyEqualOperation.INSTANCE.evaluate((Object)name, (Object)"reject");
                    CAUGHT_eq = eq;
                }
                catch (Exception e) {
                    CAUGHT_eq = ValuesUtil.createInvalidValue((Exception)e);
                }
                try {
                    String name_0 = self.getName();
                    Boolean eq_0 = OclAnyEqualOperation.INSTANCE.evaluate((Object)name_0, (Object)"select");
                    CAUGHT_eq_0 = eq_0;
                }
                catch (Exception e) {
                    CAUGHT_eq_0 = ValuesUtil.createInvalidValue((Exception)e);
                }
                Boolean or = BooleanOrOperation.INSTANCE.evaluate(CAUGHT_eq, CAUGHT_eq_0);
                CAUGHT_or = or;
            }
            catch (Exception e) {
                CAUGHT_or = ValuesUtil.createInvalidValue((Exception)e);
            }
            try {
                Type type = self.getType();
                OCLExpression source = self.getSource();
                if (source == null) {
                    throw new InvalidValueException("Null source", new Object[0]);
                }
                DomainType type_0 = source.getType();
                Boolean eq_1 = OclAnyEqualOperation.INSTANCE.evaluate((Object)type, (Object)type_0);
                CAUGHT_eq_1 = eq_1;
            }
            catch (Exception e) {
                CAUGHT_eq_1 = ValuesUtil.createInvalidValue((Exception)e);
            }
            Boolean implies = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_or, CAUGHT_eq_1);
            CAUGHT_implies = implies;
        }
        catch (Exception e) {
            CAUGHT_implies = ValuesUtil.createInvalidValue((Exception)e);
        }
        if (CAUGHT_implies == ValuesUtil.TRUE_VALUE) {
            return true;
        }
        if (diagnostics != null) {
            int severity = CAUGHT_implies == null ? 4 : 2;
            String message = NLS.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"IteratorExp", "RejectOrSelectTypeIsSourceType", EObjectValidator.getObjectLabel((EObject)this, context)});
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.ocl.examples.pivot", 21, message, new Object[]{this}));
        }
        return false;
    }

    @Override
    public boolean validateRejectOrSelectTypeIsBoolean(DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object CAUGHT_implies;
        IteratorExpImpl self = this;
        EcoreExecutorManager evaluator = new EcoreExecutorManager((Object)this, PivotTables.LIBRARY);
        IdResolver idResolver = evaluator.getIdResolver();
        DomainType TYP_Boolean = idResolver.getType((TypeId)TypeId.BOOLEAN, null);
        try {
            Object CAUGHT_eq_1;
            Object CAUGHT_or;
            try {
                Object CAUGHT_eq_0;
                Object CAUGHT_eq;
                try {
                    String name = self.getName();
                    Boolean eq = OclAnyEqualOperation.INSTANCE.evaluate((Object)name, (Object)"reject");
                    CAUGHT_eq = eq;
                }
                catch (Exception e) {
                    CAUGHT_eq = ValuesUtil.createInvalidValue((Exception)e);
                }
                try {
                    String name_0 = self.getName();
                    Boolean eq_0 = OclAnyEqualOperation.INSTANCE.evaluate((Object)name_0, (Object)"select");
                    CAUGHT_eq_0 = eq_0;
                }
                catch (Exception e) {
                    CAUGHT_eq_0 = ValuesUtil.createInvalidValue((Exception)e);
                }
                Boolean or = BooleanOrOperation.INSTANCE.evaluate(CAUGHT_eq, CAUGHT_eq_0);
                CAUGHT_or = or;
            }
            catch (Exception e) {
                CAUGHT_or = ValuesUtil.createInvalidValue((Exception)e);
            }
            try {
                Type type = self.getType();
                Boolean eq_1 = OclAnyEqualOperation.INSTANCE.evaluate((Object)type, (Object)TYP_Boolean);
                CAUGHT_eq_1 = eq_1;
            }
            catch (Exception e) {
                CAUGHT_eq_1 = ValuesUtil.createInvalidValue((Exception)e);
            }
            Boolean implies = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_or, CAUGHT_eq_1);
            CAUGHT_implies = implies;
        }
        catch (Exception e) {
            CAUGHT_implies = ValuesUtil.createInvalidValue((Exception)e);
        }
        if (CAUGHT_implies == ValuesUtil.TRUE_VALUE) {
            return true;
        }
        if (diagnostics != null) {
            int severity = CAUGHT_implies == null ? 4 : 2;
            String message = NLS.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"IteratorExp", "RejectOrSelectTypeIsBoolean", EObjectValidator.getObjectLabel((EObject)this, context)});
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.ocl.examples.pivot", 30, message, new Object[]{this}));
        }
        return false;
    }

    @Override
    public boolean validateSortedByHasOneIterator(DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object CAUGHT_implies;
        IteratorExpImpl self = this;
        EcoreExecutorManager evaluator = new EcoreExecutorManager((Object)this, PivotTables.LIBRARY);
        IdResolver idResolver = evaluator.getIdResolver();
        try {
            Object CAUGHT_eq_0;
            Object CAUGHT_eq;
            try {
                String name = self.getName();
                Boolean eq = OclAnyEqualOperation.INSTANCE.evaluate((Object)name, (Object)"sortedBy");
                CAUGHT_eq = eq;
            }
            catch (Exception e) {
                CAUGHT_eq = ValuesUtil.createInvalidValue((Exception)e);
            }
            try {
                List<Variable> iterator = self.getIterator();
                OrderedSetValue BOXED_iterator = idResolver.createOrderedSetOfAll(PivotTables.ORD_CLSSid_Variable, iterator);
                IntegerValue size = CollectionSizeOperation.INSTANCE.evaluate((Object)BOXED_iterator);
                Boolean eq_0 = OclAnyEqualOperation.INSTANCE.evaluate((Object)size, (Object)PivotTables.INT_1);
                CAUGHT_eq_0 = eq_0;
            }
            catch (Exception e) {
                CAUGHT_eq_0 = ValuesUtil.createInvalidValue((Exception)e);
            }
            Boolean implies = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_eq, CAUGHT_eq_0);
            CAUGHT_implies = implies;
        }
        catch (Exception e) {
            CAUGHT_implies = ValuesUtil.createInvalidValue((Exception)e);
        }
        if (CAUGHT_implies == ValuesUtil.TRUE_VALUE) {
            return true;
        }
        if (diagnostics != null) {
            int severity = CAUGHT_implies == null ? 4 : 2;
            String message = NLS.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"IteratorExp", "SortedByHasOneIterator", EObjectValidator.getObjectLabel((EObject)this, context)});
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.ocl.examples.pivot", 24, message, new Object[]{this}));
        }
        return false;
    }

    @Override
    public boolean validateSortedByIsOrderedIfSourceIsOrdered(DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object CAUGHT_implies;
        IteratorExpImpl self = this;
        EcoreExecutorManager evaluator = new EcoreExecutorManager((Object)this, PivotTables.LIBRARY);
        IdResolver idResolver = evaluator.getIdResolver();
        DomainType TYP_pivot_c_c_BagType = idResolver.getType((TypeId)PivotTables.CLSSid_BagType, null);
        DomainType TYP_pivot_c_c_OrderedSetType = idResolver.getType((TypeId)PivotTables.CLSSid_OrderedSetType, null);
        DomainType TYP_pivot_c_c_SequenceType = idResolver.getType((TypeId)PivotTables.CLSSid_SequenceType, null);
        try {
            Object CAUGHT_symbol_0;
            Object CAUGHT_eq;
            try {
                String name = self.getName();
                Boolean eq = OclAnyEqualOperation.INSTANCE.evaluate((Object)name, (Object)"sortedBy");
                CAUGHT_eq = eq;
            }
            catch (Exception e) {
                CAUGHT_eq = ValuesUtil.createInvalidValue((Exception)e);
            }
            try {
                Boolean symbol_0;
                Object CAUGHT_oclIsKindOf_0;
                Object CAUGHT_oclIsKindOf;
                try {
                    OCLExpression source = self.getSource();
                    if (source == null) {
                        throw new InvalidValueException("Null source", new Object[0]);
                    }
                    DomainType type = source.getType();
                    Boolean oclIsKindOf = OclAnyOclIsKindOfOperation.INSTANCE.evaluate((DomainEvaluator)evaluator, (Object)type, (Object)TYP_pivot_c_c_SequenceType);
                    CAUGHT_oclIsKindOf = oclIsKindOf;
                }
                catch (Exception e) {
                    CAUGHT_oclIsKindOf = ValuesUtil.createInvalidValue((Exception)e);
                }
                try {
                    OCLExpression source_0 = self.getSource();
                    if (source_0 == null) {
                        throw new InvalidValueException("Null source", new Object[0]);
                    }
                    DomainType type_0 = source_0.getType();
                    Boolean oclIsKindOf_0 = OclAnyOclIsKindOfOperation.INSTANCE.evaluate((DomainEvaluator)evaluator, (Object)type_0, (Object)TYP_pivot_c_c_BagType);
                    CAUGHT_oclIsKindOf_0 = oclIsKindOf_0;
                }
                catch (Exception e) {
                    CAUGHT_oclIsKindOf_0 = ValuesUtil.createInvalidValue((Exception)e);
                }
                Boolean or = BooleanOrOperation.INSTANCE.evaluate(CAUGHT_oclIsKindOf, CAUGHT_oclIsKindOf_0);
                if (or == null) {
                    throw new InvalidValueException("Null source", new Object[0]);
                }
                if (or.booleanValue()) {
                    Boolean oclIsKindOf_1;
                    Type type_1 = self.getType();
                    symbol_0 = oclIsKindOf_1 = OclAnyOclIsKindOfOperation.INSTANCE.evaluate((DomainEvaluator)evaluator, (Object)type_1, (Object)TYP_pivot_c_c_SequenceType);
                } else {
                    Boolean oclIsKindOf_2;
                    Type type_2 = self.getType();
                    symbol_0 = oclIsKindOf_2 = OclAnyOclIsKindOfOperation.INSTANCE.evaluate((DomainEvaluator)evaluator, (Object)type_2, (Object)TYP_pivot_c_c_OrderedSetType);
                }
                CAUGHT_symbol_0 = symbol_0;
            }
            catch (Exception e) {
                CAUGHT_symbol_0 = ValuesUtil.createInvalidValue((Exception)e);
            }
            Boolean implies = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_eq, CAUGHT_symbol_0);
            CAUGHT_implies = implies;
        }
        catch (Exception e) {
            CAUGHT_implies = ValuesUtil.createInvalidValue((Exception)e);
        }
        if (CAUGHT_implies == ValuesUtil.TRUE_VALUE) {
            return true;
        }
        if (diagnostics != null) {
            int severity = CAUGHT_implies == null ? 4 : 2;
            String message = NLS.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"IteratorExp", "SortedByIsOrderedIfSourceIsOrdered", EObjectValidator.getObjectLabel((EObject)this, context)});
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.ocl.examples.pivot", 22, message, new Object[]{this}));
        }
        return false;
    }

    @Override
    public boolean validateSortedByElementTypeIsSourceElementType(DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object CAUGHT_implies;
        IteratorExpImpl self = this;
        EcoreExecutorManager evaluator = new EcoreExecutorManager((Object)this, PivotTables.LIBRARY);
        IdResolver idResolver = evaluator.getIdResolver();
        DomainType TYP_pivot_c_c_CollectionType = idResolver.getType((TypeId)PivotTables.CLSSid_CollectionType, null);
        try {
            Object CAUGHT_eq_0;
            Object CAUGHT_eq;
            try {
                String name = self.getName();
                Boolean eq = OclAnyEqualOperation.INSTANCE.evaluate((Object)name, (Object)"sortedBy");
                CAUGHT_eq = eq;
            }
            catch (Exception e) {
                CAUGHT_eq = ValuesUtil.createInvalidValue((Exception)e);
            }
            try {
                Type type = self.getType();
                CollectionType oclAsType = (CollectionType)OclAnyOclAsTypeOperation.INSTANCE.evaluate((DomainEvaluator)evaluator, (Object)type, (Object)TYP_pivot_c_c_CollectionType);
                if (oclAsType == null) {
                    throw new InvalidValueException("Null source", new Object[0]);
                }
                Type elementType = oclAsType.getElementType();
                OCLExpression body = self.getBody();
                DomainType type_0 = body.getType();
                CollectionType oclAsType_0 = (CollectionType)OclAnyOclAsTypeOperation.INSTANCE.evaluate((DomainEvaluator)evaluator, (Object)type_0, (Object)TYP_pivot_c_c_CollectionType);
                if (oclAsType_0 == null) {
                    throw new InvalidValueException("Null source", new Object[0]);
                }
                Type elementType_0 = oclAsType_0.getElementType();
                Boolean eq_0 = OclAnyEqualOperation.INSTANCE.evaluate((Object)elementType, (Object)elementType_0);
                CAUGHT_eq_0 = eq_0;
            }
            catch (Exception e) {
                CAUGHT_eq_0 = ValuesUtil.createInvalidValue((Exception)e);
            }
            Boolean implies = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_eq, CAUGHT_eq_0);
            CAUGHT_implies = implies;
        }
        catch (Exception e) {
            CAUGHT_implies = ValuesUtil.createInvalidValue((Exception)e);
        }
        if (CAUGHT_implies == ValuesUtil.TRUE_VALUE) {
            return true;
        }
        if (diagnostics != null) {
            int severity = CAUGHT_implies == null ? 4 : 2;
            String message = NLS.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"IteratorExp", "SortedByElementTypeIsSourceElementType", EObjectValidator.getObjectLabel((EObject)this, context)});
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.ocl.examples.pivot", 33, message, new Object[]{this}));
        }
        return false;
    }

    @Override
    public boolean validateIteratorTypeIsSourceElementType(DiagnosticChain diagnostics, Map<Object, Object> context) {
        Object CAUGHT_forAll;
        IteratorExpImpl self = this;
        EcoreExecutorManager evaluator = new EcoreExecutorManager((Object)this, PivotTables.LIBRARY);
        IdResolver idResolver = evaluator.getIdResolver();
        DomainType TYP_pivot_c_c_CollectionType = idResolver.getType((TypeId)PivotTables.CLSSid_CollectionType, null);
        try {
            Boolean forAll;
            block8: {
                Variable _1;
                Type type_0;
                Type elementType;
                Boolean conformsTo;
                List<Variable> iterator = self.getIterator();
                OrderedSetValue BOXED_iterator = idResolver.createOrderedSetOfAll(PivotTables.ORD_CLSSid_Variable, iterator);
                Iterator ITERATOR__1 = BOXED_iterator.iterator();
                do {
                    if (!ITERATOR__1.hasNext()) {
                        forAll = ValuesUtil.TRUE_VALUE;
                        break block8;
                    }
                    _1 = (Variable)ITERATOR__1.next();
                    OCLExpression source = self.getSource();
                    if (source == null) {
                        throw new InvalidValueException("Null source", new Object[0]);
                    }
                    DomainType type = source.getType();
                    CollectionType oclAsType = (CollectionType)OclAnyOclAsTypeOperation.INSTANCE.evaluate((DomainEvaluator)evaluator, (Object)type, (Object)TYP_pivot_c_c_CollectionType);
                    if (oclAsType == null) {
                        throw new InvalidValueException("Null source", new Object[0]);
                    }
                    elementType = oclAsType.getElementType();
                    if (_1 != null) continue;
                    throw new InvalidValueException("Null source", new Object[0]);
                } while ((conformsTo = OclTypeConformsToOperation.INSTANCE.evaluate((DomainEvaluator)evaluator, (Object)elementType, (Object)(type_0 = _1.getType()))) == ValuesUtil.TRUE_VALUE);
                forAll = ValuesUtil.FALSE_VALUE;
            }
            CAUGHT_forAll = forAll;
        }
        catch (Exception e) {
            CAUGHT_forAll = ValuesUtil.createInvalidValue((Exception)e);
        }
        if (CAUGHT_forAll == ValuesUtil.TRUE_VALUE) {
            return true;
        }
        if (diagnostics != null) {
            int severity = 2;
            String message = NLS.bind((String)EvaluatorMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object[])new Object[]{"IteratorExp", "IteratorTypeIsSourceElementType", EObjectValidator.getObjectLabel((EObject)this, context)});
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.ocl.examples.pivot", 25, message, new Object[]{this}));
        }
        return false;
    }

    public int eDerivedOperationID(int baseOperationID, Class<?> baseClass) {
        if (baseClass == ReferringElement.class) {
            switch (baseOperationID) {
                case 0: {
                    return 4;
                }
            }
            return -1;
        }
        return super.eDerivedOperationID(baseOperationID, baseClass);
    }

    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                return this.allOwnedElements();
            }
            case 1: {
                return this.getValue((Type)arguments.get(0), (String)arguments.get(1));
            }
            case 2: {
                return this.validateSourceIsCollection((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 3: {
                return this.validateNoInitializers((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 4: {
                return this.getReferredElement();
            }
            case 5: {
                return this.validateExistsBodyTypeIsBoolean((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 6: {
                return this.validateCollectNestedHasOneIterator((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 7: {
                return this.validateClosureSourceElementTypeIsBodyElementType((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 8: {
                return this.validateExistsTypeIsBoolean((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 9: {
                return this.validateCollectTypeIsUnordered((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 10: {
                return this.validateClosureTypeIsUniqueCollection((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 11: {
                return this.validateRejectOrSelectTypeIsSourceType((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 12: {
                return this.validateSortedByIsOrderedIfSourceIsOrdered((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 13: {
                return this.validateAnyTypeIsSourceElementType((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 14: {
                return this.validateSortedByHasOneIterator((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 15: {
                return this.validateIteratorTypeIsSourceElementType((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 16: {
                return this.validateOneBodyTypeIsBoolean((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 17: {
                return this.validateCollectNestedTypeIsBag((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 18: {
                return this.validateAnyHasOneIterator((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 19: {
                return this.validateAnyBodyTypeIsBoolean((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 20: {
                return this.validateRejectOrSelectTypeIsBoolean((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 21: {
                return this.validateOneHasOneIterator((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 22: {
                return this.validateOneTypeIsBoolean((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 23: {
                return this.validateSortedByElementTypeIsSourceElementType((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 24: {
                return this.validateForAllTypeIsBoolean((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 25: {
                return this.validateCollectHasOneIterator((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 26: {
                return this.validateClosureElementTypeIsSourceElementType((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 27: {
                return this.validateCollectElementTypeIsSourceElementType((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 28: {
                return this.validateClosureHasOneIterator((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 29: {
                return this.validateClosureBodyTypeIsConformanttoIteratorType((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 30: {
                return this.validateSortedByIteratorTypeIsComparable((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 31: {
                return this.validateCollectNestedTypeIsBodyType((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 32: {
                return this.validateIsUniqueHasOneIterator((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 33: {
                return this.validateRejectOrSelectHasOneIterator((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 34: {
                return this.validateForAllBodyTypeIsBoolean((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 35: {
                return this.validateIsUniqueTypeIsBoolean((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
        }
        return this.eDynamicInvoke(operationID, arguments);
    }

    @Override
    public <R> R accept(@NonNull Visitor<R> visitor) {
        return visitor.visitIteratorExp(this);
    }

    @Override
    public Element getReferredElement() {
        return this.getReferredIteration();
    }
}

