/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.library;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.ids.IdManager;
import org.eclipse.ocl.examples.domain.ids.PropertyId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.library.AbstractProperty;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;

public class CompositionProperty
extends AbstractProperty {
    @NonNull
    protected PropertyId containmentPropertyId;
    private EReference eContainmentFeature = null;

    public CompositionProperty(@NonNull PropertyId containmentPropertyId) {
        this.containmentPropertyId = containmentPropertyId;
    }

    @Nullable
    public Object evaluate(@NonNull DomainEvaluator evaluator, @NonNull TypeId returnTypeId, @Nullable Object sourceValue) {
        EObject eObject = CompositionProperty.asNavigableObject((Object)sourceValue);
        EObject eContainer = eObject.eContainer();
        if (eContainer == null) {
            return null;
        }
        EReference eContainmentFeature = (EReference)DomainUtil.nonNullModel((Object)eObject.eContainmentFeature());
        if (eContainmentFeature != this.eContainmentFeature) {
            PropertyId propertyId = IdManager.getPropertyId((EStructuralFeature)eContainmentFeature);
            if (!this.containmentPropertyId.equals(propertyId)) {
                return null;
            }
            this.eContainmentFeature = eContainmentFeature;
        }
        return evaluator.getIdResolver().boxedValueOf((Object)eContainer);
    }
}

