/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.manager;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.types.AbstractStandardLibrary;
import org.eclipse.ocl.examples.pivot.AnyType;
import org.eclipse.ocl.examples.pivot.BagType;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.InvalidType;
import org.eclipse.ocl.examples.pivot.Metaclass;
import org.eclipse.ocl.examples.pivot.OrderedSetType;
import org.eclipse.ocl.examples.pivot.PrimitiveType;
import org.eclipse.ocl.examples.pivot.SelfType;
import org.eclipse.ocl.examples.pivot.SequenceType;
import org.eclipse.ocl.examples.pivot.SetType;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.VoidType;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.ocl.examples.pivot.utilities.IllegalLibraryException;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PivotStandardLibrary
extends AbstractStandardLibrary {
    private static final Logger logger = Logger.getLogger(PivotStandardLibrary.class);
    @NonNull
    public static final String DEFAULT_OCL_STDLIB_URI = "http://www.eclipse.org/ocl/3.1.0/OCL.oclstdlib";
    @NonNull
    protected String defaultStandardLibraryURI = "http://www.eclipse.org/ocl/3.1.0/OCL.oclstdlib";
    private BagType bagType = null;
    private PrimitiveType booleanType = null;
    private Class classType = null;
    private CollectionType collectionType = null;
    private Class enumerationType = null;
    private PrimitiveType integerType = null;
    private Metaclass metaclassType = null;
    private AnyType oclAnyType = null;
    private Class oclComparableType = null;
    private Class oclElementType = null;
    private InvalidType oclInvalidType = null;
    private Class oclLambdaType = null;
    private SelfType oclSelfType = null;
    private Class oclSummableType = null;
    private Class oclTupleType = null;
    private VoidType oclVoidType = null;
    private OrderedSetType orderedSetType = null;
    private PrimitiveType realType = null;
    private SequenceType sequenceType = null;
    private SetType setType = null;
    private PrimitiveType stringType = null;
    private CollectionType uniqueCollectionType = null;
    private PrimitiveType unlimitedNaturalType = null;
    private Map<String, Type> nameToLibraryTypeMap = null;

    protected void defineLibraryType(Type pivotType) {
        String name;
        Type oldType;
        if (this.nameToLibraryTypeMap == null) {
            this.nameToLibraryTypeMap = new HashMap<String, Type>();
        }
        if ((oldType = this.nameToLibraryTypeMap.put(name = pivotType.getName(), pivotType)) != null && oldType != pivotType) {
            logger.warn((Object)("Conflicting pivot type '" + name + "'"));
        }
    }

    public void dispose() {
        this.resetLibrary();
        super.dispose();
    }

    @NonNull
    public BagType getBagType() {
        BagType bagType2 = this.bagType;
        if (bagType2 == null) {
            bagType2 = this.bagType = this.resolveRequiredTemplateableType(BagType.class, "Bag", 1);
        }
        return bagType2;
    }

    @NonNull
    public PrimitiveType getBooleanType() {
        PrimitiveType booleanType2 = this.booleanType;
        if (booleanType2 == null) {
            booleanType2 = this.booleanType = this.resolveRequiredSimpleType(PrimitiveType.class, "Boolean");
        }
        return booleanType2;
    }

    @NonNull
    public Class getClassType() {
        Class classType2 = this.classType;
        if (classType2 == null) {
            classType2 = this.classType = this.resolveRequiredSimpleType(Class.class, "Class");
        }
        return classType2;
    }

    @NonNull
    public CollectionType getCollectionType() {
        CollectionType collectionType2 = this.collectionType;
        if (collectionType2 == null) {
            collectionType2 = this.collectionType = this.resolveRequiredTemplateableType(CollectionType.class, "Collection", 1);
        }
        return collectionType2;
    }

    @NonNull
    public Class getEnumerationType() {
        Class enumerationType2 = this.enumerationType;
        if (enumerationType2 == null) {
            enumerationType2 = this.enumerationType = this.resolveRequiredSimpleType(Class.class, "Enumeration");
        }
        return enumerationType2;
    }

    @NonNull
    public PrimitiveType getIntegerType() {
        PrimitiveType integerType2 = this.integerType;
        if (integerType2 == null) {
            integerType2 = this.integerType = this.resolveRequiredSimpleType(PrimitiveType.class, "Integer");
        }
        return integerType2;
    }

    public Type getLibraryType(@NonNull String typeName) {
        if (this.nameToLibraryTypeMap == null) {
            this.nameToLibraryTypeMap = new HashMap<String, Type>();
            this.loadDefaultLibrary(this.defaultStandardLibraryURI);
        }
        return this.nameToLibraryTypeMap.get(typeName);
    }

    @NonNull
    public Metaclass getMetaclassType() {
        Metaclass metaclassType2 = this.metaclassType;
        if (metaclassType2 == null) {
            metaclassType2 = this.metaclassType = this.resolveRequiredTemplateableType(Metaclass.class, "Metaclass", 1);
        }
        return metaclassType2;
    }

    @NonNull
    public AnyType getOclAnyType() {
        AnyType oclAnyType2 = this.oclAnyType;
        if (oclAnyType2 == null) {
            oclAnyType2 = this.oclAnyType = this.resolveRequiredSimpleType(AnyType.class, "OclAny");
        }
        return oclAnyType2;
    }

    @NonNull
    public Class getOclComparableType() {
        Class oclComparableType2 = this.oclComparableType;
        if (oclComparableType2 == null) {
            oclComparableType2 = this.oclComparableType = this.resolveRequiredSimpleType(Class.class, "OclComparable");
        }
        return oclComparableType2;
    }

    @NonNull
    public Class getOclElementType() {
        Class oclElementType2 = this.oclElementType;
        if (oclElementType2 == null) {
            oclElementType2 = this.oclElementType = this.resolveRequiredSimpleType(Class.class, "OclElement");
        }
        return oclElementType2;
    }

    @NonNull
    public InvalidType getOclInvalidType() {
        InvalidType oclInvalidType2 = this.oclInvalidType;
        if (oclInvalidType2 == null) {
            oclInvalidType2 = this.oclInvalidType = this.resolveRequiredSimpleType(InvalidType.class, "OclInvalid");
        }
        return oclInvalidType2;
    }

    @NonNull
    public Class getOclLambdaType() {
        Class oclLambdaType2 = this.oclLambdaType;
        if (oclLambdaType2 == null) {
            oclLambdaType2 = this.oclLambdaType = this.resolveRequiredSimpleType(Class.class, "OclLambda");
        }
        return oclLambdaType2;
    }

    public Type getOclMessageType() {
        return this.getRequiredLibraryType("OclMessage");
    }

    @NonNull
    public SelfType getOclSelfType() {
        SelfType oclSelfType2 = this.oclSelfType;
        if (oclSelfType2 == null) {
            oclSelfType2 = this.oclSelfType = this.resolveRequiredSimpleType(SelfType.class, "OclSelf");
        }
        return oclSelfType2;
    }

    @NonNull
    public Class getOclSummableType() {
        Class oclSummableType2 = this.oclSummableType;
        if (oclSummableType2 == null) {
            oclSummableType2 = this.oclSummableType = this.resolveRequiredSimpleType(Class.class, "OclSummable");
        }
        return oclSummableType2;
    }

    @NonNull
    public Class getOclTupleType() {
        Class oclTupleType2 = this.oclTupleType;
        if (oclTupleType2 == null) {
            oclTupleType2 = this.oclTupleType = this.resolveRequiredSimpleType(Class.class, "OclTuple");
        }
        return oclTupleType2;
    }

    @NonNull
    public VoidType getOclVoidType() {
        VoidType oclVoidType2 = this.oclVoidType;
        if (oclVoidType2 == null) {
            oclVoidType2 = this.oclVoidType = this.resolveRequiredSimpleType(VoidType.class, "OclVoid");
        }
        return oclVoidType2;
    }

    @NonNull
    public OrderedSetType getOrderedSetType() {
        OrderedSetType orderedSetType2 = this.orderedSetType;
        if (orderedSetType2 == null) {
            orderedSetType2 = this.orderedSetType = this.resolveRequiredTemplateableType(OrderedSetType.class, "OrderedSet", 1);
        }
        return orderedSetType2;
    }

    @NonNull
    public PrimitiveType getRealType() {
        PrimitiveType realType2 = this.realType;
        if (realType2 == null) {
            realType2 = this.realType = this.resolveRequiredSimpleType(PrimitiveType.class, "Real");
        }
        return realType2;
    }

    @NonNull
    public Type getRequiredLibraryType(@NonNull String typeName) {
        Type type = this.getLibraryType(typeName);
        if (type == null) {
            type = this.getLibraryType(typeName);
            if (this.nameToLibraryTypeMap == null || this.nameToLibraryTypeMap.isEmpty()) {
                throw new IllegalLibraryException(OCLMessages.EmptyLibrary_ERROR_);
            }
            throw new IllegalLibraryException(NLS.bind((String)OCLMessages.MissingLibraryType_ERROR_, (Object)typeName));
        }
        return type;
    }

    @NonNull
    public SequenceType getSequenceType() {
        SequenceType sequenceType2 = this.sequenceType;
        if (sequenceType2 == null) {
            sequenceType2 = this.sequenceType = this.resolveRequiredTemplateableType(SequenceType.class, "Sequence", 1);
        }
        return sequenceType2;
    }

    @NonNull
    public SetType getSetType() {
        SetType setType2 = this.setType;
        if (setType2 == null) {
            setType2 = this.setType = this.resolveRequiredTemplateableType(SetType.class, "Set", 1);
        }
        return setType2;
    }

    @NonNull
    public PrimitiveType getStringType() {
        PrimitiveType stringType2 = this.stringType;
        if (stringType2 == null) {
            stringType2 = this.stringType = this.resolveRequiredSimpleType(PrimitiveType.class, "String");
        }
        return stringType2;
    }

    @NonNull
    public CollectionType getUniqueCollectionType() {
        CollectionType uniqueCollectionType2 = this.uniqueCollectionType;
        if (uniqueCollectionType2 == null) {
            uniqueCollectionType2 = this.uniqueCollectionType = this.resolveRequiredTemplateableType(CollectionType.class, "UniqueCollection", 1);
        }
        return uniqueCollectionType2;
    }

    @NonNull
    public PrimitiveType getUnlimitedNaturalType() {
        PrimitiveType unlimitedNaturalType2 = this.unlimitedNaturalType;
        if (unlimitedNaturalType2 == null) {
            unlimitedNaturalType2 = this.unlimitedNaturalType = this.resolveRequiredSimpleType(PrimitiveType.class, "UnlimitedNatural");
        }
        return unlimitedNaturalType2;
    }

    public boolean isOrdered(Type sourceType) {
        if (sourceType instanceof OrderedSetType) {
            return true;
        }
        return sourceType instanceof SequenceType;
    }

    public boolean isUnique(Type sourceType) {
        if (sourceType instanceof OrderedSetType) {
            return true;
        }
        return sourceType instanceof SetType;
    }

    protected abstract Resource loadDefaultLibrary(String var1);

    public void resetLibrary() {
        this.bagType = null;
        this.booleanType = null;
        this.classType = null;
        this.collectionType = null;
        this.enumerationType = null;
        this.integerType = null;
        this.metaclassType = null;
        this.oclAnyType = null;
        this.oclElementType = null;
        this.oclInvalidType = null;
        this.oclLambdaType = null;
        this.oclTupleType = null;
        this.oclVoidType = null;
        this.orderedSetType = null;
        this.realType = null;
        this.sequenceType = null;
        this.setType = null;
        this.stringType = null;
        this.unlimitedNaturalType = null;
        this.nameToLibraryTypeMap = null;
    }

    @NonNull
    protected <T extends TemplateableElement> T resolveRequiredSimpleType(@NonNull java.lang.Class<T> requiredClassType, @NonNull String name) {
        Type type = this.getRequiredLibraryType(name);
        if (requiredClassType.isAssignableFrom(type.getClass())) {
            Type type2 = type;
            return (T)type2;
        }
        throw new IllegalLibraryException(String.valueOf(name) + " is not a " + requiredClassType.getSimpleName());
    }

    @NonNull
    protected <T extends TemplateableElement> T resolveRequiredTemplateableType(@NonNull java.lang.Class<T> requiredClassType, @NonNull String name, int parameterCount) {
        Type type = this.getRequiredLibraryType(name);
        if (requiredClassType.isAssignableFrom(type.getClass())) {
            if (type.getOwnedTemplateSignature() == null) {
                throw new IllegalLibraryException(String.valueOf(name) + " is not a templated type");
            }
            if (type.getOwnedTemplateSignature().getParameter().size() != parameterCount) {
                throw new IllegalLibraryException(String.valueOf(name) + " is not a templated type with " + parameterCount + " argument" + (parameterCount != 1 ? "s" : ""));
            }
            Type type2 = type;
            return (T)type2;
        }
        throw new IllegalLibraryException(String.valueOf(name) + " is not a " + requiredClassType.getSimpleName());
    }
}

