/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.utilities;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.util.Visitable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPivotSaver {
    @NonNull
    private static Map<EPackage, Factory> factoryMap = new HashMap<EPackage, Factory>();
    @NonNull
    private Map<EPackage, LocateVisitor> locateVisitors = new HashMap<EPackage, LocateVisitor>();
    @NonNull
    private Map<EPackage, ResolveVisitor> resolveVisitors = new HashMap<EPackage, ResolveVisitor>();

    public static synchronized void addFactory(@NonNull Factory factory) {
        factoryMap.put(factory.getEPackage(), factory);
    }

    public abstract void addSpecializingElement(@NonNull Element var1);

    public abstract boolean addSpecializingElement(@NonNull Element var1, @NonNull Operation var2);

    public abstract boolean addSpecializingElement(@NonNull Element var1, @NonNull Type var2);

    @NonNull
    protected LocateVisitor getLocateVisitor(@NonNull EObject eObject) {
        EPackage ePackage = eObject.eClass().getEPackage();
        LocateVisitor locateVisitor = this.locateVisitors.get(ePackage);
        if (locateVisitor == null) {
            Factory factory = factoryMap.get(ePackage);
            locateVisitor = factory.createLocateVisitor(this);
            this.locateVisitors.put(ePackage, locateVisitor);
        }
        return locateVisitor;
    }

    @NonNull
    protected ResolveVisitor getResolveVisitor(@NonNull EObject eObject) {
        EPackage ePackage = eObject.eClass().getEPackage();
        ResolveVisitor resolveVisitor = this.resolveVisitors.get(ePackage);
        if (resolveVisitor == null) {
            Factory factory = factoryMap.get(ePackage);
            resolveVisitor = factory.createResolveVisitor(this);
            this.resolveVisitors.put(ePackage, resolveVisitor);
        }
        return resolveVisitor;
    }

    @NonNull
    public abstract <T extends Operation> T resolveOperation(@NonNull T var1);

    @NonNull
    public abstract <T extends Type> T resolveType(@NonNull T var1);

    public static interface Factory {
        @NonNull
        public LocateVisitor createLocateVisitor(@NonNull AbstractPivotSaver var1);

        @NonNull
        public ResolveVisitor createResolveVisitor(@NonNull AbstractPivotSaver var1);

        @NonNull
        public EPackage getEPackage();
    }

    public static interface LocateVisitor {
        public Object safeVisit(@NonNull Visitable var1);
    }

    public static interface ResolveVisitor {
        public Object safeVisit(@NonNull Visitable var1);
    }
}

