/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.utilities;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.Nameable;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.values.Unlimited;
import org.eclipse.ocl.examples.pivot.AnyType;
import org.eclipse.ocl.examples.pivot.AssociationClassCallExp;
import org.eclipse.ocl.examples.pivot.BooleanLiteralExp;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.CollectionItem;
import org.eclipse.ocl.examples.pivot.CollectionLiteralExp;
import org.eclipse.ocl.examples.pivot.CollectionLiteralPart;
import org.eclipse.ocl.examples.pivot.CollectionRange;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.ConstructorExp;
import org.eclipse.ocl.examples.pivot.ConstructorPart;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.ElementExtension;
import org.eclipse.ocl.examples.pivot.EnumLiteralExp;
import org.eclipse.ocl.examples.pivot.EnumerationLiteral;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.FeatureCallExp;
import org.eclipse.ocl.examples.pivot.IfExp;
import org.eclipse.ocl.examples.pivot.Import;
import org.eclipse.ocl.examples.pivot.IntegerLiteralExp;
import org.eclipse.ocl.examples.pivot.InvalidLiteralExp;
import org.eclipse.ocl.examples.pivot.InvalidType;
import org.eclipse.ocl.examples.pivot.IterateExp;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.IteratorExp;
import org.eclipse.ocl.examples.pivot.LambdaType;
import org.eclipse.ocl.examples.pivot.LetExp;
import org.eclipse.ocl.examples.pivot.MessageExp;
import org.eclipse.ocl.examples.pivot.Metaclass;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.NullLiteralExp;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Precedence;
import org.eclipse.ocl.examples.pivot.PrimitiveType;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.PropertyCallExp;
import org.eclipse.ocl.examples.pivot.RealLiteralExp;
import org.eclipse.ocl.examples.pivot.Root;
import org.eclipse.ocl.examples.pivot.StateExp;
import org.eclipse.ocl.examples.pivot.StringLiteralExp;
import org.eclipse.ocl.examples.pivot.TemplateBinding;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.TupleLiteralExp;
import org.eclipse.ocl.examples.pivot.TupleLiteralPart;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypeExp;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.examples.pivot.UnspecifiedType;
import org.eclipse.ocl.examples.pivot.UnspecifiedValueExp;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.VariableExp;
import org.eclipse.ocl.examples.pivot.VoidType;
import org.eclipse.ocl.examples.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToStringVisitor
extends AbstractExtendingVisitor<String, Object> {
    private static final Logger logger = Logger.getLogger(ToStringVisitor.class);
    @NonNull
    private static Map<EPackage, Factory> factoryMap = new HashMap<EPackage, Factory>();
    @NonNull
    public static Factory FACTORY = new MyFactory();
    @NonNull
    protected static String NULL_PLACEHOLDER = "\"<null>\"";
    @NonNull
    protected StringBuilder result = new StringBuilder();

    public static synchronized void addFactory(@NonNull Factory factory) {
        factoryMap.put(factory.getEPackage(), factory);
    }

    @Nullable
    public static ToStringVisitor create(@NonNull EObject eObject) {
        EPackage ePackage = eObject.eClass().getEPackage();
        Factory factory = factoryMap.get(ePackage);
        if (factory != null) {
            return factory.createToStringVisitor();
        }
        logger.error((Object)("No ToStringVisitor Factory registered for " + ePackage.getName()));
        return null;
    }

    protected ToStringVisitor() {
        super(Object.class);
    }

    protected void append(Number number) {
        if (number != null) {
            this.result.append(number.toString());
        } else {
            this.result.append(NULL_PLACEHOLDER);
        }
    }

    protected void append(String string) {
        if (string != null) {
            this.result.append(string);
        } else {
            this.result.append(NULL_PLACEHOLDER);
        }
    }

    protected void appendAtPre(FeatureCallExp mpc) {
        if (mpc.isPre()) {
            this.append("@pre");
        }
    }

    protected void appendElementType(@Nullable TypedElement typedElement) {
        if (typedElement == null) {
            this.append(NULL_PLACEHOLDER);
        } else {
            this.safeVisit(typedElement.getType());
            if (!typedElement.isRequired()) {
                this.append("[?]");
            }
        }
    }

    protected void appendName(Nameable object) {
        if (object == null) {
            this.result.append(NULL_PLACEHOLDER);
        } else {
            this.result.append(object.getName());
        }
    }

    protected void appendOperationSignature(Operation operation) {
        this.appendName(operation);
        this.append("(");
        boolean comma = false;
        for (Parameter parm : operation.getOwnedParameter()) {
            if (comma) {
                this.append(", ");
            } else {
                comma = true;
            }
            this.appendName(parm);
            this.append(" : ");
            if (parm.getType() != null) {
                this.appendElementType(parm);
                continue;
            }
            this.append("OclVoid");
        }
        this.append(") :");
        if (operation.getType() != null) {
            this.append(" ");
            this.appendElementType(operation);
        }
    }

    protected void appendPropertySignature(Property property) {
        this.appendName(property);
        if (property.getType() != null) {
            this.append(" : ");
            this.appendElementType(property);
        }
    }

    protected void appendQualifiedName(NamedElement parent, String separator, NamedElement child) {
        if (parent != null) {
            this.appendQualifiedName(parent);
            this.append(separator);
        }
        this.appendName(child);
    }

    protected void appendQualifiedName(@Nullable NamedElement object) {
        if (object == null) {
            this.result.append(NULL_PLACEHOLDER);
        } else {
            EObject container = object.eContainer();
            if (!(container instanceof Root || !(container instanceof NamedElement) || container.eContainer() instanceof Root && "ocl".equals(((NamedElement)container).getName()))) {
                this.appendQualifiedName((NamedElement)container);
                this.append("::");
            }
            this.appendName(object);
            if (object instanceof TemplateableElement) {
                TemplateableElement templateableElement = (TemplateableElement)((Object)object);
                this.appendTemplateBindings(templateableElement.getTemplateBinding());
                this.appendTemplateSignature(templateableElement.getOwnedTemplateSignature());
            }
        }
    }

    protected void appendTemplateBindings(List<TemplateBinding> templateBindings) {
        if (templateBindings.size() > 0) {
            this.append("(");
            String prefix = "";
            for (TemplateBinding templateBinding : templateBindings) {
                for (TemplateParameterSubstitution templateParameterSubstitution : templateBinding.getParameterSubstitution()) {
                    this.append(prefix);
                    this.safeVisit(templateParameterSubstitution.getActual());
                    prefix = ",";
                }
            }
            this.append(")");
        }
    }

    protected void appendTemplateSignature(TemplateSignature templateSignature) {
        List<TemplateParameter> templateParameters;
        if (templateSignature != null && !(templateParameters = templateSignature.getOwnedParameter()).isEmpty()) {
            this.append("(");
            String prefix = "";
            for (TemplateParameter templateParameter : templateParameters) {
                this.append(prefix);
                this.safeVisit(templateParameter.getParameteredElement());
                prefix = ",";
            }
            this.append(")");
        }
    }

    protected void appendType(Type type) {
        if (type != null && type.eClass() == PivotPackage.Literals.CLASS && type.eContainer() instanceof NamedElement) {
            this.appendQualifiedName((NamedElement)type.eContainer());
            this.append("::");
        }
        this.appendName(type);
    }

    public String toString() {
        return this.result.toString();
    }

    @Override
    public String visitAnyType(@NonNull AnyType object) {
        this.appendName(object);
        return null;
    }

    @Override
    public String visitAssociationClassCallExp(@NonNull AssociationClassCallExp ac) {
        this.safeVisit(ac.getSource());
        this.append(".");
        this.appendName(ac.getReferredAssociationClass());
        this.appendAtPre(ac);
        List<OCLExpression> qualifiers = ac.getQualifier();
        if (!qualifiers.isEmpty()) {
            this.append("[");
            this.safeVisit(qualifiers.get(0));
            this.append("]");
        }
        return null;
    }

    @Override
    public String visitBooleanLiteralExp(@NonNull BooleanLiteralExp bl) {
        this.append(Boolean.toString(bl.isBooleanSymbol()));
        return null;
    }

    @Override
    public String visitClass(@NonNull Class cls) {
        TemplateParameter owningTemplateParameter = cls.getOwningTemplateParameter();
        if (owningTemplateParameter != null) {
            this.appendName(cls);
        } else {
            Package pkg = cls.getPackage();
            if (pkg == null) {
                this.append("null::");
                this.appendName(cls);
            } else if (!(pkg.eContainer() instanceof Root) || !"ocl".equals(pkg.getName())) {
                this.appendQualifiedName(pkg, "::", cls);
            } else {
                this.appendName(cls);
            }
            this.appendTemplateBindings(cls.getTemplateBinding());
            this.appendTemplateSignature(cls.getOwnedTemplateSignature());
        }
        return null;
    }

    @Override
    public String visitCollectionItem(@NonNull CollectionItem item) {
        this.safeVisit(item.getItem());
        return null;
    }

    @Override
    public String visitCollectionLiteralExp(@NonNull CollectionLiteralExp cl) {
        switch (cl.getKind()) {
            case SET: {
                this.append("Set {");
                break;
            }
            case ORDERED_SET: {
                this.append("OrderedSet {");
                break;
            }
            case BAG: {
                this.append("Bag {");
                break;
            }
            case SEQUENCE: {
                this.append("Sequence {");
                break;
            }
            default: {
                this.append("Collection {");
            }
        }
        boolean isFirst = true;
        for (CollectionLiteralPart part : cl.getPart()) {
            if (!isFirst) {
                this.append(", ");
            }
            this.safeVisit(part);
            isFirst = false;
        }
        this.append("}");
        return null;
    }

    @Override
    public String visitCollectionRange(@NonNull CollectionRange range) {
        this.safeVisit(range.getFirst());
        this.append(" .. ");
        this.safeVisit(range.getLast());
        return null;
    }

    @Override
    public String visitCollectionType(@NonNull CollectionType object) {
        long upperValue;
        this.appendName(object);
        this.appendTemplateBindings(object.getTemplateBinding());
        this.appendTemplateSignature(object.getOwnedTemplateSignature());
        Number lower = object.getLower();
        Number upper = object.getUpper();
        long lowerValue = lower != null ? lower.longValue() : 0L;
        long l = upperValue = upper != null && !(upper instanceof Unlimited) ? upper.longValue() : -1L;
        if (lowerValue != 0L || upperValue != -1L) {
            DomainUtil.formatMultiplicity((StringBuilder)this.result, (long)lowerValue, (long)upperValue);
        }
        return null;
    }

    @Override
    public String visitConstraint(@NonNull Constraint constraint) {
        List<Element> constrained = constraint.getConstrainedElement();
        if (!constrained.isEmpty()) {
            EObject elem = constrained.get(0);
            this.append("context ");
            if (elem instanceof Type) {
                this.appendName((NamedElement)elem);
            } else if (elem instanceof Operation) {
                Operation oper = (Operation)elem;
                this.appendOperationSignature(oper);
            } else if (elem instanceof Property) {
                Property prop = (Property)elem;
                this.appendPropertySignature(prop);
            }
            this.append(" ");
        }
        String stereo = PivotUtil.getStereotype(constraint);
        this.append(stereo);
        String name = constraint.getName();
        if (name != null) {
            this.append(" ");
            this.append(name);
        }
        this.append(": ");
        this.safeVisit(constraint.getSpecification());
        return null;
    }

    @Override
    public String visitConstructorExp(@NonNull ConstructorExp constructorExp) {
        this.appendQualifiedName(constructorExp.getType());
        this.append("{");
        String prefix = "";
        for (ConstructorPart part : constructorExp.getPart()) {
            this.append(prefix);
            this.safeVisit(part);
            prefix = ", ";
        }
        this.append("}");
        return null;
    }

    @Override
    public String visitConstructorPart(@NonNull ConstructorPart part) {
        this.appendName(part.getReferredProperty());
        OCLExpression initExpression = part.getInitExpression();
        if (initExpression != null) {
            this.append(" = ");
            this.safeVisit(initExpression);
        }
        return null;
    }

    @Override
    public String visitElementExtension(@NonNull ElementExtension as) {
        this.appendQualifiedName(as.getPackage(), "::", as);
        return null;
    }

    @Override
    public String visitEnumLiteralExp(@NonNull EnumLiteralExp el) {
        this.appendQualifiedName(el.getReferredEnumLiteral());
        return null;
    }

    @Override
    public String visitEnumerationLiteral(@NonNull EnumerationLiteral el) {
        this.appendQualifiedName(el.getEnumeration(), "::", el);
        return null;
    }

    @Override
    public String visitExpressionInOCL(@NonNull ExpressionInOCL expression) {
        OCLExpression bodyExpression = expression.getBodyExpression();
        if (bodyExpression != null) {
            return (String)this.safeVisit(bodyExpression);
        }
        return PivotUtil.getBody(expression);
    }

    @Override
    public String visitIfExp(@NonNull IfExp ifExp) {
        this.append("if ");
        this.safeVisit(ifExp.getCondition());
        this.append(" then ");
        this.safeVisit(ifExp.getThenExpression());
        this.append(" else ");
        this.safeVisit(ifExp.getElseExpression());
        this.append(" endif");
        return null;
    }

    @Override
    @Nullable
    public String visitImport(@NonNull Import object) {
        this.appendName(object);
        this.append(" : ");
        this.appendQualifiedName(object.getImportedNamespace());
        return null;
    }

    @Override
    public String visitIntegerLiteralExp(@NonNull IntegerLiteralExp il) {
        this.append(il.getIntegerSymbol());
        return null;
    }

    @Override
    public String visitInvalidLiteralExp(@NonNull InvalidLiteralExp il) {
        this.append("invalid");
        return null;
    }

    @Override
    public String visitInvalidType(@NonNull InvalidType object) {
        this.appendName(object);
        return null;
    }

    @Override
    public String visitIterateExp(@NonNull IterateExp callExp) {
        this.safeVisit(callExp.getSource());
        this.append("->");
        this.appendName(callExp.getReferredIteration());
        this.append("(");
        boolean isFirst = true;
        for (Variable variable : callExp.getIterator()) {
            if (!isFirst) {
                this.append(", ");
            }
            this.safeVisit(variable);
            isFirst = false;
        }
        this.append("; ");
        this.safeVisit(callExp.getResult());
        this.append(" | ");
        this.safeVisit(callExp.getBody());
        this.append(")");
        return null;
    }

    @Override
    public String visitIteration(@NonNull Iteration iteration) {
        this.appendQualifiedName(iteration.getOwningType(), ".", iteration);
        this.appendTemplateBindings(iteration.getTemplateBinding());
        this.appendTemplateSignature(iteration.getOwnedTemplateSignature());
        this.append("(");
        boolean isFirst = true;
        for (Parameter parameter : iteration.getOwnedIterator()) {
            if (!isFirst) {
                this.append(", ");
            }
            this.appendElementType(parameter);
            isFirst = false;
        }
        isFirst = true;
        for (Parameter accumulator : iteration.getOwnedAccumulator()) {
            if (!isFirst) {
                this.append(", ");
            } else {
                this.append("; ");
            }
            this.appendElementType(accumulator);
            isFirst = false;
        }
        isFirst = true;
        for (Parameter parameter : iteration.getOwnedParameter()) {
            if (!isFirst) {
                this.append(", ");
            } else {
                this.append(" | ");
            }
            this.appendElementType(parameter);
            isFirst = false;
        }
        this.append(") : ");
        this.appendElementType(iteration);
        return null;
    }

    @Override
    public String visitIteratorExp(@NonNull IteratorExp callExp) {
        this.safeVisit(callExp.getSource());
        this.append("->");
        this.appendName(callExp.getReferredIteration());
        this.append("(");
        boolean isFirst = true;
        for (Variable variable : callExp.getIterator()) {
            if (!isFirst) {
                this.append(", ");
            }
            this.safeVisit(variable);
            isFirst = false;
        }
        this.append(" | ");
        this.safeVisit(callExp.getBody());
        this.append(")");
        return null;
    }

    @Override
    public String visitLambdaType(@NonNull LambdaType lambda) {
        this.appendName(lambda);
        Type contextType = lambda.getContextType();
        if (contextType != null) {
            this.append(" ");
            this.appendType(contextType);
            this.appendTemplateSignature(lambda.getOwnedTemplateSignature());
            this.append("(");
            boolean isFirst = true;
            for (Type parameterType : lambda.getParameterType()) {
                if (!isFirst) {
                    this.append(",");
                }
                this.appendType(parameterType);
                isFirst = false;
            }
            this.append(") : ");
            this.appendType(lambda.getResultType());
        }
        return null;
    }

    @Override
    public String visitLetExp(@NonNull LetExp letExp) {
        this.append("let ");
        this.safeVisit(letExp.getVariable());
        this.append(" in ");
        this.safeVisit(letExp.getIn());
        return null;
    }

    @Override
    public String visitMessageExp(@NonNull MessageExp messageExp) {
        this.safeVisit(messageExp.getTarget());
        this.append(messageExp.getType() instanceof CollectionType ? "^^" : "^");
        if (messageExp.getCalledOperation() != null) {
            this.appendName(messageExp.getCalledOperation().getOperation());
        } else if (messageExp.getSentSignal() != null) {
            this.appendName(messageExp.getSentSignal().getSignal());
        }
        this.append("(");
        String prefix = "";
        for (OCLExpression argument : messageExp.getArgument()) {
            this.append(prefix);
            this.safeVisit(argument);
            prefix = ", ";
        }
        this.append(")");
        return null;
    }

    @Override
    public String visitMetaclass(@NonNull Metaclass object) {
        this.appendName(object);
        if (object.getTemplateBinding().size() > 0) {
            this.appendTemplateBindings(object.getTemplateBinding());
        } else if (object.getInstanceType() != null) {
            this.append("<");
            this.appendQualifiedName(object.getInstanceType());
            this.append(">");
        }
        this.appendTemplateSignature(object.getOwnedTemplateSignature());
        return null;
    }

    @Override
    public String visitNullLiteralExp(@NonNull NullLiteralExp il) {
        this.append("null");
        return null;
    }

    @Override
    public String visitOpaqueExpression(@NonNull OpaqueExpression object) {
        String body = PivotUtil.getBody(object);
        if (body != null) {
            this.append(body);
        }
        return null;
    }

    @Override
    public String visitOperation(@NonNull Operation operation) {
        this.appendQualifiedName(operation.getOwningType(), ".", operation);
        this.appendTemplateBindings(operation.getTemplateBinding());
        this.appendTemplateSignature(operation.getOwnedTemplateSignature());
        this.append("(");
        boolean isFirst = true;
        for (Parameter parameter : operation.getOwnedParameter()) {
            if (!isFirst) {
                this.append(",");
            }
            this.appendElementType(parameter);
            isFirst = false;
        }
        this.append(") : ");
        this.appendElementType(operation);
        return null;
    }

    @Override
    public String visitOperationCallExp(@NonNull OperationCallExp oc) {
        OCLExpression source = oc.getSource();
        this.safeVisit(source);
        Operation oper = oc.getReferredOperation();
        if (oper != null) {
            Type sourceType = source != null ? source.getType() : null;
            this.append(sourceType instanceof CollectionType ? "->" : ".");
            this.appendName(oper);
        } else {
            this.append(".");
            this.appendName(oc);
        }
        this.append("(");
        String prefix = "";
        for (OCLExpression argument : oc.getArgument()) {
            this.append(prefix);
            this.safeVisit(argument);
            prefix = ", ";
        }
        this.append(")");
        this.appendAtPre(oc);
        return null;
    }

    @Override
    public String visitPackage(@NonNull Package pkg) {
        this.appendQualifiedName(pkg.getNestingPackage(), "::", pkg);
        return null;
    }

    @Override
    public String visitParameter(@NonNull Parameter parameter) {
        this.appendQualifiedName((NamedElement)parameter.eContainer(), ".", parameter);
        return null;
    }

    @Override
    public String visitPrecedence(@NonNull Precedence precedence) {
        this.appendName(precedence);
        return null;
    }

    @Override
    public String visitPrimitiveType(@NonNull PrimitiveType object) {
        this.appendName(object);
        return null;
    }

    @Override
    public String visitProperty(@NonNull Property property) {
        this.appendQualifiedName(property.getOwningType(), ".", property);
        return null;
    }

    @Override
    public String visitPropertyCallExp(@NonNull PropertyCallExp pc) {
        OCLExpression source = pc.getSource();
        this.safeVisit(source);
        Property property = pc.getReferredProperty();
        Type sourceType = source != null ? source.getType() : null;
        this.result.append(sourceType instanceof CollectionType ? "->" : ".");
        this.appendName(property);
        this.appendAtPre(pc);
        List<OCLExpression> qualifiers = pc.getQualifier();
        if (!qualifiers.isEmpty()) {
            this.append("[");
            String prefix = "";
            for (OCLExpression qualifier : qualifiers) {
                this.append(prefix);
                this.safeVisit(qualifier);
                prefix = ", ";
            }
            this.append("]");
        }
        return null;
    }

    @Override
    public String visitRealLiteralExp(@NonNull RealLiteralExp rl) {
        this.append(rl.getRealSymbol());
        return null;
    }

    @Override
    public String visitRoot(@NonNull Root root) {
        this.appendName(root);
        return null;
    }

    @Override
    public String visitStateExp(@NonNull StateExp s) {
        this.appendName(s);
        return null;
    }

    @Override
    public String visitStringLiteralExp(@NonNull StringLiteralExp sl) {
        this.append("'");
        this.append(sl.getStringSymbol());
        this.append("'");
        return null;
    }

    @Override
    public String visitTemplateBinding(@NonNull TemplateBinding object) {
        this.appendTemplateBindings(Collections.singletonList(object));
        return null;
    }

    @Override
    public String visitTemplateParameter(@NonNull TemplateParameter object) {
        TemplateSignature signature = object.getSignature();
        this.appendName(signature != null ? (NamedElement)((Object)signature.getTemplate()) : null);
        this.append(".");
        this.appendName((NamedElement)((Object)object.getParameteredElement()));
        return null;
    }

    @Override
    public String visitTemplateParameterSubstitution(@NonNull TemplateParameterSubstitution object) {
        TemplateParameter formal = object.getFormal();
        this.appendName(formal != null ? (NamedElement)((Object)formal.getParameteredElement()) : null);
        this.append("/");
        this.appendName((NamedElement)((Object)object.getActual()));
        return null;
    }

    @Override
    public String visitTemplateSignature(@NonNull TemplateSignature object) {
        this.appendTemplateSignature(object);
        return null;
    }

    @Override
    public String visitTupleLiteralExp(@NonNull TupleLiteralExp literalExp) {
        this.append("Tuple{");
        String prefix = "";
        for (TupleLiteralPart part : literalExp.getPart()) {
            this.append(prefix);
            this.safeVisit(part);
            prefix = ", ";
        }
        this.append("}");
        return null;
    }

    @Override
    public String visitTupleLiteralPart(@NonNull TupleLiteralPart part) {
        OCLExpression initExpression;
        this.appendName(part);
        Type type = part.getType();
        if (type != null) {
            this.append(" : ");
            this.appendElementType(part);
        }
        if ((initExpression = part.getInitExpression()) != null) {
            this.append(" = ");
            this.safeVisit(initExpression);
        }
        return null;
    }

    @Override
    public String visitTupleType(@NonNull TupleType object) {
        this.appendName(object);
        this.append("(");
        String prefix = "";
        for (TypedElement typedElement : object.getOwnedAttribute()) {
            this.append(prefix);
            this.appendName(typedElement);
            this.append(":");
            this.appendElementType(typedElement);
            prefix = ",";
        }
        this.append(")");
        return null;
    }

    @Override
    public String visitTypeExp(@NonNull TypeExp t) {
        this.appendQualifiedName(t.getReferredType());
        return null;
    }

    @Override
    public String visitUnlimitedNaturalLiteralExp(@NonNull UnlimitedNaturalLiteralExp unl) {
        this.append(unl.getUnlimitedNaturalSymbol());
        return null;
    }

    @Override
    public String visitUnspecifiedType(@NonNull UnspecifiedType object) {
        this.appendName(object);
        return null;
    }

    @Override
    public String visitUnspecifiedValueExp(@NonNull UnspecifiedValueExp uv) {
        this.append("?");
        if (uv.getType() != null && !(uv.getType() instanceof VoidType)) {
            this.append(" : ");
            this.appendName(uv.getType());
        }
        return null;
    }

    @Override
    public String visitVariable(@NonNull Variable variable) {
        OCLExpression initExpression;
        this.appendName(variable);
        Type type = variable.getType();
        if (type != null) {
            this.append(" : ");
            this.appendElementType(variable);
        }
        if ((initExpression = variable.getInitExpression()) != null) {
            this.append(" = ");
            this.safeVisit(initExpression);
        }
        return null;
    }

    @Override
    public String visitVariableExp(@NonNull VariableExp v) {
        this.appendName(v.getReferredVariable());
        return null;
    }

    @Override
    public String visitVoidType(@NonNull VoidType object) {
        this.appendName(object);
        return null;
    }

    @Override
    public String visiting(@NonNull Visitable visitable) {
        this.append(visitable.getClass().getName());
        return null;
    }

    public static interface Factory {
        @NonNull
        public ToStringVisitor createToStringVisitor();

        @NonNull
        public EPackage getEPackage();
    }

    private static final class MyFactory
    implements Factory {
        private MyFactory() {
            ToStringVisitor.addFactory(this);
        }

        @NonNull
        public ToStringVisitor createToStringVisitor() {
            return new ToStringVisitor();
        }

        @NonNull
        public EPackage getEPackage() {
            PivotPackage eInstance = PivotPackage.eINSTANCE;
            assert (eInstance != null);
            return eInstance;
        }
    }
}

