/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.pivot2cs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainNamedElement;
import org.eclipse.ocl.examples.domain.elements.DomainPackage;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Namespace;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.PackageServer;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.PathElement;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.baseCST.ImportCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.NamedElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.RootPackageCS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AliasAnalysis
extends AdapterImpl {
    @NonNull
    protected final MetaModelManager metaModelManager;
    @NonNull
    private Map<String, Object> allNames = new HashMap<String, Object>();
    @NonNull
    private Map<DomainPackage, String> allAliases = new HashMap<DomainPackage, String>();

    public static void dispose(@NonNull Resource resource) {
        List eAdapters = (List)DomainUtil.nonNullEMF((Object)resource.eAdapters());
        AliasAnalysis adapter = (AliasAnalysis)((Object)PivotUtil.getAdapter(AliasAnalysis.class, (List)eAdapters));
        if (adapter != null) {
            adapter.dispose();
        }
    }

    @NonNull
    public static AliasAnalysis getAdapter(@NonNull Resource resource) {
        MetaModelManager metaModelManager = PivotUtil.findMetaModelManager((Resource)resource);
        if (metaModelManager == null) {
            throw new IllegalStateException("No MetaModelManager");
        }
        return AliasAnalysis.getAdapter(resource, metaModelManager);
    }

    @NonNull
    public static AliasAnalysis getAdapter(@NonNull Resource resource, @NonNull MetaModelManager metaModelManager) {
        EList eAdapters = resource.eAdapters();
        for (Adapter adapter : eAdapters) {
            if (!(adapter instanceof AliasAnalysis)) continue;
            AliasAnalysis aliasAnalysis = (AliasAnalysis)adapter;
            if (aliasAnalysis.metaModelManager != metaModelManager) continue;
            return aliasAnalysis;
        }
        AliasAnalysis aliasAnalysis = new AliasAnalysis(resource, metaModelManager);
        HashSet<Package> localPackages = new HashSet<Package>();
        HashSet<Package> otherPackages = new HashSet<Package>();
        aliasAnalysis.computePackages(localPackages, otherPackages);
        aliasAnalysis.computeAliases(localPackages, otherPackages);
        return aliasAnalysis;
    }

    public AliasAnalysis(@NonNull Resource resource, @NonNull MetaModelManager metaModelManager) {
        resource.eAdapters().add((Object)this);
        this.metaModelManager = metaModelManager;
    }

    private void computeAliases(@NonNull Set<Package> localPackages, @NonNull Set<Package> otherPackages) {
        String alias;
        PackageServer primaryPackage;
        for (Package localPackage : localPackages) {
            if (localPackage == null || (primaryPackage = this.metaModelManager.getPackageServer((DomainPackage)localPackage)).getNsPrefix() == null && primaryPackage.getNestingPackage() != null || this.allAliases.containsKey(primaryPackage)) continue;
            alias = this.computeAlias((DomainPackage)primaryPackage);
            this.allAliases.put((DomainPackage)localPackage, alias);
        }
        for (Package otherPackage : otherPackages) {
            if (otherPackage == null || this.allAliases.containsKey(primaryPackage = this.metaModelManager.getPackageServer((DomainPackage)otherPackage))) continue;
            alias = this.computeAlias((DomainPackage)primaryPackage);
            this.allAliases.put((DomainPackage)primaryPackage, alias);
        }
    }

    private void addName(@NonNull String name, @NonNull Object primaryElement) {
        if (!this.allNames.containsKey(name)) {
            this.allNames.put(name, primaryElement);
        } else if (this.allNames.get(name) != primaryElement) {
            this.allNames.put(name, null);
        }
    }

    private String computeAlias(@NonNull DomainPackage primaryPackage) {
        String nsPrefix = primaryPackage.getNsPrefix();
        String aliasBase = nsPrefix != null ? nsPrefix : this.getDefaultAlias(primaryPackage.getName());
        int index = 0;
        String alias = aliasBase;
        while (this.allNames.containsKey(alias) && this.allNames.get(alias) != primaryPackage) {
            Object debugObject = this.allNames.get(alias);
            alias = String.valueOf(aliasBase) + "_" + index++;
        }
        this.addName(alias, primaryPackage);
        return alias;
    }

    private void computePackages(@NonNull Set<Package> localPackages, @NonNull Set<Package> otherPackages) {
        TreeIterator tit = ((Resource)this.target).getAllContents();
        block0: while (tit.hasNext()) {
            String name;
            EObject eObject = (EObject)tit.next();
            if (eObject instanceof ImportCS) {
                String name2 = ((ImportCS)eObject).getName();
                Namespace namespace = ((ImportCS)eObject).getNamespace();
                if (namespace instanceof Package) {
                    this.allAliases.put((DomainPackage)((Package)namespace), name2);
                }
            }
            EObject csObject = eObject;
            if (eObject instanceof Pivotable) {
                eObject = ((Pivotable)eObject).getPivot();
            }
            if (!(eObject instanceof DomainNamedElement)) continue;
            DomainNamedElement domainNamedElement = (DomainNamedElement)eObject;
            if (!(eObject instanceof PackageServer) && !(eObject instanceof PackageServer) && eObject instanceof DomainPackage) {
                domainNamedElement = this.metaModelManager.getPackageServer((DomainPackage)eObject);
            }
            if ((name = domainNamedElement.getName()) != null) {
                this.addName(name, domainNamedElement);
            }
            if (eObject instanceof Package && csObject instanceof RootPackageCS) {
                Package pivotPackage = (Package)eObject;
                String nsPrefix = pivotPackage.getNsPrefix();
                if (nsPrefix != null) {
                    this.addName(nsPrefix, domainNamedElement);
                }
                localPackages.add(pivotPackage);
                continue;
            }
            EObject eContainer = eObject;
            while (eContainer != null) {
                if (eContainer instanceof Package) {
                    otherPackages.add((Package)eContainer);
                    continue block0;
                }
                if (eContainer instanceof Type) {
                    eContainer = PivotUtil.getUnspecializedTemplateableElement((TemplateableElement)((Type)eContainer));
                }
                eContainer = eContainer.eContainer();
            }
        }
        otherPackages.removeAll(localPackages);
        HashSet<Package> nestedPackages = new HashSet<Package>();
        for (Package localPackage : localPackages) {
            EObject eContainerContainer;
            EObject eContainer = localPackage.eContainer();
            if (!(eContainer instanceof Package) || !((eContainerContainer = eContainer.eContainer()) instanceof Package)) continue;
            nestedPackages.add(localPackage);
        }
        localPackages.removeAll(nestedPackages);
    }

    public void dispose() {
        this.target.eAdapters().remove((Object)this);
    }

    @Nullable
    public String getAlias(@NonNull EObject eObject) {
        PackageServer packageServer;
        String alias;
        EObject eObject2 = eObject;
        if (eObject2 instanceof Pivotable) {
            eObject2 = ((Pivotable)eObject2).getPivot();
        }
        if (eObject2 instanceof DomainPackage && (alias = this.allAliases.get(packageServer = this.metaModelManager.getPackageServer((DomainPackage)eObject2))) != null) {
            return alias;
        }
        return null;
    }

    @NonNull
    public Iterable<DomainPackage> getAliases() {
        return this.allAliases.keySet();
    }

    @NonNull
    protected String getDefaultAlias(@Nullable String name) {
        if (name == null) {
            return "anon";
        }
        int iMax = name.length();
        if (iMax <= 0) {
            return "anon";
        }
        if (Character.isLowerCase(name.charAt(0))) {
            return name;
        }
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i < iMax) {
            char c = name.charAt(i);
            if (!Character.isUpperCase(c)) {
                s.append(name.substring(i));
                break;
            }
            s.append(Character.toLowerCase(c));
            ++i;
        }
        String string = s.toString();
        return string;
    }

    @NonNull
    public List<PathElement> getPath(@NonNull Element eObject) {
        EObject eContainer = eObject.eContainer();
        if (eContainer == null) {
            return new ArrayList<PathElement>();
        }
        List<PathElement> result = this.getPath((Element)eContainer);
        if (eObject instanceof NamedElement) {
            result.add(new PathElement(((NamedElement)eObject).getName(), eObject));
        } else if (eObject instanceof ENamedElement) {
            result.add(new PathElement(((ENamedElement)eObject).getName(), eObject));
        } else if (eObject instanceof NamedElementCS) {
            result.add(new PathElement(((NamedElementCS)eObject).getName(), eObject));
        }
        return result;
    }

    public boolean isAdapterForType(Object type) {
        return type == AliasAnalysis.class;
    }
}

