/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.utilities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Feature;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Namespace;
import org.eclipse.ocl.examples.pivot.Root;
import org.eclipse.ocl.examples.pivot.TemplateBinding;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.scoping.Attribution;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.attributes.RootCSAttribution;
import org.eclipse.ocl.examples.xtext.base.baseCST.BaseCSTFactory;
import org.eclipse.ocl.examples.xtext.base.baseCST.ClassCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ModelElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.MultiplicityCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.NamedElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.OperationCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PathElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PathNameCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TemplateBindingCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TemplateParameterSubstitutionCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypeRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.WildcardTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.CS2Pivot;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.LibraryDiagnostic;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextSyntaxDiagnostic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementUtil {
    private static final String[] delegateExtensionPoints = new String[]{"invocation_delegate", "query_delegate", "setting_delegate", "validation_delegate"};
    private static String[][] delegationModes = null;

    @Deprecated
    @Nullable
    public static MetaModelManager findMetaModelManager(@NonNull EObject eObject) {
        return PivotUtil.findMetaModelManager((EObject)eObject);
    }

    @Deprecated
    @Nullable
    public static MetaModelManager findMetaModelManager(@NonNull Resource resource) {
        return PivotUtil.findMetaModelManager((Resource)resource);
    }

    @Deprecated
    public static MetaModelManager findMetaModelManager(@NonNull ResourceSet resourceSet) {
        return PivotUtil.findMetaModelManager((ResourceSet)resourceSet);
    }

    @Nullable
    public static String getCollectionTypeName(@NonNull TypedElementCS csTypedElement) {
        TypedRefCS csTypeRef = csTypedElement.getOwnedType();
        if (csTypeRef == null) {
            return null;
        }
        MultiplicityCS csMultiplicity = csTypeRef.getMultiplicity();
        if (csMultiplicity == null) {
            return null;
        }
        int upper = csMultiplicity.getUpper();
        if (upper == 1) {
            return null;
        }
        EList<String> qualifiers = csTypedElement.getQualifier();
        boolean isOrdered = true;
        boolean isUnique = true;
        if (qualifiers.contains("!ordered")) {
            isOrdered = false;
        } else if (qualifiers.contains("ordered")) {
            isOrdered = true;
        }
        if (qualifiers.contains("!unique")) {
            isUnique = false;
        } else if (qualifiers.contains("unique")) {
            isUnique = true;
        }
        return ElementUtil.getCollectionName(isOrdered, isUnique);
    }

    @NonNull
    public static String getCollectionName(boolean ordered, boolean unique) {
        if (ordered) {
            return unique ? "OrderedSet" : "Sequence";
        }
        return unique ? "Set" : "Bag";
    }

    @Nullable
    public static ModelElementCS getCsElement(@NonNull Element obj) {
        Resource resource = obj.eResource();
        if (resource == null) {
            return null;
        }
        ResourceSet resourceSet = resource.getResourceSet();
        if (resourceSet == null) {
            return null;
        }
        CS2Pivot cs2Pivot = CS2Pivot.findAdapter(resourceSet);
        if (cs2Pivot == null) {
            return null;
        }
        return cs2Pivot.getCSElement(obj);
    }

    public static String[][] getDelegateURIs() {
        if (delegationModes == null) {
            HashSet<String> uris = new HashSet<String>();
            IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
            String pluginID = EcorePlugin.getPlugin().getBundle().getSymbolicName();
            String[] stringArray = delegateExtensionPoints;
            int n = delegateExtensionPoints.length;
            int n2 = 0;
            while (n2 < n) {
                String extensionPointID = stringArray[n2];
                IExtensionPoint point = pluginRegistry.getExtensionPoint(pluginID, extensionPointID);
                if (point != null) {
                    IConfigurationElement[] elements = point.getConfigurationElements();
                    int i = 0;
                    while (i < elements.length) {
                        String uri = elements[i].getAttribute("uri");
                        if (uri != null) {
                            uris.add(uri);
                        }
                        ++i;
                    }
                }
                ++n2;
            }
            ArrayList uriList = new ArrayList(uris);
            Collections.sort(uriList);
            delegationModes = new String[uriList.size()][2];
            int i = 0;
            while (i < uris.size()) {
                ElementUtil.delegationModes[i][0] = (String)uriList.get(i);
                ElementUtil.delegationModes[i][1] = (String)uriList.get(i);
                ++i;
            }
        }
        return delegationModes;
    }

    @Nullable
    public static RootCSAttribution getDocumentAttribution(@NonNull ElementCS context) {
        ElementCS parent;
        ElementCS target = context;
        while ((parent = target.getLogicalParent()) != null) {
            Attribution attribution = PivotUtil.getAttribution((EObject)parent);
            if (attribution instanceof RootCSAttribution) {
                return (RootCSAttribution)attribution;
            }
            target = parent;
        }
        return null;
    }

    @Nullable
    public static String getExpressionText(@NonNull ElementCS csElement) {
        ICompositeNode parserNode = NodeModelUtils.getNode((EObject)csElement);
        if (parserNode != null) {
            String text = parserNode.getText().replace("\r", "");
            if (text.length() > 0 && text.charAt(0) == ' ') {
                text = text.substring(1);
            }
            INode nextNode = parserNode.getNextSibling();
            ICompositeNode parent = parserNode.getParent();
            while (parent != null) {
                nextNode = parent.getNextSibling();
                if (nextNode != null) {
                    String nextText = nextNode.getText().replace("\r", "");
                    int i = 0;
                    int iMax = nextText.length();
                    while (i < iMax) {
                        if (!Character.isWhitespace(nextText.charAt(i))) break;
                        ++i;
                    }
                    return String.valueOf(text) + nextText.substring(0, i);
                }
                parent = parent.getParent();
            }
            return text;
        }
        return null;
    }

    @Nullable
    public static TemplateParameter getFormalTemplateParameter(@NonNull TemplateParameterSubstitutionCS csTemplateParameterSubstitution) {
        TemplateBindingCS csTemplateBinding = csTemplateParameterSubstitution.getOwningTemplateBinding();
        int index = csTemplateBinding.getOwnedParameterSubstitution().indexOf((Object)csTemplateParameterSubstitution);
        if (index < 0) {
            return null;
        }
        TemplateBinding templateBinding = (TemplateBinding)csTemplateBinding.getPivot();
        TemplateSignature templateSignature = templateBinding.getSignature();
        List templateParameters = templateSignature.getOwnedParameter();
        if (templateParameters.size() <= index) {
            return null;
        }
        return (TemplateParameter)templateParameters.get(index);
    }

    @Nullable
    public static ILeafNode getLeafNode(@NonNull INode node) {
        ILeafNode leafNode = null;
        if (node instanceof ILeafNode) {
            return (ILeafNode)node;
        }
        for (ILeafNode lNode : node.getLeafNodes()) {
            if (lNode.isHidden()) continue;
            leafNode = lNode;
            return leafNode;
        }
        return null;
    }

    public static int getLower(@NonNull TypedElementCS csTypedElement) {
        TypedRefCS csTypeRef = csTypedElement.getOwnedType();
        if (csTypeRef == null) {
            return 0;
        }
        MultiplicityCS csMultiplicity = csTypeRef.getMultiplicity();
        if (csMultiplicity == null) {
            return 1;
        }
        return csMultiplicity.getLower();
    }

    @Nullable
    public static <T extends NamedElementCS> T getNamedElementCS(@NonNull Collection<T> namedElements, @NonNull String name) {
        for (NamedElementCS namedElement : namedElements) {
            if (!name.equals(namedElement.getName())) continue;
            return (T)namedElement;
        }
        return null;
    }

    public static boolean getQualifier(@NonNull List<String> qualifiers, @NonNull String trueString, @NonNull String falseString, boolean defaultValue) {
        if (qualifiers.contains(trueString)) {
            return true;
        }
        if (qualifiers.contains(falseString)) {
            return false;
        }
        return defaultValue;
    }

    public static String getText(@NonNull ElementCS csElement) {
        ICompositeNode node = NodeModelUtils.getNode((EObject)csElement);
        return NodeModelUtils.getTokenText((INode)node);
    }

    @Nullable
    public static String getText(@NonNull TypedTypeRefCS csElement, @NonNull EReference feature) {
        List nodes = NodeModelUtils.findNodesForFeature((EObject)csElement, (EStructuralFeature)feature);
        if (nodes.isEmpty()) {
            return null;
        }
        if (nodes.size() == 1) {
            return NodeModelUtils.getTokenText((INode)((INode)nodes.get(0)));
        }
        StringBuilder s = new StringBuilder();
        for (INode node : nodes) {
            s.append(NodeModelUtils.getTokenText((INode)node));
        }
        return s.toString();
    }

    public static int getUpper(@NonNull TypedElementCS csTypedElement) {
        TypedRefCS csTypeRef = csTypedElement.getOwnedType();
        if (csTypeRef == null) {
            return 1;
        }
        MultiplicityCS csMultiplicity = csTypeRef.getMultiplicity();
        if (csMultiplicity == null) {
            return 1;
        }
        return csMultiplicity.getUpper();
    }

    public static boolean hasSyntaxError(@NonNull List<Resource.Diagnostic> diagnostics) {
        for (Resource.Diagnostic diagnostic : diagnostics) {
            if (diagnostic instanceof LibraryDiagnostic) {
                return true;
            }
            if (!(diagnostic instanceof XtextSyntaxDiagnostic)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInOperation(@NonNull ElementCS csElement) {
        ElementCS eObject = csElement;
        while (eObject != null) {
            if (eObject instanceof OperationCS) {
                return true;
            }
            if (eObject instanceof ClassCS) {
                return false;
            }
            eObject = eObject.eContainer();
        }
        return false;
    }

    public static boolean isOrdered(@NonNull TypedElementCS csTypedElement) {
        EList<String> qualifiers = csTypedElement.getQualifier();
        assert (qualifiers != null);
        return ElementUtil.getQualifier(qualifiers, "ordered", "!ordered", false);
    }

    @Deprecated
    public static NamedElement isPathable(@NonNull EObject element) {
        if (element instanceof Feature) {
            return (Feature)element;
        }
        if (element instanceof Type) {
            return (Type)element;
        }
        if (element instanceof Namespace) {
            return (Namespace)element;
        }
        return null;
    }

    public static boolean isUnique(@NonNull TypedElementCS csTypedElement) {
        EList<String> qualifiers = csTypedElement.getQualifier();
        assert (qualifiers != null);
        return ElementUtil.getQualifier(qualifiers, "unique", "!unique", true);
    }

    public static boolean isSpecialization(@NonNull TemplateBindingCS csTemplateBinding) {
        TypedTypeRefCS csTypedTypeRef = csTemplateBinding.getOwningTemplateBindableElement();
        Element type = csTypedTypeRef.getPivot();
        for (TemplateParameterSubstitutionCS csTemplateParameterSubstitution : csTemplateBinding.getOwnedParameterSubstitution()) {
            TypeRefCS ownedActualParameter = csTemplateParameterSubstitution.getOwnedActualParameter();
            if (ownedActualParameter instanceof WildcardTypeRefCS) {
                return true;
            }
            Type actualParameterClass = (Type)ownedActualParameter.getPivot();
            TemplateParameter owningTemplateParameter = actualParameterClass.getOwningTemplateParameter();
            if (owningTemplateParameter == null) {
                return true;
            }
            TemplateSignature signature = owningTemplateParameter.getSignature();
            TemplateableElement template = signature.getTemplate();
            if (template == type) continue;
            return true;
        }
        return false;
    }

    public static void setPathName(@NonNull PathNameCS csPathName, @NonNull Element element, Namespace scope) {
        EList<PathElementCS> csPath = csPathName.getPath();
        csPath.clear();
        PathElementCS csSimpleRef = BaseCSTFactory.eINSTANCE.createPathElementCS();
        csPath.add(csSimpleRef);
        csSimpleRef.setElement(element);
        if (ElementUtil.isPathable((EObject)element) == null) {
            return;
        }
        EObject eContainer = element.eContainer();
        while (eContainer instanceof Element) {
            if (eContainer instanceof Root) {
                return;
            }
            Namespace aScope = scope;
            while (aScope != null) {
                if (aScope == eContainer) {
                    return;
                }
                aScope = aScope.eContainer();
            }
            csSimpleRef = BaseCSTFactory.eINSTANCE.createPathElementCS();
            csPath.add(0, csSimpleRef);
            csSimpleRef.setElement((Element)eContainer);
            eContainer = eContainer.eContainer();
        }
    }
}

