/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.essentialocl.attributes;

import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.elements.DomainNamedElement;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.IterateExp;
import org.eclipse.ocl.examples.pivot.LoopExp;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.scoping.AbstractAttribution;
import org.eclipse.ocl.examples.pivot.scoping.EnvironmentView;
import org.eclipse.ocl.examples.pivot.scoping.ScopeView;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.essentialocl.attributes.NavigationUtil;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.ExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.InvocationExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NavigatingArgCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NavigationOperatorCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NavigationRole;

public class NavigatingArgCSAttribution
extends AbstractAttribution {
    @NonNull
    public static final NavigatingArgCSAttribution INSTANCE = new NavigatingArgCSAttribution();

    public ScopeView computeLookup(@NonNull EObject target, @NonNull EnvironmentView environmentView, @NonNull ScopeView scopeView) {
        ExpCS csSource;
        OCLExpression source;
        NavigatingArgCS fromArgument = (NavigatingArgCS)target;
        NavigationRole role = fromArgument.getRole();
        InvocationExpCS targetElement = (InvocationExpCS)fromArgument.getLogicalParent();
        assert (targetElement != null);
        NavigationOperatorCS csNavigationOperator = NavigationUtil.getNavigationOperator(targetElement);
        OCLExpression pivot = (OCLExpression)PivotUtil.getPivot(OCLExpression.class, (Pivotable)targetElement);
        if (pivot instanceof LoopExp) {
            Variable result;
            if (role == NavigationRole.EXPRESSION) {
                for (Variable iterator : ((LoopExp)pivot).getIterator()) {
                    if (iterator.isImplicit()) {
                        environmentView.addElementsOfScope((Element)iterator.getType(), scopeView);
                    } else {
                        environmentView.addNamedElement((DomainNamedElement)iterator);
                    }
                    if (!environmentView.hasFinalResult()) continue;
                    return null;
                }
                if (pivot instanceof IterateExp) {
                    Variable result2 = ((IterateExp)pivot).getResult();
                    if (result2.isImplicit()) {
                        environmentView.addElementsOfScope((Element)result2.getType(), scopeView);
                    } else {
                        environmentView.addNamedElement((DomainNamedElement)result2);
                    }
                    if (environmentView.hasFinalResult()) {
                        return null;
                    }
                }
            } else if (role == NavigationRole.ITERATOR) {
                List iterators = ((LoopExp)pivot).getIterator();
                assert (iterators != null);
                environmentView.addNamedElements((Iterable)iterators);
            } else if (role == NavigationRole.ACCUMULATOR && (result = ((IterateExp)pivot).getResult()) != null) {
                environmentView.addNamedElement((DomainNamedElement)result);
            }
        } else if (pivot == null && role == NavigationRole.EXPRESSION && csNavigationOperator != null && csNavigationOperator.getName().equals("->") && (source = (OCLExpression)PivotUtil.getPivot(OCLExpression.class, (Pivotable)(csSource = csNavigationOperator.getSource()))) != null) {
            Type elementType;
            CollectionType collectionType;
            Type type = source.getType();
            MetaModelManager metaModelManager = environmentView.getMetaModelManager();
            if (type instanceof CollectionType) {
                collectionType = (CollectionType)type;
                elementType = collectionType.getElementType();
                ExpCS csArgument = csNavigationOperator.getArgument();
                assert (csArgument == targetElement);
            } else {
                elementType = type;
                collectionType = metaModelManager.getSetType();
            }
            if (NavigationUtil.isIteration(metaModelManager, targetElement, collectionType)) {
                if (environmentView.accepts(PivotPackage.Literals.TYPE)) {
                    EClassifier requiredType = environmentView.getRequiredType();
                    try {
                        environmentView.setRequiredType((EClassifier)PivotPackage.Literals.TYPE);
                        environmentView.computeLookups(scopeView.getParent().getParent().getParent());
                    }
                    finally {
                        environmentView.setRequiredType(requiredType);
                    }
                }
                environmentView.addElementsOfScope((Element)elementType, scopeView);
                if (environmentView.hasFinalResult()) {
                    return null;
                }
            }
        }
        if (csNavigationOperator != null) {
            return scopeView.getParent().getParent().getParent();
        }
        return scopeView.getParent().getParent();
    }
}

