/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.essentialocl.cs2pivot;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainElement;
import org.eclipse.ocl.examples.domain.values.Unlimited;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;
import org.eclipse.ocl.examples.pivot.BooleanLiteralExp;
import org.eclipse.ocl.examples.pivot.CollectionItem;
import org.eclipse.ocl.examples.pivot.CollectionLiteralExp;
import org.eclipse.ocl.examples.pivot.CollectionLiteralPart;
import org.eclipse.ocl.examples.pivot.CollectionRange;
import org.eclipse.ocl.examples.pivot.ConstructorExp;
import org.eclipse.ocl.examples.pivot.ConstructorPart;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.IfExp;
import org.eclipse.ocl.examples.pivot.IntegerLiteralExp;
import org.eclipse.ocl.examples.pivot.NullLiteralExp;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.RealLiteralExp;
import org.eclipse.ocl.examples.pivot.StringLiteralExp;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TupleLiteralExp;
import org.eclipse.ocl.examples.pivot.TupleLiteralPart;
import org.eclipse.ocl.examples.pivot.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.VariableExp;
import org.eclipse.ocl.examples.pivot.context.Base2PivotConversion;
import org.eclipse.ocl.examples.pivot.context.ParserContext;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.scoping.EnvironmentView;
import org.eclipse.ocl.examples.pivot.scoping.ScopeFilter;
import org.eclipse.ocl.examples.pivot.utilities.BaseResource;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.baseCST.BaseCSTPackage;
import org.eclipse.ocl.examples.xtext.base.baseCST.ConstraintCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ModelElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PathNameCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.SpecificationCS;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.CS2Pivot;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.CS2PivotConversion;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.Continuation;
import org.eclipse.ocl.examples.xtext.essentialocl.cs2pivot.AbstractEssentialOCLContainmentVisitor;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.BooleanLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.CollectionLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.CollectionLiteralPartCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.CollectionTypeCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.ConstructorExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.ConstructorPartCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.ContextCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.ExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.ExpSpecificationCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.IfExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.IndexExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.InfixExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.InvalidLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.InvocationExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.LiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NameExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NavigatingArgCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NestedExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NullLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NumberLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.OperatorCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.PrefixExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.PrimitiveLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.SelfExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.StringLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.TupleLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.TupleLiteralPartCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.TypeLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.TypeNameExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.UnlimitedNaturalLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.VariableCS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EssentialOCLContainmentVisitor
extends AbstractEssentialOCLContainmentVisitor {
    public EssentialOCLContainmentVisitor(@NonNull CS2PivotConversion context) {
        super(context);
    }

    @Override
    public Continuation<?> visitBooleanLiteralExpCS(@NonNull BooleanLiteralExpCS csElement) {
        BooleanLiteralExp pivotElement = (BooleanLiteralExp)((CS2PivotConversion)this.context).refreshModelElement(BooleanLiteralExp.class, PivotPackage.Literals.BOOLEAN_LITERAL_EXP, (ModelElementCS)csElement);
        if (pivotElement != null) {
            pivotElement.setBooleanSymbol(Boolean.valueOf(csElement.getName()).booleanValue());
        }
        return null;
    }

    @Override
    public Continuation<?> visitCollectionLiteralExpCS(@NonNull CollectionLiteralExpCS csElement) {
        CollectionLiteralExp pivotElement = (CollectionLiteralExp)((CS2PivotConversion)this.context).refreshModelElement(CollectionLiteralExp.class, PivotPackage.Literals.COLLECTION_LITERAL_EXP, (ModelElementCS)csElement);
        if (pivotElement != null) {
            ((CS2PivotConversion)this.context).refreshPivotList(CollectionLiteralPart.class, pivotElement.getPart(), csElement.getOwnedParts());
        }
        return null;
    }

    @Override
    public Continuation<?> visitCollectionLiteralPartCS(@NonNull CollectionLiteralPartCS csElement) {
        if (csElement.getLastExpressionCS() == null) {
            ((CS2PivotConversion)this.context).refreshModelElement(CollectionItem.class, PivotPackage.Literals.COLLECTION_ITEM, (ModelElementCS)csElement);
        } else {
            ((CS2PivotConversion)this.context).refreshModelElement(CollectionRange.class, PivotPackage.Literals.COLLECTION_RANGE, (ModelElementCS)csElement);
        }
        return null;
    }

    @Override
    public Continuation<?> visitCollectionTypeCS(@NonNull CollectionTypeCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitConstructorExpCS(@NonNull ConstructorExpCS csElement) {
        ConstructorExp pivotElement;
        PathNameCS pathName = csElement.getPathName();
        if (pathName != null) {
            CS2Pivot.setElementType((PathNameCS)pathName, (EClass)PivotPackage.Literals.TYPE, (ElementCS)csElement, null);
        }
        if ((pivotElement = (ConstructorExp)((CS2PivotConversion)this.context).refreshModelElement(ConstructorExp.class, PivotPackage.Literals.CONSTRUCTOR_EXP, (ModelElementCS)csElement)) != null) {
            pivotElement.setValue(csElement.getValue());
            ((CS2PivotConversion)this.context).refreshPivotList(ConstructorPart.class, pivotElement.getPart(), csElement.getOwnedParts());
        }
        return null;
    }

    @Override
    public Continuation<?> visitConstructorPartCS(@NonNull ConstructorPartCS csElement) {
        ((CS2PivotConversion)this.context).refreshModelElement(ConstructorPart.class, PivotPackage.Literals.CONSTRUCTOR_PART, (ModelElementCS)csElement);
        return null;
    }

    @Override
    public Continuation<?> visitContextCS(@NonNull ContextCS csElement) {
        ExpressionInOCL pivotElement = (ExpressionInOCL)((CS2PivotConversion)this.context).refreshModelElement(ExpressionInOCL.class, PivotPackage.Literals.EXPRESSION_IN_OCL, (ModelElementCS)csElement);
        if (pivotElement != null) {
            ParserContext parserContext;
            PivotUtil.setBody((ExpressionInOCL)pivotElement, null, null);
            PivotUtil.setMessage((ExpressionInOCL)pivotElement, null, null);
            Resource resource = csElement.eResource();
            if (resource instanceof BaseResource && (parserContext = ((BaseResource)resource).getParserContext()) != null) {
                parserContext.initialize((Base2PivotConversion)this.context, pivotElement);
            }
        }
        return null;
    }

    @Override
    public Continuation<?> visitExpCS(@NonNull ExpCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitExpSpecificationCS(@NonNull ExpSpecificationCS csElement) {
        EClass ecoreLiteral;
        EStructuralFeature eContainingFeature = csElement.eContainingFeature();
        Class pivotClass = csElement.getOwnedExpression() != null ? ExpressionInOCL.class : OpaqueExpression.class;
        EClass eClass = ecoreLiteral = csElement.getOwnedExpression() != null ? PivotPackage.Literals.EXPRESSION_IN_OCL : PivotPackage.Literals.OPAQUE_EXPRESSION;
        if (eContainingFeature == BaseCSTPackage.Literals.CONSTRAINT_CS__MESSAGE_SPECIFICATION) {
            Element pivotElement;
            SpecificationCS csSpecification = ((ConstraintCS)csElement.eContainer()).getSpecification();
            if (csSpecification != null && (pivotElement = ((CS2PivotConversion)this.context).refreshModelElement(pivotClass, ecoreLiteral, (ModelElementCS)csSpecification)) != null) {
                ((CS2PivotConversion)this.context).installPivotUsage((ModelElementCS)csElement, pivotElement);
            }
        } else {
            ((CS2PivotConversion)this.context).refreshModelElement(pivotClass, ecoreLiteral, (ModelElementCS)csElement);
        }
        return null;
    }

    @Override
    public Continuation<?> visitIfExpCS(@NonNull IfExpCS csElement) {
        ((CS2PivotConversion)this.context).refreshModelElement(IfExp.class, PivotPackage.Literals.IF_EXP, (ModelElementCS)csElement);
        return null;
    }

    @Override
    public Continuation<?> visitIndexExpCS(@NonNull IndexExpCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitInfixExpCS(@NonNull InfixExpCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitInvalidLiteralExpCS(@NonNull InvalidLiteralExpCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitInvocationExpCS(@NonNull InvocationExpCS csElement) {
        PathNameCS pathName = csElement.getPathName();
        assert (pathName != null);
        CS2Pivot.setElementType((PathNameCS)pathName, (EClass)PivotPackage.Literals.OPERATION, (ElementCS)csElement, null);
        return null;
    }

    @Override
    public Continuation<?> visitLiteralExpCS(@NonNull LiteralExpCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitNameExpCS(@NonNull NameExpCS csElement) {
        PathNameCS pathName = csElement.getPathName();
        assert (pathName != null);
        CS2Pivot.setElementType((PathNameCS)pathName, (EClass)PivotPackage.Literals.ELEMENT, (ElementCS)csElement, (ScopeFilter)NotOperationFilter.INSTANCE);
        return null;
    }

    @Override
    public Continuation<?> visitNavigatingArgCS(@NonNull NavigatingArgCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitNestedExpCS(@NonNull NestedExpCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitNullLiteralExpCS(@NonNull NullLiteralExpCS csElement) {
        ((CS2PivotConversion)this.context).refreshModelElement(NullLiteralExp.class, PivotPackage.Literals.NULL_LITERAL_EXP, (ModelElementCS)csElement);
        return null;
    }

    @Override
    public Continuation<?> visitNumberLiteralExpCS(@NonNull NumberLiteralExpCS csElement) {
        Number number = csElement.getName();
        if (number instanceof BigDecimal || number instanceof Double || number instanceof Float) {
            RealLiteralExp pivotElement = (RealLiteralExp)((CS2PivotConversion)this.context).refreshModelElement(RealLiteralExp.class, PivotPackage.Literals.REAL_LITERAL_EXP, (ModelElementCS)csElement);
            if (pivotElement != null) {
                pivotElement.setRealSymbol(number);
            }
        } else {
            IntegerLiteralExp pivotElement;
            boolean isNegative;
            if (number instanceof BigInteger) {
                BigInteger bigInteger = (BigInteger)number;
                boolean bl = isNegative = bigInteger.signum() < 0;
                if (isNegative) {
                    if (bigInteger.compareTo(ValuesUtil.INTEGER_MIN_VALUE) >= 0) {
                        number = bigInteger.intValue();
                    } else if (bigInteger.compareTo(ValuesUtil.LONG_MIN_VALUE) >= 0) {
                        number = bigInteger.longValue();
                    }
                } else if (bigInteger.compareTo(ValuesUtil.INTEGER_MAX_VALUE) <= 0) {
                    number = bigInteger.intValue();
                } else if (bigInteger.compareTo(ValuesUtil.LONG_MAX_VALUE) <= 0) {
                    number = bigInteger.longValue();
                }
            } else {
                long longValue = number.longValue();
                boolean bl = isNegative = longValue < 0L;
                number = isNegative ? (Number)(longValue >= Integer.MIN_VALUE ? (Number)((int)longValue) : (Number)longValue) : (Number)(longValue <= Integer.MAX_VALUE ? (Number)((int)longValue) : (Number)longValue);
            }
            if (isNegative) {
                pivotElement = (IntegerLiteralExp)((CS2PivotConversion)this.context).refreshModelElement(IntegerLiteralExp.class, PivotPackage.Literals.INTEGER_LITERAL_EXP, (ModelElementCS)csElement);
                if (pivotElement != null) {
                    pivotElement.setIntegerSymbol(number);
                }
            } else {
                pivotElement = (UnlimitedNaturalLiteralExp)((CS2PivotConversion)this.context).refreshModelElement(UnlimitedNaturalLiteralExp.class, PivotPackage.Literals.UNLIMITED_NATURAL_LITERAL_EXP, (ModelElementCS)csElement);
                if (pivotElement != null) {
                    pivotElement.setUnlimitedNaturalSymbol(number);
                }
            }
        }
        return null;
    }

    @Override
    public Continuation<?> visitOperatorCS(@NonNull OperatorCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitPrefixExpCS(@NonNull PrefixExpCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitPrimitiveLiteralExpCS(@NonNull PrimitiveLiteralExpCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitSelfExpCS(@NonNull SelfExpCS csElement) {
        ((CS2PivotConversion)this.context).refreshModelElement(VariableExp.class, PivotPackage.Literals.VARIABLE_EXP, (ModelElementCS)csElement);
        return null;
    }

    @Override
    public Continuation<?> visitStringLiteralExpCS(@NonNull StringLiteralExpCS csElement) {
        StringLiteralExp pivotElement = (StringLiteralExp)((CS2PivotConversion)this.context).refreshModelElement(StringLiteralExp.class, PivotPackage.Literals.STRING_LITERAL_EXP, (ModelElementCS)csElement);
        if (pivotElement != null) {
            EList<String> names = csElement.getName();
            if (names.size() == 0) {
                pivotElement.setStringSymbol("");
            } else if (names.size() == 1) {
                pivotElement.setStringSymbol((String)names.get(0));
            } else {
                StringBuilder s = new StringBuilder();
                for (String name : names) {
                    s.append(name);
                }
                pivotElement.setStringSymbol(s.toString());
            }
        }
        return null;
    }

    @Override
    public Continuation<?> visitTupleLiteralExpCS(@NonNull TupleLiteralExpCS csElement) {
        TupleLiteralExp pivotElement = (TupleLiteralExp)((CS2PivotConversion)this.context).refreshModelElement(TupleLiteralExp.class, PivotPackage.Literals.TUPLE_LITERAL_EXP, (ModelElementCS)csElement);
        if (pivotElement != null) {
            ((CS2PivotConversion)this.context).refreshPivotList(TupleLiteralPart.class, pivotElement.getPart(), csElement.getOwnedParts());
        }
        return null;
    }

    @Override
    public Continuation<?> visitTupleLiteralPartCS(@NonNull TupleLiteralPartCS csElement) {
        this.refreshNamedElement(TupleLiteralPart.class, PivotPackage.Literals.TUPLE_LITERAL_PART, csElement);
        return null;
    }

    @Override
    public Continuation<?> visitTypeLiteralExpCS(@NonNull TypeLiteralExpCS csElement) {
        return null;
    }

    @Override
    public Continuation<?> visitTypeNameExpCS(@NonNull TypeNameExpCS csElement) {
        PathNameCS pathName = csElement.getPathName();
        assert (pathName != null);
        CS2Pivot.setElementType((PathNameCS)pathName, (EClass)PivotPackage.Literals.TYPE, (ElementCS)csElement, null);
        return null;
    }

    @Override
    public Continuation<?> visitUnlimitedNaturalLiteralExpCS(@NonNull UnlimitedNaturalLiteralExpCS csElement) {
        UnlimitedNaturalLiteralExp pivotElement = (UnlimitedNaturalLiteralExp)((CS2PivotConversion)this.context).refreshModelElement(UnlimitedNaturalLiteralExp.class, PivotPackage.Literals.UNLIMITED_NATURAL_LITERAL_EXP, (ModelElementCS)csElement);
        if (pivotElement != null) {
            pivotElement.setName("*");
            pivotElement.setUnlimitedNaturalSymbol((Number)Unlimited.INSTANCE);
        }
        return null;
    }

    @Override
    public Continuation<?> visitVariableCS(@NonNull VariableCS csElement) {
        this.refreshNamedElement(Variable.class, PivotPackage.Literals.VARIABLE, csElement);
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NotOperationFilter
    implements ScopeFilter {
        public static NotOperationFilter INSTANCE = new NotOperationFilter();

        private NotOperationFilter() {
        }

        public int compareMatches(@NonNull MetaModelManager metaModelManager, @NonNull DomainElement match1, @Nullable Map<TemplateParameter, ParameterableElement> bindings1, @NonNull DomainElement match2, @Nullable Map<TemplateParameter, ParameterableElement> bindings2) {
            return 0;
        }

        public boolean matches(@NonNull EnvironmentView environmentView, @NonNull DomainElement eObject) {
            return !(eObject instanceof Operation);
        }
    }
}

