/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.essentialocl.utilities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.elements.Nameable;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.PivotConstants;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.baseCST.BaseCSTPackage;
import org.eclipse.ocl.examples.xtext.base.baseCST.ConstraintCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ModelElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PathElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.PathNameCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedRefCS;
import org.eclipse.ocl.examples.xtext.base.util.BaseCSVisitor;
import org.eclipse.ocl.examples.xtext.base.util.VisitableCS;
import org.eclipse.ocl.examples.xtext.base.utilities.BaseCS2MonikerVisitor;
import org.eclipse.ocl.examples.xtext.base.utilities.CS2Moniker;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.BinaryOperatorCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.BooleanLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.CollectionLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.CollectionLiteralPartCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.CollectionTypeCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.ConstructorExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.ContextCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.EssentialOCLCSTPackage;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.IfExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.InfixExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.InvalidLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.InvocationExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.LetExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.LetVariableCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NameExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NavigatingArgCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NavigationOperatorCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NavigationRole;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NestedExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NullLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NumberLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.OperatorCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.PrefixExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.SelfExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.StringLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.TupleLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.TupleLiteralPartCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.TypeLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.TypeNameExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.UnlimitedNaturalLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.util.AbstractExtendingDelegatingEssentialOCLCSVisitor;
import org.eclipse.ocl.examples.xtext.essentialocl.utilities.EssentialOCLUtils;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EssentialOCLCS2MonikerVisitor
extends AbstractExtendingDelegatingEssentialOCLCSVisitor<Boolean, CS2Moniker, BaseCSVisitor<Boolean>>
implements PivotConstants {
    @NonNull
    public static CS2Moniker.Factory FACTORY = new Factory();

    public EssentialOCLCS2MonikerVisitor(CS2Moniker context) {
        super(context.getVisitor((EPackage)BaseCSTPackage.eINSTANCE), context);
    }

    protected void appendExpPrefix(ElementCS object) {
        EObject pivotingParentParent;
        ModelElementCS pivotingParent;
        if (((CS2Moniker)this.context).toString().length() >= 1024) {
            ((CS2Moniker)this.context).append("##");
            return;
        }
        ModelElementCS pivotedChild = EssentialOCLUtils.getPivotedCS((EObject)object);
        ElementCS pivotingChild = EssentialOCLUtils.getPivotingChildCS((ElementCS)pivotedChild);
        EReference pivotingFeature = EssentialOCLUtils.getPivotingFeature(pivotingChild, (ElementCS)(pivotingParent = EssentialOCLUtils.getPivotingParentCS(pivotingChild)));
        if (pivotingFeature == null) {
            ((CS2Moniker)this.context).append("<<null-element>>");
            return;
        }
        assert (pivotingFeature.getEContainingClass().isInstance((Object)pivotingParent));
        assert (pivotingFeature.getEReferenceType().isInstance((Object)pivotingChild));
        ModelElementCS pivotedCS = EssentialOCLUtils.getPivotedCS((EObject)pivotingParent);
        if (pivotedCS != null) {
            ((CS2Moniker)this.context).append(CS2Moniker.toString((ElementCS)pivotedCS));
        }
        ((CS2Moniker)this.context).append("!");
        if (pivotingFeature == EssentialOCLCSTPackage.Literals.LET_EXP_CS__IN) {
            int iMax = ((LetExpCS)pivotingParent).getVariable().size();
            int i = 1;
            while (i < iMax) {
                ((CS2Moniker)this.context).append(EssentialOCLCSTPackage.Literals.LET_EXP_CS__IN.getName());
                ((CS2Moniker)this.context).append("~");
                ((CS2Moniker)this.context).append("let");
                ((CS2Moniker)this.context).append("!");
                ++i;
            }
        } else if (pivotingFeature == EssentialOCLCSTPackage.Literals.EXP_SPECIFICATION_CS__OWNED_EXPRESSION && (pivotingParentParent = pivotingParent.eContainer()) instanceof ConstraintCS) {
            ConstraintCS csConstraint = (ConstraintCS)pivotingParentParent;
            if (pivotingParent == csConstraint.getSpecification()) {
                pivotingFeature = PivotPackage.Literals.EXPRESSION_IN_OCL__BODY_EXPRESSION;
            } else if (pivotingParent == csConstraint.getMessageSpecification()) {
                pivotingFeature = PivotPackage.Literals.EXPRESSION_IN_OCL__MESSAGE_EXPRESSION;
            }
        }
        int index = 0;
        if (pivotingFeature.isMany()) {
            index = ((List)pivotingParent.eGet((EStructuralFeature)pivotingFeature)).indexOf(pivotingChild);
            if (pivotingFeature == EssentialOCLCSTPackage.Literals.INVOCATION_EXP_CS__ARGUMENT) {
                InvocationExpCS csNavigatingExp = (InvocationExpCS)pivotingParent;
                NavigatingArgCS csNavigatingArg = (NavigatingArgCS)csNavigatingExp.getArgument().get(index);
                switch (csNavigatingArg.getRole()) {
                    case ITERATOR: {
                        pivotingFeature = PivotPackage.Literals.LOOP_EXP__ITERATOR;
                        break;
                    }
                    case ACCUMULATOR: {
                        pivotingFeature = PivotPackage.Literals.ITERATE_EXP__RESULT;
                        break;
                    }
                    case EXPRESSION: {
                        pivotingFeature = PivotPackage.Literals.LOOP_EXP__BODY;
                    }
                }
                int roleIndex = 0;
                while (roleIndex < index) {
                    if (((NavigatingArgCS)csNavigatingExp.getArgument().get(index - (roleIndex + 1))).getRole() != csNavigatingArg.getRole()) break;
                    ++roleIndex;
                }
                index = roleIndex;
            }
        } else if (pivotingFeature == EssentialOCLCSTPackage.Literals.COLLECTION_LITERAL_PART_CS__EXPRESSION_CS) {
            pivotingFeature = ((CollectionLiteralPartCS)pivotingParent).getLastExpressionCS() != null ? PivotPackage.Literals.COLLECTION_RANGE__FIRST : PivotPackage.Literals.COLLECTION_ITEM__ITEM;
        }
        ((CS2Moniker)this.context).appendRoleCS((EStructuralFeature)pivotingFeature);
        if (index != 0) {
            assert (index > 0);
            ((CS2Moniker)this.context).append(index);
        }
        ((CS2Moniker)this.context).append("~");
        if (pivotingChild instanceof NavigatingArgCS && ((NavigatingArgCS)pivotingChild).getRole() == NavigationRole.ACCUMULATOR && object != pivotingChild && object != ((NavigatingArgCS)pivotingChild).getName()) {
            NameExpCS csNameExp = (NameExpCS)((NavigatingArgCS)pivotingChild).getName();
            this.appendPathNameCS(csNameExp.getPathName());
            ((CS2Moniker)this.context).append("!");
            ((CS2Moniker)this.context).append(PivotPackage.Literals.VARIABLE__INIT_EXPRESSION.getName());
            ((CS2Moniker)this.context).append("~");
        }
    }

    protected void appendPathNameCS(PathNameCS pathName) {
        int iMax;
        EList path;
        Element element = null;
        if (pathName != null && (path = pathName.getPath()) != null && (iMax = path.size()) > 0) {
            boolean scopeIsResolved = true;
            int i = 0;
            while (i < iMax - 1) {
                Element scopeElement = ((PathElementCS)path.get(i)).basicGetElement();
                if (scopeElement == null || scopeElement.eIsProxy()) {
                    scopeIsResolved = false;
                    break;
                }
                ++i;
            }
            if (scopeIsResolved) {
                element = ((PathElementCS)path.get(iMax - 1)).basicGetElement();
            }
        }
        if (element != null && !element.eIsProxy()) {
            ((CS2Moniker)this.context).appendName(element);
        } else {
            ICompositeNode node = NodeModelUtils.getNode((EObject)pathName);
            if (node != null) {
                String text = node.getText().trim();
                int length = text.length();
                if (text.startsWith("_'") && text.endsWith("'") && length >= 3) {
                    text = text.substring(2, length - 1);
                }
                ((CS2Moniker)this.context).append(text);
            }
        }
    }

    public String toString() {
        return ((CS2Moniker)this.context).toString();
    }

    @Override
    public Boolean visitBooleanLiteralExpCS(@NonNull BooleanLiteralExpCS object) {
        this.appendExpPrefix((ElementCS)object);
        ((CS2Moniker)this.context).append(object.getName());
        return true;
    }

    @Override
    public Boolean visitCollectionLiteralExpCS(@NonNull CollectionLiteralExpCS object) {
        this.appendExpPrefix((ElementCS)object);
        ((CS2Moniker)this.context).appendNameCS((Nameable)object.getOwnedType());
        return true;
    }

    @Override
    public Boolean visitCollectionLiteralPartCS(@NonNull CollectionLiteralPartCS object) {
        ((CS2Moniker)this.context).appendParentCS((ElementCS)object, "@");
        ((CS2Moniker)this.context).appendIndex((EObject)object);
        return true;
    }

    @Override
    public Boolean visitCollectionTypeCS(@NonNull CollectionTypeCS object) {
        Type specializedPivotType = (Type)PivotUtil.getPivot(Type.class, (Pivotable)object);
        Type unspecializedPivotType = specializedPivotType != null ? (Type)PivotUtil.getUnspecializedTemplateableElement((TemplateableElement)specializedPivotType) : null;
        ((CS2Moniker)this.context).appendParent((Element)unspecializedPivotType, "!");
        ((CS2Moniker)this.context).appendNameCS((Nameable)object);
        TypedRefCS type = object.getOwnedType();
        if (type != null) {
            ((CS2Moniker)this.context).append("[");
            ((CS2Moniker)this.context).appendElementCS((VisitableCS)type);
            ((CS2Moniker)this.context).append("]");
        }
        return true;
    }

    @Override
    public Boolean visitConstructorExpCS(@NonNull ConstructorExpCS object) {
        this.appendExpPrefix((ElementCS)object);
        this.appendPathNameCS(object.getPathName());
        return true;
    }

    @Override
    public Boolean visitContextCS(@NonNull ContextCS object) {
        ((CS2Moniker)this.context).append("root");
        return true;
    }

    @Override
    public Boolean visitIfExpCS(@NonNull IfExpCS object) {
        this.appendExpPrefix((ElementCS)object);
        ((CS2Moniker)this.context).append("if");
        return true;
    }

    @Override
    public Boolean visitInfixExpCS(@NonNull InfixExpCS object) {
        if (((BinaryOperatorCS)object.getOwnedOperator().get(0)).getSource() == null) {
            ((CS2Moniker)this.context).append("%%tree-less%%");
            return true;
        }
        this.appendExpPrefix((ElementCS)object);
        ((CS2Moniker)this.context).append("infix");
        return true;
    }

    @Override
    public Boolean visitInvalidLiteralExpCS(@NonNull InvalidLiteralExpCS object) {
        this.appendExpPrefix((ElementCS)object);
        ((CS2Moniker)this.context).append("invalid");
        return true;
    }

    @Override
    public Boolean visitInvocationExpCS(@NonNull InvocationExpCS object) {
        this.appendExpPrefix((ElementCS)object);
        ((CS2Moniker)this.context).append("navexp");
        return true;
    }

    @Override
    public Boolean visitLetExpCS(@NonNull LetExpCS object) {
        this.appendExpPrefix((ElementCS)object);
        ((CS2Moniker)this.context).append("let");
        return true;
    }

    @Override
    public Boolean visitLetVariableCS(@NonNull LetVariableCS object) {
        ((CS2Moniker)this.context).appendParentCS((ElementCS)object, "!");
        LetExpCS csLetExp = object.getLetExpression();
        for (LetVariableCS csVariable : csLetExp.getVariable()) {
            if (csVariable == object) break;
            ((CS2Moniker)this.context).append(EssentialOCLCSTPackage.Literals.LET_EXP_CS__IN.getName());
            ((CS2Moniker)this.context).append("~");
            ((CS2Moniker)this.context).append("let");
            ((CS2Moniker)this.context).append("!");
        }
        ((CS2Moniker)this.context).append("variable");
        ((CS2Moniker)this.context).append("~");
        ((CS2Moniker)this.context).appendNameCS((Nameable)object);
        return true;
    }

    @Override
    public Boolean visitNameExpCS(@NonNull NameExpCS object) {
        this.appendExpPrefix((ElementCS)object);
        this.appendPathNameCS(object.getPathName());
        return true;
    }

    @Override
    public Boolean visitNavigatingArgCS(@NonNull NavigatingArgCS object) {
        this.appendExpPrefix((ElementCS)object);
        ((CS2Moniker)this.context).append("navarg");
        return true;
    }

    @Override
    public Boolean visitNavigationOperatorCS(@NonNull NavigationOperatorCS object) {
        this.appendExpPrefix((ElementCS)object);
        ((CS2Moniker)this.context).append("navop");
        return true;
    }

    @Override
    public Boolean visitNestedExpCS(@NonNull NestedExpCS object) {
        this.appendExpPrefix((ElementCS)object);
        ((CS2Moniker)this.context).append("nested");
        return true;
    }

    @Override
    public Boolean visitNullLiteralExpCS(@NonNull NullLiteralExpCS object) {
        this.appendExpPrefix((ElementCS)object);
        ((CS2Moniker)this.context).append("null");
        return true;
    }

    @Override
    public Boolean visitNumberLiteralExpCS(@NonNull NumberLiteralExpCS object) {
        this.appendExpPrefix((ElementCS)object);
        ((CS2Moniker)this.context).append(object.getName().toString());
        return true;
    }

    @Override
    public Boolean visitOperatorCS(@NonNull OperatorCS object) {
        this.appendExpPrefix((ElementCS)object);
        ((CS2Moniker)this.context).appendNameCS((Nameable)object);
        return true;
    }

    @Override
    public Boolean visitPrefixExpCS(@NonNull PrefixExpCS object) {
        this.appendExpPrefix((ElementCS)object);
        ((CS2Moniker)this.context).append("prefix");
        return true;
    }

    @Override
    public Boolean visitSelfExpCS(@NonNull SelfExpCS object) {
        this.appendExpPrefix((ElementCS)object);
        ((CS2Moniker)this.context).append("self");
        return true;
    }

    @Override
    public Boolean visitStringLiteralExpCS(@NonNull StringLiteralExpCS object) {
        this.appendExpPrefix((ElementCS)object);
        ((CS2Moniker)this.context).append("string");
        return true;
    }

    @Override
    public Boolean visitTupleLiteralExpCS(@NonNull TupleLiteralExpCS object) {
        this.appendExpPrefix((ElementCS)object);
        ArrayList<TupleLiteralPartCS> parts = new ArrayList<TupleLiteralPartCS>((Collection<TupleLiteralPartCS>)object.getOwnedParts());
        Collections.sort(parts, new Comparator<TupleLiteralPartCS>(){

            @Override
            public int compare(TupleLiteralPartCS o1, TupleLiteralPartCS o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        ((CS2Moniker)this.context).append("tuple");
        return true;
    }

    @Override
    public Boolean visitTupleLiteralPartCS(@NonNull TupleLiteralPartCS object) {
        ((CS2Moniker)this.context).appendParentCS((ElementCS)object, "!");
        ((CS2Moniker)this.context).appendNameCS((Nameable)object);
        return true;
    }

    @Override
    public Boolean visitTypeLiteralExpCS(@NonNull TypeLiteralExpCS object) {
        this.appendExpPrefix((ElementCS)object);
        ((CS2Moniker)this.context).append(((Type)object.getOwnedType().getPivot()).getName());
        return true;
    }

    @Override
    public Boolean visitTypeNameExpCS(@NonNull TypeNameExpCS object) {
        ((CS2Moniker)this.context).appendElement(object.getPivot());
        return true;
    }

    @Override
    public Boolean visitUnlimitedNaturalLiteralExpCS(@NonNull UnlimitedNaturalLiteralExpCS object) {
        this.appendExpPrefix((ElementCS)object);
        ((CS2Moniker)this.context).append("*");
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Factory
    implements CS2Moniker.Factory {
        private Factory() {
            BaseCS2MonikerVisitor.FACTORY.getClass();
            CS2Moniker.addFactory((EPackage)EssentialOCLCSTPackage.eINSTANCE, (CS2Moniker.Factory)this);
            roleNames.put(EssentialOCLCSTPackage.Literals.COLLECTION_LITERAL_PART_CS__EXPRESSION_CS, "first");
            roleNames.put(EssentialOCLCSTPackage.Literals.COLLECTION_LITERAL_PART_CS__LAST_EXPRESSION_CS, "last");
            roleNames.put(EssentialOCLCSTPackage.Literals.CONTEXT_CS__OWNED_EXPRESSION, PivotPackage.Literals.EXPRESSION_IN_OCL__BODY_EXPRESSION.getName());
            roleNames.put(EssentialOCLCSTPackage.Literals.INFIX_EXP_CS__OWNED_EXPRESSION, "source");
        }

        @NonNull
        public BaseCSVisitor<?> create(@NonNull CS2Moniker context) {
            return new EssentialOCLCS2MonikerVisitor(context);
        }
    }
}

