/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.properties.generation.wizard;

import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.papyrus.customization.properties.generation.generators.IGenerator;
import org.eclipse.papyrus.customization.properties.generation.layout.ILayoutGenerator;
import org.eclipse.papyrus.customization.properties.generation.messages.Messages;
import org.eclipse.papyrus.customization.properties.generation.wizard.AbstractCreateContextPage;
import org.eclipse.papyrus.customization.properties.generation.wizard.CreateContextWizard;
import org.eclipse.papyrus.customization.properties.generation.wizard.widget.FileChooser;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class GeneratorPage
extends AbstractCreateContextPage
implements Listener {
    private IGenerator generator;
    private Composite root;
    private Composite generatorControl;
    private FileChooser targetFileChooser;
    private CCombo layoutCombo;

    public GeneratorPage() {
        super(Messages.GeneratorPage_title);
    }

    public void setGenerator(IGenerator generator) {
        this.cleanGeneratorControl();
        generator.addListener(this);
        this.setDescription(generator.getDescription());
        this.generator = generator;
        generator.createControls(this.generatorControl);
        this.generatorControl.layout();
        this.root.layout();
    }

    public void dispose() {
        this.generator.removeListener(this);
    }

    public boolean isPageComplete() {
        return this.targetFileChooser.getFilePath() != null && this.generator != null && this.generator.isReady();
    }

    private void cleanGeneratorControl() {
        Control[] controlArray = this.generatorControl.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
    }

    public void createControl(Composite parent) {
        this.root = new Composite(parent, 0);
        this.root.setLayout((Layout)new GridLayout(2, false));
        this.root.setLayoutData((Object)new GridData(4, 4, true, true));
        this.generatorControl = new Composite(this.root, 0);
        this.generatorControl.setLayout((Layout)new FillLayout());
        this.generatorControl.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        Label layoutGeneratorLabel = new Label(this.root, 0);
        layoutGeneratorLabel.setText(Messages.GeneratorPage_layoutGenerator);
        GridData data = new GridData();
        data.widthHint = 100;
        layoutGeneratorLabel.setLayoutData((Object)data);
        this.layoutCombo = new CCombo(this.root, 2048);
        this.layoutCombo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.layoutCombo.setEditable(false);
        this.layoutCombo.setBackground(new Color((Device)this.layoutCombo.getDisplay(), 255, 255, 255));
        for (ILayoutGenerator layoutGenerator : CreateContextWizard.layoutGenerators) {
            this.layoutCombo.add(layoutGenerator.getName());
        }
        this.layoutCombo.select(0);
        Label targetLabel = new Label(this.root, 0);
        targetLabel.setText(Messages.GeneratorPage_target);
        data = new GridData();
        data.widthHint = 100;
        targetLabel.setLayoutData((Object)data);
        this.targetFileChooser = new FileChooser(this.root, true);
        this.targetFileChooser.setLayoutData(new GridData(4, 4, true, false));
        this.targetFileChooser.addListener(this);
        this.setControl((Control)this.root);
    }

    public void handleEvent(Event event) {
        String filePath = this.targetFileChooser.getFilePath();
        if (filePath != null) {
            this.getWizard().selectFieldsPage.setTargetURI(URI.createPlatformResourceURI((String)this.targetFileChooser.getFilePath(), (boolean)true));
        }
        super.getContainer().updateButtons();
    }

    public IWizardPage getNextPage() {
        int selection = this.layoutCombo.getSelectionIndex();
        this.getWizard().layoutGenerator = CreateContextWizard.layoutGenerators.get(selection);
        return super.getNextPage();
    }
}

