/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.properties.editor;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.emf.ecore.presentation.EcoreActionBarContributor;
import org.eclipse.emf.edit.ui.action.CopyAction;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.emf.edit.ui.action.CreateSiblingAction;
import org.eclipse.emf.edit.ui.action.CutAction;
import org.eclipse.emf.edit.ui.action.DeleteAction;
import org.eclipse.emf.edit.ui.action.PasteAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.papyrus.customization.properties.editor.actions.CreateSectionAction;
import org.eclipse.papyrus.customization.properties.editor.actions.CreateSectionWidgetAction;
import org.eclipse.papyrus.customization.properties.editor.actions.MoDiscoCopyAction;
import org.eclipse.papyrus.customization.properties.editor.actions.MoDiscoCutAction;
import org.eclipse.papyrus.customization.properties.editor.actions.MoDiscoDeleteAction;
import org.eclipse.papyrus.customization.properties.editor.actions.MoDiscoPasteAction;
import org.eclipse.papyrus.customization.properties.editor.actions.ToggleDataContextAction;
import org.eclipse.papyrus.customization.properties.editor.actions.ValidationAction;
import org.eclipse.papyrus.customization.properties.util.ActionUtil;
import org.eclipse.papyrus.views.properties.contexts.Context;
import org.eclipse.papyrus.views.properties.contexts.Section;
import org.eclipse.papyrus.views.properties.contexts.Tab;
import org.eclipse.papyrus.views.properties.contexts.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextEditorActionBarContributor
extends EcoreActionBarContributor {
    private int i = 0;

    public ContextEditorActionBarContributor() {
        this.validateAction = new ValidationAction();
    }

    protected void addGlobalActions(IMenuManager menuManager) {
        super.addGlobalActions(menuManager);
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        super.menuAboutToShow(menuManager);
    }

    protected Collection<IAction> generateCreateChildActions(Collection<?> descriptors, ISelection selection) {
        IStructuredSelection sSelection;
        Collection result = super.generateCreateChildActions(descriptors, selection);
        if (selection instanceof IStructuredSelection && (sSelection = (IStructuredSelection)selection).size() == 1) {
            Object firstElement = sSelection.getFirstElement();
            if (firstElement instanceof View) {
                result.addAll(this.createChildForView(selection, (View)sSelection.getFirstElement()));
            } else if (firstElement instanceof Section) {
                result.addAll(this.createChildForSection(selection));
            } else if (firstElement instanceof Tab) {
                this.removeChildActionsForTab(result);
            } else if (firstElement instanceof Context) {
                this.removeChildActionsForContext(result);
            }
        }
        return result;
    }

    protected Collection<IAction> generateCreateSiblingActions(Collection<?> descriptors, ISelection selection) {
        IStructuredSelection sSelection;
        Collection result = super.generateCreateSiblingActions(descriptors, selection);
        if (selection instanceof IStructuredSelection && (sSelection = (IStructuredSelection)selection).size() == 1) {
            Object firstElement = sSelection.getFirstElement();
            if (firstElement instanceof Section) {
                this.removeSiblingActionsForSection(result);
                this.createSiblingActionsForSection((ISelection)sSelection, (Section)firstElement);
            } else if (firstElement instanceof View || firstElement instanceof Tab) {
                this.removeSiblingActionsForViewAndTab(result);
            }
        }
        return result;
    }

    protected void removeChildActionsForTab(Collection<IAction> actions) {
        Iterator<IAction> iterator = actions.iterator();
        while (iterator.hasNext()) {
            CreateChildAction createChildAction;
            IAction action = iterator.next();
            if (!(action instanceof CreateChildAction) || !(createChildAction = (CreateChildAction)action).getText().equals("Section")) continue;
            iterator.remove();
        }
    }

    protected void removeChildActionsForContext(Collection<IAction> actions) {
        Iterator<IAction> iterator = actions.iterator();
        while (iterator.hasNext()) {
            IAction action = iterator.next();
            if (!(action instanceof CreateChildAction)) continue;
            CreateChildAction createChildAction = (CreateChildAction)action;
            if (ToggleDataContextAction.showDataContext || !createChildAction.getText().equals("Data Context Root")) continue;
            iterator.remove();
        }
    }

    protected void removeSiblingActionsForViewAndTab(Collection<IAction> actions) {
        Iterator<IAction> iterator = actions.iterator();
        while (iterator.hasNext()) {
            CreateSiblingAction createSiblingAction;
            IAction action = iterator.next();
            if (!(action instanceof CreateSiblingAction) || !(createSiblingAction = (CreateSiblingAction)action).getText().equals("Data Context Root")) continue;
            iterator.remove();
        }
    }

    protected void removeSiblingActionsForSection(Collection<IAction> actions) {
        Iterator<IAction> iterator = actions.iterator();
        while (iterator.hasNext()) {
            CreateSiblingAction createSiblingAction;
            IAction action = iterator.next();
            if (!(action instanceof CreateSiblingAction) || !(createSiblingAction = (CreateSiblingAction)action).getText().equals("Section")) continue;
            iterator.remove();
        }
    }

    protected Collection<IAction> createSiblingActionsForSection(ISelection selection, Section section) {
        LinkedList<IAction> actions = new LinkedList<IAction>();
        return actions;
    }

    protected Collection<IAction> createChildForView(ISelection selection, View view) {
        LinkedList<IAction> actions = new LinkedList<IAction>();
        if (view.getContext() == null) {
            return actions;
        }
        String sectionName = this.getSectionName(view.getContext());
        String sectionFile = this.getSectionFile(sectionName);
        CreateSectionAction action = new CreateSectionAction(selection, sectionName, sectionFile);
        actions.add((IAction)action);
        return actions;
    }

    protected String getSectionName(Context context) {
        String name;
        while (!this.isValidName(name = "Section " + this.i, context)) {
            ++this.i;
        }
        return name;
    }

    protected boolean isValidName(String sectionName, Context context) {
        for (Tab tab : context.getTabs()) {
            for (Section section : tab.getSections()) {
                if (!section.getName().equals(sectionName)) continue;
                return false;
            }
        }
        return true;
    }

    protected String getSectionFile(String sectionName) {
        return "ui/" + sectionName + ".xwt";
    }

    protected Collection<IAction> createChildForSection(ISelection selection) {
        LinkedList<IAction> actions = new LinkedList<IAction>();
        actions.add((IAction)new CreateSectionWidgetAction(selection));
        return actions;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection newSelection = ActionUtil.getAdaptedSelection(event.getSelection());
        SelectionChangedEvent newEvent = new SelectionChangedEvent(event.getSelectionProvider(), newSelection);
        super.selectionChanged(newEvent);
    }

    protected DeleteAction createDeleteAction() {
        return new MoDiscoDeleteAction(this.removeAllReferencesOnDelete());
    }

    protected boolean removeAllReferencesOnDelete() {
        return false;
    }

    protected CutAction createCutAction() {
        return new MoDiscoCutAction();
    }

    protected CopyAction createCopyAction() {
        return new MoDiscoCopyAction();
    }

    protected PasteAction createPasteAction() {
        return new MoDiscoPasteAction();
    }
}

