/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageManager;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.infra.core.sashwindows.di.PageRef;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class CloseOtherDiagramsCommand
extends AbstractHandler {
    public void setEnabled(Object evaluationContext) {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            IEditorPart part = HandlerUtil.getActiveEditor((ExecutionEvent)event);
            IPageManager pageMngr = (IPageManager)part.getAdapter(IPageManager.class);
            TransactionalEditingDomain editingDomain = (TransactionalEditingDomain)part.getAdapter(TransactionalEditingDomain.class);
            ISashWindowsContainer container = (ISashWindowsContainer)part.getAdapter(ISashWindowsContainer.class);
            Object pageIdentifier = container.getActiveSashWindowsPage().getRawModel();
            if (pageIdentifier instanceof PageRef) {
                pageIdentifier = ((PageRef)pageIdentifier).getPageIdentifier();
            }
            this.execute(pageMngr, editingDomain, pageIdentifier);
        }
        catch (NullPointerException e) {
            return null;
        }
        return null;
    }

    public void execute(final IPageManager pageMngr, TransactionalEditingDomain editingDomain, final Object pageIdentifier) {
        boolean atLeastOneDifferentPageOpen = false;
        for (Object page : pageMngr.allPages()) {
            if (page == pageIdentifier || !pageMngr.isOpen(page)) continue;
            atLeastOneDifferentPageOpen = true;
            break;
        }
        if (!atLeastOneDifferentPageOpen) {
            return;
        }
        editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain, "Close other pages"){

            protected void doExecute() {
                pageMngr.closeOtherPages(pageIdentifier);
            }
        });
    }
}

