/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.multidiagram.actionbarcontributor;

import java.util.List;
import org.eclipse.papyrus.infra.core.editor.BackboneException;
import org.eclipse.papyrus.infra.core.multidiagram.actionbarcontributor.ActionBarContributorRegistry;
import org.eclipse.papyrus.infra.core.sasheditor.editor.actionbarcontributor.ComposedActionBarContributor;
import org.eclipse.papyrus.infra.core.sasheditor.editor.actionbarcontributor.IMultiPageEditorActionBarContributor;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.EditorActionBarContributor;

public class CoreComposedActionBarContributor
extends ComposedActionBarContributor
implements IMultiPageEditorActionBarContributor {
    protected ActionBarContributorRegistry actionBarContributorRegistry;
    protected List<EditorActionBarContributor> contributors;

    public CoreComposedActionBarContributor() throws BackboneException {
        this.loadContributors();
    }

    private void loadContributors() throws BackboneException {
        this.actionBarContributorRegistry = new ActionBarContributorRegistry("org.eclipse.papyrus.infra.core");
        this.contributors = this.actionBarContributorRegistry.getActionBarContributors();
    }

    public ActionBarContributorRegistry getActionBarContributorRegistry() {
        return this.actionBarContributorRegistry;
    }

    public void dispose() {
        for (EditorActionBarContributor contributor : this.contributors) {
            contributor.dispose();
        }
        super.dispose();
    }

    public void init(IActionBars bars, IWorkbenchPage page) {
        super.init(bars, page);
        this.buildActions();
        for (EditorActionBarContributor contributor : this.contributors) {
            contributor.init(bars, page);
            bars.setGlobalActionHandler("save", null);
        }
    }

    protected void buildActions() {
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        for (EditorActionBarContributor contributor : this.contributors) {
            if (part == null) continue;
            contributor.setActiveEditor(part);
        }
    }
}

