/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.resource;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.core.resource.AbstractBaseModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractModelWithSharedResource<T extends EObject>
extends AbstractBaseModel {
    private ModelKind modelKind;

    public AbstractModelWithSharedResource(ModelKind modelKind) {
        this.modelKind = modelKind;
    }

    public AbstractModelWithSharedResource() {
        this.modelKind = ModelKind.slave;
    }

    @Override
    public void loadModel(URI uriWithoutExtension) {
        this.lookupResource(uriWithoutExtension);
        if (this.resourceIsSet()) {
            this.configureResource(this.resource);
            return;
        }
        super.loadModel(uriWithoutExtension);
    }

    @Override
    public void createModel(URI uri) {
        this.lookupResource(uri);
        if (this.resourceIsSet()) {
            this.configureResource(this.resource);
            return;
        }
        super.createModel(uri);
    }

    private void lookupResource(URI uriWithoutExtension) {
        this.resourceURI = uriWithoutExtension.appendFileExtension(this.getModelFileExtension());
        this.resource = this.getResourceSet().getResource(this.resourceURI, false);
    }

    @Override
    public void saveModel() throws IOException {
        if (this.modelKind == ModelKind.slave) {
            return;
        }
        super.saveModel();
    }

    @Override
    public void saveCopy(IPath targetPathWithoutExtension, Map<Object, Object> targetMap) {
        if (this.modelKind == ModelKind.slave) {
            return;
        }
        super.saveCopy(targetPathWithoutExtension, targetMap);
    }

    public T getModelRoot() {
        for (EObject object : this.getResource().getContents()) {
            if (!this.isModelRoot(object)) continue;
            return (T)object;
        }
        return null;
    }

    public List<T> getModelRoots() {
        ArrayList<EObject> roots = new ArrayList<EObject>();
        for (EObject object : this.getResource().getContents()) {
            if (!this.isModelRoot(object)) continue;
            roots.add(object);
        }
        return roots;
    }

    protected abstract boolean isModelRoot(EObject var1);

    public void addModelRoot(T root) {
        this.getResource().getContents().add(root);
    }

    @Override
    protected Map<Object, Object> getSaveOptions() {
        if (this.modelKind == ModelKind.master) {
            return super.getSaveOptions();
        }
        return Collections.emptyMap();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ModelKind {
        master,
        slave;

    }
}

