/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.resource;

import java.util.Collections;
import java.util.LinkedList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.eclipse.emf.workspace.WorkspaceEditingDomainFactory;
import org.eclipse.papyrus.infra.core.resource.ITransactionalEditingDomainProvider;

public class TransactionalEditingDomainManager {
    protected static final ITransactionalEditingDomainProvider[] orderedProvidersArray;

    static {
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.papyrus.infra.core", "transactionalEditingDomainProvider");
        LinkedList<ProviderPriorityPair> providerPriorityPairs = new LinkedList<ProviderPriorityPair>();
        IConfigurationElement[] iConfigurationElementArray = configElements;
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elem = iConfigurationElementArray[n2];
            if ("transactionalEditingDomainProvider".equals(elem.getName())) {
                try {
                    ProviderPriorityPair providerPriorityPair = new ProviderPriorityPair();
                    providerPriorityPair.provider = (ITransactionalEditingDomainProvider)elem.createExecutableExtension("class");
                    providerPriorityPair.priority = Integer.parseInt(elem.getAttribute("priority"));
                    providerPriorityPairs.add(providerPriorityPair);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++n2;
        }
        Collections.sort(providerPriorityPairs);
        orderedProvidersArray = new ITransactionalEditingDomainProvider[providerPriorityPairs.size()];
        int i = 0;
        while (i < orderedProvidersArray.length) {
            TransactionalEditingDomainManager.orderedProvidersArray[i] = ((ProviderPriorityPair)providerPriorityPairs.get((int)i)).provider;
            ++i;
        }
    }

    public static TransactionalEditingDomain createTransactionalEditingDomain(ResourceSet resourceSet) {
        ITransactionalEditingDomainProvider[] iTransactionalEditingDomainProviderArray = orderedProvidersArray;
        int n = orderedProvidersArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITransactionalEditingDomainProvider provider = iTransactionalEditingDomainProviderArray[n2];
            TransactionalEditingDomain ed = provider.createTransactionalEditingDomain(resourceSet);
            if (ed != null) {
                return ed;
            }
            ++n2;
        }
        return TransactionalEditingDomainManager.createDefaultTransactionalEditingDomain(resourceSet);
    }

    public static TransactionalEditingDomain createDefaultTransactionalEditingDomain(ResourceSet resourceSet) {
        TransactionalEditingDomainImpl result = new TransactionalEditingDomainImpl((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE), resourceSet);
        WorkspaceEditingDomainFactory.INSTANCE.mapResourceSet((TransactionalEditingDomain)result);
        return result;
    }

    public static TransactionalEditingDomain getTransactionalEditingDomain(ResourceSet resourceSet) {
        return WorkspaceEditingDomainFactory.INSTANCE.getEditingDomain(resourceSet);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ProviderPriorityPair
    implements Comparable<ProviderPriorityPair> {
        public ITransactionalEditingDomainProvider provider;
        public int priority;

        protected ProviderPriorityPair() {
        }

        @Override
        public int compareTo(ProviderPriorityPair o) {
            if (o.priority > this.priority) {
                return 1;
            }
            if (o.priority < this.priority) {
                return -1;
            }
            return 0;
        }
    }
}

