/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.commands.wrappers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;

public class EMFtoGMFCommandWrapper
extends AbstractCommand {
    protected Command emfCommand;
    protected boolean isBusy;

    public EMFtoGMFCommandWrapper(Command emfCommand) {
        super(emfCommand.getLabel());
        this.emfCommand = emfCommand;
    }

    public Command getEMFCommand() {
        return this.emfCommand;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        this.emfCommand.execute();
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (!this.isBusy) {
            this.isBusy = true;
            this.emfCommand.redo();
            this.isBusy = false;
        }
        return CommandResult.newOKCommandResult();
    }

    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (!this.isBusy) {
            this.isBusy = true;
            this.emfCommand.undo();
            this.isBusy = false;
        }
        return CommandResult.newOKCommandResult();
    }

    public boolean canExecute() {
        return this.emfCommand.canExecute();
    }

    public void dispose() {
        this.emfCommand.dispose();
    }

    public boolean canUndo() {
        if (!this.isBusy) {
            this.isBusy = true;
            boolean res = this.emfCommand.canUndo();
            this.isBusy = false;
            return res;
        }
        return true;
    }

    public List getAffectedFiles() {
        ArrayList affectedFiles = new ArrayList();
        Collection affectedObjects = this.emfCommand.getAffectedObjects();
        if (affectedObjects != null) {
            for (Object o : affectedObjects) {
                if (o instanceof EObject) {
                    o = ((EObject)o).eResource();
                }
                if (o instanceof Resource) {
                    o = WorkspaceSynchronizer.getFile((Resource)((Resource)o));
                }
                if (!(o instanceof IFile)) continue;
                affectedFiles.add(o);
            }
        }
        return affectedFiles;
    }

    public CommandResult getCommandResult() {
        Collection res = this.emfCommand.getResult();
        if (res != null && !res.isEmpty()) {
            if (res.size() == 1) {
                return CommandResult.newOKCommandResult(res.iterator().next());
            }
            return CommandResult.newOKCommandResult((Object)res);
        }
        return CommandResult.newOKCommandResult();
    }
}

