/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.hyperlink.object;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.Activator;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkObject;
import org.eclipse.papyrus.infra.services.openelement.service.OpenElementService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HyperLinkSpecificObject
extends HyperLinkObject {
    private EObject targetElement;

    public HyperLinkSpecificObject(EObject targetElement) {
        this.targetElement = targetElement;
    }

    public HyperLinkSpecificObject() {
    }

    @Override
    public void executeEditMousePressed(List<HyperLinkObject> list, EObject amodel) {
    }

    public void setTargetElement(EObject targetElement) {
        this.targetElement = targetElement;
    }

    @Override
    public boolean needsOpenCommand() {
        return this.targetElement != null;
    }

    @Override
    public void openLink() {
        OpenElementService openElementService;
        if (this.targetElement == null) {
            return;
        }
        try {
            openElementService = (OpenElementService)ServiceUtilsForEObject.getInstance().getService(OpenElementService.class, (Object)this.targetElement);
        }
        catch (ServiceException ex) {
            Activator.log.error((Throwable)ex);
            return;
        }
        try {
            openElementService.openElement(this.targetElement);
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    public EObject getTargetElement() {
        return this.targetElement;
    }
}

