/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.hyperlink.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.hyperlink.Activator;
import org.eclipse.papyrus.infra.hyperlink.messages.Messages;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkObject;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.infra.widgets.providers.CollectionContentProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorNavigationDialog
extends Dialog {
    protected int width = 350;
    protected int height = 150;
    protected List<HyperLinkObject> hyperlinkObjects;
    private TableViewer tableViewer;
    protected Table availableHyperLink;
    protected List<HyperLinkObject> hyperlinkResult = new ArrayList<HyperLinkObject>();
    protected EObject contextElement;

    public EditorNavigationDialog(Shell parentShell, ArrayList<HyperLinkObject> hyperlinkObjects, EObject contextElement) {
        super(parentShell);
        this.hyperlinkObjects = hyperlinkObjects;
        this.contextElement = contextElement;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createContents(Composite parent) {
        super.createContents(parent);
        Composite defaultHyperlinkComposite = (Composite)this.getDialogArea();
        Label lblHyperlinks = new Label(defaultHyperlinkComposite, 0);
        lblHyperlinks.setForeground(Display.getCurrent().getSystemColor(2));
        lblHyperlinks.setText(Messages.DiagramNavigationDialog_WhichHyperLinksWouldYouToNavigateTo);
        this.availableHyperLink = new Table(defaultHyperlinkComposite, 67616);
        this.availableHyperLink.setLayoutData((Object)new GridData(1808));
        this.tableViewer = new TableViewer(this.availableHyperLink);
        this.tableViewer.setContentProvider((IContentProvider)CollectionContentProvider.instance);
        LabelProvider provider = null;
        if (this.contextElement != null) {
            try {
                provider = ((LabelProviderService)ServiceUtilsForEObject.getInstance().getService(LabelProviderService.class, (Object)this.contextElement)).getLabelProvider();
            }
            catch (ServiceException ex) {
                Activator.log.error((Throwable)ex);
            }
        }
        if (provider == null) {
            provider = new LabelProvider();
        }
        this.tableViewer.setLabelProvider((IBaseLabelProvider)provider);
        this.tableViewer.setInput(this.hyperlinkObjects);
        TableItem[] tableItemArray = this.availableHyperLink.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            item.setChecked(true);
            ++n2;
        }
        this.getShell().setText(Messages.DiagramNavigationDialog_ChooseHyperLinks);
        this.getShell().pack();
        return defaultHyperlinkComposite;
    }

    public List<HyperLinkObject> getSelectedHyperlinks() {
        return this.hyperlinkResult;
    }

    protected void okPressed() {
        this.hyperlinkResult = new ArrayList<HyperLinkObject>();
        TableItem[] tableItems = this.availableHyperLink.getItems();
        int i = 0;
        while (i < tableItems.length) {
            if (tableItems[i].getChecked()) {
                this.hyperlinkResult.add((HyperLinkObject)tableItems[i].getData());
            }
            ++i;
        }
        super.okPressed();
    }
}

