/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.controlmode.handlers;

import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeManager;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;
import org.eclipse.papyrus.infra.services.controlmode.IControlModeManager;
import org.eclipse.papyrus.infra.services.controlmode.ui.CreateModelFragmentDialog;
import org.eclipse.papyrus.infra.services.controlmode.util.LabelHelper;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.NotificationBuilder;
import org.eclipse.papyrus.views.modelexplorer.handler.AbstractModelExplorerHandler;
import org.eclipse.swt.widgets.Display;

public class ControlCommandHandler
extends AbstractModelExplorerHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        List selection = this.getCurrentSelectionAdaptedToType(event, EObject.class);
        if (selection == null || selection.isEmpty() || selection.size() > 1) {
            NotificationBuilder.createInfoPopup((String)"Nothing to control").run();
            return null;
        }
        EObject eObjectToControl = (EObject)selection.get(0);
        CreateModelFragmentDialog dialog = new CreateModelFragmentDialog(Display.getCurrent().getActiveShell(), eObjectToControl.eResource(), this.getDefaultLabelResource(eObjectToControl));
        if (dialog.open() == 0) {
            ControlModeRequest controlRequest = ControlModeRequest.createUIControlModelRequest(this.getEditingDomain(), eObjectToControl, dialog.getURI());
            IControlModeManager controlMng = ControlModeManager.getInstance();
            ICommand controlCommand = controlMng.getControlCommand(controlRequest);
            this.getEditingDomain().getCommandStack().execute((Command)new GMFtoEMFCommandWrapper(controlCommand));
        }
        return null;
    }

    protected String getDefaultLabelResource(EObject eObject) {
        Object eGet;
        String defaultName = null;
        EStructuralFeature feature = eObject.eClass().getEStructuralFeature("name");
        if (feature != null && (eGet = eObject.eGet(feature)) instanceof String) {
            defaultName = (String)eGet;
        }
        if (defaultName == null) {
            LabelHelper.getPrettyLabel(eObject);
            Pattern p = Pattern.compile("<<.*>>");
            defaultName = p.matcher(defaultName).replaceAll("");
        }
        StringBuilder b = new StringBuilder();
        char[] cArray = defaultName.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            Character c = Character.valueOf(cArray[n2]);
            if (Character.isJavaIdentifierPart(c.charValue())) {
                b.append(c);
            } else {
                b.append("_");
            }
            ++n2;
        }
        return b.toString();
    }
}

