/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.table.common.providers;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.infra.core.editorsfactory.IPageIconsRegistry;
import org.eclipse.papyrus.infra.core.editorsfactory.IPageIconsRegistryExtended;
import org.eclipse.papyrus.infra.core.editorsfactory.PageIconsRegistry;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.table.instance.papyrustableinstance.PapyrusTableInstance;
import org.eclipse.swt.graphics.Image;

public class TableLabelProvider
extends LabelProvider {
    private IPageIconsRegistry editorRegistry;

    protected IPageIconsRegistry createEditorRegistry(EObject from) {
        try {
            return (IPageIconsRegistry)ServiceUtilsForEObject.getInstance().getService(IPageIconsRegistry.class, (Object)from);
        }
        catch (ServiceException e) {
            return new PageIconsRegistry();
        }
    }

    protected IPageIconsRegistryExtended getEditorRegistry(EObject from) {
        if (this.editorRegistry == null) {
            this.editorRegistry = this.createEditorRegistry(from);
        }
        if (!(this.editorRegistry instanceof IPageIconsRegistryExtended)) {
            throw new RuntimeException("The editor registry do not implement IPageIconsRegistryExtended");
        }
        return (IPageIconsRegistryExtended)this.editorRegistry;
    }

    public String getText(Object element) {
        EObject eObject = EMFHelper.getEObject((Object)element);
        if (eObject instanceof PapyrusTableInstance) {
            return ((PapyrusTableInstance)eObject).getName();
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        EObject eObject = EMFHelper.getEObject((Object)element);
        if (eObject instanceof PapyrusTableInstance) {
            return this.getEditorRegistry(eObject).getEditorIcon((Object)eObject);
        }
        return super.getImage(element);
    }
}

