/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.table.controlmode;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;
import org.eclipse.papyrus.infra.services.controlmode.participants.IControlCommandParticipant;
import org.eclipse.papyrus.infra.services.controlmode.participants.IUncontrolCommandParticipant;
import org.eclipse.papyrus.infra.table.controlmode.ControlTableCommand;
import org.eclipse.papyrus.infra.table.instance.util.TableContentsUtils;

public class TableControlParticipant
implements IControlCommandParticipant,
IUncontrolCommandParticipant {
    public String getID() {
        return "org.eclipse.papyrus.infra.table.controlmode.TableControlParticipant";
    }

    public int getPriority() {
        return 40;
    }

    public boolean provideControlCommand(ControlModeRequest request) {
        EObject objectToControl = request.getTargetObject();
        if (objectToControl == null) {
            return false;
        }
        Iterable ite = TableContentsUtils.createDescendantTablesIterable((EObject)objectToControl);
        return ite.iterator().hasNext();
    }

    public ICommand getPreControlCommand(ControlModeRequest request) {
        return null;
    }

    public ICommand getPostControlCommand(ControlModeRequest request) {
        return new ControlTableCommand(request);
    }

    public boolean provideUnControlCommand(ControlModeRequest request) {
        return this.provideControlCommand(request);
    }

    public ICommand getPreUncontrolCommand(ControlModeRequest request) {
        return new ControlTableCommand(request);
    }

    public ICommand getPostUncontrolCommand(ControlModeRequest request) {
        return null;
    }
}

