/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.tools.util;

import java.util.Collection;
import java.util.TreeSet;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.infra.tools.Activator;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandImageService;
import org.eclipse.ui.commands.ICommandService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseCommandUtils {
    private EclipseCommandUtils() {
    }

    public static final Collection<Command> getAllExistingCommandsInCategory(String categoryId) {
        TreeSet<Command> commands = new TreeSet<Command>();
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Category category = commandService.getCategory(categoryId);
        Command[] commandArray = commandService.getDefinedCommands();
        int n = commandArray.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                Command command = commandArray[n2];
                Category currentCategory = null;
                try {
                    currentCategory = command.getCategory();
                }
                catch (NotDefinedException e) {
                    Activator.log.debug(e.getLocalizedMessage());
                    break block4;
                }
                if (category.equals((Object)currentCategory)) {
                    commands.add(command);
                }
            }
            ++n2;
        }
        return commands;
    }

    public static final ImageDescriptor getCommandIcon(Command command) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        ICommandImageService service = (ICommandImageService)workbench.getService(ICommandImageService.class);
        ImageDescriptor imageDescriptor = service.getImageDescriptor(command.getId());
        return imageDescriptor;
    }
}

