/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelectionListener;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelector;
import org.eclipse.papyrus.infra.widgets.messages.Messages;
import org.eclipse.papyrus.infra.widgets.providers.CollectionContentProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.dialogs.SelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleValueSelectorDialog
extends SelectionDialog
implements ISelectionChangedListener,
IDoubleClickListener,
IElementSelectionListener,
SelectionListener {
    public static int MANY = -1;
    protected IElementSelector selector;
    protected Composite selectorSection;
    protected Composite buttonsSection;
    protected Composite rightButtonsSection;
    protected StructuredViewer selectedElementsViewer;
    protected Tree selectedElements;
    protected Button add;
    protected Button create;
    protected Button delete;
    protected Button remove;
    protected Button addAll;
    protected Button removeAll;
    protected Button up;
    protected Button down;
    protected ILabelProvider labelProvider;
    protected final Collection<Object> allElements;
    protected boolean unique;
    protected boolean ordered;
    protected ReferenceValueFactory factory;
    protected Set<Object> newObjects = new HashSet<Object>();
    protected int upperBound;

    public MultipleValueSelectorDialog(Shell parentShell, IElementSelector selector) {
        this(parentShell, selector, null, false, false);
    }

    public MultipleValueSelectorDialog(Shell parentShell, IElementSelector selector, String title) {
        this(parentShell, selector, title, false, false);
    }

    public MultipleValueSelectorDialog(Shell parentShell, IElementSelector selector, boolean unique) {
        this(parentShell, selector, null, unique, false);
    }

    public MultipleValueSelectorDialog(Shell parentShell, IElementSelector selector, String title, boolean unique, boolean ordered) {
        this(parentShell, selector, title, unique, ordered, MANY);
    }

    public MultipleValueSelectorDialog(Shell parentShell, IElementSelector selector, String title, boolean unique, boolean ordered, int upperBound) {
        super(parentShell);
        Assert.isNotNull((Object)selector, (String)"The element selector should be defined");
        this.selector = selector;
        this.allElements = unique ? new LinkedHashSet() : new LinkedList();
        this.setHelpAvailable(false);
        this.setTitle(title);
        this.unique = unique;
        this.ordered = ordered;
        this.upperBound = upperBound;
        selector.addElementSelectionListener(this);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setImage(Activator.getDefault().getImage("/icons/papyrus.png"));
    }

    public void create() {
        super.create();
        this.createDialogContents();
        this.getShell().pack();
        this.updateControls();
    }

    protected void createDialogContents() {
        Composite parent = this.getDialogArea();
        GridLayout layout = (GridLayout)parent.getLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        Composite selectorPane = new Composite(parent, 0);
        selectorPane.setLayout((Layout)new GridLayout(2, false));
        selectorPane.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite selectedPane = new Composite(parent, 0);
        selectedPane.setLayout((Layout)new GridLayout(2, false));
        selectedPane.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createSelectorSection(selectorPane);
        this.createControlsSection(selectorPane);
        this.createListSection(selectedPane);
        this.createRightButtonsSection(selectedPane);
    }

    protected Composite getDialogArea() {
        return (Composite)super.getDialogArea();
    }

    private void createSelectorSection(Composite parent) {
        this.selectorSection = new Composite(parent, 0);
        this.selectorSection.setLayout((Layout)new FillLayout());
        this.selectorSection.setLayoutData((Object)new GridData(4, 4, true, true));
        this.selector.createControls(this.selectorSection);
    }

    private void createControlsSection(Composite parent) {
        this.buttonsSection = new Composite(parent, 0);
        this.buttonsSection.setLayout((Layout)new GridLayout(1, true));
        this.add = new Button(this.buttonsSection, 8);
        this.add.setImage(Activator.getDefault().getImage("/icons/arrow_right.gif"));
        this.add.addSelectionListener((SelectionListener)this);
        this.add.setToolTipText(Messages.MultipleValueSelectorDialog_AddSelectedElements);
        this.remove = new Button(this.buttonsSection, 8);
        this.remove.setImage(Activator.getDefault().getImage("/icons/arrow_left.gif"));
        this.remove.addSelectionListener((SelectionListener)this);
        this.remove.setToolTipText(Messages.MultipleValueEditor_RemoveSelectedElements);
        this.addAll = new Button(this.buttonsSection, 8);
        this.addAll.setImage(Activator.getDefault().getImage("/icons/arrow_double.gif"));
        this.addAll.addSelectionListener((SelectionListener)this);
        this.addAll.setToolTipText(Messages.MultipleValueSelectorDialog_AddAllElements);
        if (this.upperBound != MANY && this.allElements.size() > this.upperBound) {
            this.addAll.setEnabled(false);
        }
        this.removeAll = new Button(this.buttonsSection, 8);
        this.removeAll.setImage(Activator.getDefault().getImage("/icons/arrow_left_double.gif"));
        this.removeAll.addSelectionListener((SelectionListener)this);
        this.removeAll.setToolTipText(Messages.MultipleValueSelectorDialog_RemoveAllElements);
    }

    private void createListSection(Composite parent) {
        this.selectedElements = new Tree(parent, 2818);
        GridData data = new GridData(4, 4, true, true);
        this.selectedElements.setLayoutData((Object)data);
        this.selectedElementsViewer = new TreeViewer(this.selectedElements);
        this.selectedElementsViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.selectedElementsViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.selectedElementsViewer.setContentProvider((IContentProvider)CollectionContentProvider.instance);
        if (this.labelProvider != null) {
            this.selectedElementsViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        }
        this.selectedElementsViewer.setInput(this.allElements);
        this.selector.setSelectedElements(this.allElements.toArray());
    }

    private void createRightButtonsSection(Composite parent) {
        this.rightButtonsSection = new Composite(parent, 0);
        this.rightButtonsSection.setLayout((Layout)new GridLayout(1, true));
        this.up = new Button(this.rightButtonsSection, 8);
        this.up.setImage(Activator.getDefault().getImage("/icons/Up_12x12.gif"));
        this.up.addSelectionListener((SelectionListener)this);
        this.up.setToolTipText(Messages.MultipleValueEditor_MoveSelectedElementsUp);
        this.down = new Button(this.rightButtonsSection, 8);
        this.down.setImage(Activator.getDefault().getImage("/icons/Down_12x12.gif"));
        this.down.addSelectionListener((SelectionListener)this);
        this.down.setToolTipText(Messages.MultipleValueEditor_MoveSelectedElementsDown);
        this.create = new Button(this.rightButtonsSection, 8);
        this.create.setImage(Activator.getDefault().getImage("/icons/Add_12x12.gif"));
        this.create.addSelectionListener((SelectionListener)this);
        this.create.setToolTipText(Messages.MultipleValueSelectorDialog_CreateNewElement);
        this.delete = new Button(this.rightButtonsSection, 8);
        this.delete.setImage(Activator.getDefault().getImage("/icons/Delete_12x12.gif"));
        this.delete.addSelectionListener((SelectionListener)this);
        this.delete.setToolTipText(Messages.MultipleValueSelectorDialog_DeleteNewElement);
        this.delete.setEnabled(false);
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.add) {
            this.addAction();
        } else if (e.widget == this.remove) {
            this.removeAction();
        } else if (e.widget == this.addAll) {
            this.addAllAction();
        } else if (e.widget == this.removeAll) {
            this.removeAllAction();
        } else if (e.widget == this.up) {
            this.upAction();
        } else if (e.widget == this.down) {
            this.downAction();
        } else if (e.widget == this.create) {
            this.createAction();
        }
        this.updateControls();
    }

    public void setFactory(ReferenceValueFactory factory) {
        this.factory = factory;
        this.updateControls();
    }

    public int open() {
        this.allElements.clear();
        this.allElements.addAll(this.getInitialElementSelections());
        return super.open();
    }

    protected void addAction() {
        Object[] elements = this.selector.getSelectedElements();
        this.addElements(elements);
    }

    protected void upAction() {
        IStructuredSelection selection = (IStructuredSelection)this.selectedElementsViewer.getSelection();
        LinkedList<Object> list = new LinkedList<Object>(this.allElements);
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            int oldIndex = list.indexOf(o);
            if (oldIndex > 0) {
                this.move(list, oldIndex, oldIndex - 1);
            }
            ++n2;
        }
        this.allElements.clear();
        this.allElements.addAll(list);
        StructuredSelection selectionCopy = new StructuredSelection(selection.toArray());
        this.selectedElementsViewer.setSelection((ISelection)selectionCopy);
        this.selectedElementsViewer.refresh();
    }

    protected void downAction() {
        IStructuredSelection selection = (IStructuredSelection)this.selectedElementsViewer.getSelection();
        LinkedList<Object> list = new LinkedList<Object>(this.allElements);
        int maxIndex = list.size() - 1;
        Object[] selectionArray = selection.toArray();
        int i = selectionArray.length - 1;
        while (i >= 0) {
            Object o = selectionArray[i];
            int oldIndex = list.indexOf(o);
            if (oldIndex < maxIndex) {
                this.move(list, oldIndex, oldIndex + 1);
            }
            --i;
        }
        this.allElements.clear();
        this.allElements.addAll(list);
        StructuredSelection selectionCopy = new StructuredSelection(selection.toArray());
        this.selectedElementsViewer.setSelection((ISelection)selectionCopy);
        this.selectedElementsViewer.refresh();
    }

    protected void createAction() {
        if (this.factory == null) {
            return;
        }
        Object newObject = this.factory.createObject((Control)this.create);
        if (newObject == null) {
            return;
        }
        this.newObjects.add(newObject);
        this.selector.newObjectCreated(newObject);
        Object[] createdObjects = new Object[]{newObject};
        this.addElements(createdObjects);
        this.selector.setSelectedElements(this.allElements.toArray());
    }

    private void move(List<Object> list, int oldIndex, int newIndex) {
        int size = list.size();
        if (oldIndex < 0 || oldIndex >= size) {
            throw new IndexOutOfBoundsException("oldIndex: " + oldIndex + ", size:" + size);
        }
        if (newIndex < 0 || newIndex >= size) {
            throw new IndexOutOfBoundsException("newIndex: " + newIndex + ", size:" + size);
        }
        Object element = list.remove(oldIndex);
        list.add(newIndex, element);
    }

    protected void removeAction() {
        IStructuredSelection selection = (IStructuredSelection)this.selectedElementsViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            this.allElements.remove(element);
            ++n2;
        }
        this.selector.setSelectedElements(this.allElements.toArray());
        this.selectedElementsViewer.setSelection(null);
        this.selectedElementsViewer.refresh();
    }

    protected void deleteAction() {
    }

    protected void removeAllAction() {
        this.allElements.clear();
        this.selector.setSelectedElements(new Object[0]);
        this.selectedElementsViewer.setSelection(null);
        this.selectedElementsViewer.refresh();
    }

    protected void addAllAction() {
        Object[] elements = this.selector.getAllElements();
        this.addElements(elements);
    }

    @Override
    public void addElements(Object[] elements) {
        if (elements != null) {
            this.allElements.addAll(Arrays.asList(elements));
            this.selectedElementsViewer.refresh();
        }
    }

    protected void okPressed() {
        if (this.factory != null) {
            LinkedList<Object> objectsToValidate = new LinkedList<Object>();
            for (Object object : this.newObjects) {
                if (!this.allElements.contains(object)) continue;
                objectsToValidate.add(object);
            }
            this.factory.validateObjects(objectsToValidate);
            this.selector.clearTemporaryElements();
        }
        this.setResult(new LinkedList<Object>(this.allElements));
        super.okPressed();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
        this.updateControls();
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
        this.updateControls();
    }

    private void updateControls() {
        this.updateControl((Control)this.up, this.ordered);
        this.updateControl((Control)this.down, this.ordered);
        this.updateControl((Control)this.create, this.factory != null && this.factory.canCreateObject());
        boolean canAdd = true;
        if (this.upperBound != MANY && this.allElements.size() >= this.upperBound) {
            canAdd = false;
        }
        this.updateControl((Control)this.add, canAdd);
    }

    private void updateControl(Control control, boolean enabled) {
        if (control != null) {
            control.setEnabled(enabled);
        }
    }

    public void setSelector(IElementSelector selector) {
        this.selector = selector;
    }

    public void setUpperBound(int upperBound) {
        this.upperBound = upperBound;
    }

    public boolean close() {
        this.selector.removeElementSelectionListener(this);
        return super.close();
    }

    public void doubleClick(DoubleClickEvent event) {
        this.removeAction();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateControls();
    }
}

