/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.providers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.papyrus.infra.widgets.providers.AbstractFilteredContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IRestrictedContentProvider;

public class CompoundFilteredRestrictedContentProvider
extends AbstractFilteredContentProvider
implements IRestrictedContentProvider {
    private List<IRestrictedContentProvider> encapsulatedContentProviders = new ArrayList<IRestrictedContentProvider>();

    public boolean add(IRestrictedContentProvider o) {
        if (o != null) {
            return this.encapsulatedContentProviders.add(o);
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        ArrayList<Object> asList = new ArrayList<Object>();
        for (IRestrictedContentProvider encapsulatedContentProvider : this.encapsulatedContentProviders) {
            Object[] directElements = encapsulatedContentProvider.getElements(inputElement);
            asList.addAll(Arrays.asList(directElements));
        }
        return asList.toArray();
    }

    public Object[] getChildren(Object parentElement) {
        ArrayList<Object> asList = new ArrayList<Object>();
        for (IRestrictedContentProvider encapsulatedContentProvider : this.encapsulatedContentProviders) {
            Object[] directElements = encapsulatedContentProvider.getChildren(parentElement);
            if (directElements == null || directElements.length == 0) continue;
            asList.addAll(Arrays.asList(directElements));
        }
        return asList.toArray();
    }

    public Object getParent(Object element) {
        for (IRestrictedContentProvider encapsulatedContentProvider : this.encapsulatedContentProviders) {
            Object parent = encapsulatedContentProvider.getParent(element);
            if (parent == null) continue;
            return parent;
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return true;
    }

    public void dispose() {
        super.dispose();
        this.encapsulatedContentProviders.clear();
    }

    public void setRestriction(boolean isRestricted) {
        for (IRestrictedContentProvider current : this.encapsulatedContentProviders) {
            current.setRestriction(isRestricted);
        }
    }

    public boolean isRestricted() {
        if (!this.encapsulatedContentProviders.isEmpty()) {
            return this.encapsulatedContentProviders.get(0).isRestricted();
        }
        throw new UnsupportedOperationException();
    }

    public boolean isValidValue(Object element) {
        boolean result = false;
        for (IRestrictedContentProvider current : this.encapsulatedContentProviders) {
            boolean bl = result = result || current.isValidValue(element);
        }
        return result;
    }

    public Object[] getElements() {
        return this.getElements(null);
    }

    public void setIgnoreInheritedElements(boolean ignoreInheritedElements) {
        for (IRestrictedContentProvider current : this.encapsulatedContentProviders) {
            current.setIgnoreInheritedElements(ignoreInheritedElements);
        }
    }

    public boolean isIgnoringInheritedElements() {
        return this.encapsulatedContentProviders.get(0).isIgnoringInheritedElements();
    }
}

