/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.providers;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.papyrus.infra.tools.util.ListHelper;
import org.eclipse.papyrus.infra.widgets.editors.AbstractEditor;
import org.eclipse.papyrus.infra.widgets.editors.ICommitListener;
import org.eclipse.papyrus.infra.widgets.providers.IAdaptableContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IGraphicalContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IHierarchicContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.strategy.IStrategyBasedContentProvider;
import org.eclipse.papyrus.infra.widgets.strategy.TreeBrowseStrategy;
import org.eclipse.papyrus.infra.widgets.util.IRevealSemanticElement;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncapsulatedContentProvider
implements IHierarchicContentProvider,
IGraphicalContentProvider,
ICommitListener,
IAdaptableContentProvider,
IRevealSemanticElement,
IStrategyBasedContentProvider,
IStaticContentProvider {
    protected IStructuredContentProvider encapsulated;
    private Set<Object> temporaryElements = new LinkedHashSet<Object>();

    public EncapsulatedContentProvider(IStructuredContentProvider encapsulated) {
        this.encapsulated = encapsulated;
    }

    protected EncapsulatedContentProvider() {
    }

    private Object[] getAllElements(Object[] elements) {
        if (this.temporaryElements.isEmpty()) {
            return elements;
        }
        List result = ListHelper.asList((Object[])elements);
        result.addAll(this.temporaryElements);
        return result.toArray();
    }

    public void dispose() {
    }

    protected void addViewerFilter(StructuredViewer viewer, ViewerFilter filter) {
        LinkedHashSet<ViewerFilter> currentFilters = new LinkedHashSet<ViewerFilter>(Arrays.asList(viewer.getFilters()));
        currentFilters.add(filter);
        viewer.setFilters(currentFilters.toArray(new ViewerFilter[currentFilters.size()]));
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (this.encapsulated != null) {
            this.encapsulated.inputChanged(viewer, oldInput, newInput);
        }
    }

    public Object[] getElements(Object inputElement) {
        if (this.encapsulated == null) {
            return new Object[0];
        }
        return this.getAllElements(this.encapsulated.getElements(inputElement));
    }

    @Override
    public Object[] getElements() {
        if (this.encapsulated instanceof IStaticContentProvider) {
            return this.getAllElements(((IStaticContentProvider)this.encapsulated).getElements());
        }
        return this.getElements(null);
    }

    public void addTemporaryElement(Object newObject) {
        this.temporaryElements.add(newObject);
    }

    public void removeTemporaryElement(Object removeObject) {
        this.temporaryElements.remove(removeObject);
    }

    public void clearTemporaryElements() {
        this.temporaryElements.clear();
    }

    public Object[] getChildren(Object parentElement) {
        if (this.encapsulated instanceof ITreeContentProvider) {
            return ((ITreeContentProvider)this.encapsulated).getChildren(parentElement);
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (this.encapsulated instanceof ITreeContentProvider) {
            return ((ITreeContentProvider)this.encapsulated).getParent(element);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (this.encapsulated instanceof ITreeContentProvider) {
            return ((ITreeContentProvider)this.encapsulated).hasChildren(element);
        }
        return false;
    }

    @Override
    public boolean isValidValue(Object element) {
        if (this.encapsulated instanceof IHierarchicContentProvider) {
            return ((IHierarchicContentProvider)this.encapsulated).isValidValue(element);
        }
        return true;
    }

    @Override
    public void createBefore(Composite parent) {
        if (this.encapsulated instanceof IGraphicalContentProvider) {
            ((IGraphicalContentProvider)this.encapsulated).createBefore(parent);
        }
    }

    @Override
    public void createAfter(Composite parent) {
        if (this.encapsulated instanceof IGraphicalContentProvider) {
            ((IGraphicalContentProvider)this.encapsulated).createAfter(parent);
        }
    }

    @Override
    public void commit(AbstractEditor editor) {
        if (this.encapsulated instanceof ICommitListener) {
            ((ICommitListener)this.encapsulated).commit(editor);
        }
    }

    @Override
    public Object getAdaptedValue(Object selection) {
        if (this.encapsulated instanceof IAdaptableContentProvider) {
            return ((IAdaptableContentProvider)this.encapsulated).getAdaptedValue(selection);
        }
        return selection;
    }

    @Override
    public void revealSemanticElement(List<?> elementList) {
        if (this.encapsulated instanceof IRevealSemanticElement) {
            ((IRevealSemanticElement)this.encapsulated).revealSemanticElement(elementList);
        }
    }

    @Override
    public TreeBrowseStrategy getBrowseStrategy() {
        if (this.encapsulated instanceof IStrategyBasedContentProvider) {
            return ((IStrategyBasedContentProvider)this.encapsulated).getBrowseStrategy();
        }
        return null;
    }

    @Override
    public TreeBrowseStrategy getRevealStrategy() {
        if (this.encapsulated instanceof IStrategyBasedContentProvider) {
            return ((IStrategyBasedContentProvider)this.encapsulated).getRevealStrategy();
        }
        return null;
    }
}

