/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.blockdefinition.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.sysml.diagram.blockdefinition.preferences.BlockDefinitionDiagramNodePreferencePage;
import org.eclipse.papyrus.sysml.diagram.common.preferences.LabelPreferenceHelper;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class ConstraintPreferencePage
extends BlockDefinitionDiagramNodePreferencePage {
    public static String prefKey = "BlockDefinition_shape_uml_constraint_as_label";
    protected Button bttnName;
    protected Button bttnSpecification;
    public static String prefLabelKey = "BlockDefinition_shape_uml_constraint_as_label";
    private String labelDisplayPreferenceKey = LabelPreferenceHelper.getPreferenceConstant((String)prefLabelKey, (String)"label.display");
    private int propertyValue = this.getPreferenceStore().getInt(this.labelDisplayPreferenceKey);

    public ConstraintPreferencePage() {
        this.setPreferenceKey("BlockDefinition_shape_uml_constraint_as_label");
    }

    public static void initDefaults(IPreferenceStore store) {
        store.setDefault(LabelPreferenceHelper.getPreferenceConstant((String)prefKey, (String)"label.display"), 4096);
    }

    protected Button createCheckButton(Composite parent, String label, int mask) {
        Button button = new Button(parent, 32);
        button.setText(label);
        button.addSelectionListener((SelectionListener)new AppearenceSelectionListener(mask));
        return button;
    }

    protected void createLabelPreferencesButtons(Composite parent) {
        Group group = new Group(parent, 32);
        group.setText("Label Display");
        group.setLayout((Layout)new FormLayout());
        this.bttnName = this.createCheckButton((Composite)group, "Name", 8);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 0);
        this.bttnName.setLayoutData((Object)data);
        this.bttnSpecification = this.createCheckButton((Composite)group, "Specification", 4096);
        data = new FormData();
        data.left = new FormAttachment((Control)this.bttnName, 85);
        data.top = new FormAttachment(0, 0);
        this.bttnSpecification.setLayoutData((Object)data);
    }

    protected void createPageContents(Composite parent) {
        super.createPageContents(parent);
        this.createLabelPreferencesButtons(parent);
        this.refreshButtons();
    }

    protected void loadDefaultPreferences() {
        this.propertyValue = this.getPreferenceStore().getDefaultInt(this.labelDisplayPreferenceKey);
        this.refreshButtons();
    }

    protected void performDefaults() {
        this.loadDefaultPreferences();
        super.performDefaults();
    }

    public boolean performOk() {
        this.storePreferences();
        return super.performOk();
    }

    protected void refreshButtons() {
        this.bttnName.setSelection((this.propertyValue & 8) == 8);
        this.bttnSpecification.setSelection((this.propertyValue & 0x1000) == 4096);
    }

    protected void storePreferences() {
        super.storePreferences();
        IPreferenceStore store = this.getPreferenceStore();
        if (this.propertyValue != store.getInt(this.labelDisplayPreferenceKey)) {
            store.setValue(this.labelDisplayPreferenceKey, this.propertyValue);
        }
    }

    private class AppearenceSelectionListener
    implements SelectionListener {
        private final int style;

        public AppearenceSelectionListener(int style) {
            this.style = style;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            ConstraintPreferencePage constraintPreferencePage = ConstraintPreferencePage.this;
            constraintPreferencePage.propertyValue = constraintPreferencePage.propertyValue ^ this.style;
            ConstraintPreferencePage.this.refreshButtons();
        }
    }
}

