/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.common.dialogs;

import java.util.Collection;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.papyrus.infra.services.edit.commands.ConfigureFeatureCommandFactory;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.widgets.editors.TreeSelectorDialog;
import org.eclipse.papyrus.sysml.diagram.common.Activator;
import org.eclipse.papyrus.sysml.diagram.common.dialogs.ServiceEditContentProvider;
import org.eclipse.papyrus.sysml.diagram.common.messages.Messages;
import org.eclipse.papyrus.uml.tools.providers.UMLLabelProvider;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.UMLPackage;

public class CreateOrSelectTypeDialog
extends FormDialog {
    protected Button creationRadio;
    protected Button selectionRadio;
    protected Text newTypeNameText;
    protected Text newTypeContainerNameText;
    protected Button newTypeContainerButton;
    protected String newTypeName = null;
    protected ICommand newTypeCreateCommand = null;
    protected EObject newTypeContainer = null;
    protected Text existingTypeNameText;
    protected Button existingTypeButton;
    protected EObject existingType = null;
    protected EObject defaultContainer;
    protected ILabelProvider labelProvider;
    protected IElementType elementType;
    protected EStructuralFeature editedFeature;
    protected EClass elementEClass;
    protected IElementType containerType;
    protected EStructuralFeature containerFeature;
    protected EClass containerEClass;

    public CreateOrSelectTypeDialog(Shell shell, EObject defaultContainer, IElementType elementType, EStructuralFeature editedFeature, EClass elementEClass, IElementType containerType, EStructuralFeature containerFeature, EClass containerEClass) {
        super(shell);
        this.defaultContainer = defaultContainer;
        this.elementType = elementType;
        this.editedFeature = editedFeature;
        this.elementEClass = elementEClass;
        this.containerType = containerType;
        this.containerFeature = containerFeature;
        this.containerEClass = containerEClass;
        this.labelProvider = new UMLLabelProvider();
    }

    protected String getDialogTitle() {
        return Messages.CreateOrSelectTypeDialog_DialogTitle;
    }

    protected String getSelectionSectionTitle() {
        return Messages.CreateOrSelectTypeDialog_SelectionSectionTitle;
    }

    protected String getSelectionSectionRadioLabel() {
        return Messages.CreateOrSelectTypeDialog_SelectionSectionRadioLabel;
    }

    protected String getCreationSectionTitle() {
        return Messages.CreateOrSelectTypeDialog_CreationSectionTitle;
    }

    protected String getCreationSectionRadioLabel() {
        return Messages.CreateOrSelectTypeDialog_CreationSectionRadioLabel;
    }

    protected String getNewTypeNameLabel() {
        return Messages.CreateOrSelectTypeDialog_NewTypeNameLabel;
    }

    protected String getNewTypeContainerNameLabel() {
        return Messages.CreateOrSelectTypeDialog_NewTypeContainerNameLabel;
    }

    protected String getNewTypeContainerDialogTitle() {
        return Messages.CreateOrSelectTypeDialog_SelectNewTypeContainerDialogTitle;
    }

    protected String getNewTypeContainerDialogMessage() {
        return Messages.CreateOrSelectTypeDialog_SelectNewTypeContainerDialogMessage;
    }

    protected String getTypeDialogTitle() {
        return Messages.CreateOrSelectTypeDialog_SelectTypeDialogTitle;
    }

    protected String getTypeDialogMessage() {
        return Messages.CreateOrSelectTypeDialog_SelectTypeDialogMessage;
    }

    protected void createFormContent(IManagedForm pForm) {
        pForm.getForm().setText(this.getDialogTitle());
        ScrolledForm scrolledForm = pForm.getForm();
        FormToolkit toolkit = pForm.getToolkit();
        Composite parent = scrolledForm.getBody();
        parent.setLayout((Layout)new GridLayout());
        this.createFormCreationSection(scrolledForm.getBody(), toolkit);
        this.createFormSelectionSection(scrolledForm.getBody(), toolkit);
        this.refreshSectionsEnable(false);
        this.hookListeners();
        this.setNewTypeContainer(this.defaultContainer);
        this.setNewTypeName(null);
        scrolledForm.reflow(true);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.refreshOkButton();
    }

    protected void createFormSelectionSection(Composite pParent, FormToolkit pToolkit) {
        String lSectionTitle = this.getSelectionSectionTitle();
        Section lSection = pToolkit.createSection(pParent, 320);
        lSection.setLayoutData((Object)new GridData(768));
        if (lSectionTitle != null) {
            lSection.setText(lSectionTitle);
        }
        ScrolledForm lInsideScrolledForm = pToolkit.createScrolledForm((Composite)lSection);
        lInsideScrolledForm.setExpandHorizontal(true);
        lInsideScrolledForm.setExpandVertical(true);
        Composite lBody = lInsideScrolledForm.getBody();
        GridLayout lLayout = new GridLayout();
        lLayout.numColumns = 3;
        lBody.setLayout((Layout)lLayout);
        this.selectionRadio = pToolkit.createButton(lBody, this.getSelectionSectionRadioLabel(), 16);
        this.selectionRadio.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        pToolkit.createLabel(lBody, this.elementType.getDisplayName(), 0);
        this.existingTypeNameText = pToolkit.createText(lBody, "", 2056);
        this.existingTypeNameText.setLayoutData((Object)new GridData(768));
        this.existingTypeButton = pToolkit.createButton(lBody, "...", 0x800000);
        Image image = Activator.getInstance().getImage((ENamedElement)this.elementType.getEClass());
        if (this.elementEClass != null) {
            image = Activator.getInstance().getImage((ENamedElement)this.elementEClass);
        }
        this.existingTypeButton.setImage(image);
        this.existingTypeButton.setLayoutData((Object)new GridData(0));
        lInsideScrolledForm.reflow(true);
        lSection.setClient((Control)lInsideScrolledForm);
    }

    protected void createFormCreationSection(Composite pParent, FormToolkit pToolkit) {
        String lSectionTitle = this.getCreationSectionTitle();
        Section lSection = pToolkit.createSection(pParent, 320);
        lSection.setLayoutData((Object)new GridData(768));
        if (lSectionTitle != null) {
            lSection.setText(lSectionTitle);
        }
        ScrolledForm lInsideScrolledForm = pToolkit.createScrolledForm((Composite)lSection);
        lInsideScrolledForm.setExpandHorizontal(true);
        lInsideScrolledForm.setExpandVertical(true);
        Composite lBody = lInsideScrolledForm.getBody();
        GridLayout lLayout = new GridLayout();
        lLayout.numColumns = 3;
        lBody.setLayout((Layout)lLayout);
        this.creationRadio = pToolkit.createButton(lBody, this.getCreationSectionRadioLabel(), 16);
        this.creationRadio.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        pToolkit.createLabel(lBody, this.getNewTypeNameLabel(), 0);
        this.newTypeNameText = pToolkit.createText(lBody, "", 2048);
        this.newTypeNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.newTypeNameText.setFocus();
        pToolkit.createLabel(lBody, this.getNewTypeContainerNameLabel(), 0);
        this.newTypeContainerNameText = pToolkit.createText(lBody, this.labelProvider.getText((Object)this.newTypeContainer), 2056);
        this.newTypeContainerNameText.setLayoutData((Object)new GridData(768));
        this.newTypeContainerButton = pToolkit.createButton(lBody, "...", 0x800000);
        Image image = Activator.getInstance().getImage((ENamedElement)this.containerType.getEClass());
        if (this.containerEClass != null) {
            image = Activator.getInstance().getImage((ENamedElement)this.containerEClass);
        }
        this.newTypeContainerButton.setImage(image);
        this.newTypeContainerButton.setLayoutData((Object)new GridData(0));
        lInsideScrolledForm.reflow(true);
        lSection.setClient((Control)lInsideScrolledForm);
    }

    protected void okPressed() {
        boolean isSelectionMode = this.selectionRadio.getSelection();
        if (!isSelectionMode) {
            this.existingType = null;
            this.buildNewTypeCreateCommand();
        } else {
            this.newTypeCreateCommand = null;
        }
        super.okPressed();
    }

    protected void buildNewTypeCreateCommand() {
        IElementEditService commandService = ElementEditServiceUtils.getCommandProvider((Object)this.newTypeContainer);
        if (commandService != null) {
            CreateElementRequest createTypeRequest = new CreateElementRequest(this.newTypeContainer, this.elementType);
            createTypeRequest.setParameter("IConfigureCommandFactory_ID", (Object)new ConfigureFeatureCommandFactory((EStructuralFeature)UMLPackage.eINSTANCE.getNamedElement_Name(), (Object)this.newTypeNameText.getText()));
            this.newTypeCreateCommand = commandService.getEditCommand((IEditCommandRequest)createTypeRequest);
        }
    }

    public ICommand getNewTypeCreateCommand() {
        return this.newTypeCreateCommand;
    }

    public String getNewTypeName() {
        return this.newTypeNameText.getText();
    }

    public EObject getExistingType() {
        return this.existingType;
    }

    protected void hookListeners() {
        SelectionAdapter selectCreateListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CreateOrSelectTypeDialog.this.creationRadio.equals(e.getSource())) {
                    CreateOrSelectTypeDialog.this.refreshSectionsEnable(false);
                } else {
                    CreateOrSelectTypeDialog.this.refreshSectionsEnable(true);
                }
                CreateOrSelectTypeDialog.this.refreshOkButton();
            }
        };
        this.selectionRadio.addSelectionListener((SelectionListener)selectCreateListener);
        this.creationRadio.addSelectionListener((SelectionListener)selectCreateListener);
        SelectionAdapter selectBtnListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateOrSelectTypeDialog.this.handleChooseType();
                CreateOrSelectTypeDialog.this.refreshOkButton();
            }
        };
        this.existingTypeButton.addSelectionListener((SelectionListener)selectBtnListener);
        ModifyListener lNameListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateOrSelectTypeDialog.this.setNewTypeName(CreateOrSelectTypeDialog.this.existingTypeNameText.getText());
            }
        };
        this.existingTypeNameText.addModifyListener(lNameListener);
        SelectionAdapter selectTypeBtnListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateOrSelectTypeDialog.this.handleChooseNewTypeContainer();
                if (CreateOrSelectTypeDialog.this.newTypeName == null) {
                    CreateOrSelectTypeDialog.this.setNewTypeName(null);
                }
                CreateOrSelectTypeDialog.this.refreshOkButton();
            }
        };
        this.newTypeContainerButton.addSelectionListener((SelectionListener)selectTypeBtnListener);
        ModifyListener lNewNameListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateOrSelectTypeDialog.this.validateNewTypeName();
                CreateOrSelectTypeDialog.this.refreshOkButton();
            }
        };
        this.newTypeNameText.addModifyListener(lNewNameListener);
    }

    protected void setNewTypeName(String text) {
        String name = text;
        if (text == null) {
            name = NamedElementUtil.getDefaultNameWithIncrementFromBase((String)this.elementType.getEClass().getName(), (Collection)this.newTypeContainer.eContents());
            if (this.elementEClass != null) {
                name = NamedElementUtil.getDefaultNameWithIncrementFromBase((String)this.elementEClass.getName(), (Collection)this.newTypeContainer.eContents());
            }
            this.newTypeNameText.setText(name);
        } else {
            this.newTypeNameText.setText(name);
            this.newTypeName = name;
        }
        this.validateNewTypeName();
        this.refreshOkButton();
    }

    protected void validateNewTypeName() {
        if (this.isValidName(this.newTypeContainer, this.newTypeNameText.getText())) {
            Color black = this.newTypeNameText.getDisplay().getSystemColor(2);
            this.newTypeNameText.setForeground(black);
        } else {
            Color red = this.newTypeNameText.getDisplay().getSystemColor(3);
            this.newTypeNameText.setForeground(red);
        }
    }

    protected boolean isValidName(EObject container, String newName) {
        boolean isValid = true;
        if (container instanceof Namespace && ((Namespace)container).getOwnedMember(newName) != null) {
            isValid = false;
        }
        return isValid;
    }

    protected void handleChooseType() {
        TreeSelectorDialog dialog = new TreeSelectorDialog(this.getShell());
        dialog.setMessage(this.getTypeDialogMessage());
        dialog.setTitle(this.getTypeDialogTitle());
        dialog.setInput((Object)EcoreUtil.getRootContainer((EObject)this.defaultContainer));
        ServiceEditContentProvider provider = new ServiceEditContentProvider(this.elementType, this.editedFeature, EcoreUtil.getRootContainer((EObject)this.defaultContainer));
        dialog.setContentProvider((ITreeContentProvider)provider);
        dialog.setLabelProvider(this.labelProvider);
        if (dialog.open() == 0) {
            Object result = dialog.getResult()[0];
            if (result instanceof IAdaptable) {
                result = ((IAdaptable)result).getAdapter(EObject.class);
            }
            if (result instanceof EObject) {
                this.setExistingTypeSelection((EObject)result);
            } else {
                this.setExistingTypeSelection(null);
            }
        }
    }

    protected void setExistingTypeSelection(EObject type) {
        if (type == null) {
            this.existingTypeNameText.setText("");
        } else {
            this.existingType = type;
            this.existingTypeNameText.setText(this.labelProvider.getText((Object)this.existingType));
        }
    }

    protected void handleChooseNewTypeContainer() {
        TreeSelectorDialog dialog = new TreeSelectorDialog(this.getShell());
        dialog.setMessage(this.getNewTypeContainerDialogMessage());
        dialog.setTitle(this.getNewTypeContainerDialogTitle());
        dialog.setInput((Object)EcoreUtil.getRootContainer((EObject)this.defaultContainer));
        ServiceEditContentProvider provider = new ServiceEditContentProvider(this.containerType, this.containerFeature, EcoreUtil.getRootContainer((EObject)this.defaultContainer));
        dialog.setContentProvider((ITreeContentProvider)provider);
        dialog.setLabelProvider(this.labelProvider);
        if (dialog.open() == 0) {
            Object result = dialog.getResult()[0];
            if (result instanceof IAdaptable) {
                result = ((IAdaptable)result).getAdapter(EObject.class);
            }
            if (result instanceof EObject) {
                this.setNewTypeContainer((EObject)result);
            } else {
                this.setNewTypeContainer(null);
            }
        }
    }

    protected void setNewTypeContainer(EObject container) {
        if (this.containerType instanceof ISpecializationType && ((ISpecializationType)this.containerType).getMatcher().matches(container)) {
            this.newTypeContainer = container;
            this.newTypeContainerNameText.setText(this.labelProvider.getText((Object)this.newTypeContainer));
        } else if (this.containerType.getEClass().isInstance((Object)container)) {
            this.newTypeContainer = container;
            this.newTypeContainerNameText.setText(this.labelProvider.getText((Object)this.newTypeContainer));
        } else {
            this.newTypeContainer = null;
            this.newTypeContainerNameText.setText("");
        }
    }

    private void refreshSectionsEnable(boolean isSelectionSelected) {
        if (isSelectionSelected) {
            this.creationRadio.setSelection(false);
            if (!this.selectionRadio.getSelection()) {
                this.selectionRadio.setSelection(true);
            }
        } else {
            this.selectionRadio.setSelection(false);
            if (!this.creationRadio.getSelection()) {
                this.creationRadio.setSelection(true);
            }
        }
        this.existingTypeNameText.setEnabled(isSelectionSelected);
        this.existingTypeButton.setEnabled(isSelectionSelected);
        this.newTypeNameText.setEnabled(!isSelectionSelected);
        this.newTypeNameText.setFocus();
        this.newTypeContainerNameText.setEnabled(!isSelectionSelected);
        this.newTypeContainerButton.setEnabled(!isSelectionSelected);
    }

    protected void refreshOkButton() {
        boolean isSelectionSelected = this.selectionRadio.getSelection();
        if (this.getButton(0) != null && !this.getButton(0).isDisposed()) {
            if (isSelectionSelected) {
                this.getButton(0).setEnabled(this.existingType != null);
            } else {
                this.getButton(0).setEnabled(this.newTypeContainer != null && this.isValidName(this.newTypeContainer, this.newTypeNameText.getText()));
            }
        }
    }
}

