/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.uml.alf.alf.AcceptBlock;
import org.eclipse.papyrus.uml.alf.alf.AcceptStatement;
import org.eclipse.papyrus.uml.alf.alf.AlfPackage;
import org.eclipse.papyrus.uml.alf.alf.AssignmentOperator;
import org.eclipse.papyrus.uml.alf.alf.ClassificationClause;
import org.eclipse.papyrus.uml.alf.alf.ClassificationFromClause;
import org.eclipse.papyrus.uml.alf.alf.ClassificationToClause;
import org.eclipse.papyrus.uml.alf.alf.ClassifyStatement;
import org.eclipse.papyrus.uml.alf.alf.ConcurrentClauses;
import org.eclipse.papyrus.uml.alf.alf.DoStatement;
import org.eclipse.papyrus.uml.alf.alf.DocumentedStatement;
import org.eclipse.papyrus.uml.alf.alf.ForStatement;
import org.eclipse.papyrus.uml.alf.alf.IfStatement;
import org.eclipse.papyrus.uml.alf.alf.InstanceCreationInvocationStatement;
import org.eclipse.papyrus.uml.alf.alf.InvocationOrAssignementOrDeclarationStatement;
import org.eclipse.papyrus.uml.alf.alf.LocalNameDeclarationStatement;
import org.eclipse.papyrus.uml.alf.alf.LoopVariableDefinition;
import org.eclipse.papyrus.uml.alf.alf.NameExpression;
import org.eclipse.papyrus.uml.alf.alf.NonEmptyStatementSequence;
import org.eclipse.papyrus.uml.alf.alf.NonFinalClause;
import org.eclipse.papyrus.uml.alf.alf.PropertyCallExpression;
import org.eclipse.papyrus.uml.alf.alf.QualifiedNameList;
import org.eclipse.papyrus.uml.alf.alf.QualifiedNameWithBinding;
import org.eclipse.papyrus.uml.alf.alf.ReturnStatement;
import org.eclipse.papyrus.uml.alf.alf.StatementSequence;
import org.eclipse.papyrus.uml.alf.alf.SuffixExpression;
import org.eclipse.papyrus.uml.alf.alf.SuperInvocationStatement;
import org.eclipse.papyrus.uml.alf.alf.ThisInvocationStatement;
import org.eclipse.papyrus.uml.alf.alf.TupleElement;
import org.eclipse.papyrus.uml.alf.alf.UnqualifiedName;
import org.eclipse.papyrus.uml.alf.alf.VariableDeclarationCompletion;
import org.eclipse.papyrus.uml.alf.alf.WhileStatement;
import org.eclipse.papyrus.uml.alf.scoping.AlfPartialScope;
import org.eclipse.papyrus.uml.alf.scoping.AlfScopeProvider;
import org.eclipse.papyrus.uml.alf.validation.AbstractAlfJavaValidator;
import org.eclipse.papyrus.uml.alf.validation.PredefinedBehaviorsAndTypesUtils;
import org.eclipse.papyrus.uml.alf.validation.typing.AssignmentPolicy;
import org.eclipse.papyrus.uml.alf.validation.typing.ErrorTypeFacade;
import org.eclipse.papyrus.uml.alf.validation.typing.SignatureFacade;
import org.eclipse.papyrus.uml.alf.validation.typing.TypeExpression;
import org.eclipse.papyrus.uml.alf.validation.typing.TypeExpressionFactory;
import org.eclipse.papyrus.uml.alf.validation.typing.TypeFacade;
import org.eclipse.papyrus.uml.alf.validation.typing.TypeFacadeFactory;
import org.eclipse.papyrus.uml.alf.validation.typing.TypeUtils;
import org.eclipse.papyrus.uml.alf.validation.typing.VoidFacade;
import org.eclipse.papyrus.uml.extensionpoints.library.RegisteredLibrary;
import org.eclipse.papyrus.uml.extensionpoints.utils.Util;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;

public class AlfJavaValidator
extends AbstractAlfJavaValidator {
    private static Element contextElement;
    private static Classifier contextClassifier;
    private static Namespace model;
    private static Package alfStandardLibrary;
    public static PredefinedBehaviorsAndTypesUtils predefinedBehaviorsAndTypes;

    public static Package getAlfStandardLibrary() {
        return alfStandardLibrary;
    }

    public static boolean validate() {
        return true;
    }

    public static Namespace getModel() {
        return model;
    }

    public static void setModel(Namespace model) {
        AlfJavaValidator.model = model;
    }

    public static void setContextElement(Element _contextElement) {
        contextElement = _contextElement;
    }

    public static Element getContextElement() {
        return contextElement;
    }

    public static Classifier getContextClassifier() {
        return contextClassifier;
    }

    public static void setContextClassifier(Classifier contextClassifier) {
        AlfJavaValidator.contextClassifier = contextClassifier;
        alfStandardLibrary = null;
        for (PackageImport pImport : contextClassifier.getModel().getPackageImports()) {
            Package p = pImport.getImportedPackage();
            if (!p.getQualifiedName().equals("Alf")) continue;
            alfStandardLibrary = p;
        }
        if (alfStandardLibrary != null) {
            predefinedBehaviorsAndTypes = new PredefinedBehaviorsAndTypesUtils();
            predefinedBehaviorsAndTypes.init(alfStandardLibrary);
        } else {
            String question = "The context model " + contextClassifier.getModel().getName() + " does not import the standard Alf library. This import is required for static validation of Alf expressions and statements. \n\n Do you want to generate this import?";
            boolean doGenerateImport = MessageDialog.openQuestion((Shell)new Shell(), (String)"Alf editor", (String)question);
            if (doGenerateImport) {
                RegisteredLibrary[] libraries = RegisteredLibrary.getRegisteredLibraries();
                RegisteredLibrary alfLibrary = null;
                RegisteredLibrary[] registeredLibraryArray = libraries;
                int n = libraries.length;
                int n2 = 0;
                while (n2 < n) {
                    RegisteredLibrary l = registeredLibraryArray[n2];
                    if (l.getName().equals("AlfLibrary")) {
                        alfLibrary = l;
                    }
                    ++n2;
                }
                if (alfLibrary != null) {
                    UpdateImportCommand updateCommand = new UpdateImportCommand(contextClassifier.getModel(), alfLibrary);
                    try {
                        OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)updateCommand, (IProgressMonitor)new NullProgressMonitor(), null);
                        AlfJavaValidator.setContextClassifier(contextClassifier);
                    }
                    catch (ExecutionException e) {
                        System.err.println((Object)e);
                    }
                } else {
                    MessageDialog.openError((Shell)new Shell(), (String)"Alf editor", (String)"Could not find standard Alf library");
                }
            }
        }
    }

    public void register(EValidatorRegistrar registrar) {
        super.register(registrar);
    }

    @Check
    public void checkTupleElement(TupleElement tupleElement) {
        TypeExpression exp = new TypeUtils().getTypeOfExpression(tupleElement.getArgument());
        if (exp.getTypeFacade() instanceof ErrorTypeFacade) {
            ErrorTypeFacade error = (ErrorTypeFacade)exp.getTypeFacade();
            this.error(error.getLabel(), error.getErrorSource(), error.getStructuralFeature(), -1);
        }
    }

    @Check
    public void checkLocalNameDeclarationStatement(LocalNameDeclarationStatement statement) {
        AlfPartialScope variablesScope;
        List<EObject> resolved;
        if (statement.getVarName() != null && !(resolved = (variablesScope = AlfScopeProvider.scopingTool.getVisibleVariablesOrParametersOrProperties(statement)).resolveByName(statement.getVarName())).isEmpty() && variablesScope.getScopingLevel(resolved.get(0)) == 0 && resolved.get(0) != statement) {
            this.error("Local name " + statement.getVarName() + " is not available", (EStructuralFeature)AlfPackage.eINSTANCE.getLocalNameDeclarationStatement_VarName());
        }
        TypeFacade variableType = null;
        if (statement.getType() != null) {
            variableType = TypeFacadeFactory.eInstance.createVoidFacade(statement.getType());
            if (variableType instanceof ErrorTypeFacade) {
                ErrorTypeFacade error = (ErrorTypeFacade)variableType;
                this.error(error.getLabel(), error.getErrorSource(), error.getStructuralFeature(), -1);
                variableType = null;
            } else if (variableType.isATemplate() && statement.getType().getBinding() == null) {
                String errorMessage = String.valueOf(variableType.getLabel()) + " is a template. All its parameters shall be bound.";
                this.error(errorMessage, statement, (EStructuralFeature)AlfPackage.eINSTANCE.getLocalNameDeclarationStatement_Type(), -1);
            }
        }
        if (statement.getInit() != null) {
            boolean isOrdered;
            boolean isUnique;
            int upperBound;
            int lowerBound;
            TypeExpression expectedType;
            TypeExpression typeOfInit = new TypeUtils().getTypeOfSequenceElement(statement.getInit());
            if (typeOfInit.getTypeFacade() instanceof ErrorTypeFacade) {
                ErrorTypeFacade error = (ErrorTypeFacade)typeOfInit.getTypeFacade();
                this.error(error.getLabel(), error.getErrorSource(), error.getStructuralFeature(), -1);
            } else if (variableType != null && (expectedType = TypeExpressionFactory.eInstance.createTypeExpression(variableType, lowerBound = statement.isMultiplicityIndicator() ? 0 : 1, upperBound = statement.isMultiplicityIndicator() ? -1 : 1, isUnique = !statement.isMultiplicityIndicator(), isOrdered = statement.isMultiplicityIndicator())).isCompatibleWithMe(typeOfInit) == 0) {
                this.error("Found an expression of type " + typeOfInit.getLabel() + ". Expecting an expression of type " + expectedType.getLabel(), (EStructuralFeature)AlfPackage.eINSTANCE.getLocalNameDeclarationStatement_Init());
            }
        }
    }

    @Check
    public void checkIfStatement(IfStatement statement) {
        for (ConcurrentClauses concurrentClause : statement.getSequentialClausses().getConccurentClauses()) {
            for (NonFinalClause nonFinalClause : concurrentClause.getNonFinalClause()) {
                TypeExpression typeOfCondition = new TypeUtils().getTypeOfExpression(nonFinalClause.getCondition());
                if (typeOfCondition.getTypeFacade() instanceof ErrorTypeFacade) {
                    ErrorTypeFacade error = (ErrorTypeFacade)typeOfCondition.getTypeFacade();
                    this.error(error.getLabel(), error.getErrorSource(), error.getStructuralFeature(), -1);
                    continue;
                }
                if (TypeExpressionFactory.eInstance.createTypeExpression(TypeUtils._boolean).isCompatibleWithMe(typeOfCondition) != 0) continue;
                String errorMessage = "Expecting an expression of type Boolean. Found an expression of type " + typeOfCondition.getLabel();
                this.error(errorMessage, nonFinalClause, (EStructuralFeature)AlfPackage.eINSTANCE.getNonFinalClause_Condition(), -1);
            }
        }
    }

    @Check
    public void checkWhileStatement(WhileStatement statement) {
        TypeExpression typeOfCondition = new TypeUtils().getTypeOfExpression(statement.getCondition());
        if (typeOfCondition.getTypeFacade() instanceof ErrorTypeFacade) {
            ErrorTypeFacade error = (ErrorTypeFacade)typeOfCondition.getTypeFacade();
            this.error(error.getLabel(), error.getErrorSource(), error.getStructuralFeature(), -1);
        } else if (TypeExpressionFactory.eInstance.createTypeExpression(TypeUtils._boolean).isCompatibleWithMe(typeOfCondition) == 0) {
            String errorMessage = "Expecting an expression of type Boolean. Found an expression of type " + typeOfCondition.getLabel();
            this.error(errorMessage, (EStructuralFeature)AlfPackage.eINSTANCE.getWhileStatement_Condition());
        }
    }

    @Check
    public void checkDoStatement(DoStatement statement) {
        TypeExpression typeOfCondition = new TypeUtils().getTypeOfExpression(statement.getCondition());
        if (typeOfCondition.getTypeFacade() instanceof ErrorTypeFacade) {
            ErrorTypeFacade error = (ErrorTypeFacade)typeOfCondition.getTypeFacade();
            this.error(error.getLabel(), error.getErrorSource(), error.getStructuralFeature(), -1);
        } else if (TypeExpressionFactory.eInstance.createTypeExpression(TypeUtils._boolean).isCompatibleWithMe(typeOfCondition) == 0) {
            String errorMessage = "Expecting an expression of type Boolean. Found an expression of type " + typeOfCondition.getLabel();
            this.error(errorMessage, (EStructuralFeature)AlfPackage.eINSTANCE.getDoStatement_Condition());
        }
    }

    @Check
    public void checkForStatement(ForStatement statement) {
        AlfPartialScope variablesScope = AlfScopeProvider.scopingTool.getVisibleVariablesOrParametersOrProperties(statement);
        HashMap<String, Integer> declaredVariables = new HashMap<String, Integer>();
        for (LoopVariableDefinition loopVariable : statement.getControl().getLoopVariableDefinition()) {
            Integer variableDefinitionCounter = (Integer)declaredVariables.get(loopVariable.getName());
            if (variableDefinitionCounter == null) {
                declaredVariables.put(loopVariable.getName(), new Integer(1));
            } else {
                declaredVariables.put(loopVariable.getName(), variableDefinitionCounter + 1);
            }
            List<EObject> visibleVariables = variablesScope.resolveByName(loopVariable.getName());
            if (visibleVariables.isEmpty() || variablesScope.getScopingLevel(visibleVariables.get(0)) != 0) continue;
            this.error("Local name " + loopVariable.getName() + " is not available", loopVariable, (EStructuralFeature)AlfPackage.eINSTANCE.getLocalNameDeclarationStatement_VarName(), statement.getControl().getLoopVariableDefinition().indexOf((Object)loopVariable));
        }
        boolean duplicationFound = false;
        for (Integer i : declaredVariables.values()) {
            if (i <= 1) continue;
            duplicationFound = true;
        }
        if (duplicationFound) {
            this.error("Duplicate loop variable definitions", (EStructuralFeature)AlfPackage.eINSTANCE.getForStatement_Control());
        }
        for (LoopVariableDefinition loopVariable : statement.getControl().getLoopVariableDefinition()) {
            String errorMessage;
            ErrorTypeFacade error;
            TypeExpression typeOfExpression1;
            if (loopVariable.getExpression1() != null && loopVariable.getExpression2() == null) {
                typeOfExpression1 = new TypeUtils().getTypeOfExpression(loopVariable.getExpression1());
                if (typeOfExpression1.getTypeFacade() instanceof ErrorTypeFacade) {
                    error = (ErrorTypeFacade)typeOfExpression1.getTypeFacade();
                    this.error(error.getLabel(), error.getErrorSource(), error.getStructuralFeature(), -1);
                    continue;
                }
                int upperBound = typeOfExpression1.getMultiplicity().getUpperBound();
                if (upperBound > 1 || upperBound == -1) continue;
                String errorMessage2 = "Invalid upper bound multiplicity (" + upperBound + "). A collection is expected.";
                this.error(errorMessage2, loopVariable, (EStructuralFeature)AlfPackage.eINSTANCE.getLoopVariableDefinition_Expression1(), -1);
                continue;
            }
            if (loopVariable.getExpression1() != null && loopVariable.getExpression2() != null) {
                TypeExpression typeOfExpression2;
                typeOfExpression1 = new TypeUtils().getTypeOfExpression(loopVariable.getExpression1());
                boolean errorInExpressions = false;
                if (typeOfExpression1.getTypeFacade() instanceof ErrorTypeFacade) {
                    ErrorTypeFacade error2 = (ErrorTypeFacade)typeOfExpression1.getTypeFacade();
                    this.error(error2.getLabel(), error2.getErrorSource(), error2.getStructuralFeature(), -1);
                    errorInExpressions = true;
                }
                if ((typeOfExpression2 = new TypeUtils().getTypeOfExpression(loopVariable.getExpression2())).getTypeFacade() instanceof ErrorTypeFacade) {
                    ErrorTypeFacade error3 = (ErrorTypeFacade)typeOfExpression2.getTypeFacade();
                    this.error(error3.getLabel(), error3.getErrorSource(), error3.getStructuralFeature(), -1);
                    errorInExpressions = true;
                }
                if (errorInExpressions) continue;
                TypeFacade typeFacadeOfExpression1 = typeOfExpression1.getTypeFacade();
                int upperBoundExpression1 = typeOfExpression1.getMultiplicityFacade().getUpperBound();
                String errorMessageForExpression1 = "";
                if (!this.isANumberType(typeFacadeOfExpression1)) {
                    errorMessageForExpression1 = upperBoundExpression1 > 1 || upperBoundExpression1 == -1 ? String.valueOf(errorMessageForExpression1) + "A scalar number value is expected" : String.valueOf(errorMessageForExpression1) + "A number value is expected";
                } else if (upperBoundExpression1 > 1 || upperBoundExpression1 == -1) {
                    errorMessageForExpression1 = String.valueOf(errorMessageForExpression1) + "A scalar value is expected";
                }
                if (errorMessageForExpression1.length() != 0) {
                    this.error(errorMessageForExpression1, loopVariable, (EStructuralFeature)AlfPackage.eINSTANCE.getLoopVariableDefinition_Expression1(), -1);
                }
                TypeFacade typeFacadeOfExpression2 = typeOfExpression2.getTypeFacade();
                int upperBoundExpression2 = typeOfExpression2.getMultiplicityFacade().getUpperBound();
                String errorMessageForExpression2 = "";
                if (!this.isANumberType(typeFacadeOfExpression2)) {
                    errorMessageForExpression2 = upperBoundExpression2 > 1 || upperBoundExpression2 == -1 ? String.valueOf(errorMessageForExpression2) + "A scalar number value is expected" : String.valueOf(errorMessageForExpression2) + "A number value is expected";
                } else if (upperBoundExpression2 > 1 || upperBoundExpression2 == -1) {
                    errorMessageForExpression2 = String.valueOf(errorMessageForExpression2) + "A scalar value is expected";
                }
                if (errorMessageForExpression2.length() == 0) continue;
                this.error(errorMessageForExpression2, loopVariable, (EStructuralFeature)AlfPackage.eINSTANCE.getLoopVariableDefinition_Expression2(), -1);
                continue;
            }
            if (loopVariable.getType() == null) continue;
            TypeFacade typeOfVariable = TypeFacadeFactory.eInstance.createVoidFacade(loopVariable.getType());
            if (typeOfVariable instanceof ErrorTypeFacade) {
                error = (ErrorTypeFacade)typeOfVariable;
                this.error(error.getLabel(), error.getErrorSource(), error.getStructuralFeature(), -1);
                continue;
            }
            TypeExpression typeOfDomain = new TypeUtils().getTypeOfExpression(loopVariable.getExpression());
            if (typeOfDomain.getTypeFacade() instanceof ErrorTypeFacade) {
                ErrorTypeFacade error4 = (ErrorTypeFacade)typeOfDomain.getTypeFacade();
                this.error(error4.getLabel(), error4.getErrorSource(), error4.getStructuralFeature(), -1);
                continue;
            }
            int upperBound = typeOfDomain.getMultiplicity().getUpperBound();
            if (upperBound <= 1 && upperBound != -1) {
                errorMessage = "Invalid upper bound multiplicity (" + upperBound + "). A collection is expected.";
                this.error(errorMessage, loopVariable, (EStructuralFeature)AlfPackage.eINSTANCE.getLoopVariableDefinition_Expression(), -1);
            }
            if (typeOfVariable.isCompatibleWithMe(typeOfDomain.getTypeFacade()) != 0) continue;
            errorMessage = "Cannot convert from " + typeOfDomain.getTypeFacade().getLabel() + " to " + typeOfVariable.getLabel();
            this.error(errorMessage, loopVariable, (EStructuralFeature)AlfPackage.eINSTANCE.getLoopVariableDefinition_Type(), -1);
        }
    }

    @Check
    public void checkReturnStatement(ReturnStatement statement) {
        boolean returnStatementExpected = AlfScopeProvider.scopingTool.isAReturnStatementExpected(statement);
        if (!returnStatementExpected) {
            String errorMessage = "No return statement expected";
            this.error(errorMessage, (EStructuralFeature)AlfPackage.eINSTANCE.getReturnStatement_Expression());
        } else {
            TypeExpression expectedReturnType = AlfScopeProvider.scopingTool.getExpectedReturnType(statement);
            TypeExpression actualReturnType = new TypeUtils().getTypeOfExpression(statement.getExpression());
            if (actualReturnType.getTypeFacade() instanceof ErrorTypeFacade) {
                ErrorTypeFacade error = (ErrorTypeFacade)actualReturnType.getTypeFacade();
                this.error(error.getLabel(), error.getErrorSource(), error.getStructuralFeature(), -1);
            } else if (expectedReturnType.isCompatibleWithMe(actualReturnType) == 0) {
                String errorMessage = "An expression of type " + expectedReturnType.getLabel() + " is expected. Found an expression of type " + actualReturnType.getLabel();
                this.error(errorMessage, (EStructuralFeature)AlfPackage.eINSTANCE.getReturnStatement_Expression());
            }
        }
        EObject cddStatementSequence = statement.eContainer();
        DocumentedStatement contextDocumentedStatement = null;
        while (cddStatementSequence != null && !(cddStatementSequence instanceof StatementSequence) && !(cddStatementSequence instanceof NonEmptyStatementSequence)) {
            if (contextDocumentedStatement == null && cddStatementSequence instanceof DocumentedStatement) {
                contextDocumentedStatement = (DocumentedStatement)cddStatementSequence;
            }
            cddStatementSequence = cddStatementSequence.eContainer();
        }
        if (cddStatementSequence != null && contextDocumentedStatement != null) {
            int statementIndex = 0;
            int numberOfStatements = 0;
            if (cddStatementSequence instanceof StatementSequence) {
                statementIndex = ((StatementSequence)cddStatementSequence).getStatements().indexOf((Object)contextDocumentedStatement);
                numberOfStatements = ((StatementSequence)cddStatementSequence).getStatements().size();
            } else {
                statementIndex = ((NonEmptyStatementSequence)cddStatementSequence).getStatement().indexOf((Object)contextDocumentedStatement);
                numberOfStatements = ((NonEmptyStatementSequence)cddStatementSequence).getStatement().size();
            }
            String errorMessage = "The statement cannot be reached";
            int i = statementIndex + 1;
            while (i < numberOfStatements) {
                DocumentedStatement current = null;
                current = cddStatementSequence instanceof StatementSequence ? (DocumentedStatement)((StatementSequence)cddStatementSequence).getStatements().get(i) : (DocumentedStatement)((NonEmptyStatementSequence)cddStatementSequence).getStatement().get(i);
                this.error(errorMessage, current, (EStructuralFeature)AlfPackage.eINSTANCE.getDocumentedStatement_Statement(), -1);
                ++i;
            }
        }
    }

    @Check
    public void checkAcceptStatement(AcceptStatement statement) {
        List<EObject> visibleElements;
        if (!(contextClassifier instanceof Class) || !((Class)contextClassifier).isActive()) {
            this.error("The context classifier must be an active class", (EStructuralFeature)AlfPackage.eINSTANCE.getAcceptStatement_Clause());
        }
        AlfPartialScope vppScope = AlfScopeProvider.scopingTool.getVisibleVariablesOrParametersOrProperties(statement);
        if (statement.getClause().getName() != null && !(visibleElements = vppScope.resolveByName(statement.getClause().getName())).isEmpty() && vppScope.getScopingLevel(visibleElements.get(0)) == 0) {
            String errorMessage = "Local name " + statement.getClause().getName() + " is not available";
            this.error(errorMessage, statement.getClause(), (EStructuralFeature)AlfPackage.eINSTANCE.getAcceptClause_Name(), -1);
        }
        if (statement.getCompoundAccept() != null) {
            for (AcceptBlock block : statement.getCompoundAccept().getAcceptBlock()) {
                List<EObject> visibleElements2;
                if (block.getClause() == null || block.getClause().getName() == null || (visibleElements2 = vppScope.resolveByName(block.getClause().getName())).isEmpty() || vppScope.getScopingLevel(visibleElements2.get(0)) != 0) continue;
                String errorMessage = "Local name " + block.getClause().getName() + " is not available";
                this.error(errorMessage, block.getClause(), (EStructuralFeature)AlfPackage.eINSTANCE.getAcceptClause_Name(), -1);
            }
        }
        AlfPartialScope signalReceptionScope = AlfScopeProvider.scopingTool.getVisibleSignalReceptions(statement);
        ArrayList<TypeFacade> signalReceptionTypeFacade = new ArrayList<TypeFacade>();
        for (List<EObject> l : signalReceptionScope.getScopeDetails()) {
            for (EObject m : l) {
                signalReceptionTypeFacade.add(TypeFacadeFactory.eInstance.createTypeFacade(m));
            }
        }
        HashMap<Classifier, ArrayList<QualifiedNameWithBinding>> allReferencedSignals = new HashMap<Classifier, ArrayList<QualifiedNameWithBinding>>();
        if (statement.getClause().getQualifiedNameList() != null) {
            QualifiedNameList list = statement.getClause().getQualifiedNameList();
            int index = 0;
            for (QualifiedNameWithBinding qualifiedName : list.getQualifiedName()) {
                TypeFacade type = TypeFacadeFactory.eInstance.createVoidFacade(qualifiedName);
                if (type instanceof ErrorTypeFacade) {
                    ErrorTypeFacade error = (ErrorTypeFacade)type;
                    this.error(error.getLabel(), error.getErrorSource(), error.getStructuralFeature(), -1);
                } else {
                    Classifier actualReferencedClassifier = type.extractActualType();
                    ArrayList<QualifiedNameWithBinding> existingReferences = (ArrayList<QualifiedNameWithBinding>)allReferencedSignals.get(actualReferencedClassifier);
                    if (existingReferences == null) {
                        existingReferences = new ArrayList<QualifiedNameWithBinding>();
                    }
                    existingReferences.add(qualifiedName);
                    allReferencedSignals.put(actualReferencedClassifier, existingReferences);
                    boolean found = false;
                    Iterator i = signalReceptionTypeFacade.iterator();
                    while (i.hasNext() && !found) {
                        TypeFacade current = (TypeFacade)i.next();
                        if (current.isCompatibleWithMe(type) == 0) continue;
                        found = true;
                    }
                    if (!found) {
                        String errorMessage = "The context classifier does not define any reception for " + type.getLabel();
                        this.error(errorMessage, list, (EStructuralFeature)AlfPackage.eINSTANCE.getQualifiedNameList_QualifiedName(), index);
                    }
                }
                ++index;
            }
        }
        for (Classifier key : allReferencedSignals.keySet()) {
            List referencesToKey = (List)allReferencedSignals.get(key);
            if (referencesToKey.size() <= 1) continue;
            for (QualifiedNameWithBinding qualifiedName : referencesToKey) {
                String errorMessage = "No signal may be named in more than one accept clause";
                QualifiedNameList containingList = (QualifiedNameList)qualifiedName.eContainer();
                int index = containingList.getQualifiedName().indexOf((Object)qualifiedName);
                this.error(errorMessage, containingList, (EStructuralFeature)AlfPackage.eINSTANCE.getQualifiedNameList_QualifiedName(), index - 1);
            }
        }
    }

    @Check
    public void checkClassifyStatement(ClassifyStatement statement) {
        int index;
        String errorMessage;
        Classifier actualType;
        ErrorTypeFacade error;
        TypeFacade type;
        Classifier actualStaticType = null;
        TypeExpression staticType = new TypeUtils().getTypeOfExpression(statement.getExpression());
        boolean errorFound = false;
        if (staticType.getTypeFacade() instanceof ErrorTypeFacade) {
            ErrorTypeFacade error2 = (ErrorTypeFacade)staticType.getTypeFacade();
            this.error(error2.getLabel(), error2.getErrorSource(), error2.getStructuralFeature(), -1);
            errorFound = true;
        } else {
            actualStaticType = staticType.getTypeFacade().extractActualType();
        }
        if (actualStaticType == null || !(actualStaticType instanceof Class)) {
            String errorMessage2 = "The type of the target expression must be a class";
            this.error(errorMessage2, (EStructuralFeature)AlfPackage.eINSTANCE.getClassifyStatement_Expression());
            errorFound = true;
        } else {
            int upperBound = staticType.getMultiplicityFacade().getUpperBound();
            if (upperBound > 1 || upperBound == -1) {
                String errorMessage3 = "The target expression must evaluate to a single object";
                this.error(errorMessage3, (EStructuralFeature)AlfPackage.eINSTANCE.getClassifyStatement_Expression());
                errorFound = true;
            }
        }
        ClassificationClause classificationClause = statement.getClause();
        ArrayList<Class> fromClasses = new ArrayList<Class>();
        ArrayList<Class> toClasses = new ArrayList<Class>();
        if (classificationClause == null) {
            return;
        }
        boolean isAReclassifyFromAll = false;
        if (classificationClause.getClassifyFromClause() == null && classificationClause.getClassifyToClause() == null && classificationClause.getReclassyAllClause() == null) {
            return;
        }
        if (classificationClause.getReclassyAllClause() != null) {
            isAReclassifyFromAll = true;
        }
        if (classificationClause.getClassifyFromClause() != null) {
            ClassificationFromClause fromClause = classificationClause.getClassifyFromClause();
            for (QualifiedNameWithBinding name : fromClause.getQualifiedNameList().getQualifiedName()) {
                type = TypeFacadeFactory.eInstance.createVoidFacade(name);
                if (type instanceof ErrorTypeFacade) {
                    error = (ErrorTypeFacade)type;
                    this.error(error.getLabel(), error.getErrorSource(), error.getStructuralFeature(), -1);
                    errorFound = true;
                    continue;
                }
                actualType = TypeFacade.extractActualType(type);
                if (actualType == null || !(actualType instanceof Class)) {
                    errorMessage = "All types in the 'from' list must be Classes";
                    index = fromClause.getQualifiedNameList().getQualifiedName().indexOf((Object)name);
                    this.error(errorMessage, fromClause.getQualifiedNameList(), (EStructuralFeature)AlfPackage.eINSTANCE.getQualifiedNameList_QualifiedName(), index);
                    continue;
                }
                fromClasses.add((Class)actualType);
            }
        }
        if (classificationClause.getClassifyToClause() != null) {
            ClassificationToClause toClause = classificationClause.getClassifyToClause();
            for (QualifiedNameWithBinding name : toClause.getQualifiedNameList().getQualifiedName()) {
                type = TypeFacadeFactory.eInstance.createVoidFacade(name);
                if (type instanceof ErrorTypeFacade) {
                    error = (ErrorTypeFacade)type;
                    this.error(error.getLabel(), error.getErrorSource(), error.getStructuralFeature(), -1);
                    errorFound = true;
                    continue;
                }
                actualType = TypeFacade.extractActualType(type);
                if (actualType == null || !(actualType instanceof Class)) {
                    errorMessage = "All types in the 'from' list must be Classes";
                    index = toClause.getQualifiedNameList().getQualifiedName().indexOf((Object)name);
                    this.error(errorMessage, toClause.getQualifiedNameList(), (EStructuralFeature)AlfPackage.eINSTANCE.getQualifiedNameList_QualifiedName(), index);
                    continue;
                }
                toClasses.add((Class)actualType);
            }
        }
        if (errorFound) {
            return;
        }
        ArrayList fromGenerals = new ArrayList();
        ArrayList toGenerals = new ArrayList();
        if (actualStaticType != null && !errorFound) {
            String errorMessage4 = "All classes in the 'from' list must be subclasses of the target expression type";
            int index2 = 0;
            for (Class c : fromClasses) {
                if (!c.allParents().contains((Object)actualStaticType)) {
                    this.error(errorMessage4, classificationClause.getClassifyFromClause(), (EStructuralFeature)AlfPackage.eINSTANCE.getClassificationFromClause_QualifiedNameList(), index2);
                    errorFound = true;
                }
                fromGenerals.addAll(c.allParents());
                ++index2;
            }
            errorMessage4 = "All classes in the 'to' list must be subclasses of the target expression type";
            index2 = 0;
            for (Class c : toClasses) {
                if (!c.allParents().contains((Object)actualStaticType)) {
                    this.error(errorMessage4, classificationClause.getClassifyToClause(), (EStructuralFeature)AlfPackage.eINSTANCE.getClassificationToClause_QualifiedNameList(), index2);
                    errorFound = true;
                }
                ++index2;
                toGenerals.addAll(c.allParents());
            }
        }
        if (errorFound) {
            return;
        }
        fromGenerals.retainAll(toGenerals);
        for (Classifier c : fromGenerals) {
            if (!c.allParents().contains((Object)actualStaticType)) continue;
            String errorMessage5 = "Superclasses of classes in 'to' and 'from' lists must be disjoint subclasses of the target expression type";
            this.error(errorMessage5, (EStructuralFeature)AlfPackage.eINSTANCE.getClassifyStatement_Clause());
            return;
        }
    }

    @Check
    public void checkInvocationOrAssignmentOrDeclarationStatement(InvocationOrAssignementOrDeclarationStatement statement) {
        if (statement.getVariableDeclarationCompletion() != null) {
            this.checkVariableDeclarationStatement(statement);
        } else if (statement.getAssignmentCompletion() != null) {
            this.checkAssignmentExpression(statement);
        } else {
            this.checkInvocationOrPrefixOrSuffixStatement(statement);
        }
    }

    private void checkInvocationOrPrefixOrSuffixStatement(InvocationOrAssignementOrDeclarationStatement statement) {
        boolean isAnInvocation = statement.getTypePart_OR_assignedPart_OR_invocationPart().getInvocationCompletion() != null;
        boolean isAPrefixExpression = statement.getTypePart_OR_assignedPart_OR_invocationPart().getPrefixOp() != null;
        boolean isAPostfixExpression = statement.getTypePart_OR_assignedPart_OR_invocationPart().getPostfixOp() != null;
        boolean hasASuffix = statement.getTypePart_OR_assignedPart_OR_invocationPart().getSuffix() != null;
        int resolvedKindOfExpression = 0;
        resolvedKindOfExpression += isAnInvocation ? 1 : 0;
        resolvedKindOfExpression += isAPrefixExpression ? 1 : 0;
        resolvedKindOfExpression += isAPostfixExpression ? 1 : 0;
        if ((resolvedKindOfExpression += hasASuffix ? 1 : 0) > 1 && !hasASuffix || resolvedKindOfExpression == 0) {
            String errorMessage = "An invocation expression, OR a prefix expression, OR a postfix expression is expected.";
            this.error(errorMessage, (EStructuralFeature)AlfPackage.eINSTANCE.getInvocationOrAssignementOrDeclarationStatement_TypePart_OR_assignedPart_OR_invocationPart());
            return;
        }
        if (isAnInvocation || hasASuffix) {
            NameExpression varOrParamOrPropOrOpOrBehav = statement.getTypePart_OR_assignedPart_OR_invocationPart();
            TypeExpression typeOfPrefix = new TypeUtils().getTypeOfNameExpression(varOrParamOrPropOrOpOrBehav);
            if (typeOfPrefix.getTypeFacade() != null && typeOfPrefix.getTypeFacade() instanceof ErrorTypeFacade) {
                ErrorTypeFacade error = (ErrorTypeFacade)typeOfPrefix.getTypeFacade();
                this.error(error.getLabel(), error.getErrorSource(), error.getStructuralFeature(), -1);
                return;
            }
            if (hasASuffix) {
                SuffixExpression suffix;
                SuffixExpression lastSuffix = suffix = statement.getTypePart_OR_assignedPart_OR_invocationPart().getSuffix();
                boolean suffixHasASuffix = false;
                do {
                    suffixHasASuffix = false;
                    Iterator content = suffix.eContents().iterator();
                    while (content.hasNext() && !suffixHasASuffix) {
                        EObject cddSuffix = (EObject)content.next();
                        if (!(cddSuffix instanceof SuffixExpression)) continue;
                        lastSuffix = (SuffixExpression)cddSuffix;
                        suffixHasASuffix = true;
                    }
                    if (!suffixHasASuffix) continue;
                    suffix = lastSuffix;
                } while (suffixHasASuffix);
                if (lastSuffix instanceof PropertyCallExpression) {
                    this.error("An invocation is expected", (EStructuralFeature)AlfPackage.eINSTANCE.getInvocationOrAssignementOrDeclarationStatement_TypePart_OR_assignedPart_OR_invocationPart());
                    return;
                }
            }
        } else if (isAPrefixExpression || isAPostfixExpression) {
            EAttribute feature;
            TypeExpression typeOfAssignedElement = new TypeUtils().getTypeOfNameExpression(statement.getTypePart_OR_assignedPart_OR_invocationPart());
            if (typeOfAssignedElement.getTypeFacade() instanceof ErrorTypeFacade) {
                ErrorTypeFacade error = (ErrorTypeFacade)typeOfAssignedElement.getTypeFacade();
                this.error(error.getLabel(), error.getErrorSource(), error.getStructuralFeature(), -1);
                return;
            }
            if (statement.getTypePart_OR_assignedPart_OR_invocationPart().getPath() != null || statement.getTypePart_OR_assignedPart_OR_invocationPart().getInvocationCompletion() != null && statement.getTypePart_OR_assignedPart_OR_invocationPart().getSuffix() == null || statement.getTypePart_OR_assignedPart_OR_invocationPart().getSequenceConstructionCompletion() != null || statement.getTypePart_OR_assignedPart_OR_invocationPart().getId() == null || statement.getTypePart_OR_assignedPart_OR_invocationPart().getId().length() == 0) {
                this.error("The assigned part must resolve to an assignable property, parameter or local variable", (EStructuralFeature)AlfPackage.eINSTANCE.getInvocationOrAssignementOrDeclarationStatement_TypePart_OR_assignedPart_OR_invocationPart());
                return;
            }
            if (statement.getTypePart_OR_assignedPart_OR_invocationPart().getSuffix() == null) {
                AlfPartialScope varParamPropScope = AlfScopeProvider.scopingTool.getVisibleVariablesOrParametersOrProperties(statement);
                EObject resolved = varParamPropScope.resolveByName(statement.getTypePart_OR_assignedPart_OR_invocationPart().getId()).get(0);
                String potentialAssignmentError = AssignmentPolicy.eInstance.isAssignable(resolved);
                if (potentialAssignmentError.length() != 0) {
                    this.error(potentialAssignmentError, (EStructuralFeature)AlfPackage.eINSTANCE.getInvocationOrAssignementOrDeclarationStatement_TypePart_OR_assignedPart_OR_invocationPart());
                    return;
                }
            } else {
                SuffixExpression suffix;
                SuffixExpression lastSuffix = suffix = statement.getTypePart_OR_assignedPart_OR_invocationPart().getSuffix();
                boolean suffixHasASuffix = false;
                do {
                    suffixHasASuffix = false;
                    Iterator content = suffix.eContents().iterator();
                    while (content.hasNext() && !suffixHasASuffix) {
                        EObject cddSuffix = (EObject)content.next();
                        if (!(cddSuffix instanceof SuffixExpression)) continue;
                        lastSuffix = (SuffixExpression)cddSuffix;
                        suffixHasASuffix = true;
                    }
                    if (!suffixHasASuffix) continue;
                    suffix = lastSuffix;
                } while (suffixHasASuffix);
                if (!(lastSuffix instanceof PropertyCallExpression)) {
                    this.error("The assigned part must resolve to an assignable property, parameter or local variable", (EStructuralFeature)AlfPackage.eINSTANCE.getInvocationOrAssignementOrDeclarationStatement_TypePart_OR_assignedPart_OR_invocationPart());
                    return;
                }
            }
            TypeExpression integerExpression = TypeExpressionFactory.eInstance.createTypeExpression(TypeUtils._integer);
            TypeExpression naturalExpression = TypeExpressionFactory.eInstance.createTypeExpression(TypeUtils._natural);
            TypeExpression unlimitedExpression = TypeExpressionFactory.eInstance.createTypeExpression(TypeUtils._unlimited);
            String operator = isAPrefixExpression ? statement.getTypePart_OR_assignedPart_OR_invocationPart().getPrefixOp() : statement.getTypePart_OR_assignedPart_OR_invocationPart().getPostfixOp();
            EAttribute eAttribute = feature = isAPrefixExpression ? AlfPackage.eINSTANCE.getNameExpression_PrefixOp() : AlfPackage.eINSTANCE.getNameExpression_PostfixOp();
            if (integerExpression.isCompatibleWithMe(typeOfAssignedElement) == 0 && naturalExpression.isCompatibleWithMe(typeOfAssignedElement) == 0 && unlimitedExpression.isCompatibleWithMe(typeOfAssignedElement) == 0) {
                this.error("Operator " + operator + " does not apply to " + typeOfAssignedElement.getLabel(), statement.getTypePart_OR_assignedPart_OR_invocationPart(), (EStructuralFeature)feature, -1);
            }
        }
    }

    private void checkVariableDeclarationStatement(InvocationOrAssignementOrDeclarationStatement statement) {
        String errorMessage;
        List<EObject> visibleElements;
        VoidFacade actualVariableType = null;
        TypeFacade cddVariableType = TypeFacadeFactory.eInstance.createVoidFacade(statement.getTypePart_OR_assignedPart_OR_invocationPart());
        if (cddVariableType instanceof ErrorTypeFacade) {
            ErrorTypeFacade error = (ErrorTypeFacade)cddVariableType;
            this.error(error.getLabel(), error.getErrorSource(), error.getStructuralFeature(), -1);
        } else {
            actualVariableType = (VoidFacade)cddVariableType;
        }
        VariableDeclarationCompletion declaration = statement.getVariableDeclarationCompletion();
        TypeExpression variableTypeExpression = null;
        if (actualVariableType != null) {
            variableTypeExpression = declaration.isMultiplicityIndicator() ? TypeExpressionFactory.eInstance.createTypeExpression(actualVariableType, 0, -1, false, true) : TypeExpressionFactory.eInstance.createTypeExpression(actualVariableType, 1, 1, true, false);
        }
        AlfPartialScope vppScope = AlfScopeProvider.scopingTool.getVisibleVariablesOrParametersOrProperties(statement);
        if (declaration.getVariableName() != null && !(visibleElements = vppScope.resolveByName(declaration.getVariableName())).isEmpty() && vppScope.getScopingLevel(visibleElements.get(0)) == 0) {
            errorMessage = "Local name " + declaration.getVariableName() + " is not available";
            this.error(errorMessage, declaration, (EStructuralFeature)AlfPackage.eINSTANCE.getVariableDeclarationCompletion_VariableName(), -1);
        }
        if (declaration.getInitValue() != null && declaration.getInitValue().getRightHandSide() != null) {
            TypeExpression typeOfInit = new TypeUtils().getTypeOfSequenceElement(declaration.getInitValue().getRightHandSide());
            if (typeOfInit == null) {
                errorMessage = "Init value is missing";
                this.error(errorMessage, (EStructuralFeature)AlfPackage.eINSTANCE.getInvocationOrAssignementOrDeclarationStatement_VariableDeclarationCompletion());
                return;
            }
            if (typeOfInit.getTypeFacade() instanceof ErrorTypeFacade) {
                ErrorTypeFacade error = (ErrorTypeFacade)typeOfInit.getTypeFacade();
                this.error(error.getLabel(), error.getErrorSource(), error.getStructuralFeature(), -1);
                return;
            }
            if (variableTypeExpression != null) {
                if (variableTypeExpression.isCompatibleWithMe(typeOfInit) == 0) {
                    errorMessage = "Expecting an expression of type " + variableTypeExpression.getLabel() + ". Found an expression of type " + typeOfInit.getLabel() + ".";
                    this.error(errorMessage, declaration.getInitValue(), (EStructuralFeature)AlfPackage.eINSTANCE.getAssignmentCompletion_RightHandSide(), -1);
                } else if (declaration.getInitValue().getOp() != AssignmentOperator.ASSIGN) {
                    errorMessage = "Expecting assignment operator '='";
                    this.error(errorMessage, declaration.getInitValue(), (EStructuralFeature)AlfPackage.eINSTANCE.getAssignmentCompletion_Op(), -1);
                }
            }
        }
    }

    private void checkAssignmentExpression(InvocationOrAssignementOrDeclarationStatement statement) {
        boolean errorInExpressions = false;
        TypeExpression typeOfLeft = new TypeUtils().getTypeOfNameExpression(statement.getTypePart_OR_assignedPart_OR_invocationPart());
        if (typeOfLeft.getTypeFacade() == null || typeOfLeft.getTypeFacade() instanceof ErrorTypeFacade) {
            ErrorTypeFacade error = (ErrorTypeFacade)typeOfLeft.getTypeFacade();
            this.error(error.getLabel(), error.getErrorSource(), error.getStructuralFeature(), -1);
            errorInExpressions = true;
        }
        TypeExpression typeOfRight = null;
        if (statement.getAssignmentCompletion().getRightHandSide() != null && ((typeOfRight = new TypeUtils().getTypeOfSequenceElement(statement.getAssignmentCompletion().getRightHandSide())) == null || typeOfRight.getTypeFacade() instanceof ErrorTypeFacade)) {
            ErrorTypeFacade error = (ErrorTypeFacade)typeOfRight.getTypeFacade();
            this.error(error.getLabel(), error.getErrorSource(), error.getStructuralFeature(), -1);
            errorInExpressions = true;
        }
        if (errorInExpressions) {
            return;
        }
        if (statement.getTypePart_OR_assignedPart_OR_invocationPart().getPath() != null || statement.getTypePart_OR_assignedPart_OR_invocationPart().getInvocationCompletion() != null && statement.getTypePart_OR_assignedPart_OR_invocationPart().getSuffix() == null || statement.getTypePart_OR_assignedPart_OR_invocationPart().getPrefixOp() != null || statement.getTypePart_OR_assignedPart_OR_invocationPart().getPostfixOp() != null || statement.getTypePart_OR_assignedPart_OR_invocationPart().getSequenceConstructionCompletion() != null) {
            if (statement.getTypePart_OR_assignedPart_OR_invocationPart().getSequenceConstructionCompletion() != null && statement.getTypePart_OR_assignedPart_OR_invocationPart().getSequenceConstructionCompletion().getAccessCompletion() != null) {
                return;
            }
            this.error("The left part of the assignment must resolve to an assignable property, parameter or local variable", (EStructuralFeature)AlfPackage.eINSTANCE.getInvocationOrAssignementOrDeclarationStatement_TypePart_OR_assignedPart_OR_invocationPart());
            return;
        }
        if (statement.getTypePart_OR_assignedPart_OR_invocationPart().getSuffix() == null) {
            AlfPartialScope varParamPropScope = AlfScopeProvider.scopingTool.getVisibleVariablesOrParametersOrProperties(statement);
            EObject resolved = varParamPropScope.resolveByName(statement.getTypePart_OR_assignedPart_OR_invocationPart().getId()).get(0);
            String potentialAssignmentError = AssignmentPolicy.eInstance.isAssignable(resolved);
            if (potentialAssignmentError.length() != 0) {
                this.error(potentialAssignmentError, (EStructuralFeature)AlfPackage.eINSTANCE.getInvocationOrAssignementOrDeclarationStatement_TypePart_OR_assignedPart_OR_invocationPart());
            }
        } else {
            SuffixExpression suffix;
            SuffixExpression lastSuffix = suffix = statement.getTypePart_OR_assignedPart_OR_invocationPart().getSuffix();
            boolean suffixHasASuffix = false;
            do {
                suffixHasASuffix = false;
                Iterator content = suffix.eContents().iterator();
                while (content.hasNext() && !suffixHasASuffix) {
                    EObject cddSuffix = (EObject)content.next();
                    if (!(cddSuffix instanceof SuffixExpression)) continue;
                    lastSuffix = (SuffixExpression)cddSuffix;
                    suffixHasASuffix = true;
                }
                if (!suffixHasASuffix) continue;
                suffix = lastSuffix;
            } while (suffixHasASuffix);
            if (!(lastSuffix instanceof PropertyCallExpression)) {
                this.error("The left part of the assignment must resolve to an assignable property, parameter or local variable", (EStructuralFeature)AlfPackage.eINSTANCE.getInvocationOrAssignementOrDeclarationStatement_TypePart_OR_assignedPart_OR_invocationPart());
                return;
            }
        }
        if (statement.getAssignmentCompletion().getOp() == AssignmentOperator.ASSIGN) {
            String errorMessage;
            if (typeOfRight.getTypeFacade() == TypeUtils._undefined) {
                errorMessage = "Right part is untyped";
                this.error(errorMessage, (EStructuralFeature)AlfPackage.eINSTANCE.getInvocationOrAssignementOrDeclarationStatement_AssignmentCompletion());
            } else if (typeOfLeft.isCompatibleWithMe(typeOfRight) == 0) {
                errorMessage = "Cannot assign " + typeOfRight.getLabel() + " to " + typeOfLeft.getLabel();
                this.error(errorMessage, (EStructuralFeature)AlfPackage.eINSTANCE.getInvocationOrAssignementOrDeclarationStatement_AssignmentCompletion());
            }
        } else {
            String assignmentOp = this.assignmentOpToString(statement.getAssignmentCompletion().getOp());
            List<SignatureFacade> candidates = predefinedBehaviorsAndTypes.getSignatures(assignmentOp);
            ArrayList<TypeExpression> arguments = new ArrayList<TypeExpression>();
            arguments.add(typeOfLeft);
            arguments.add(typeOfRight);
            List<SignatureFacade> matchingSignatures = SignatureFacade.findNearestSignature(arguments, candidates);
            if (matchingSignatures.isEmpty()) {
                String errorMessage = "Operator " + assignmentOp + " does not apply to arguments (";
                boolean first = true;
                for (TypeExpression argType : arguments) {
                    if (!first) {
                        errorMessage = String.valueOf(errorMessage) + ", ";
                    } else {
                        first = false;
                    }
                    errorMessage = String.valueOf(errorMessage) + argType.getLabel();
                }
                errorMessage = String.valueOf(errorMessage) + ")";
                this.error(errorMessage, (EStructuralFeature)AlfPackage.eINSTANCE.getInvocationOrAssignementOrDeclarationStatement_AssignmentCompletion());
            }
        }
    }

    @Check
    public void checkSuperInvocationStatement(SuperInvocationStatement statement) {
        TypeExpression typeOfSuperInvocationExp = new TypeUtils().getTypeOfSuperInvocationExpression(statement.get_super());
        if (typeOfSuperInvocationExp.getTypeFacade() instanceof ErrorTypeFacade) {
            ErrorTypeFacade error = (ErrorTypeFacade)typeOfSuperInvocationExp.getTypeFacade();
            this.error(error.getLabel(), error.getErrorSource(), error.getStructuralFeature(), -1);
            return;
        }
    }

    @Check
    public void checkThisInvocationStatement(ThisInvocationStatement statement) {
        SuffixExpression suffix;
        TypeExpression typeOfThisExpression = new TypeUtils().getTypeOfThisExpression(statement.get_this());
        if (typeOfThisExpression.getTypeFacade() instanceof ErrorTypeFacade) {
            ErrorTypeFacade error = (ErrorTypeFacade)typeOfThisExpression.getTypeFacade();
            this.error(error.getLabel(), error.getErrorSource(), error.getStructuralFeature(), -1);
        }
        if (statement.getAssignmentCompletion() != null) {
            if (statement.get_this().getSuffix() == null) {
                this.error("A Property call expression is missing", (EStructuralFeature)AlfPackage.eINSTANCE.getThisInvocationStatement__this());
            } else {
                SuffixExpression lastSuffix = suffix = statement.get_this().getSuffix();
                boolean suffixHasASuffix = false;
                do {
                    suffixHasASuffix = false;
                    Iterator content = suffix.eContents().iterator();
                    while (content.hasNext() && !suffixHasASuffix) {
                        EObject cddSuffix = (EObject)content.next();
                        if (!(cddSuffix instanceof SuffixExpression)) continue;
                        lastSuffix = (SuffixExpression)cddSuffix;
                        suffixHasASuffix = true;
                    }
                    if (!suffixHasASuffix) continue;
                    suffix = lastSuffix;
                } while (suffixHasASuffix);
                if (!(lastSuffix instanceof PropertyCallExpression)) {
                    this.error("The expression should resolve to a Property", (EStructuralFeature)AlfPackage.eINSTANCE.getThisInvocationStatement__this());
                }
            }
            TypeExpression typeOfAssignment = null;
            if (statement.getAssignmentCompletion().getRightHandSide() == null) {
                return;
            }
            typeOfAssignment = new TypeUtils().getTypeOfSequenceElement(statement.getAssignmentCompletion().getRightHandSide());
            if (typeOfAssignment.getTypeFacade() instanceof ErrorTypeFacade) {
                ErrorTypeFacade error = (ErrorTypeFacade)typeOfAssignment.getTypeFacade();
                this.error(error.getLabel(), error.getErrorSource(), error.getStructuralFeature(), -1);
                return;
            }
            if (typeOfThisExpression.getTypeFacade() instanceof ErrorTypeFacade) {
                return;
            }
            if (statement.getAssignmentCompletion().getOp() == AssignmentOperator.ASSIGN) {
                String errorMessage;
                if (typeOfAssignment.getTypeFacade() == TypeUtils._undefined) {
                    errorMessage = "Right part is untyped";
                    this.error(errorMessage, (EStructuralFeature)AlfPackage.eINSTANCE.getInvocationOrAssignementOrDeclarationStatement_AssignmentCompletion());
                } else if (typeOfThisExpression.isCompatibleWithMe(typeOfAssignment) == 0) {
                    errorMessage = "Cannot assign " + typeOfAssignment.getLabel() + " to " + typeOfThisExpression.getLabel();
                    this.error(errorMessage, (EStructuralFeature)AlfPackage.eINSTANCE.getThisInvocationStatement_AssignmentCompletion());
                }
            } else {
                String assignmentOp = this.assignmentOpToString(statement.getAssignmentCompletion().getOp());
                List<SignatureFacade> candidates = predefinedBehaviorsAndTypes.getSignatures(assignmentOp);
                ArrayList<TypeExpression> arguments = new ArrayList<TypeExpression>();
                arguments.add(typeOfThisExpression);
                arguments.add(typeOfAssignment);
                List<SignatureFacade> matchingSignatures = SignatureFacade.findNearestSignature(arguments, candidates);
                if (matchingSignatures.isEmpty()) {
                    String errorMessage = "Operator " + assignmentOp + " does not apply to arguments (";
                    boolean first = true;
                    for (TypeExpression argType : arguments) {
                        if (!first) {
                            errorMessage = String.valueOf(errorMessage) + ", ";
                        } else {
                            first = false;
                        }
                        errorMessage = String.valueOf(errorMessage) + argType.getLabel();
                    }
                    errorMessage = String.valueOf(errorMessage) + ")";
                    this.error(errorMessage, (EStructuralFeature)AlfPackage.eINSTANCE.getThisInvocationStatement_AssignmentCompletion());
                }
            }
        } else {
            if (statement.get_this().getSuffix() == null) {
                this.error("An invocation expression is expected", (EStructuralFeature)AlfPackage.eINSTANCE.getThisInvocationStatement__this());
                return;
            }
            SuffixExpression lastSuffix = suffix = statement.get_this().getSuffix();
            boolean suffixHasASuffix = false;
            do {
                suffixHasASuffix = false;
                Iterator content = suffix.eContents().iterator();
                while (content.hasNext() && !suffixHasASuffix) {
                    EObject cddSuffix = (EObject)content.next();
                    if (!(cddSuffix instanceof SuffixExpression)) continue;
                    lastSuffix = (SuffixExpression)cddSuffix;
                    suffixHasASuffix = true;
                }
                if (!suffixHasASuffix) continue;
                suffix = lastSuffix;
            } while (suffixHasASuffix);
            if (lastSuffix instanceof PropertyCallExpression) {
                this.error("An assignment is expected", (EStructuralFeature)AlfPackage.eINSTANCE.getThisInvocationStatement__this());
                return;
            }
        }
    }

    @Check
    public void checkInstanceCreationInvocationStatement(InstanceCreationInvocationStatement statement) {
        SuffixExpression suffix;
        TypeExpression typeOfInstanceCreationExpression = new TypeUtils().getTypeOfInstanceCreationExpression(statement.get_new());
        if (typeOfInstanceCreationExpression.getTypeFacade() instanceof ErrorTypeFacade) {
            ErrorTypeFacade error = (ErrorTypeFacade)typeOfInstanceCreationExpression.getTypeFacade();
            this.error(error.getLabel(), error.getErrorSource(), error.getStructuralFeature(), -1);
            return;
        }
        SuffixExpression lastSuffix = suffix = statement.get_new().getSuffix();
        boolean suffixHasASuffix = false;
        do {
            suffixHasASuffix = false;
            Iterator content = suffix.eContents().iterator();
            while (content.hasNext() && !suffixHasASuffix) {
                EObject cddSuffix = (EObject)content.next();
                if (!(cddSuffix instanceof SuffixExpression)) continue;
                lastSuffix = (SuffixExpression)cddSuffix;
                suffixHasASuffix = true;
            }
            if (!suffixHasASuffix) continue;
            suffix = lastSuffix;
        } while (suffixHasASuffix);
        if (lastSuffix instanceof PropertyCallExpression) {
            this.error("An invocation is expected", (EStructuralFeature)AlfPackage.eINSTANCE.getInstanceCreationInvocationStatement__new());
            return;
        }
    }

    private String assignmentOpToString(AssignmentOperator operator) {
        switch (operator) {
            case ANDASSIGN: {
                return "&";
            }
            case DIVASSIGN: {
                return "/";
            }
            case LSHIFTASSIGN: {
                return "<<";
            }
            case MINUSASSIGN: {
                return "-";
            }
            case MODASSIGN: {
                return "%";
            }
            case MULTASSIGN: {
                return "*";
            }
            case ORASSIGN: {
                return "|";
            }
            case PLUSASSIGN: {
                return "+";
            }
            case RSHIFTASSIGN: {
                return ">>";
            }
            case URSHIFTASSIGN: {
                return ">>>";
            }
            case XORASSIGN: {
                return "^";
            }
            case ASSIGN: {
                return "=";
            }
        }
        return "";
    }

    private boolean isANumberType(TypeFacade typeFacade) {
        return TypeUtils._integer.isCompatibleWithMe(typeFacade) == 3 || TypeUtils._natural.isCompatibleWithMe(typeFacade) == 3 || TypeUtils._unlimited.isCompatibleWithMe(typeFacade) == 3;
    }

    @Check
    public void checkTemplateBindingInNameExpression(UnqualifiedName expression) {
        if (expression.getTemplateBinding() != null) {
            String errorMessage = "Template bindings are not supported in name expressions.";
            this.warning(errorMessage, (EStructuralFeature)AlfPackage.eINSTANCE.getUnqualifiedName_TemplateBinding());
        }
    }

    @Check
    public void checkTemplateBindingInQualifiedNameWithBinding(QualifiedNameWithBinding expression) {
    }

    protected static class UpdateImportCommand
    extends AbstractTransactionalCommand {
        private Model model;
        private RegisteredLibrary library;

        protected CommandResult doExecuteWithResult(IProgressMonitor arg0, IAdaptable arg1) throws ExecutionException {
            URI libraryUri = this.library.uri;
            ResourceSet resourceSet = Util.getResourceSet((EObject)contextClassifier);
            Resource libraryResource = resourceSet.getResource(libraryUri, true);
            Package libraryObject = (Package)libraryResource.getContents().get(0);
            this.model.createPackageImport(libraryObject);
            return CommandResult.newOKCommandResult((Object)this.model);
        }

        public UpdateImportCommand(Model model, RegisteredLibrary library) {
            super(UpdateImportCommand.getTransactionalEditingDomain(model), "Model Update", UpdateImportCommand.getWorkspaceFiles((EObject)model));
            this.model = model;
            this.library = library;
        }

        private static TransactionalEditingDomain getTransactionalEditingDomain(Model model) {
            try {
                return ServiceUtilsForEObject.getInstance().getTransactionalEditingDomain((Object)model);
            }
            catch (ServiceException ex) {
                ex.printStackTrace(System.err);
                return null;
            }
        }
    }
}

