/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.commands.handler;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.core.utils.ServiceUtilsForActionHandlers;
import org.eclipse.papyrus.infra.emf.utils.BusinessModelResolver;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForHandlers;
import org.eclipse.papyrus.uml.commands.Activator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEMFCommandHandler
extends AbstractHandler {
    protected TransactionalEditingDomain getEditingDomain() {
        TransactionalEditingDomain editingDomain = null;
        try {
            editingDomain = ServiceUtilsForActionHandlers.getInstance().getTransactionalEditingDomain();
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return editingDomain;
    }

    protected abstract Command getCommand(ServicesRegistry var1);

    protected EObject getSelectedElement() {
        EObject eObject = null;
        Object selection = null;
        selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            selection = structuredSelection.getFirstElement();
        }
        if (selection != null) {
            Object businessObject;
            if (selection instanceof IAdaptable) {
                selection = ((IAdaptable)selection).getAdapter(EObject.class);
            }
            if ((businessObject = BusinessModelResolver.getInstance().getBusinessModel(selection)) instanceof EObject) {
                eObject = (EObject)businessObject;
            }
        }
        return eObject;
    }

    protected List<EObject> getSelectedElements() {
        EObject eobject;
        ArrayList<EObject> selectedEObjects = new ArrayList<EObject>();
        RunnableWithResult.Impl<ISelection> runnable = new RunnableWithResult.Impl<ISelection>(){

            public void run() {
                this.setResult(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection());
            }
        };
        Display.getDefault().syncExec((Runnable)runnable);
        ISelection selection = (ISelection)runnable.getResult();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object[] objectArray = structuredSelection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                EObject eobject2;
                Object current = objectArray[n2];
                if (current instanceof IAdaptable && (eobject2 = (EObject)((IAdaptable)current).getAdapter(EObject.class)) != null) {
                    selectedEObjects.add(eobject2);
                }
                ++n2;
            }
        } else if (selection != null && selection instanceof IAdaptable && (eobject = (EObject)((IAdaptable)selection).getAdapter(EObject.class)) != null) {
            selectedEObjects.add(eobject);
        }
        return selectedEObjects;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            ServicesRegistry registry = ServiceUtilsForHandlers.getInstance().getServiceRegistry(event);
            Command emfCommand = this.getCommand(registry);
            ServiceUtils.getInstance().getTransactionalEditingDomain((Object)registry).getCommandStack().execute(emfCommand);
            return emfCommand.getResult();
        }
        catch (ServiceException e) {
            Activator.log.error("Unexpected error while executing command.", (Throwable)e);
            return null;
        }
    }

    public boolean isEnabled() {
        return this.getCommand(this.getServicesRegistryFromSelection()).canExecute();
    }

    protected ServicesRegistry getServicesRegistryFromSelection() {
        for (EObject selectedElement : this.getSelectedElements()) {
            try {
                ServicesRegistry registry = ServiceUtilsForEObject.getInstance().getServiceRegistry(selectedElement);
                if (registry == null) continue;
                return registry;
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean isVisible() {
        return this.getCommand(this.getServicesRegistryFromSelection()).canExecute();
    }
}

