/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.commands.handler;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.views.modelexplorer.handler.AbstractCommandHandler;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.NamedElement;

public class RenameNamedElementHandler
extends AbstractCommandHandler {
    protected Command getCommand() {
        NamedElement namedElement;
        String currentName;
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        List selectedElements = this.getSelectedElements();
        if (selectedElements.size() == 1 && selectedElements.get(0) instanceof NamedElement && (currentName = (namedElement = (NamedElement)selectedElements.get(0)).getName()) != null) {
            AbstractTransactionalCommand cmd = new AbstractTransactionalCommand(editingDomain, "RenameCommand", null){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), "Rename...", "New name:", currentName, null);
                    if (dialog.open() == 0) {
                        String name = dialog.getValue();
                        if (name != null && name.length() > 0) {
                            namedElement.setName(name);
                        }
                        return CommandResult.newOKCommandResult();
                    }
                    return CommandResult.newCancelledCommandResult();
                }
            };
            return new GMFtoEMFCommandWrapper((ICommand)cmd);
        }
        return null;
    }

    protected boolean computeEnabled() {
        boolean enabled = super.computeEnabled();
        if (enabled) {
            List selectedElements = this.getSelectedElements();
            EObject selection = (EObject)selectedElements.get(0);
            enabled = !EMFHelper.isReadOnly((EObject)selection);
        }
        return enabled;
    }
}

