/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.handlers;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.commands.DestroyElementPapyrusCommand;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.Type;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.NotificationBuilder;
import org.eclipse.papyrus.uml.diagram.activity.commands.CreatePinToParameterLinkEAnnotation;
import org.eclipse.papyrus.uml.diagram.activity.handlers.AbstractSynchronizePinsAndParameters;
import org.eclipse.papyrus.uml.diagram.activity.helper.PinAndParameterSynchronizer;
import org.eclipse.papyrus.uml.diagram.activity.helper.datastructure.LinkPinToParameter;
import org.eclipse.papyrus.uml.diagram.activity.providers.UMLMarkerNavigationProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.uml2.uml.Action;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BroadcastSignalAction;
import org.eclipse.uml2.uml.CallAction;
import org.eclipse.uml2.uml.CallBehaviorAction;
import org.eclipse.uml2.uml.CallOperationAction;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InputPin;
import org.eclipse.uml2.uml.InvocationAction;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.OutputPin;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.Pin;
import org.eclipse.uml2.uml.SendSignalAction;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.edit.providers.UMLItemProviderAdapterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizePinsParametersHandler
extends AbstractSynchronizePinsAndParameters {
    private static final String SYNCHRONIZE_PINS_AND_PARAMETERS = "Synchronize pins and parameters";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        if (selection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            Object obj = structuredSelection.getFirstElement();
            EObject element = null;
            if (obj instanceof IAdaptable) {
                element = (EObject)((IAdaptable)obj).getAdapter(EObject.class);
                if (element instanceof View) {
                    element = ((View)element).getElement();
                }
                if (element instanceof InvocationAction) {
                    SynchronizePinsParametersHandler.syncInvocationAction((InvocationAction)element);
                }
            }
        }
        return null;
    }

    public static void syncInvocationAction(InvocationAction invocationAction) {
        if (!SynchronizePinsParametersHandler.isAccessible(invocationAction)) {
            SynchronizePinsParametersHandler.createNotification(SYNCHRONIZE_PINS_AND_PARAMETERS, "Unable to synchronize pins on " + invocationAction.getQualifiedName() + " : the ressource is unreachable", Type.WARNING);
            return;
        }
        SynchronizePinsParametersHandler.matchPinsAndParams(invocationAction);
        if (SynchronizePinsParametersHandler.isUpToDate(invocationAction)) {
            SynchronizePinsParametersHandler.createNotification(SYNCHRONIZE_PINS_AND_PARAMETERS, "The call action " + invocationAction.getQualifiedName() + " is up to date", Type.INFO);
        } else {
            SynchronizePinsParametersHandler.syncCallActionWhenOutdated(invocationAction);
        }
        SynchronizePinsParametersHandler.renamePins(invocationAction);
    }

    private static void renamePins(final InvocationAction invocationAction) {
        AbstractTransactionalCommand renamePinsCommand = new AbstractTransactionalCommand(EditorUtils.getTransactionalEditingDomain(), "renaming pins", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                Iterable allPins = Lists.newArrayList((Iterable)invocationAction.getArguments());
                if (invocationAction instanceof CallAction) {
                    allPins = Iterables.concat((Iterable)((CallAction)invocationAction).getResults(), (Iterable)allPins);
                }
                Behavior behaviorStructural = null;
                if (invocationAction instanceof CallBehaviorAction) {
                    behaviorStructural = ((CallBehaviorAction)invocationAction).getBehavior();
                } else if (invocationAction instanceof CallOperationAction) {
                    behaviorStructural = ((CallOperationAction)invocationAction).getOperation();
                } else if (invocationAction instanceof SendSignalAction) {
                    behaviorStructural = ((SendSignalAction)invocationAction).getSignal();
                } else if (invocationAction instanceof BroadcastSignalAction) {
                    behaviorStructural = ((BroadcastSignalAction)invocationAction).getSignal();
                }
                XMIResource xmiResource = PinAndParameterSynchronizer.getXMIResource((Element)behaviorStructural);
                for (Pin pin : allPins) {
                    TypedElement typedElement = PinAndParameterSynchronizer.getLinkedParemeter(pin, xmiResource);
                    if (typedElement == null) continue;
                    String paramName = typedElement.getName();
                    pin.setName(paramName);
                }
                return CommandResult.newOKCommandResult();
            }
        };
        SynchronizePinsParametersHandler.executeCommand((Command)new GMFtoEMFCommandWrapper((ICommand)renamePinsCommand), (EObject)invocationAction);
    }

    private static void matchPinsAndParams(InvocationAction invocationAction) {
        ArrayList inputPins = Lists.newArrayList((Iterable)invocationAction.getArguments());
        EList outputPins = null;
        if (outputPins instanceof CallAction) {
            CallAction callAction = (CallAction)outputPins;
            outputPins = callAction.getResults();
        } else {
            outputPins = Collections.emptyList();
        }
        CompoundCommand linkingPinsAndParamsCommand = new CompoundCommand();
        if (invocationAction instanceof CallAction) {
            CallAction callAction = (CallAction)invocationAction;
            List<Parameter> callActionParams = SynchronizePinsParametersHandler.getParametersFromCallAction(callAction);
            HashMap<Integer, TypedElement> inputParameters = new HashMap<Integer, TypedElement>();
            HashMap<Integer, TypedElement> outputParameters = new HashMap<Integer, TypedElement>();
            PinAndParameterSynchronizer.splitParameters(callActionParams, Lists.newArrayList(), inputParameters, outputParameters, (Action)invocationAction);
            SynchronizePinsParametersHandler.matchPinsAndParams(inputPins, inputParameters, linkingPinsAndParamsCommand);
            SynchronizePinsParametersHandler.matchPinsAndParams((List<? extends Pin>)outputPins, outputParameters, linkingPinsAndParamsCommand);
        } else if (invocationAction instanceof InvocationAction) {
            Map<Integer, TypedElement> invocationActionProperties = SynchronizePinsParametersHandler.getPropertyFromInvocationAction(invocationAction);
            SynchronizePinsParametersHandler.matchPinsAndParams(inputPins, invocationActionProperties, linkingPinsAndParamsCommand);
        }
        SynchronizePinsParametersHandler.executeCommand((Command)linkingPinsAndParamsCommand, (EObject)invocationAction);
    }

    private static void matchPinsAndParams(List<? extends Pin> pins, Map<Integer, ? extends TypedElement> parameters, CompoundCommand globalCmd) {
        int pinIndex = 0;
        while (pinIndex < pins.size()) {
            Pin pin = pins.get(pinIndex);
            if (SynchronizePinsParametersHandler.lacksPinToParameterLink(pin)) {
                TypedElement paramWithSameIndex = parameters.get(pinIndex);
                boolean foundMatchingParam = false;
                if (paramWithSameIndex != null && pin.getType() == paramWithSameIndex.getType()) {
                    LinkPinToParameter link = new LinkPinToParameter(pin, paramWithSameIndex);
                    CreatePinToParameterLinkEAnnotation linkCommand = new CreatePinToParameterLinkEAnnotation(EditorUtils.getTransactionalEditingDomain(), link);
                    if (linkCommand != null) {
                        globalCmd.append((Command)linkCommand);
                        foundMatchingParam = true;
                    }
                    SynchronizePinsParametersHandler.createNotification(SYNCHRONIZE_PINS_AND_PARAMETERS, "The pin " + pin.getQualifiedName() + " " + "has been linked to the parameter " + paramWithSameIndex.getQualifiedName(), Type.INFO);
                }
                if (!foundMatchingParam) {
                    SynchronizePinsParametersHandler.createNotification(SYNCHRONIZE_PINS_AND_PARAMETERS, "The pin " + pin.getQualifiedName() + " will be deleted, along with its edges", Type.WARNING);
                }
            }
            ++pinIndex;
        }
    }

    private static boolean lacksPinToParameterLink(Pin pin) {
        return pin.getEAnnotation("PinToParameterLink") == null;
    }

    private static List<Parameter> getParametersFromCallAction(CallAction callAction) {
        Operation operation;
        ArrayList result = Lists.newArrayList();
        if (callAction instanceof CallBehaviorAction) {
            Behavior behavior = ((CallBehaviorAction)callAction).getBehavior();
            if (behavior != null) {
                result = behavior.getOwnedParameters();
            }
        } else if (callAction instanceof CallOperationAction && (operation = ((CallOperationAction)callAction).getOperation()) != null) {
            result = operation.getOwnedParameters();
        }
        return result;
    }

    private static Map<Integer, TypedElement> getPropertyFromInvocationAction(InvocationAction invocationAction) {
        HashMap result;
        block4: {
            Signal signal;
            block3: {
                result = Maps.newHashMap();
                if (!(invocationAction instanceof SendSignalAction)) break block3;
                Signal signal2 = ((SendSignalAction)invocationAction).getSignal();
                if (signal2 == null) break block4;
                EList properties = signal2.getOwnedAttributes();
                int index = 0;
                while (index < properties.size()) {
                    result.put(index, (TypedElement)properties.get(index));
                    ++index;
                }
                break block4;
            }
            if (invocationAction instanceof BroadcastSignalAction && (signal = ((BroadcastSignalAction)invocationAction).getSignal()) != null) {
                EList properties = signal.getOwnedAttributes();
                int index = 0;
                while (index < properties.size()) {
                    result.put(index, (TypedElement)properties.get(index));
                    ++index;
                }
            }
        }
        return result;
    }

    private static void syncCallActionWhenOutdated(InvocationAction invocationAction) {
        CompoundCommand cmd = null;
        if (invocationAction instanceof CallAction) {
            cmd = PinAndParameterSynchronizer.getResetPinsCmd(invocationAction);
        } else if (invocationAction instanceof SendSignalAction) {
            cmd = PinAndParameterSynchronizer.getResetPinsCmd(invocationAction);
        } else if (invocationAction instanceof BroadcastSignalAction) {
            cmd = PinAndParameterSynchronizer.getResetPinsCmd(invocationAction);
        }
        Behavior behaviorStructural = null;
        if (invocationAction instanceof CallBehaviorAction) {
            behaviorStructural = ((CallBehaviorAction)invocationAction).getBehavior();
        } else if (invocationAction instanceof CallOperationAction) {
            behaviorStructural = ((CallOperationAction)invocationAction).getOperation();
        } else if (invocationAction instanceof SendSignalAction) {
            behaviorStructural = ((SendSignalAction)invocationAction).getSignal();
        } else if (invocationAction instanceof BroadcastSignalAction) {
            behaviorStructural = ((BroadcastSignalAction)invocationAction).getSignal();
        }
        XMIResource xmiResource = PinAndParameterSynchronizer.getXMIResource((Element)behaviorStructural);
        if (!cmd.isEmpty() && cmd.canExecute()) {
            Iterable<Object> outgoing = Collections.emptyList();
            Iterable<Object> incoming = Collections.emptyList();
            if (invocationAction instanceof CallAction) {
                for (Pin p : ((CallAction)invocationAction).getResults()) {
                    if (SynchronizePinsParametersHandler.isUpToDate(p, xmiResource)) continue;
                    outgoing = Iterables.concat(outgoing, (Iterable)p.getOutgoings());
                }
            }
            for (Pin p : invocationAction.getArguments()) {
                if (SynchronizePinsParametersHandler.isUpToDate(p, xmiResource)) continue;
                incoming = Iterables.concat(incoming, (Iterable)p.getIncomings());
            }
            HashSet newHashSet = Sets.newHashSet((Iterable)Iterables.concat(outgoing, incoming));
            DeleteActivityEdgeDialog dialog = new DeleteActivityEdgeDialog(new Shell(), newHashSet, invocationAction);
            if (dialog.open() == 0) {
                IFile target = invocationAction.eResource() != null ? WorkspaceSynchronizer.getFile((Resource)invocationAction.eResource()) : null;
                for (ActivityEdge activityEdge : dialog.getEgdesToDelete()) {
                    DestroyElementPapyrusCommand detryCmd;
                    EditingDomain editingDomain;
                    if (!newHashSet.isEmpty()) {
                        UMLItemProviderAdapterFactory umlAdapterFactory = new UMLItemProviderAdapterFactory();
                        IItemLabelProvider edgeLabelProvider = (IItemLabelProvider)umlAdapterFactory.adapt((Notifier)activityEdge, IItemLabelProvider.class);
                        IItemLabelProvider callActionLabelProvider = (IItemLabelProvider)umlAdapterFactory.adapt((Notifier)invocationAction, IItemLabelProvider.class);
                        UMLMarkerNavigationProvider.addMarker(target, activityEdge.eResource().getURIFragment((EObject)activityEdge), EMFCoreUtil.getQualifiedName((EObject)invocationAction, (boolean)true), "The edge " + edgeLabelProvider.getText((Object)activityEdge) + " has been deleted since " + callActionLabelProvider.getText((Object)invocationAction) + " has been synchronized", 2);
                    }
                    if (!((editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)activityEdge)) instanceof TransactionalEditingDomain) || (detryCmd = new DestroyElementPapyrusCommand(new DestroyElementRequest((EObject)activityEdge, false))) == null || !detryCmd.canExecute()) continue;
                    ((TransactionalEditingDomain)editingDomain).getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)detryCmd));
                }
                SynchronizePinsParametersHandler.executeCommand((Command)cmd, (EObject)invocationAction);
                SynchronizePinsParametersHandler.createNotification(SYNCHRONIZE_PINS_AND_PARAMETERS, "The call action " + invocationAction.getQualifiedName() + " has been synchronized", Type.INFO);
            }
        }
    }

    public static void createNotification(String title, String text, Type type) {
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.papyrus.infra.widgets.toolbox.notification.view.PapyrusNotificationView");
        }
        catch (PartInitException partInitException) {
            // empty catch block
        }
        new NotificationBuilder().setAsynchronous(true).setTemporary(false).setTitle(title).setMessage(text).setType(type).run();
    }

    private static boolean isUpToDate(InvocationAction invocationAction) {
        TypedElement pa;
        Signal signal;
        ArrayList typedElementArgument = null;
        ArrayList invocationActionArguments = Lists.newArrayList((Iterable)invocationAction.getArguments());
        ArrayList callActionResult = Lists.newArrayList();
        if (invocationAction instanceof CallAction) {
            callActionResult.addAll(((CallAction)invocationAction).getResults());
        }
        XMIResource xmiResource = null;
        if (invocationAction instanceof CallOperationAction) {
            CallOperationAction callOperationAction = (CallOperationAction)invocationAction;
            Operation operation = callOperationAction.getOperation();
            if (operation != null) {
                xmiResource = PinAndParameterSynchronizer.getXMIResource((Element)operation);
                typedElementArgument = Lists.newArrayList(SynchronizePinsParametersHandler.transformeToTypedElementIterable((Iterable<? extends EObject>)callOperationAction.getOperation().getOwnedParameters()));
            }
        } else if (invocationAction instanceof CallBehaviorAction) {
            CallBehaviorAction callBehaviorAction = (CallBehaviorAction)invocationAction;
            Behavior behavior = callBehaviorAction.getBehavior();
            if (behavior != null) {
                xmiResource = PinAndParameterSynchronizer.getXMIResource((Element)behavior);
                typedElementArgument = Lists.newArrayList(SynchronizePinsParametersHandler.transformeToTypedElementIterable((Iterable<? extends EObject>)behavior.getOwnedParameters()));
            }
        } else if (invocationAction instanceof SendSignalAction) {
            signal = ((SendSignalAction)invocationAction).getSignal();
            if (signal != null) {
                xmiResource = PinAndParameterSynchronizer.getXMIResource((Element)signal);
                typedElementArgument = Lists.newArrayList(SynchronizePinsParametersHandler.transformeToTypedElementIterable((Iterable<? extends EObject>)signal.getOwnedAttributes()));
            }
        } else if (invocationAction instanceof BroadcastSignalAction && (signal = ((BroadcastSignalAction)invocationAction).getSignal()) != null) {
            xmiResource = PinAndParameterSynchronizer.getXMIResource((Element)signal);
            typedElementArgument = Lists.newArrayList(SynchronizePinsParametersHandler.transformeToTypedElementIterable((Iterable<? extends EObject>)signal.getOwnedAttributes()));
        }
        if (typedElementArgument == null) {
            return true;
        }
        final HashSet<TypedElement> typedElementArgumentFound = new HashSet<TypedElement>();
        for (InputPin p : invocationActionArguments) {
            if (!SynchronizePinsParametersHandler.isUpToDate((Pin)p, xmiResource)) {
                return false;
            }
            pa = PinAndParameterSynchronizer.getLinkedParemeter((Pin)p, xmiResource);
            typedElementArgumentFound.add(pa);
        }
        for (InputPin p : callActionResult) {
            if (!SynchronizePinsParametersHandler.isUpToDate((Pin)p, xmiResource)) {
                return false;
            }
            pa = PinAndParameterSynchronizer.getLinkedParemeter((Pin)p, xmiResource);
            typedElementArgumentFound.add(pa);
        }
        Iterable intersectionBetweenPinParamsAndAllParams = Iterables.filter((Iterable)typedElementArgument, (Predicate)new Predicate<TypedElement>(){

            public boolean apply(TypedElement input) {
                return !typedElementArgumentFound.contains(input);
            }
        });
        return Iterables.size((Iterable)intersectionBetweenPinParamsAndAllParams) == 0;
    }

    private static Iterable<TypedElement> transformeToTypedElementIterable(Iterable<? extends EObject> input) {
        Iterable typedElements = Iterables.transform(input, (Function)new Function<EObject, TypedElement>(){

            public TypedElement apply(EObject from) {
                if (from instanceof TypedElement) {
                    return (TypedElement)from;
                }
                return null;
            }
        });
        return Iterables.filter((Iterable)typedElements, (Predicate)Predicates.notNull());
    }

    public static boolean isUpToDate(Pin pin, XMIResource xmiResource) {
        boolean result = false;
        TypedElement typedElement = PinAndParameterSynchronizer.getLinkedParemeter(pin, xmiResource);
        if (typedElement != null) {
            if (pin.getType() != null) {
                result = pin.getType().isCompatibleWith((ParameterableElement)typedElement.getType());
            } else {
                boolean bl = result = pin.getType() == typedElement.getType();
            }
            if (typedElement instanceof Parameter) {
                Parameter pa = (Parameter)typedElement;
                if (pin instanceof OutputPin) {
                    boolean directionIsOut = pa.getDirection().getValue() == 2;
                    directionIsOut |= pa.getDirection().getValue() == 1;
                    result &= (directionIsOut |= pa.getDirection().getValue() == 3);
                } else if (pin instanceof InputPin) {
                    boolean directionIsIn = pa.getDirection().getValue() == 0;
                    result &= (directionIsIn |= pa.getDirection().getValue() == 1);
                }
            }
        }
        return result;
    }

    public static boolean isAccessible(InvocationAction callAction) {
        boolean result = false;
        Behavior targetedBehavior = null;
        if (callAction instanceof CallBehaviorAction) {
            CallBehaviorAction cba = (CallBehaviorAction)callAction;
            targetedBehavior = cba.getBehavior();
        } else if (callAction instanceof CallOperationAction) {
            targetedBehavior = ((CallOperationAction)callAction).getOperation();
        } else if (callAction instanceof SendSignalAction) {
            targetedBehavior = ((SendSignalAction)callAction).getSignal();
        } else if (callAction instanceof BroadcastSignalAction) {
            targetedBehavior = ((BroadcastSignalAction)callAction).getSignal();
        }
        if (targetedBehavior != null) {
            result = !targetedBehavior.eIsProxy();
        }
        return result;
    }

    protected static void executeCommand(Command cmd, EObject eObject) {
        if (cmd != null && cmd.canExecute()) {
            Map<String, Boolean> options = null;
            options = Collections.singletonMap("no_validation", Boolean.TRUE);
            EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)eObject);
            if (editingDomain instanceof TransactionalEditingDomain) {
                TransactionalEditingDomain d = (TransactionalEditingDomain)editingDomain;
                try {
                    if (d.getCommandStack() instanceof TransactionalCommandStack) {
                        TransactionalCommandStack comStack = (TransactionalCommandStack)d.getCommandStack();
                        comStack.execute(cmd, options);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (RollbackException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected static List<IGraphicalEditPart> getIGraphicalPartSelection() {
        ArrayList<IGraphicalEditPart> viewSelected = new ArrayList<IGraphicalEditPart>();
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return Collections.emptyList();
        }
        for (Object object : ((IStructuredSelection)selection).toList()) {
            if (!(object instanceof IGraphicalEditPart) || object instanceof DiagramEditPart) continue;
            viewSelected.add((IGraphicalEditPart)object);
        }
        return viewSelected;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteActivityEdgeDialog
    extends MessageDialog {
        private Iterable<ActivityEdge> egdes;
        private InvocationAction callAction;

        public DeleteActivityEdgeDialog(Shell parentShell, Iterable<ActivityEdge> egdes, InvocationAction callAction) {
            super(parentShell, SynchronizePinsParametersHandler.SYNCHRONIZE_PINS_AND_PARAMETERS, SynchronizePinsParametersHandler.getIcon(), "", 4, new String[]{"Synchronize", "Cancel"}, 0);
            this.egdes = egdes;
            this.callAction = callAction;
            this.message = this.getEdgeListString();
        }

        private String getEdgeListString() {
            UMLItemProviderAdapterFactory t = new UMLItemProviderAdapterFactory();
            IItemLabelProvider provider = (IItemLabelProvider)t.adapt((Notifier)this.callAction, IItemLabelProvider.class);
            StringBuilder builder = new StringBuilder("If you synchronize " + provider.getText((Object)this.callAction) + " the following edges will be deleted : \n ");
            for (ActivityEdge e : this.egdes) {
                provider = (IItemLabelProvider)t.adapt((Notifier)e, IItemLabelProvider.class);
                builder.append(provider.getText((Object)e)).append(" \n");
            }
            return builder.toString();
        }

        public int open() {
            if (this.egdes.iterator().hasNext()) {
                return super.open();
            }
            return 0;
        }

        public Iterable<ActivityEdge> getEgdesToDelete() {
            return this.egdes;
        }
    }
}

