/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.listeners;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.papyrus.commands.wrappers.EMFtoGMFCommandWrapper;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.Type;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.NotificationBuilder;
import org.eclipse.papyrus.uml.diagram.activity.helper.UMLValidationHelper;
import org.eclipse.papyrus.uml.diagram.common.listeners.AbstractPapyrusModifcationTriggerListener;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InInterruptibleActivityRegionListener
extends AbstractPapyrusModifcationTriggerListener {
    private static NotificationFilter FEATURE_FILTER = null;

    public static NotificationFilter getFEATURE_FILTER() {
        if (FEATURE_FILTER == null) {
            FEATURE_FILTER = NotificationFilter.createFeatureFilter((EStructuralFeature)UMLPackage.Literals.ACTIVITY_NODE__IN_INTERRUPTIBLE_REGION);
        }
        return FEATURE_FILTER;
    }

    protected ActivityNode getElement(Notification notif) {
        try {
            return (ActivityNode)notif.getNotifier();
        }
        catch (ClassCastException e) {
            throw new RuntimeException("InInterruptibleActivityRegionListener should only be notified by ActivityNode");
        }
    }

    public Iterator<Iterable<ActivityEdge>> getActivityEdgeImpactedWithThisChange(ActivityNode node) {
        Iterator activityEdges = Iterators.transform((Iterator)Iterators.concat(Collections.singleton(node).iterator(), (Iterator)node.eAllContents()), (Function)new Function<EObject, Iterable<ActivityEdge>>(){

            public Iterable<ActivityEdge> apply(EObject from) {
                if (from instanceof ActivityNode) {
                    ActivityNode activityNode = (ActivityNode)from;
                    Iterable incomingInterruptibleEdge = Iterables.filter((Iterable)activityNode.getIncomings(), (Predicate)new Predicate<EObject>(){

                        public boolean apply(EObject input) {
                            if (input instanceof ActivityEdge) {
                                return ((ActivityEdge)input).getInterrupts() != null;
                            }
                            return false;
                        }
                    });
                    Iterable outcomingEdgeInterruptibleEdge = Iterables.filter((Iterable)activityNode.getOutgoings(), (Predicate)new Predicate<EObject>(){

                        public boolean apply(EObject input) {
                            if (input instanceof ActivityEdge) {
                                return ((ActivityEdge)input).getInterrupts() != null;
                            }
                            return false;
                        }
                    });
                    Iterable allInterruptibleEdge = Iterables.concat((Iterable)outcomingEdgeInterruptibleEdge, (Iterable)incomingInterruptibleEdge);
                    if (!Iterables.isEmpty((Iterable)allInterruptibleEdge)) {
                        return allInterruptibleEdge;
                    }
                }
                return null;
            }
        });
        return activityEdges;
    }

    public NotificationFilter getFilter() {
        return InInterruptibleActivityRegionListener.getFEATURE_FILTER();
    }

    protected ICommand getModificationCommand(Notification notif) {
        ActivityNode node = this.getElement(notif);
        Iterator<Iterable<ActivityEdge>> activityEdges = this.getActivityEdgeImpactedWithThisChange(node);
        while (activityEdges.hasNext()) {
            Iterable<ActivityEdge> interruptibleEdge = activityEdges.next();
            if (interruptibleEdge == null) continue;
            for (ActivityEdge interrpEdge : interruptibleEdge) {
                if (UMLValidationHelper.validateInterruptibleEdge(interrpEdge, interrpEdge.getInterrupts())) continue;
                NotificationBuilder popup = new NotificationBuilder().setAsynchronous(true).setTemporary(true).setMessage("The Activity Edge " + interrpEdge.getName() + " can not interrupt its referencing region because it violates a constraint").setType(Type.INFO);
                popup.run();
                return new EMFtoGMFCommandWrapper((Command)new SetCommand((EditingDomain)this.getDiagramEditPart().getEditingDomain(), (EObject)interrpEdge, (EStructuralFeature)UMLPackage.Literals.ACTIVITY_EDGE__INTERRUPTS, null));
            }
        }
        return null;
    }

    protected DiagramEditPart getDiagramEditPart() {
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchPage page = wb.getActiveWorkbenchWindow().getActivePage();
        IEditorPart editor = page.getActiveEditor();
        if (editor instanceof IMultiDiagramEditor) {
            IMultiDiagramEditor papyrusEditor = (IMultiDiagramEditor)editor;
            return (DiagramEditPart)papyrusEditor.getAdapter(DiagramEditPart.class);
        }
        return null;
    }
}

