/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.listeners;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.uml.diagram.activity.edit.part.interfaces.InterruptibleEdge;
import org.eclipse.papyrus.uml.diagram.activity.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.activity.request.InterruptibleEdgeRequest;
import org.eclipse.papyrus.uml.diagram.common.listeners.AbstractPapyrusModifcationTriggerListener;
import org.eclipse.papyrus.uml.diagram.common.util.DiagramEditPartsUtil;
import org.eclipse.papyrus.uml.diagram.common.util.functions.EObjectToViewFunction;
import org.eclipse.papyrus.uml.diagram.common.util.functions.SettingToEObjectFunction;
import org.eclipse.papyrus.uml.diagram.common.util.predicates.ReferencingViewPredicate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterruptibleEdgeListener
extends AbstractPapyrusModifcationTriggerListener {
    private static ImmutableBiMap<EClass, String> INTERRUPTIBLE_EDGE_ICON_VISUAL_ID_COLLECTION = ImmutableBiMap.of((Object)UMLPackage.Literals.OBJECT_FLOW, (Object)String.valueOf(6014), (Object)UMLPackage.Literals.CONTROL_FLOW, (Object)String.valueOf(6013));
    private static NotificationFilter FEATURE_FILTER = null;

    public static NotificationFilter getFEATURE_FILTER() {
        if (FEATURE_FILTER == null) {
            FEATURE_FILTER = NotificationFilter.createFeatureFilter((EStructuralFeature)UMLPackage.Literals.ACTIVITY_EDGE__INTERRUPTS);
        }
        return FEATURE_FILTER;
    }

    protected DiagramEditPart getDiagramEditPart() {
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchPage page = wb.getActiveWorkbenchWindow().getActivePage();
        IEditorPart editor = page.getActiveEditor();
        if (editor instanceof IMultiDiagramEditor) {
            IMultiDiagramEditor papyrusEditor = (IMultiDiagramEditor)editor;
            return (DiagramEditPart)papyrusEditor.getAdapter(DiagramEditPart.class);
        }
        return null;
    }

    protected ICommand getModificationCommand(Notification notif) {
        if (1 == notif.getEventType()) {
            String visualID;
            CompositeCommand cc = new CompositeCommand("Interruptible Edge Command");
            Iterable edgesEditPart = DiagramEditPartsUtil.getChildrenByEObject((EObject)((EObject)notif.getNotifier()), (IGraphicalEditPart)this.getDiagramEditPart(), (boolean)true);
            InterruptibleEdgeRequest request = new InterruptibleEdgeRequest();
            Iterable<View> views = this.getReferencingView(notif);
            if (notif.getNewValue() != null) {
                request.setType(InterruptibleEdgeRequest.SET_INTERRUPTIBLE_EDGE);
                for (View view : views) {
                    try {
                        visualID = (String)INTERRUPTIBLE_EDGE_ICON_VISUAL_ID_COLLECTION.get((Object)view.getElement().eClass());
                        ICommand createViewCommand = this.createInterruptibleEdgeIcon(view, visualID);
                        if (createViewCommand == null || !createViewCommand.canExecute()) continue;
                        cc.compose((IUndoableOperation)createViewCommand);
                    }
                    catch (NullPointerException e) {
                        throw new RuntimeException("Unable to find the Visual ID of the Icon of the interruptible Edge for element" + view.getElement());
                    }
                }
            } else {
                request.setType(InterruptibleEdgeRequest.UNSET_INTERRUPTIBLE_EDGE);
                for (View view : views) {
                    try {
                        visualID = (String)INTERRUPTIBLE_EDGE_ICON_VISUAL_ID_COLLECTION.get((Object)view.getElement().eClass());
                        ICommand destroyCommand = this.destroyInterruptibleIcon(view, visualID);
                        if (destroyCommand == null || !destroyCommand.canExecute()) continue;
                        cc.compose((IUndoableOperation)destroyCommand);
                    }
                    catch (NullPointerException e) {
                        throw new RuntimeException("Unable to find the Visual ID of the Icon of the interruptible Edge for element" + view.getElement());
                    }
                }
            }
            for (IGraphicalEditPart edgeEditPart : edgesEditPart) {
                Command command;
                if (edgeEditPart == null || !(edgeEditPart instanceof InterruptibleEdge) || !(edgeEditPart.getModel() instanceof View) || (command = edgeEditPart.getCommand((Request)request)) == null || !command.canExecute()) continue;
                cc.compose((IUndoableOperation)new CommandProxy(command));
            }
            return cc;
        }
        return null;
    }

    public Iterable<View> getReferencingView(Notification notif) {
        ActivityEdge element = this.getElement(notif);
        Resource eResource = element.eResource();
        if (eResource != null) {
            ECrossReferenceAdapter adapter = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)eResource.getResourceSet());
            if (adapter == null) {
                adapter = new ECrossReferenceAdapter();
            }
            Collection inverseReferences = adapter.getInverseReferences((EObject)element);
            Iterable settings = Iterables.transform((Iterable)inverseReferences, (Function)new SettingToEObjectFunction());
            Iterable eObjects = Iterables.filter((Iterable)settings, (Predicate)new ReferencingViewPredicate((EObject)element));
            Iterable views = Iterables.transform((Iterable)eObjects, (Function)new EObjectToViewFunction());
            return views;
        }
        return Collections.emptyList();
    }

    private TransactionalEditingDomain getEditingDomain(View model) {
        DiagramEditPart diagramEditPart = this.getDiagramEditPart();
        if (diagramEditPart != null) {
            return diagramEditPart.getEditingDomain();
        }
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)model);
        if (editingDomain instanceof TransactionalEditingDomain) {
            return (TransactionalEditingDomain)editingDomain;
        }
        return null;
    }

    private ICommand destroyInterruptibleIcon(final View model, final String visualID) {
        TransactionalEditingDomain editingDomain = this.getEditingDomain(model);
        if (editingDomain != null) {
            AbstractTransactionalCommand cmd = new AbstractTransactionalCommand(editingDomain, "Destroy Interruptible Edge Icon", null){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    if (model != null) {
                        View interruptibleEdgeIconView = ViewUtil.getChildBySemanticHint((View)model, (String)visualID);
                        ViewUtil.destroy((View)interruptibleEdgeIconView);
                        return CommandResult.newOKCommandResult();
                    }
                    return null;
                }
            };
            return cmd;
        }
        return null;
    }

    private ICommand createInterruptibleEdgeIcon(final View model, final String visualID) {
        TransactionalEditingDomain editingDomain = this.getEditingDomain(model);
        if (editingDomain != null) {
            AbstractTransactionalCommand cmd = new AbstractTransactionalCommand(editingDomain, "Create Interruptible Edge Icon", null){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    if (model != null) {
                        Node node = ViewService.createNode((View)model, (String)visualID, (PreferencesHint)UMLDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                        if (node != null) {
                            return CommandResult.newOKCommandResult((Object)node);
                        }
                        return CommandResult.newErrorCommandResult((String)"Unable to create the view for Interruptible Edge label");
                    }
                    return null;
                }

                protected IStatus doUndo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    IStatus status = super.doUndo(monitor, info);
                    InterruptibleEdgeListener.this.getDiagramEditPart().refresh();
                    return status;
                }

                protected IStatus doRedo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    IStatus status = super.doRedo(monitor, info);
                    InterruptibleEdgeListener.this.getDiagramEditPart().refresh();
                    return status;
                }
            };
            return cmd;
        }
        return null;
    }

    protected ActivityEdge getElement(Notification notif) {
        Object element = notif.getNotifier();
        if (element instanceof ActivityEdge) {
            return (ActivityEdge)element;
        }
        return null;
    }

    public NotificationFilter getFilter() {
        return InterruptibleEdgeListener.getFEATURE_FILTER();
    }
}

