/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.clazz.custom.command;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.clazz.edit.commands.ContextLinkCreateCommand;
import org.eclipse.uml2.common.util.CacheAdapter;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Namespace;

public class CustomContextLinkCreateCommand
extends ContextLinkCreateCommand {
    public CustomContextLinkCreateCommand(CreateRelationshipRequest request, EObject source, EObject target) {
        super(request, source, target);
    }

    public boolean canExecute() {
        if (this.source == null && this.target == null) {
            return false;
        }
        if (this.source != null && !(this.source instanceof Constraint)) {
            return false;
        }
        if (this.target != null && !(this.target instanceof Namespace)) {
            return false;
        }
        if (this.getSource() == null) {
            return true;
        }
        if (this.getSource() != null && this.getSource().getContext() != null && this.target != null && this.getSource().getContext() != this.target) {
            return false;
        }
        View viewSource = this.findView(this.source);
        if (viewSource != null && this.source instanceof Constraint) {
            View viewTarget = this.findView(this.target);
            List sourceConnections = ViewUtil.getSourceConnections((View)viewSource);
            for (Object connector : sourceConnections) {
                Edge edge;
                if (!(connector instanceof Connector) || !"8500".equals((edge = (Edge)connector).getType()) || viewTarget != edge.getTarget()) continue;
                return false;
            }
        }
        return this.getTarget() == null || !this.getTarget().getOwnedRules().contains((Object)this.getTarget());
    }

    private View findView(EObject element) {
        if (element == null) {
            return null;
        }
        Collection settings = CacheAdapter.getInstance().getNonNavigableInverseReferences(element);
        for (EStructuralFeature.Setting ref : settings) {
            View view;
            if (!NotationPackage.eINSTANCE.getView_Element().equals(ref.getEStructuralFeature()) || (view = (View)ref.getEObject()) == null) continue;
            return view;
        }
        return null;
    }
}

