/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.clazz.custom.helper.advice;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.common.util.CacheAdapter;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.UMLPackage;

public class ConstraintHelperAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getAfterSetCommand(SetRequest request) {
        EObject element = request.getElementToEdit();
        View view = this.findView(element);
        if (view != null && element instanceof Constraint) {
            EStructuralFeature feature = request.getFeature();
            Object value = request.getValue();
            Edge edgeToDestroy = null;
            Namespace targetContextElement = null;
            if (UMLPackage.eINSTANCE.getConstraint_Context().equals(feature)) {
                Namespace constraintContext = ((Constraint)element).getContext();
                if (constraintContext == value) {
                    return null;
                }
                targetContextElement = constraintContext;
                if (targetContextElement != null) {
                    View target = this.findView((EObject)targetContextElement);
                    List sourceConnections = ViewUtil.getSourceConnections((View)view);
                    for (Object connector : sourceConnections) {
                        Edge edge;
                        if (!(connector instanceof Connector) || !"8500".equals((edge = (Edge)connector).getType()) || target != edge.getTarget()) continue;
                        edgeToDestroy = edge;
                    }
                }
                if (edgeToDestroy != null) {
                    ICommand result;
                    TransactionalEditingDomain editingDomain = request.getEditingDomain();
                    CompositeCommand command = new CompositeCommand("Clear context links");
                    DestroyElementRequest destroy = new DestroyElementRequest(editingDomain, edgeToDestroy, false);
                    Object eHelperContext = destroy.getEditHelperContext();
                    IElementType context = ElementTypeRegistry.getInstance().getElementType(eHelperContext);
                    if (context != null && (result = context.getEditCommand((IEditCommandRequest)destroy)) != null) {
                        command.add((IUndoableOperation)result);
                    }
                    return command;
                }
            }
        }
        return null;
    }

    private View findView(EObject element) {
        if (element == null) {
            return null;
        }
        Collection settings = CacheAdapter.getInstance().getNonNavigableInverseReferences(element);
        for (EStructuralFeature.Setting ref : settings) {
            View view;
            if (!NotationPackage.eINSTANCE.getView_Element().equals(ref.getEStructuralFeature()) || (view = (View)ref.getEObject()) == null) continue;
            return view;
        }
        return null;
    }
}

