/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.helper.NamedElementHelper;
import org.eclipse.papyrus.uml.diagram.common.service.ApplyStereotypeRequest;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Stereotype;

public class ApplyStereotypeCommand
extends AbstractTransactionalCommand {
    protected ApplyStereotypeRequest req;

    public ApplyStereotypeCommand(TransactionalEditingDomain domain, ApplyStereotypeRequest req) {
        super(domain, "Apply stereotype", null);
        this.req = req;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        List<String> stereotypeQNames = this.req.getStereotypesToApply();
        Element element = this.req.getElement();
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (String stereotypeQName : stereotypeQNames) {
            Stereotype stereotype = element.getApplicableStereotype(stereotypeQName);
            if (stereotype == null) {
                Activator.log.warn("impossible to retrieve the stereotype " + stereotypeQName);
                continue;
            }
            result.add(element.applyStereotype(stereotype));
        }
        if (this.req.renameWithFirstStereotype() && element instanceof NamedElement && !stereotypeQNames.isEmpty()) {
            String stereotypeName = NamedElementUtil.getNameFromQualifiedName((String)stereotypeQNames.get(0));
            String name = NamedElementHelper.EINSTANCE.getNewUMLElementName(element.getOwner(), stereotypeName);
            ((NamedElement)element).setName(name);
        }
        if (result.size() > 1) {
            return CommandResult.newOKCommandResult(result);
        }
        if (result.size() == 1) {
            return CommandResult.newOKCommandResult(result.get(0));
        }
        return CommandResult.newOKCommandResult();
    }
}

