/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.Platform;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.papyrus.uml.diagram.common.providers.BaseViewInfoContentProvider;
import org.eclipse.papyrus.uml.diagram.common.providers.BaseViewInfoLabelProvider;
import org.eclipse.papyrus.uml.diagram.common.providers.ViewInfo;
import org.eclipse.papyrus.uml.diagram.common.util.MDTUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectDiagramViewsFilterDialog
extends Dialog {
    private DiagramEditPart diagram = null;
    private ViewInfo viewInfo = null;
    private TreeViewer treeViewer = null;
    private Collection<Integer> selected = null;
    protected boolean isChecking = false;

    public SelectDiagramViewsFilterDialog(IShellProvider parentShell, DiagramEditPart diagram) {
        super(parentShell);
        this.diagram = diagram;
    }

    public SelectDiagramViewsFilterDialog(Shell parentShell, DiagramEditPart diagram) {
        super(parentShell);
        this.diagram = diagram;
    }

    protected void okPressed() {
        this.buildSelected();
        super.okPressed();
    }

    public DiagramEditPart getDiagramEditPart() {
        return this.diagram;
    }

    public ViewInfo getViewInfo() {
        Object adapter;
        if (this.viewInfo == null && (adapter = this.getDiagramEditPart().getAdapter(ViewInfo.class)) instanceof ViewInfo) {
            this.viewInfo = (ViewInfo)adapter;
        }
        return this.viewInfo;
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public Collection<Integer> getSelected() {
        if (this.selected == null) {
            this.buildSelected();
        }
        return this.selected;
    }

    protected void buildSelected() {
        this.selected = new ArrayList<Integer>();
        if (this.getTreeViewer() == null || this.getTreeViewer().getTree() == null || this.getTreeViewer().getTree().getItems().length <= 0) {
            return;
        }
        TreeItem[] treeItemArray = this.getTreeViewer().getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object data;
            TreeItem item = treeItemArray[n2];
            if (!item.getChecked() && (data = item.getData()) instanceof ViewInfo) {
                this.selected.add(((ViewInfo)data).getVisualID());
            }
            this.addViewInfos(item, this.selected);
            ++n2;
        }
    }

    protected void addViewInfos(TreeItem root, Collection<Integer> infos) {
        TreeItem[] treeItemArray = root.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object data;
            TreeItem item = treeItemArray[n2];
            if (!item.getChecked() && (data = item.getData()) instanceof ViewInfo) {
                infos.add(((ViewInfo)data).getVisualID());
            }
            this.addViewInfos(item, infos);
            ++n2;
        }
    }

    protected Diagram getDiagram() {
        if (this.getDiagramEditPart() != null) {
            return (Diagram)this.getDiagramEditPart().getNotationView();
        }
        return null;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Select the views to filter");
        Composite composite = new Composite(parent, 0);
        GridData data = new GridData(768, 1040, true, true);
        data.widthHint = 600;
        data.heightHint = 400;
        composite.setLayoutData((Object)data);
        composite.setLayout((Layout)new GridLayout());
        this.treeViewer = new TreeViewer(composite, 2080);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new BaseViewInfoLabelProvider());
        this.treeViewer.setContentProvider((IContentProvider)new BaseViewInfoContentProvider());
        this.treeViewer.setInput((Object)this.getViewInfo());
        this.treeViewer.getTree().addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SelectDiagramViewsFilterDialog.this.treeItemSelected(e);
            }
        });
        data = new GridData(768, 1040, true, true);
        data.widthHint = 600;
        data.heightHint = 400;
        this.treeViewer.getTree().setLayoutData((Object)data);
        this.getTreeViewer().expandAll();
        this.populateTree();
        return composite;
    }

    protected void populateTree() {
        if (this.getTreeViewer() == null || this.getTreeViewer().getTree() == null || this.getViewInfo() == null || this.getDiagram() == null) {
            return;
        }
        Diagram diagram = this.getDiagram();
        Collection<Integer> filters = MDTUtil.getAllViewsToFilterFromDiagram(diagram);
        TreeItem[] treeItemArray = this.getTreeViewer().getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            Object data = item.getData();
            if (data instanceof ViewInfo) {
                ViewInfo info = (ViewInfo)data;
                if (filters.contains(info.getVisualID())) {
                    item.setChecked(false);
                } else {
                    item.setChecked(true);
                }
                if (!((ViewInfo)data).isSelectable()) {
                    item.setForeground(ColorConstants.gray);
                }
            }
            this.setChecked(item, filters);
            ++n2;
        }
    }

    protected void setChecked(TreeItem root, Collection<Integer> filters) {
        TreeItem[] treeItemArray = root.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            Object data = item.getData();
            if (data instanceof ViewInfo) {
                ViewInfo info = (ViewInfo)data;
                if (filters.contains(info.getVisualID())) {
                    item.setChecked(false);
                } else {
                    item.setChecked(true);
                }
            }
            this.setChecked(item, filters);
            ++n2;
        }
    }

    protected void treeItemSelected(SelectionEvent e) {
        if (e.detail == 32 && !this.isChecking) {
            this.isChecking = true;
            try {
                Object data = e.item.getData();
                ViewInfo viewInfo = (ViewInfo)Platform.getAdapterManager().getAdapter(data, ViewInfo.class);
                TreeItem item = (TreeItem)Platform.getAdapterManager().getAdapter((Object)e.item, TreeItem.class);
                if (viewInfo != null && item != null && this.getTreeViewer().getTree().getItems() != null) {
                    if (viewInfo.isSelectable()) {
                        this.setAllVisualIDsChecked(this.getTreeViewer().getTree().getItems(), viewInfo.getVisualID(), item.getChecked());
                    } else {
                        item.setChecked(!item.getChecked());
                    }
                }
            }
            finally {
                this.isChecking = false;
            }
        }
    }

    protected void setAllVisualIDsChecked(TreeItem[] items, int visualID, boolean check) {
        ViewInfo viewInfo = null;
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item != null) {
                viewInfo = (ViewInfo)Platform.getAdapterManager().getAdapter(item.getData(), ViewInfo.class);
                if (viewInfo != null && visualID == viewInfo.getVisualID()) {
                    item.setChecked(check);
                }
                if (item.getItems() != null) {
                    this.setAllVisualIDsChecked(item.getItems(), visualID, check);
                }
            }
            ++n2;
        }
    }
}

