/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.editparts;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.emf.appearance.helper.NameLabelIconHelper;
import org.eclipse.papyrus.uml.diagram.common.editparts.IUMLNamedElementEditPart;
import org.eclipse.papyrus.uml.diagram.common.editparts.UMLNodeEditPart;
import org.eclipse.papyrus.uml.diagram.common.figure.node.IPapyrusNodeNamedElementFigure;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.uml2.uml.NamedElement;

public abstract class NamedElementEditPart
extends UMLNodeEditPart
implements IUMLNamedElementEditPart {
    public NamedElementEditPart(View view) {
        super(view);
    }

    public NamedElement getNamedElement() {
        return (NamedElement)this.getUMLElement();
    }

    protected void handleNotificationEvent(Notification event) {
        super.handleNotificationEvent(event);
        if (this.resolveSemanticElement() != null) {
            this.refreshIconNamedLabel();
            this.refreshFontColor();
        }
    }

    private void refreshIconNamedLabel() {
        this.getNodeNamedElementFigure().setNameLabelIcon(NameLabelIconHelper.showLabelIcon((EModelElement)((View)this.getModel())));
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        if (this.getNodeNamedElementFigure() != null && this.resolveSemanticElement() != null) {
            this.refreshIconNamedLabel();
            this.refreshFontColor();
        }
    }

    protected void refreshLabelsFont(Font font) {
        super.refreshLabelsFont(font);
        this.getNodeNamedElementFigure().getNameLabel().setFont(font);
        if (this.getNodeNamedElementFigure().getQualifiedNameLabel() != null) {
            this.getNodeNamedElementFigure().getQualifiedNameLabel().setFont(font);
        }
        if (this.getNodeNamedElementFigure().getTaggedLabel() != null) {
            this.getNodeNamedElementFigure().getTaggedLabel().setFont(font);
        }
    }

    private IPapyrusNodeNamedElementFigure getNodeNamedElementFigure() {
        return (IPapyrusNodeNamedElementFigure)this.getPrimaryShape();
    }

    protected void setFontColor(Color color) {
        super.setFontColor(color);
        if (this.getNodeNamedElementFigure().getQualifiedNameLabel() != null) {
            this.getNodeNamedElementFigure().getQualifiedNameLabel().setForegroundColor(color);
        }
        if (this.getNodeNamedElementFigure().getTaggedLabel() != null) {
            this.getNodeNamedElementFigure().getTaggedLabel().setForegroundColor(color);
        }
    }
}

