/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.figure.node;

import java.util.StringTokenizer;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.gmf.runtime.diagram.ui.figures.NoteFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.IPapyrusNodeFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.layout.PropertiesCompartmentLayoutManager;
import org.eclipse.papyrus.uml.diagram.common.figure.node.IPapyrusNodeUMLElementFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.node.NoteShadowBorder;
import org.eclipse.papyrus.uml.diagram.common.figure.node.StereotypePropertiesCompartment;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class CornerBentFigure
extends NoteFigure
implements IPapyrusNodeUMLElementFigure,
IPapyrusNodeFigure {
    protected NoteShadowBorder shadowborder;
    protected NoteFigure.NoteFigureBorder noteBorder = null;
    protected StereotypePropertiesCompartment stereotypePropertiesContent;
    protected Label stereotypePropertiesInBraceContent;
    protected Label stereotypesLabel;
    protected Label iconLabel;
    protected Color borderColor = ColorConstants.black;
    protected boolean shadow = true;

    public CornerBentFigure() {
        super(100, 60, new Insets(5, 5, 5, 14));
        this.setLayoutManager((LayoutManager)new ToolbarLayout());
        if (this.getBorder() instanceof NoteFigure.NoteFigureBorder) {
            this.noteBorder = (NoteFigure.NoteFigureBorder)this.getBorder();
        }
        this.shadowborder = new NoteShadowBorder(3, this.getForegroundColor(), new Dimension(10, 10), this.noteBorder);
        this.setBorder((Border)this.shadowborder);
    }

    protected void createStereotypeLabel() {
        this.stereotypesLabel = new Label();
        this.stereotypesLabel.setOpaque(false);
        this.stereotypesLabel.setFont(this.getFont());
        this.stereotypesLabel.setForegroundColor(this.getForegroundColor());
        this.add((IFigure)this.stereotypesLabel, this.getStereotypeLabelPosition());
    }

    protected void createStereotypePropertiesContent() {
        this.stereotypePropertiesContent = new StereotypePropertiesCompartment();
        this.stereotypePropertiesContent.setFill(false);
        this.stereotypePropertiesContent.setLineWidth(0);
        this.stereotypePropertiesContent.setBorder(null);
        this.stereotypePropertiesContent.setUpperLine(false);
        this.stereotypePropertiesContent.setLayoutManager((LayoutManager)new PropertiesCompartmentLayoutManager());
        this.add((IFigure)this.stereotypePropertiesContent, this.getStereotypePropertiesCompartmentPosition());
    }

    protected void createStereotypePropertiesInBraceLabel() {
        this.stereotypePropertiesInBraceContent = new Label();
        this.stereotypePropertiesInBraceContent.setOpaque(false);
        this.add((IFigure)this.stereotypePropertiesInBraceContent, this.getStereotypePropertiesLabelPosition());
    }

    private void fillStereotypePropertiesInCompartment(String stereotypeProperties) {
        this.stereotypePropertiesContent.getChildren().clear();
        StringTokenizer stringTokenizer = new StringTokenizer(stereotypeProperties, ";");
        while (stringTokenizer.hasMoreElements()) {
            String tokenStereotype = stringTokenizer.nextToken();
            tokenStereotype = tokenStereotype.replace("#", "\n  ");
            tokenStereotype = tokenStereotype.replace("|", "\n  ");
            Label label = new Label(tokenStereotype);
            label.setLabelAlignment(1);
            this.stereotypePropertiesContent.add((IFigure)label);
        }
        this.repaint();
    }

    protected int getStereotypePropertiesCompartmentPosition() {
        int position = this.getChildren().indexOf(this.stereotypesLabel);
        return ++position;
    }

    public RectangleFigure getStereotypePropertiesContent() {
        return this.stereotypePropertiesContent;
    }

    protected int getStereotypePropertiesLabelPosition() {
        int position = this.getStereotypeLabelPosition();
        if (this.stereotypesLabel != null) {
            ++position;
        }
        return position;
    }

    public Label getStereotypesLabel() {
        return this.stereotypesLabel;
    }

    public void setStereotypeDisplay(String stereotypes, Image image) {
        if (!"".equals(stereotypes)) {
            this.setStereotypes(stereotypes);
        } else {
            this.setStereotypes(null);
        }
        this.setAppliedStereotypeIcon(image);
    }

    public void setStereotypePropertiesInBrace(String stereotypeProperties) {
        if (stereotypeProperties == null) {
            if (this.stereotypePropertiesInBraceContent != null) {
                this.remove((IFigure)this.stereotypePropertiesInBraceContent);
                this.stereotypePropertiesInBraceContent = null;
            }
            return;
        }
        if (this.stereotypePropertiesInBraceContent == null) {
            this.createStereotypePropertiesInBraceLabel();
        }
        if (!"".equals(stereotypeProperties)) {
            this.stereotypePropertiesInBraceContent.setText("{" + stereotypeProperties + "}");
        } else {
            this.stereotypePropertiesInBraceContent.setText("");
        }
    }

    public void setStereotypePropertiesInCompartment(String stereotypeProperties) {
        if (stereotypeProperties == null || stereotypeProperties == "") {
            if (this.stereotypePropertiesContent != null) {
                this.remove((IFigure)this.stereotypePropertiesContent);
                this.stereotypePropertiesContent = null;
            }
            return;
        }
        if (this.stereotypePropertiesContent == null) {
            this.createStereotypePropertiesContent();
        }
        this.fillStereotypePropertiesInCompartment(stereotypeProperties);
    }

    public void setStereotypes(String stereotypes) {
        if (stereotypes == null) {
            if (this.stereotypesLabel != null) {
                this.remove((IFigure)this.stereotypesLabel);
                this.stereotypesLabel = null;
            }
            return;
        }
        if (this.stereotypesLabel == null) {
            this.createStereotypeLabel();
        }
        if (!"".equals(stereotypes)) {
            this.stereotypesLabel.setText(stereotypes);
        } else {
            this.stereotypesLabel.setText("");
        }
    }

    protected int getStereotypeLabelPosition() {
        int position = this.getIconLabelPosition();
        if (this.iconLabel != null && this.iconLabel.getIcon() != null) {
            ++position;
        }
        return position;
    }

    protected int getIconLabelPosition() {
        return 0;
    }

    public void setAppliedStereotypeIcon(Image image) {
        if (image == null) {
            if (this.iconLabel != null) {
                this.remove((IFigure)this.iconLabel);
                this.iconLabel = null;
            }
            return;
        }
        if (this.iconLabel == null) {
            this.createIconLabel();
        }
        this.iconLabel.setIcon(image);
    }

    protected void createIconLabel() {
        this.iconLabel = new Label();
        this.add((IFigure)this.iconLabel, this.getIconLabelPosition());
        this.iconLabel.setLabelAlignment(1);
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
    }

    public boolean isShadow() {
        return this.shadow;
    }

    public void setShadow(boolean shadow) {
        this.shadow = shadow;
        if (shadow) {
            this.setBorder((Border)this.shadowborder);
        } else if (this.noteBorder != null) {
            this.setBorder((Border)this.noteBorder);
        }
        this.revalidate();
        this.repaint();
    }
}

