/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.handlers;

import java.util.Hashtable;
import org.eclipse.core.commands.HandlerEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.papyrus.uml.diagram.common.handlers.GraphicalCommandHandler;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class ParametricAndListeningHandler
extends GraphicalCommandHandler
implements IExecutableExtension {
    private ISelectionService serv = null;
    private ParametricAndListeningHandler thisHandler = this;
    protected String parameter = null;
    protected String parametedID = null;
    protected ISelectionListener listener = null;

    public ParametricAndListeningHandler() {
    }

    public ParametricAndListeningHandler(String parameterID) {
        this.parametedID = parameterID;
    }

    protected Command getCommand() {
        this.addSelectionListener();
        return UnexecutableCommand.INSTANCE;
    }

    protected void addSelectionListener() {
        IWorkbenchWindow workbenchWindow;
        IWorkbench workbench;
        if (this.serv == null && (workbench = PlatformUI.getWorkbench()) != null && (workbenchWindow = workbench.getActiveWorkbenchWindow()) != null) {
            this.serv = workbenchWindow.getSelectionService();
            if (this.serv != null) {
                this.listener = new ISelectionListener(){

                    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                        ParametricAndListeningHandler.this.refreshMenu();
                    }
                };
                this.serv.addSelectionListener(this.listener);
            }
        }
    }

    protected void refreshMenu() {
        this.fireHandlerChanged(new HandlerEvent((IHandler)this.thisHandler, true, false));
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof Hashtable && this.parametedID != null) {
            this.parameter = (String)((Hashtable)data).get(this.parametedID);
        }
    }

    public void dispose() {
        if (this.serv != null && this.listener != null) {
            this.serv.removeSelectionListener(this.listener);
        }
    }
}

