/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.handlers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.infra.services.resourceloading.util.LoadingUtils;
import org.eclipse.papyrus.uml.diagram.common.handlers.GraphicalCommandHandler;

public class UnloadHandler
extends GraphicalCommandHandler {
    protected Command getCommand() {
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        List<IGraphicalEditPart> selection = this.getSelectedElements();
        if (editingDomain != null && editingDomain.getResourceSet() instanceof ModelSet && selection.size() > 0) {
            final ModelSet set = (ModelSet)editingDomain.getResourceSet();
            CompoundCommand command = new CompoundCommand();
            ArrayList<URI> handledURI = new ArrayList<URI>();
            URI mainURI = NotationUtils.getNotationModel((ModelSet)set).getResourceURI().trimFileExtension();
            handledURI.add(mainURI);
            for (IGraphicalEditPart selPart : selection) {
                URI uriTrim;
                EObject sel;
                View view = (View)selPart.getAdapter(View.class);
                if (view == null || (sel = view.getElement()) == null || sel.eIsProxy() || handledURI.contains(uriTrim = sel.eResource().getURI().trimFileExtension())) continue;
                handledURI.add(uriTrim);
                Command cmd = new Command(){

                    public void redo() {
                        LoadingUtils.unloadResourcesFromModelSet((ModelSet)set, (URI)uriTrim);
                    }

                    public void execute() {
                        this.redo();
                    }

                    public boolean canExecute() {
                        return true;
                    }
                };
                command.add(cmd);
            }
            return command;
        }
        return UnexecutableCommand.INSTANCE;
    }
}

