/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramCommandStack;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedAdapter;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.tools.UnspecifiedTypeCreationTool;
import org.eclipse.gmf.runtime.diagram.ui.util.INotationType;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.part.PaletteUtil;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IAspectAction;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IPostAction;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IPreAction;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AspectUnspecifiedTypeCreationTool
extends UnspecifiedTypeCreationTool {
    protected List<IElementType> elementTypes;
    protected List<IPostAction> postActions = new ArrayList<IPostAction>();
    protected List<IPreAction> preActions = new ArrayList<IPreAction>();
    private static String ID_ASPECT_ACTION = "palette_aspect_actions";

    public AspectUnspecifiedTypeCreationTool(List<IElementType> elementTypes) {
        super(elementTypes);
        this.elementTypes = elementTypes;
    }

    protected void performCreation(int button) {
        Command command;
        this.antiScroll = true;
        boolean requiresPostCommitRun = this.requiresPostCommitRun();
        View eObject = (View)this.getTargetEditPart().getAdapter(View.class);
        DiagramEventBroker eventBroker = null;
        NotificationListener listener = null;
        final EditPartViewer currentViewer = this.getCurrentViewer();
        if (requiresPostCommitRun) {
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)eObject);
            eventBroker = DiagramEventBroker.getInstance((TransactionalEditingDomain)domain);
            listener = new NotificationListener(){

                public void notifyChanged(Notification notification) {
                    Object newValue = notification.getNewValue();
                    if (currentViewer != null) {
                        EditPart editPart = (EditPart)currentViewer.getEditPartRegistry().get(newValue);
                        for (IPostAction action : AspectUnspecifiedTypeCreationTool.this.postActions) {
                            action.runInPostCommit(editPart);
                        }
                    }
                }
            };
            if (eventBroker != null) {
                eventBroker.addNotificationListener((EObject)eObject, listener);
            }
        }
        if ((command = this.getCurrentCommand()) != null) {
            Command completeCommand = this.getCompleteCommand(command);
            this.setCurrentCommand(completeCommand);
            this.executeCurrentCommand();
        }
        if (requiresPostCommitRun && eventBroker != null) {
            eventBroker.removeNotificationListener((EObject)eObject, listener);
        }
        this.selectAddedObject(currentViewer, DiagramCommandStack.getReturnValues((Command)command));
        this.antiScroll = false;
    }

    protected Command getCompleteCommand(Command createCommand) {
        ICommand cmd;
        CompoundCommand compositeCmd = new CompoundCommand("Create Element");
        for (IPreAction preAction : this.preActions) {
            Object context = this.getTargetEditPart().getModel();
            if (!(context instanceof View) || (cmd = preAction.getNodePreCommand((View)context)) == null) continue;
            compositeCmd.add((Command)new ICommandProxy(cmd));
        }
        compositeCmd.add(createCommand);
        CreateUnspecifiedAdapter viewAdapter = new CreateUnspecifiedAdapter();
        viewAdapter.add(this.getCreateRequest());
        for (IPostAction action : this.postActions) {
            cmd = action.getPostCommand((IAdaptable)viewAdapter);
            if (cmd == null) continue;
            compositeCmd.add((Command)new ICommandProxy(cmd));
        }
        return compositeCmd;
    }

    protected boolean requiresPostCommitRun() {
        for (IPostAction action : this.postActions) {
            if (!action.needsPostCommitRun()) continue;
            return true;
        }
        return false;
    }

    protected void applyProperty(Object key, Object value) {
        if ("aspectActions".equals(key)) {
            if (value instanceof NodeList) {
                PaletteUtil.initAspectActions((NodeList)value, this.postActions, this.preActions);
            }
        } else {
            super.applyProperty(key, value);
        }
    }

    public List<IElementType> getElementTypes() {
        return this.elementTypes;
    }

    protected Request createTargetRequest() {
        CreateAspectUnspecifiedTypeRequest request = new CreateAspectUnspecifiedTypeRequest(this.getElementTypes(), this.getPreferencesHint());
        request.getExtendedData().put(ID_ASPECT_ACTION, this.postActions);
        return request;
    }

    public static List<IAspectAction> getAspectActions(Request request) {
        return request == null ? Collections.emptyList() : AspectUnspecifiedTypeCreationTool.getAspectActions(request.getExtendedData());
    }

    public static List<IAspectAction> getAspectActions(Map map) {
        return map == null ? Collections.emptyList() : map.get(ID_ASPECT_ACTION);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CreateAspectUnspecifiedTypeRequest
    extends CreateUnspecifiedTypeRequest {
        public CreateAspectUnspecifiedTypeRequest(List<IElementType> elementTypes, PreferencesHint preferencesHint) {
            super(elementTypes, preferencesHint);
        }

        protected void createRequests() {
            for (IElementType elementType : this.getElementTypes()) {
                CreateViewRequest.ViewDescriptor viewDescriptor;
                CreateViewRequest request = null;
                if (elementType instanceof INotationType) {
                    viewDescriptor = new CreateViewRequest.ViewDescriptor(null, Node.class, ((INotationType)elementType).getSemanticHint(), this.getPreferencesHint());
                    request = new CreateViewRequest(viewDescriptor);
                } else if (elementType instanceof IHintedType) {
                    viewDescriptor = new CreateViewAndElementRequest.ViewAndElementDescriptor(new CreateElementRequestAdapter(new CreateElementRequest(elementType)), Node.class, this.getGraphicalHint((IHintedType)elementType), this.getPreferencesHint());
                    request = new CreateViewAndElementRequest((CreateViewAndElementRequest.ViewAndElementDescriptor)viewDescriptor);
                    request.setExtendedData(this.getExtendedData());
                } else {
                    viewDescriptor = new CreateViewAndElementRequest.ViewAndElementDescriptor(new CreateElementRequestAdapter(new CreateElementRequest(elementType)), Node.class, this.getPreferencesHint());
                    request = new CreateViewAndElementRequest((CreateViewAndElementRequest.ViewAndElementDescriptor)viewDescriptor);
                    request.setExtendedData(this.getExtendedData());
                }
                request.setType(this.getType());
                this.requests.put(elementType, request);
            }
        }

        protected String getGraphicalHint(IHintedType elementType) {
            String hint = elementType.getSemanticHint();
            return hint;
        }
    }
}

