/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.service;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoration;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.DescriptionStyle;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.layout.OverlayLocator;
import org.eclipse.papyrus.uml.diagram.common.util.DiagramEditPartsUtil;
import org.eclipse.papyrus.uml.diagram.common.util.Util;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

public class InheritedDecorator
implements IDecorator {
    private IDecoratorTarget decoratorTarget;
    private IDecoration decoration;
    public static final String pluginID = "org.eclipse.papyrus.uml.diagram.common";
    public static final String imagePath = "/icons/hyperlink_13x13.gif";
    private static final Image ICON_HYPERLINK = Activator.getPluginIconImage("org.eclipse.papyrus.uml.diagram.common", "/icons/hyperlink_13x13.gif");
    private NotificationListener notificationListener = new NotificationListener(){

        public void notifyChanged(Notification notification) {
            if (notification.getEventType() == 4 && notification.getNotifier() instanceof Classifier) {
                IGraphicalEditPart gep = (IGraphicalEditPart)InheritedDecorator.this.getDecoratorTarget().getAdapter(IGraphicalEditPart.class);
                if (!$assertionsDisabled && gep == null) {
                    throw new AssertionError();
                }
                DiagramEventBroker.getInstance((TransactionalEditingDomain)gep.getEditingDomain()).removeNotificationListener((EObject)notification.getNotifier(), InheritedDecorator.this.notificationListener);
            }
            InheritedDecorator.this.deactivate();
            InheritedDecorator.this.activate();
            InheritedDecorator.this.refresh();
        }
    };

    public InheritedDecorator(IDecoratorTarget decoratorTarget) {
        this.decoratorTarget = decoratorTarget;
    }

    protected IDecoratorTarget getDecoratorTarget() {
        return this.decoratorTarget;
    }

    public IDecoration getDecoration() {
        return this.decoration;
    }

    public void setDecoration(IDecoration decoration) {
        this.decoration = decoration;
    }

    protected void removeDecoration() {
        if (this.decoration != null) {
            this.decoratorTarget.removeDecoration(this.decoration);
            this.decoration = null;
        }
    }

    public static Node getDecoratorTargetNode(IDecoratorTarget decoratorTarget) {
        DescriptionStyle descStyle = null;
        View node = (View)decoratorTarget.getAdapter(View.class);
        if (node != null && !(node instanceof Diagram) && (descStyle = (DescriptionStyle)node.getStyle(NotationPackage.eINSTANCE.getDescriptionStyle())) != null) {
            return (Node)node;
        }
        return null;
    }

    public void refresh() {
        DescriptionStyle descStyle;
        this.removeDecoration();
        Node node = InheritedDecorator.getDecoratorTargetNode(this.getDecoratorTarget());
        IGraphicalEditPart gep = (IGraphicalEditPart)this.getDecoratorTarget().getAdapter(IGraphicalEditPart.class);
        if (node != null && (descStyle = this.getDescriptionStyle(node)) != null && this.isInherited(node) && gep != null && gep.getRoot() != null) {
            IFigure figure = this.getFigure(ICON_HYPERLINK);
            if (this.isInCompartmentList(node) && !Util.isAffixedChildNode((EditPart)gep)) {
                this.setDecoration(this.getDecoratorTarget().addShapeDecoration(figure, this.getDirection(node), -1, false));
            } else {
                OverlayLocator locator = new OverlayLocator(gep.getFigure(), this.getDirection(node));
                this.setDecoration(this.getDecoratorTarget().addDecoration(figure, (Locator)locator, false));
            }
        }
    }

    public IFigure getFigure(Image image) {
        IMapMode mm = MapModeUtil.getMapMode((IFigure)((IGraphicalEditPart)this.getDecoratorTarget().getAdapter(IGraphicalEditPart.class)).getFigure());
        ImageFigure fig = new ImageFigure();
        fig.setImage(image);
        fig.setSize(mm.DPtoLP(image.getBounds().width), mm.DPtoLP(image.getBounds().height));
        return fig;
    }

    protected IDecoratorTarget.Direction getDirection(Node node) {
        IGraphicalEditPart gep = (IGraphicalEditPart)this.getDecoratorTarget().getAdapter(IGraphicalEditPart.class);
        assert (gep != null);
        if (gep.getParent() != null && this.isInCompartmentList(node) && !Util.isAffixedChildNode((EditPart)gep)) {
            return IDecoratorTarget.Direction.EAST;
        }
        return IDecoratorTarget.Direction.SOUTH_WEST;
    }

    protected boolean isInCompartmentList(Node node) {
        EditPart EP;
        EditPolicy editPolicy;
        EObject container;
        IGraphicalEditPart gep = (IGraphicalEditPart)this.getDecoratorTarget().getAdapter(IGraphicalEditPart.class);
        return gep != null && gep.getRoot() != null && (container = node.eContainer()) instanceof View && !((editPolicy = (EP = DiagramEditPartsUtil.getEditPartFromView((View)container, (EditPart)gep)).getEditPolicy((Object)"LayoutEditPolicy")) instanceof XYLayoutEditPolicy);
    }

    protected boolean isInherited(Node node) {
        EObject element = node.getElement();
        if (element instanceof Element) {
            EObject container = node.eContainer();
            EObject graphicalParent = null;
            if (container instanceof DecorationNode) {
                graphicalParent = ((DecorationNode)container).getElement();
            } else if (container instanceof View) {
                graphicalParent = ((View)container).getElement();
            }
            if (graphicalParent instanceof Property || graphicalParent instanceof Classifier) {
                Classifier classifier = null;
                if (graphicalParent instanceof Property) {
                    Type type = ((Property)graphicalParent).getType();
                    if (type instanceof Classifier) {
                        classifier = (Classifier)type;
                    }
                } else {
                    classifier = (Classifier)graphicalParent;
                }
                if (classifier != null) {
                    EList inheritedMembers = classifier.getInheritedMembers();
                    return inheritedMembers.contains((Object)element);
                }
            }
        }
        return false;
    }

    protected DescriptionStyle getDescriptionStyle(Node node) {
        return (DescriptionStyle)node.getStyle(NotationPackage.eINSTANCE.getDescriptionStyle());
    }

    public void activate() {
        Element semanticElement;
        EObject el;
        EObject parent;
        IGraphicalEditPart gep = (IGraphicalEditPart)this.getDecoratorTarget().getAdapter(IGraphicalEditPart.class);
        assert (gep != null);
        View view = (View)gep.getModel();
        if (view instanceof Node && this.isInherited((Node)view) && Util.isAffixedChildNode((EditPart)gep)) {
            DiagramEventBroker.getInstance((TransactionalEditingDomain)gep.getEditingDomain()).addNotificationListener((EObject)gep.getNotationView(), this.notificationListener);
        }
        if ((parent = view.eContainer()) instanceof DecorationNode) {
            parent = parent.eContainer();
        }
        if (parent instanceof View && (el = ((View)parent).getElement()) instanceof Property) {
            DiagramEventBroker.getInstance((TransactionalEditingDomain)gep.getEditingDomain()).addNotificationListener(el, (EStructuralFeature)UMLPackage.eINSTANCE.getTypedElement_Type(), this.notificationListener);
        }
        if (view.getElement() instanceof Element && (semanticElement = (Element)view.getElement()) != null && this.canBeInherited(semanticElement) && semanticElement.eContainer() != null) {
            DiagramEventBroker.getInstance((TransactionalEditingDomain)gep.getEditingDomain()).addNotificationListener(semanticElement.eContainer(), this.notificationListener);
        }
    }

    protected boolean canBeInherited(Element semanticElement) {
        if (semanticElement instanceof Classifier) {
            return true;
        }
        if (semanticElement instanceof Property) {
            return true;
        }
        return semanticElement instanceof Operation;
    }

    public void deactivate() {
        Element semanticElement;
        EObject el;
        this.removeDecoration();
        IGraphicalEditPart gep = (IGraphicalEditPart)this.getDecoratorTarget().getAdapter(IGraphicalEditPart.class);
        assert (gep != null);
        DiagramEventBroker.getInstance((TransactionalEditingDomain)gep.getEditingDomain()).removeNotificationListener((EObject)gep.getNotationView(), this.notificationListener);
        View view = (View)gep.getModel();
        EObject parent = view.eContainer();
        if (parent instanceof View && (el = ((View)parent).getElement()) instanceof Property) {
            DiagramEventBroker.getInstance((TransactionalEditingDomain)gep.getEditingDomain()).removeNotificationListener(el, (Object)UMLPackage.eINSTANCE.getTypedElement_Type(), this.notificationListener);
        }
        if (view.getElement() instanceof Element && (semanticElement = (Element)view.getElement()) != null && semanticElement.eContainer() != null) {
            DiagramEventBroker.getInstance((TransactionalEditingDomain)gep.getEditingDomain()).removeNotificationListener(semanticElement.eContainer(), this.notificationListener);
        }
    }
}

