/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.service.palette;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IAspectActionProvider;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IPreAction;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPreConditionAction
implements IPreAction {
    protected IAspectActionProvider factory;

    @Override
    public void init(Node configurationNode, IAspectActionProvider factory) {
        this.factory = factory;
    }

    @Override
    public Image getImage() {
        return this.factory.getImage();
    }

    @Override
    public String getLabel() {
        return this.factory.getName();
    }

    @Override
    public String getFactoryId() {
        return this.factory.getFactoryId();
    }

    @Override
    public IStatus checkPostCondition() {
        return null;
    }

    @Override
    public IStatus checkPreCondition() {
        return null;
    }

    @Override
    public ICommand getConnectionPreCommand(View sourceView, View targetView) {
        List<IStatus> preConditionStatusList = this.checkConnectionPreCondition(sourceView, targetView);
        return this.handlePreconditionFailure(preConditionStatusList);
    }

    protected abstract List<IStatus> checkConnectionPreCondition(View var1, View var2);

    @Override
    public ICommand getNodePreCommand(View containerView) {
        List<IStatus> preConditionStatusList = this.checkNodePreCondition(containerView);
        return this.handlePreconditionFailure(preConditionStatusList);
    }

    protected abstract List<IStatus> checkNodePreCondition(View var1);

    protected ICommand handlePreconditionFailure(List<IStatus> preConditionStatusList) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("The following precondition(s) failed with the error messages:");
        boolean failed = false;
        for (IStatus status : preConditionStatusList) {
            if (status.isOK()) continue;
            stringBuilder.append("\n\r\n\r" + status.getMessage());
            failed = true;
        }
        if (failed) {
            MessageBox dialog;
            if (this.allowContinue()) {
                stringBuilder.append("\n\r\n\rDo you wish to continue?");
                dialog = new MessageBox(Display.getCurrent().getActiveShell(), 292);
                dialog.setText("Precondition failure");
                dialog.setMessage(stringBuilder.toString());
                int returnCode = dialog.open();
                if (returnCode == 32) {
                    return null;
                }
                return new UnexecutableCommand(Status.CANCEL_STATUS);
            }
            dialog = new MessageBox(Display.getCurrent().getActiveShell(), 33);
            dialog.setText("Precondition failure");
            dialog.setMessage(stringBuilder.toString());
            dialog.open();
            return new UnexecutableCommand(Status.CANCEL_STATUS);
        }
        return null;
    }

    protected abstract boolean allowContinue();
}

