/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.service.palette;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.papyrus.infra.core.utils.EditorUtils;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.helper.AssociationHelper;
import org.eclipse.papyrus.uml.diagram.common.part.PaletteUtil;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IAspectActionProvider;
import org.eclipse.papyrus.uml.diagram.common.service.palette.IPaletteEntryProxy;
import org.eclipse.papyrus.uml.diagram.common.service.palette.ModelPostAction;
import org.eclipse.papyrus.uml.tools.utils.MultiplicityElementUtil;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssociationEndPostAction
extends ModelPostAction {
    protected List<PropertyEndConfiguration> configurations;
    protected IPaletteEntryProxy entryProxy;
    protected List<Profile> appliedProfiles;
    protected TableViewer attributeViewer;
    protected EClass metaclass = null;
    protected static final String ICON_CHECKED = "/icons/complete_tsk.gif";
    protected static final String ICON_UNCHECKED = "/icons/incomplete_tsk.gif";
    protected static final String SEPARATOR = ",,";
    protected static final String ASSOCIATION_END_NODE_NAME = "associationEnd";
    protected static final String INDEX_ATTRIBUTE_NAME = "index";
    protected static final String NAME_ATTRIBUTE_NAME = "name";
    protected static final String AGGREGATION_NODE_NAME = "aggregation";
    protected static final String VALUE_ATTRIBUTE_NAME = "value";
    protected static final String MULTIPLICITY_NODE_NAME = "multiplicity";
    protected static final String NAVIGABLE_NODE_NAME = "navigable";
    protected static final String OWNER_NODE_NAME = "owner";
    protected static final String CLASS_OWNER = "Class";
    protected static final String NAVIGABLE_YES = "Yes";
    protected List<PropertyEndComposite> configurationComposites = new ArrayList<PropertyEndComposite>();

    public AssociationEndPostAction() {
        this.configurations = new ArrayList<PropertyEndConfiguration>();
    }

    @Override
    public void init(Node configurationNode, IAspectActionProvider factory) {
        super.init(configurationNode, factory);
        if (configurationNode == null) {
            PropertyEndConfiguration sourceConfiguration = new PropertyEndConfiguration(0, "source");
            PropertyEndConfiguration targetConfiguration = new PropertyEndConfiguration(1, "target");
            this.configurations.add(sourceConfiguration);
            this.configurations.add(targetConfiguration);
            return;
        }
        NodeList childNodes = configurationNode.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node featureNode = childNodes.item(i);
            if (ASSOCIATION_END_NODE_NAME.equals(featureNode.getNodeName())) {
                Node indexNode = featureNode.getAttributes().getNamedItem(INDEX_ATTRIBUTE_NAME);
                Node nameNode = featureNode.getAttributes().getNamedItem(NAME_ATTRIBUTE_NAME);
                if (indexNode != null && nameNode != null) {
                    Integer index = Integer.parseInt(indexNode.getNodeValue());
                    PropertyEndConfiguration configuration = new PropertyEndConfiguration(index, nameNode.getNodeValue());
                    NodeList subNodes = featureNode.getChildNodes();
                    int j = 0;
                    while (j < subNodes.getLength()) {
                        Node valueNode;
                        Node subNode = subNodes.item(j);
                        String subNodeName = subNode.getNodeName();
                        if (AGGREGATION_NODE_NAME.equals(subNodeName)) {
                            valueNode = subNode.getAttributes().getNamedItem(VALUE_ATTRIBUTE_NAME);
                            if (valueNode != null) {
                                configuration.setAggregationKind(valueNode.getNodeValue());
                            }
                        } else if (MULTIPLICITY_NODE_NAME.equals(subNodeName)) {
                            valueNode = subNode.getAttributes().getNamedItem(VALUE_ATTRIBUTE_NAME);
                            if (valueNode != null) {
                                configuration.setMultiplicity(valueNode.getNodeValue());
                            }
                        } else if (NAVIGABLE_NODE_NAME.equals(subNodeName)) {
                            valueNode = subNode.getAttributes().getNamedItem(VALUE_ATTRIBUTE_NAME);
                            if (valueNode != null) {
                                configuration.setNavigation(valueNode.getNodeValue());
                            }
                        } else if (OWNER_NODE_NAME.equals(subNodeName) && (valueNode = subNode.getAttributes().getNamedItem(VALUE_ATTRIBUTE_NAME)) != null) {
                            configuration.setOwner(valueNode.getNodeValue());
                        }
                        ++j;
                    }
                    this.configurations.add(configuration);
                } else {
                    Activator.log.error("Impossible to parse the configuration node for semantic post action", null);
                }
            }
            ++i;
        }
    }

    @Override
    public ICommand getPostCommand(final IAdaptable viewAdapter) {
        TransactionalEditingDomain editingDomain = EditorUtils.getTransactionalEditingDomain();
        return new AbstractTransactionalCommand(editingDomain, "Modify Association End", null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                View view = (View)viewAdapter.getAdapter(View.class);
                if (view != null && view.getElement() instanceof Association) {
                    EObject objectToEdit = view.getElement();
                    for (PropertyEndConfiguration configuration : AssociationEndPostAction.this.configurations) {
                        IUndoableOperation operation;
                        Property property = (Property)((Association)objectToEdit).getMemberEnds().get(configuration.getIndex());
                        if (!"".equals(configuration.getOwner()) && (operation = AssociationHelper.createSetOwnerCommand((Association)objectToEdit, property, AssociationEndPostAction.CLASS_OWNER.equals(configuration.getOwner()))) != null && operation.canExecute()) {
                            operation.execute(null, null);
                        }
                        if (!"".equals(configuration.getAggregationKind())) {
                            AggregationKind aggregationKind = AggregationKind.get((String)configuration.getAggregationKind());
                            AssociationHelper.createSetAggregationCommand(property, aggregationKind).execute(null, null);
                        }
                        if (!"".equals(configuration.getMultiplicity())) {
                            String multiplicity = configuration.getMultiplicity();
                            try {
                                int[] values = MultiplicityElementUtil.parseMultiplicity((String)multiplicity);
                                if (values.length == 2) {
                                    AssociationHelper.createSetMultiplicityCommand(property, values[0], values[1]).execute(null, null);
                                }
                            }
                            catch (NumberFormatException e) {
                                Activator.log.error("Multiplicity [" + multiplicity + "] can not be parsed", (Throwable)e);
                            }
                        }
                        if ("".equals(configuration.getNavigation())) continue;
                        String navigation = configuration.getNavigation();
                        boolean isNavigable = AssociationEndPostAction.NAVIGABLE_YES.equals(navigation);
                        AssociationHelper.createSetNavigableCommand((Association)objectToEdit, property, isNavigable).execute(null, null);
                    }
                }
                return CommandResult.newOKCommandResult();
            }
        };
    }

    @Override
    public Control createConfigurationComposite(Composite parent, IPaletteEntryProxy entryProxy, List<Profile> appliedProfiles) {
        this.appliedProfiles = appliedProfiles;
        this.entryProxy = entryProxy;
        if (entryProxy.getEntry() instanceof CombinedTemplateCreationEntry) {
            this.metaclass = PaletteUtil.getToolMetaclass((ToolEntry)((CombinedTemplateCreationEntry)entryProxy.getEntry()));
        }
        Composite mainComposite = new Composite(parent, 2048);
        GridLayout layout = new GridLayout(2, true);
        mainComposite.setLayout((Layout)layout);
        Label titleLabel = new Label(mainComposite, 0);
        titleLabel.setText("Association end properties");
        GridData data = new GridData(4, 0x1000000, true, false, 2, 1);
        titleLabel.setLayoutData((Object)data);
        for (PropertyEndConfiguration configuration : this.configurations) {
            PropertyEndComposite composite = new PropertyEndComposite(configuration);
            composite.createComposite(mainComposite);
            this.configurationComposites.add(composite);
        }
        return mainComposite;
    }

    @Override
    public void save(Node parentNode) {
        if (!(parentNode instanceof Element)) {
            Activator.log.error("parent node is not an Element", null);
            return;
        }
        for (PropertyEndConfiguration configuration : this.configurations) {
            Element associationEndNode = ((Element)parentNode).getOwnerDocument().createElement(ASSOCIATION_END_NODE_NAME);
            associationEndNode.setAttribute(INDEX_ATTRIBUTE_NAME, String.valueOf(configuration.getIndex()));
            associationEndNode.setAttribute(NAME_ATTRIBUTE_NAME, configuration.getName());
            if (!"".equals(configuration.getAggregationKind())) {
                this.createChildNode(associationEndNode, AGGREGATION_NODE_NAME, configuration.getAggregationKind());
            }
            if (!"".equals(configuration.getMultiplicity())) {
                this.createChildNode(associationEndNode, MULTIPLICITY_NODE_NAME, configuration.getMultiplicity());
            }
            if (!"".equals(configuration.getNavigation())) {
                this.createChildNode(associationEndNode, NAVIGABLE_NODE_NAME, configuration.getNavigation());
            }
            if (!"".equals(configuration.getOwner())) {
                this.createChildNode(associationEndNode, OWNER_NODE_NAME, configuration.getOwner());
            }
            ((Element)parentNode).appendChild(associationEndNode);
        }
    }

    protected void createChildNode(Element parent, String tagName, String value) {
        Element childNode = parent.getOwnerDocument().createElement(tagName);
        childNode.setAttribute(VALUE_ATTRIBUTE_NAME, value);
        parent.appendChild(childNode);
    }

    protected class PropertyEndComposite {
        protected final List<String> aggregationItems = Arrays.asList("", AggregationKind.NONE_LITERAL.getName(), AggregationKind.COMPOSITE_LITERAL.getName(), AggregationKind.SHARED_LITERAL.getName());
        protected final List<String> multiplicityItems = Arrays.asList("", "0..1", "1..1", "0..*", "1..*");
        protected final List<String> navigationItems = Arrays.asList("", "Yes", "No");
        protected final List<String> ownerItems = Arrays.asList("", "Class", "Association");
        protected final PropertyEndConfiguration configuration;
        protected final String label;
        protected Combo aggregationCombo;
        protected Button ownerClassButton;
        protected Button ownerAssociationButton;
        protected Combo navigationCombo;
        protected Combo multiplicityCombo;
        protected Combo ownerCombo;

        public PropertyEndComposite(PropertyEndConfiguration configuration) {
            this.configuration = configuration;
            this.label = configuration.getName();
        }

        public void createComposite(Composite parent) {
            Group mainComposite = new Group(parent, 0);
            mainComposite.setText("Property end " + this.label);
            GridLayout layout = new GridLayout(3, false);
            mainComposite.setLayout((Layout)layout);
            GridData data = new GridData(4, 4, true, true, 1, 1);
            mainComposite.setLayoutData((Object)data);
            Label aggregationLabel = new Label((Composite)mainComposite, 0);
            aggregationLabel.setText("Aggregation");
            aggregationLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
            this.aggregationCombo = new Combo((Composite)mainComposite, 8);
            this.aggregationCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            this.aggregationCombo.setItems(this.aggregationItems.toArray(new String[0]));
            this.aggregationCombo.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    PropertyEndComposite.this.configuration.setAggregationKind(PropertyEndComposite.this.aggregationCombo.getText());
                }

                public void focusGained(FocusEvent e) {
                }
            });
            Label ownerLabel = new Label((Composite)mainComposite, 0);
            ownerLabel.setText("Owner");
            ownerLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
            this.ownerCombo = new Combo((Composite)mainComposite, 8);
            this.ownerCombo.setItems(this.ownerItems.toArray(new String[0]));
            this.ownerCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            this.ownerCombo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    String value = ((Combo)e.widget).getText();
                    PropertyEndComposite.this.configuration.setOwner(value);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            Label navigationLabel = new Label((Composite)mainComposite, 0);
            navigationLabel.setText("Navigable");
            navigationLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
            this.navigationCombo = new Combo((Composite)mainComposite, 8);
            this.navigationCombo.setItems(this.navigationItems.toArray(new String[0]));
            this.navigationCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            this.navigationCombo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    String value = ((Combo)e.widget).getText();
                    PropertyEndComposite.this.configuration.setNavigation(value);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            Label multiplicityLabel = new Label((Composite)mainComposite, 0);
            multiplicityLabel.setText("Multiplicity");
            multiplicityLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
            this.multiplicityCombo = new Combo((Composite)mainComposite, 2048);
            this.multiplicityCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            this.multiplicityCombo.setItems(this.multiplicityItems.toArray(new String[0]));
            this.multiplicityCombo.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    String newValue = PropertyEndComposite.this.multiplicityCombo.getText();
                    if (PropertyEndComposite.this.isMultiplicityValid(newValue.trim())) {
                        PropertyEndComposite.this.configuration.setMultiplicity(newValue.trim());
                    } else {
                        boolean leaveCombo = MessageDialog.openQuestion((Shell)PropertyEndComposite.this.multiplicityCombo.getShell(), (String)"Incorrect multiplicity value", (String)("The text [" + newValue + "] is not a valid value.\nDo you really want to leave the combo, losing your modification on multiplicity value?"));
                        if (!leaveCombo) {
                            PropertyEndComposite.this.multiplicityCombo.setFocus();
                            PropertyEndComposite.this.multiplicityCombo.setText(newValue);
                        } else {
                            PropertyEndComposite.this.multiplicityCombo.setText(PropertyEndComposite.this.configuration.getMultiplicity());
                        }
                    }
                }

                public void focusGained(FocusEvent e) {
                }
            });
            this.update();
        }

        public void update() {
            this.navigationCombo.select(this.navigationItems.indexOf(this.configuration.getNavigation()));
            this.aggregationCombo.select(this.aggregationItems.indexOf(this.configuration.getAggregationKind()));
            this.ownerCombo.select(this.ownerItems.indexOf(this.configuration.getOwner()));
            this.multiplicityCombo.setText(this.configuration.getMultiplicity());
        }

        private boolean isMultiplicityValid(String newValue) {
            if (newValue.equals("")) {
                return true;
            }
            try {
                int[] values = MultiplicityElementUtil.parseMultiplicity((String)newValue);
                if (values.length == 2) {
                    int lower = values[0];
                    int upper = values[1];
                    return upper == -1 ? true : upper >= lower;
                }
                return false;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }

    protected class PropertyEndConfiguration {
        protected String aggregationKind = "";
        protected String owner = "";
        protected String navigation = "";
        protected String multiplicity = "";
        protected final int index;
        protected final String name;

        public String getName() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }

        public PropertyEndConfiguration(int index, String name) {
            this.index = index;
            this.name = name;
        }

        public String getAggregationKind() {
            return this.aggregationKind;
        }

        public void setAggregationKind(String aggregationKind) {
            this.aggregationKind = aggregationKind;
        }

        public String getOwner() {
            return this.owner;
        }

        public void setOwner(String owner) {
            this.owner = owner;
        }

        public String getNavigation() {
            return this.navigation;
        }

        public void setNavigation(String navigation) {
            this.navigation = navigation;
        }

        public String getMultiplicity() {
            return this.multiplicity;
        }

        public void setMultiplicity(String multiplicity) {
            this.multiplicity = multiplicity;
        }
    }
}

