/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.common.ids.MOSKittEditorIDs;
import org.eclipse.papyrus.uml.diagram.common.part.CachedResourcesDiagramEditor;
import org.eclipse.papyrus.uml.diagram.common.part.CachedResourcesEditorInput;
import org.eclipse.papyrus.uml.diagram.common.part.EditingDomainRegistry;
import org.eclipse.papyrus.uml.diagram.common.providers.IDiagramInitializer;
import org.eclipse.papyrus.uml.diagram.common.util.DiagramEditPartsUtil;
import org.eclipse.papyrus.uml.diagram.common.util.MDTUtil;
import org.eclipse.papyrus.uml.diagram.common.util.PathsUtil;
import org.eclipse.papyrus.uml.diagram.common.util.URIUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiDiagramUtil {
    public static final String BelongToDiagramSource = "es.cv.gvcase.mdt.uml2.diagram.common.Belongs_To_This_Diagram";
    public static final String DiagramsRelatedToElement = "es.cv.gvcase.mdt.uml2.diagram.common.DiagramsRelatedToElement";
    public static final String UpperDiagram = "es.cv.gvcase.mdt.diagram.common.UpperDiagram";
    private static final QualifiedName OpenDiagramsFileProperty = new QualifiedName("es.cv.gvcase.mdt.common.part.MOSKittMultiPageEditor", "openDiagrams");
    private static final String OpenDiagramsSeparator = ";";

    public static void associateDiagramToView(Diagram diagram) {
        EAnnotation eAnnotation = diagram.getEAnnotation(DiagramsRelatedToElement);
        if (eAnnotation == null) {
            eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource(DiagramsRelatedToElement);
            diagram.getEAnnotations().add((Object)eAnnotation);
        }
        eAnnotation.getReferences().add((Object)diagram.getElement());
    }

    public static List<Diagram> getDiagramsAssociatedToView(Diagram diagram) {
        String diagramKind;
        EObject domainElement = diagram != null ? diagram.getElement() : null;
        Resource resource = diagram != null ? diagram.eResource() : null;
        String string = diagramKind = diagram != null ? diagram.getType() : null;
        if (domainElement == null || resource == null || diagramKind == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Diagram> diagrams = new ArrayList<Diagram>();
        for (EObject eObject : resource.getContents()) {
            Diagram containedDiagram;
            EAnnotation eAnnotation;
            if (!(eObject instanceof Diagram) || (eAnnotation = (containedDiagram = (Diagram)eObject).getEAnnotation(DiagramsRelatedToElement)) == null || !eAnnotation.getReferences().contains((Object)domainElement)) continue;
            diagrams.add(containedDiagram);
        }
        return diagrams;
    }

    public static boolean addEAnnotationReferenceToDiagram(AbstractUIPlugin plugin, EObject eObject) {
        return MultiDiagramUtil.AddEAnnotationReferenceToDiagram(DiagramEditPartsUtil.findDiagramFromPlugin(plugin), eObject);
    }

    public static boolean addEAnnotationReferenceToDiagram(EditPart editPart, EObject eObject) {
        return MultiDiagramUtil.AddEAnnotationReferenceToDiagram(DiagramEditPartsUtil.findDiagramFromEditPart(editPart), eObject);
    }

    public static boolean AddEAnnotationReferenceToDiagram(Diagram diagram, EObject eObject) {
        if (diagram != null) {
            EAnnotation eAnnotation = diagram.getEAnnotation(BelongToDiagramSource);
            if (eAnnotation == null) {
                eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                eAnnotation.setSource(BelongToDiagramSource);
                diagram.getEAnnotations().add((Object)eAnnotation);
            }
            eAnnotation.getReferences().add((Object)eObject);
            return true;
        }
        return false;
    }

    public static boolean addEAnnotationUpperDiagramToDiagram(Diagram diagram, EObject eObject) {
        if (diagram != null) {
            EAnnotation eAnnotation = diagram.getEAnnotation(UpperDiagram);
            if (eAnnotation == null) {
                eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                eAnnotation.setSource(UpperDiagram);
                diagram.getEAnnotations().add((Object)eAnnotation);
            }
            eAnnotation.getReferences().add((Object)eObject);
            return true;
        }
        return false;
    }

    public static boolean RemoveEAnnotationReferenceFromDiagram(AbstractUIPlugin plugin, EObject eObject) {
        return MultiDiagramUtil.RemoveEAnnotationReferenceFromDiagram(DiagramEditPartsUtil.findDiagramFromPlugin(plugin), eObject);
    }

    public static boolean RemoveEAnnotationReferenceFromDiagram(EditPart editPart, EObject eObject) {
        return MultiDiagramUtil.RemoveEAnnotationReferenceFromDiagram(DiagramEditPartsUtil.findDiagramFromEditPart(editPart), eObject);
    }

    public static boolean RemoveEAnnotationReferenceFromDiagram(Diagram diagram, EObject eObject) {
        if (diagram != null) {
            EAnnotation eAnnotation = diagram.getEAnnotation(BelongToDiagramSource);
            if (eAnnotation == null) {
                return false;
            }
            if (eAnnotation.getReferences().contains((Object)eObject)) {
                eAnnotation.getReferences().remove((Object)eObject);
                return true;
            }
        }
        return false;
    }

    public static boolean findEObjectReferencedInEAnnotation(EditPart editPart, EObject eObject) {
        return MultiDiagramUtil.findEObjectReferencedInEAnnotation(DiagramEditPartsUtil.findDiagramFromEditPart(editPart), eObject);
    }

    public static boolean findEObjectReferencedInEAnnotation(AbstractUIPlugin plugin, EObject eObject) {
        return MultiDiagramUtil.findEObjectReferencedInEAnnotation(DiagramEditPartsUtil.findDiagramFromPlugin(plugin), eObject);
    }

    public static boolean findEObjectReferencedInEAnnotation(Diagram diagram, EObject eObject) {
        if (diagram != null) {
            EAnnotation eAnnotation = diagram.getEAnnotation(BelongToDiagramSource);
            return eAnnotation != null && eAnnotation.getReferences().contains((Object)eObject);
        }
        return false;
    }

    public static List<EObject> getAllReferencesInEAnnotation(Diagram diagram) {
        EAnnotation eAnnotation = diagram.getEAnnotation(BelongToDiagramSource);
        if (eAnnotation != null) {
            return eAnnotation.getReferences();
        }
        return Collections.EMPTY_LIST;
    }

    public static void addMultiDiagramVersion(Diagram diagram) {
        String diagramKind = diagram.getType();
        if (diagramKind == null) {
            return;
        }
        String editorId = MOSKittEditorIDs.getAllExtensionModelToEditor().get(diagramKind);
        if (editorId == null) {
            return;
        }
        IPluginContribution pluginContribution = (IPluginContribution)PlatformUI.getWorkbench().getEditorRegistry().findEditor(editorId);
        if (pluginContribution == null) {
            return;
        }
        Bundle bundle = Platform.getBundle((String)pluginContribution.getPluginId());
        if (bundle == null) {
            return;
        }
        String version = (String)bundle.getHeaders().get("Bundle-Version");
        MDTUtil.addDiagramVersion(diagram, version);
    }

    public static Diagram intializeNewDiagram(String kind, EObject domainElement, Resource resource, Map<String, IDiagramInitializer> initializers) throws ExecutionException {
        return MultiDiagramUtil.intializeNewDiagram(kind, domainElement, resource, initializers, true);
    }

    public static Diagram intializeNewDiagram(String kind, EObject domainElement, Resource resource, Map<String, IDiagramInitializer> initializers, boolean askName) throws ExecutionException {
        Diagram d = null;
        try {
            d = ViewService.createDiagram((EObject)domainElement, (String)kind, (PreferencesHint)MDTUtil.getPreferencesHint(kind));
            if (askName && !MultiDiagramUtil.setDigramName(d)) {
                return null;
            }
        }
        catch (ExecutionException ex) {
            return null;
        }
        if (d == null) {
            throw new ExecutionException("Can't create diagram of '" + kind + "' kind");
        }
        resource.getContents().add((Object)d);
        IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        Diagram activeDiagram = null;
        if (activeEditor instanceof DiagramEditor) {
            DiagramEditor diagramEditor = (DiagramEditor)activeEditor;
            activeDiagram = diagramEditor.getDiagram();
        } else if (activeEditor != null) {
            activeDiagram = (Diagram)activeEditor.getAdapter(Diagram.class);
        }
        if (activeDiagram != null) {
            MultiDiagramUtil.addEAnnotationUpperDiagramToDiagram(d, (EObject)activeDiagram);
        }
        MultiDiagramUtil.associateDiagramToView(d);
        MultiDiagramUtil.createInitialElements(d, initializers);
        MultiDiagramUtil.addMultiDiagramVersion(d);
        return d;
    }

    protected static boolean setDigramName(Diagram diagram) {
        String message = "";
        message = String.valueOf(message) + "New " + diagram.getType() + " diagram name";
        InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), "Diagram name", message, diagram.getType(), null);
        int result = dialog.open();
        if (result == 0) {
            String name = dialog.getValue();
            diagram.setName(name);
            return true;
        }
        return false;
    }

    public static Diagram intializeNewDiagram(String kind, EObject domainElement, Resource resource, Map<String, IDiagramInitializer> initializers, boolean askName, String name) throws ExecutionException {
        return MultiDiagramUtil.intializeNewDiagram(kind, domainElement, resource, initializers, askName, name, null);
    }

    public static Diagram intializeNewDiagram(String kind, EObject domainElement, Resource resource, Map<String, IDiagramInitializer> initializers, boolean askName, String name, Diagram upperDiagram) throws ExecutionException {
        IEditorPart activeEditor;
        Diagram d = null;
        try {
            d = ViewService.createDiagram((EObject)domainElement, (String)kind, (PreferencesHint)MDTUtil.getPreferencesHint(kind));
            if (askName && !MultiDiagramUtil.setDigramName(d, name)) {
                return null;
            }
        }
        catch (ExecutionException ex) {
            return null;
        }
        if (d == null) {
            throw new ExecutionException("Can't create diagram of '" + kind + "' kind");
        }
        if (upperDiagram == null && (activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor()) != null) {
            upperDiagram = (Diagram)activeEditor.getAdapter(Diagram.class);
        }
        MultiDiagramUtil.addEAnnotationUpperDiagramToDiagram(d, (EObject)upperDiagram);
        MultiDiagramUtil.associateDiagramToView(d);
        MultiDiagramUtil.createInitialElements(d, initializers);
        MultiDiagramUtil.addMultiDiagramVersion(d);
        resource.getContents().add((Object)d);
        return d;
    }

    protected static boolean setDigramName(Diagram diagram, String name) {
        String message = "";
        message = String.valueOf(message) + "New " + diagram.getType() + " diagram name";
        InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), "Diagram name", message, name, null);
        int result = dialog.open();
        if (result == 0) {
            String n = dialog.getValue();
            diagram.setName(n);
            return true;
        }
        return false;
    }

    public static void setEditorForDiagram(URI uri, String editorID) throws CoreException {
        String part1 = uri.path().replaceFirst("resource", "");
        Path path = new Path(part1);
        ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        if (file != null) {
            file.setPersistentProperty(IDE.EDITOR_KEY, editorID);
            return;
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.uml.diagram.common", "Error setting file property"));
    }

    private static void createInitialElements(Diagram diagram, Map<String, IDiagramInitializer> initializers) {
        String kind;
        if (initializers != null && initializers.containsKey(kind = diagram.getType())) {
            IDiagramInitializer initializer = initializers.get(kind);
            initializer.init(diagram);
        }
    }

    public static Map getSaveOptions() {
        HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("ENCODING", "UTF-8");
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        return saveOptions;
    }

    public static Diagram performDeleteDiagram(Diagram diagram, boolean confirm) {
        MessageDialog confirmDialog;
        int result;
        if (diagram == null) {
            return null;
        }
        Diagram diagramToOpen = MultiDiagramUtil.getUpperDiagram(diagram);
        if ((diagramToOpen == null || diagramToOpen.equals(diagram)) && (diagramToOpen = MultiDiagramUtil.getOtherDiagram(diagram)) == null) {
            return null;
        }
        if (confirm && (result = (confirmDialog = new MessageDialog(Display.getCurrent().getActiveShell(), "Delete diagram?", null, "Are oyu sure you want to delete the selected diagram?", 4, new String[]{"Yes", "No"}, 1)).open()) == 1) {
            return null;
        }
        if (!MultiDiagramUtil.isDiagramActive(diagram)) {
            MultiDiagramUtil.deleteDiagramAndSave(diagram);
        } else {
            EditingDomainRegistry.getInstance().setChangingCachedEditors(true);
            MultiDiagramUtil.closeEditorsThatShowDiagram(diagram);
            MultiDiagramUtil.deleteDiagramAndSave(diagram);
            try {
                try {
                    MultiDiagramUtil.openDiagram(diagramToOpen);
                }
                catch (ExecutionException ex) {
                    Status status = new Status(4, "org.eclipse.papyrus.uml.diagram.common", "Can't open diagram");
                    Activator.getDefault().getLog().log((IStatus)status);
                    EditingDomainRegistry.getInstance().setChangingCachedEditors(false);
                    return null;
                }
            }
            finally {
                EditingDomainRegistry.getInstance().setChangingCachedEditors(false);
            }
        }
        return diagramToOpen;
    }

    public static boolean isDiagramActive(Diagram diagram) {
        Diagram activeDiagram;
        DiagramEditor diagramEditor;
        Diagram activeDiagram2;
        IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        return activeEditor instanceof DiagramEditor ? diagram.equals(activeDiagram2 = (diagramEditor = (DiagramEditor)activeEditor).getDiagram()) : activeEditor != null && (activeDiagram = (Diagram)activeEditor.getAdapter(Diagram.class)) != null && activeDiagram.equals(diagram);
    }

    public static boolean addDiagramAndSave(Diagram diagram, Resource resource) {
        return MultiDiagramUtil.addDiagramAndSave(diagram, resource, true);
    }

    public static boolean addDiagramAndSave(Diagram diagram, Resource resource, boolean save) {
        if (diagram == null || resource == null) {
            return false;
        }
        resource.getContents().add((Object)diagram);
        if (save) {
            try {
                resource.save(MultiDiagramUtil.getSaveOptions());
            }
            catch (IOException ex) {
                Status status = new Status(4, "org.eclipse.papyrus.uml.diagram.common", "Error saving resource");
                Activator.getDefault().getLog().log((IStatus)status);
                return false;
            }
        }
        return true;
    }

    public static boolean deleteDiagramAndSave(Diagram diagram) {
        return MultiDiagramUtil.deleteDiagramAndSave(diagram, true);
    }

    public static boolean deleteDiagramAndSave(Diagram diagram, boolean save) {
        if (diagram != null && diagram.eResource() != null) {
            Resource diagramResource = diagram.eResource();
            MDTUtil.removeLastOpenedDiagramProperty(diagram);
            MDTUtil.removeEditorForDiagramProperty(diagram.eResource().getURI());
            if (!MultiDiagramUtil.deleteDiagramFromResource(diagram, diagram.eResource())) {
                return false;
            }
            if (save) {
                try {
                    diagramResource.save(MultiDiagramUtil.getSaveOptions());
                }
                catch (IOException ex) {
                    Status status = new Status(4, "org.eclipse.papyrus.uml.diagram.common", "Error saving resource");
                    Activator.getDefault().getLog().log((IStatus)status);
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean deleteDiagramFromResource(Diagram diagram, Resource resource) {
        if (diagram == null || resource == null) {
            return false;
        }
        resource.getContents().remove((Object)diagram);
        return !resource.getContents().contains((Object)diagram);
    }

    public static void closeEditorsThatShowDiagram(Diagram diagram) {
        IEditorReference[] editors;
        if (diagram == null) {
            return;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] iEditorReferenceArray = editors = page.getEditorReferences();
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            DiagramEditor diagramEditor;
            Diagram editorDiagram;
            IEditorReference editorReference = iEditorReferenceArray[n2];
            IEditorPart editorPart = editorReference.getEditor(false);
            if (editorPart instanceof DiagramEditor && diagram.equals(editorDiagram = (diagramEditor = (DiagramEditor)editorPart).getDiagram())) {
                page.closeEditor((IEditorPart)diagramEditor, true);
            }
            ++n2;
        }
    }

    public static boolean deleteAndSaveEObjectInResource(URI uri, String fragment) {
        URI resourceURI = uri;
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        Resource resource = resourceSet.getResource(resourceURI, true);
        EObject toDelete = resource.getEObject(fragment);
        if (toDelete != null && resource.getContents().contains((Object)toDelete)) {
            resource.getContents().remove((Object)toDelete);
            try {
                resource.save(MultiDiagramUtil.getSaveOptions());
            }
            catch (IOException e) {
                Log.error(null, (int)0, (String)("Error saving resource " + resource.toString()), (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public static IEditorPart openDiagram(Diagram diagram) throws ExecutionException {
        return MultiDiagramUtil.openDiagram(diagram, false);
    }

    public static IEditorPart openDiagram(Diagram diagram, boolean openInNew) throws ExecutionException {
        MDTUtil.setLastOpenedDiagramProperty(diagram);
        URI uri = diagram.eResource().getURI();
        uri = uri.appendFragment(diagram.eResource().getURIFragment((EObject)diagram));
        String diagramName = MDTUtil.getDiagramName(diagram);
        CachedResourcesEditorInput editorInput = new CachedResourcesEditorInput(uri, diagramName, false, openInNew);
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart activeEditor = page.getActiveEditor();
        EditingDomainRegistry.getInstance().setChangingCachedEditors(true);
        if (!openInNew) {
            page.closeEditor(activeEditor, true);
        }
        try {
            String editorID = MOSKittEditorIDs.getAllExtensionModelToEditor().get(diagram.getType());
            IEditorPart openedEditor = page.openEditor((IEditorInput)editorInput, editorID);
            page.activate((IWorkbenchPart)openedEditor);
            IEditorPart iEditorPart = openedEditor;
            return iEditorPart;
        }
        catch (PartInitException ex) {
            throw new ExecutionException("Can't open diagram", (Throwable)ex);
        }
        finally {
            EditingDomainRegistry.getInstance().setChangingCachedEditors(false);
        }
    }

    protected static boolean checkDiagramForEditor(Diagram diagram, CachedResourcesDiagramEditor editor) {
        String kind = diagram.getType();
        String diagramEditorID = MOSKittEditorIDs.getAllExtensionModelToEditor().get(kind);
        String editorID = editor.getEditorID();
        return diagramEditorID != null && diagramEditorID.equals(editorID);
    }

    public static boolean checkSameResourceForEditorInputs(IEditorInput oldInput, IEditorInput newInput) {
        boolean openInNewEditor = false;
        CachedResourcesEditorInput newCachedEditorInput = null;
        if (newInput instanceof CachedResourcesEditorInput) {
            newCachedEditorInput = (CachedResourcesEditorInput)newInput;
            openInNewEditor = newCachedEditorInput.isOpenInNewEditor();
        }
        if (openInNewEditor) {
            return CachedResourcesEditorInput.checkSameEditorInput(oldInput, (IEditorInput)newCachedEditorInput);
        }
        URI oldUri = URIUtil.getUri(oldInput).trimFragment();
        URI newUri = URIUtil.getUri(newInput).trimFragment();
        if (oldUri != null && newUri != null) {
            return oldUri.equals(newUri);
        }
        return false;
    }

    protected static void closeOtherDiagrams(Diagram diagramToOpen, IWorkbenchPage page, boolean unload) {
        EObject rootEObject = diagramToOpen.getElement();
        if (rootEObject == null) {
            return;
        }
        Resource activeResource = rootEObject.eResource();
        String activeUri = activeResource.getURI().trimFragment().toString();
        IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            String uri;
            IEditorReference editorReference = iEditorReferenceArray[n2];
            IEditorPart editor = editorReference.getEditor(true);
            Resource resource = MDTUtil.getRootElementResource(editor);
            if (resource != null && activeUri.equals(uri = resource.getURI().trimFragment().toString())) {
                editor.doSave((IProgressMonitor)new NullProgressMonitor());
                if (editor instanceof CachedResourcesDiagramEditor) {
                    ((CachedResourcesDiagramEditor)editor).setUnloadOnDispose(unload);
                }
                page.closeEditor(editor, true);
            }
            ++n2;
        }
    }

    public static Diagram getUpperDiagram(Diagram diagram) {
        if (diagram == null) {
            return null;
        }
        EAnnotation eAnnotation = diagram.getEAnnotation(UpperDiagram);
        if (eAnnotation != null && eAnnotation.getReferences().size() > 0 && eAnnotation.getReferences().get(0) instanceof Diagram) {
            return (Diagram)eAnnotation.getReferences().get(0);
        }
        EObject domainElement = diagram.getElement();
        Resource gmfResource = diagram.eResource();
        do {
            for (EObject eObject : gmfResource.getContents()) {
                if (!(eObject instanceof Diagram) || diagram.equals(eObject) || !MultiDiagramUtil.diagramHasElement((Diagram)eObject, domainElement)) continue;
                return (Diagram)eObject;
            }
        } while ((domainElement = domainElement.eContainer()) != null);
        return null;
    }

    public static Diagram getOtherDiagram(Diagram diagram) {
        if (diagram == null) {
            return null;
        }
        EObject domainElement = diagram.getElement();
        Resource gmfResource = diagram.eResource();
        for (EObject eObject : gmfResource.getContents()) {
            Diagram newDiagram;
            if (!(eObject instanceof Diagram) || diagram.equals(newDiagram = (Diagram)eObject) || !domainElement.equals(newDiagram.getElement())) continue;
            return newDiagram;
        }
        domainElement = domainElement.eContainer();
        return null;
    }

    private static boolean diagramHasElement(Diagram diagram, EObject element) {
        TreeIterator iterator = diagram.eAllContents();
        while (iterator.hasNext()) {
            EObject eObject = (EObject)iterator.next();
            if (!(eObject instanceof View) || ((View)eObject).getElement() == null || !((View)eObject).getElement().equals(element)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static void storeOpenDiagrams(List<Diagram> openDiagrams) {
        ArrayList<Resource> affectedResources = new ArrayList<Resource>();
        ArrayList<EObject> affectedEObjects = new ArrayList<EObject>();
        for (EObject eObject : openDiagrams) {
            if (eObject == null || eObject.eResource() == null) continue;
            if (!affectedResources.contains(eObject.eResource())) {
                affectedResources.add(eObject.eResource());
            }
            affectedEObjects.add(eObject);
        }
        String string = "";
        for (Resource resource : affectedResources) {
            void var3_7;
            for (EObject eObject : affectedEObjects) {
                if (eObject.eResource() != resource) continue;
                String string2 = String.valueOf(var3_7) + resource.getURIFragment(eObject) + OpenDiagramsSeparator;
            }
            String path = PathsUtil.fromAbsoluteFileSystemToAbsoluteWorkspace(resource.getURI().toString());
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
            try {
                file.setPersistentProperty(OpenDiagramsFileProperty, (String)var3_7);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            String string3 = "";
        }
    }

    public static List<EObject> getOpenDiagrams(IEditorInput editorInput) {
        ArrayList<EObject> openDiagrams = new ArrayList<EObject>();
        String path = PathsUtil.getRelativeWorkspaceFromEditorInput(editorInput);
        if (path != null) {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
            try {
                String diagramsToOpenProperty = file.getPersistentProperty(OpenDiagramsFileProperty);
                if (diagramsToOpenProperty == null || diagramsToOpenProperty.length() <= 0) {
                    return Collections.emptyList();
                }
                List<String> diagramsToOpen = Arrays.asList(diagramsToOpenProperty.split(OpenDiagramsSeparator));
                if (diagramsToOpen == null || diagramsToOpen.size() <= 0) {
                    return openDiagrams;
                }
                List<EObject> rootEObjects = MDTUtil.getRootElementsFromFile(editorInput);
                Diagram diagram = null;
                for (EObject eObject : rootEObjects) {
                    String fragment;
                    diagram = (Diagram)Platform.getAdapterManager().getAdapter((Object)eObject, Diagram.class);
                    if (diagram == null || diagram.eResource() == null || !diagramsToOpen.contains(fragment = diagram.eResource().getURIFragment((EObject)diagram))) continue;
                    openDiagrams.add((EObject)diagram);
                }
            }
            catch (CoreException ex) {
                return openDiagrams;
            }
        }
        return openDiagrams;
    }
}

