/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.component.part;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tooling.runtime.structure.DiagramStructure;
import org.eclipse.papyrus.uml.diagram.component.part.UMLDiagramEditorPlugin;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLVisualIDRegistry {
    private static final String DEBUG_KEY = "org.eclipse.papyrus.uml.diagram.component/debug/visualID";
    public static final DiagramStructure TYPED_INSTANCE = new DiagramStructure(){

        public int getVisualID(View view) {
            return UMLVisualIDRegistry.getVisualID(view);
        }

        public String getModelID(View view) {
            return UMLVisualIDRegistry.getModelID(view);
        }

        public int getNodeVisualID(View containerView, EObject domainElement) {
            return UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        }

        public boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
            return UMLVisualIDRegistry.checkNodeVisualID(containerView, domainElement, candidate);
        }

        public boolean isCompartmentVisualID(int visualID) {
            return UMLVisualIDRegistry.isCompartmentVisualID(visualID);
        }

        public boolean isSemanticLeafVisualID(int visualID) {
            return UMLVisualIDRegistry.isSemanticLeafVisualID(visualID);
        }
    };

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("PapyrusUMLComponentDiagram".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return UMLVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException e) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                UMLDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return Integer.toString(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass()) && UMLVisualIDRegistry.isDiagram((Package)domainElement)) {
            return 1000;
        }
        if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
            return 1000;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"PapyrusUMLComponentDiagram".equals(containerModelID)) {
            return -1;
        }
        if ("PapyrusUMLComponentDiagram".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 1000: {
                if (UMLPackage.eINSTANCE.getDependency().isSuperTypeOf(domainElement.eClass())) {
                    return 3203;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 2002;
                }
                if (UMLPackage.eINSTANCE.getModel().isSuperTypeOf(domainElement.eClass())) {
                    return 3202;
                }
                if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                    return 3200;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 2003;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3201;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3199;
                }
                if (!UMLPackage.eINSTANCE.getNamedElement().isSuperTypeOf(domainElement.eClass())) break;
                return 3204;
            }
            case 2002: {
                if (!UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) break;
                return 3069;
            }
            case 3070: {
                if (!UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) break;
                return 3069;
            }
            case 3071: {
                if (!UMLPackage.eINSTANCE.getPort().isSuperTypeOf(domainElement.eClass())) break;
                return 3069;
            }
            case 7001: {
                if (!UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) break;
                return 3070;
            }
            case 7006: {
                if (UMLPackage.eINSTANCE.getModel().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3075;
            }
            case 7002: {
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) {
                    return 3075;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getModel().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (!UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) break;
                return 3076;
            }
            case 7007: {
                if (UMLPackage.eINSTANCE.getModel().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3075;
            }
            case 7005: {
                if (UMLPackage.eINSTANCE.getModel().isSuperTypeOf(domainElement.eClass())) {
                    return 3077;
                }
                if (UMLPackage.eINSTANCE.getPackage().isSuperTypeOf(domainElement.eClass())) {
                    return 3076;
                }
                if (UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) {
                    return 3071;
                }
                if (UMLPackage.eINSTANCE.getInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 3072;
                }
                if (UMLPackage.eINSTANCE.getComment().isSuperTypeOf(domainElement.eClass())) {
                    return 3074;
                }
                if (!UMLPackage.eINSTANCE.getConstraint().isSuperTypeOf(domainElement.eClass())) break;
                return 3075;
            }
            case 7003: {
                if (!UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) break;
                return 3070;
            }
            case 7004: {
                if (!UMLPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) break;
                return 3070;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = UMLVisualIDRegistry.getModelID(containerView);
        if (!"PapyrusUMLComponentDiagram".equals(containerModelID)) {
            return false;
        }
        if ("PapyrusUMLComponentDiagram".equals(containerModelID)) {
            containerVisualID = UMLVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 1000: {
                if (3203 == nodeVisualID) {
                    return true;
                }
                if (2002 == nodeVisualID) {
                    return true;
                }
                if (3202 == nodeVisualID) {
                    return true;
                }
                if (3200 == nodeVisualID) {
                    return true;
                }
                if (2003 == nodeVisualID) {
                    return true;
                }
                if (3201 == nodeVisualID) {
                    return true;
                }
                if (3199 == nodeVisualID) {
                    return true;
                }
                if (3204 != nodeVisualID) break;
                return true;
            }
            case 3203: {
                if (5008 != nodeVisualID) break;
                return true;
            }
            case 2002: {
                if (5004 == nodeVisualID) {
                    return true;
                }
                if (7001 == nodeVisualID) {
                    return true;
                }
                if (3069 != nodeVisualID) break;
                return true;
            }
            case 3202: {
                if (5262 == nodeVisualID) {
                    return true;
                }
                if (7006 != nodeVisualID) break;
                return true;
            }
            case 3200: {
                if (5254 == nodeVisualID) {
                    return true;
                }
                if (7002 != nodeVisualID) break;
                return true;
            }
            case 2003: {
                if (5005 != nodeVisualID) break;
                return true;
            }
            case 3201: {
                if (5255 != nodeVisualID) break;
                return true;
            }
            case 3199: {
                if (5252 == nodeVisualID) {
                    return true;
                }
                if (5253 != nodeVisualID) break;
                return true;
            }
            case 3204: {
                if (5265 != nodeVisualID) break;
                return true;
            }
            case 3069: {
                if (5006 == nodeVisualID) {
                    return true;
                }
                if (5007 != nodeVisualID) break;
                return true;
            }
            case 3077: {
                if (5264 == nodeVisualID) {
                    return true;
                }
                if (7007 != nodeVisualID) break;
                return true;
            }
            case 3076: {
                if (5261 == nodeVisualID) {
                    return true;
                }
                if (7005 != nodeVisualID) break;
                return true;
            }
            case 3070: {
                if (5256 == nodeVisualID) {
                    return true;
                }
                if (7003 == nodeVisualID) {
                    return true;
                }
                if (3069 != nodeVisualID) break;
                return true;
            }
            case 3071: {
                if (5257 == nodeVisualID) {
                    return true;
                }
                if (7004 == nodeVisualID) {
                    return true;
                }
                if (3069 != nodeVisualID) break;
                return true;
            }
            case 3072: {
                if (nodeVisualID != 0) break;
                return true;
            }
            case 3074: {
                if (5258 != nodeVisualID) break;
                return true;
            }
            case 3075: {
                if (5259 == nodeVisualID) {
                    return true;
                }
                if (5260 != nodeVisualID) break;
                return true;
            }
            case 7001: {
                if (3070 != nodeVisualID) break;
                return true;
            }
            case 7006: {
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 != nodeVisualID) break;
                return true;
            }
            case 7002: {
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3076 != nodeVisualID) break;
                return true;
            }
            case 7007: {
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 != nodeVisualID) break;
                return true;
            }
            case 7005: {
                if (3077 == nodeVisualID) {
                    return true;
                }
                if (3076 == nodeVisualID) {
                    return true;
                }
                if (3071 == nodeVisualID) {
                    return true;
                }
                if (3072 == nodeVisualID) {
                    return true;
                }
                if (3074 == nodeVisualID) {
                    return true;
                }
                if (3075 != nodeVisualID) break;
                return true;
            }
            case 7003: {
                if (3070 != nodeVisualID) break;
                return true;
            }
            case 7004: {
                if (3070 != nodeVisualID) break;
                return true;
            }
            case 4003: {
                if (2 != nodeVisualID) break;
                return true;
            }
            case 4012: {
                if (6006 == nodeVisualID) {
                    return true;
                }
                if (6020 != nodeVisualID) break;
                return true;
            }
            case 4014: {
                if (6008 == nodeVisualID) {
                    return true;
                }
                if (6022 != nodeVisualID) break;
                return true;
            }
            case 4007: {
                if (3 == nodeVisualID) {
                    return true;
                }
                if (4 != nodeVisualID) break;
                return true;
            }
            case 4013: {
                if (6007 == nodeVisualID) {
                    return true;
                }
                if (6021 != nodeVisualID) break;
                return true;
            }
            case 4010: {
                if (6009 == nodeVisualID) {
                    return true;
                }
                if (6023 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (UMLPackage.eINSTANCE.getUsage().isSuperTypeOf(domainElement.eClass())) {
            return 4001;
        }
        if (UMLPackage.eINSTANCE.getInterfaceRealization().isSuperTypeOf(domainElement.eClass())) {
            return 4006;
        }
        if (UMLPackage.eINSTANCE.getGeneralization().isSuperTypeOf(domainElement.eClass())) {
            return 4003;
        }
        if (UMLPackage.eINSTANCE.getSubstitution().isSuperTypeOf(domainElement.eClass())) {
            return 4012;
        }
        if (UMLPackage.eINSTANCE.getManifestation().isSuperTypeOf(domainElement.eClass())) {
            return 4014;
        }
        if (UMLPackage.eINSTANCE.getComponentRealization().isSuperTypeOf(domainElement.eClass())) {
            return 4007;
        }
        if (UMLPackage.eINSTANCE.getAbstraction().isSuperTypeOf(domainElement.eClass())) {
            return 4013;
        }
        if (UMLPackage.eINSTANCE.getDependency().isSuperTypeOf(domainElement.eClass())) {
            return 4010;
        }
        if (UMLPackage.eINSTANCE.getDependency().isSuperTypeOf(domainElement.eClass())) {
            return 4017;
        }
        return -1;
    }

    private static boolean isDiagram(Package element) {
        return true;
    }

    public static boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
        if (candidate == -1) {
            return false;
        }
        int basic = UMLVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        return basic == candidate;
    }

    public static boolean isCompartmentVisualID(int visualID) {
        switch (visualID) {
            case 7001: 
            case 7002: 
            case 7003: 
            case 7004: 
            case 7005: 
            case 7006: 
            case 7007: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSemanticLeafVisualID(int visualID) {
        switch (visualID) {
            case 1000: {
                return false;
            }
            case 2003: 
            case 3069: 
            case 3072: 
            case 3074: 
            case 3075: 
            case 3199: 
            case 3201: 
            case 3203: 
            case 3204: {
                return true;
            }
        }
        return false;
    }
}

