/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.menu.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.util.DisplayUtils;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.EditPartService;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.uml.diagram.common.commands.ShowHideLabelsRequest;
import org.eclipse.papyrus.uml.diagram.common.editparts.ILabelRoleProvider;
import org.eclipse.papyrus.uml.diagram.common.util.DiagramEditPartsUtil;
import org.eclipse.papyrus.uml.diagram.menu.actions.AbstractGraphicalParametricAction;
import org.eclipse.papyrus.uml.diagram.menu.dialogs.ShowHideLabelSelectionDialog;
import org.eclipse.papyrus.uml.diagram.menu.messages.Messages;
import org.eclipse.papyrus.uml.tools.providers.UMLLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShowHideLabelsAction
extends AbstractGraphicalParametricAction {
    public static final String MANAGE_PARAMETER = "manage";
    public static final String HIDE_PARAMETER = "hide";
    public static final String SHOW_PARAMETER = "show";

    public ShowHideLabelsAction(String parameter, List<IGraphicalEditPart> selectedEditPart) {
        super(parameter, selectedEditPart);
    }

    @Override
    protected Command getBuildedCommand() {
        List<IGraphicalEditPart> selections = this.getSelection();
        CompoundCommand cmd = new CompoundCommand("ShowHideConnectionLabelCommand");
        if (!selections.isEmpty()) {
            if (this.getParameter().equals(MANAGE_PARAMETER)) {
                ManageLabelsAction action = new ManageLabelsAction(Messages.ShowHideConnectionLabelsAction_LabelsManager, Messages.ShowHideConnectionLabelsAction_SelectTheLabelToDisplay, this.getSelection());
                cmd.add(action.getActionCommand());
            } else {
                ContentProvider provider = new ContentProvider(DiagramEditPartsUtil.getDiagramEditPart((EditPart)((EditPart)selections.get(0))));
                for (IGraphicalEditPart current : selections) {
                    Object[] children;
                    Object[] objectArray = children = provider.getChildren(current);
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object currentObj = objectArray[n2];
                        if (currentObj instanceof View) {
                            Command tmp;
                            ShowHideLabelsRequest request = null;
                            if (this.getParameter().equals(HIDE_PARAMETER)) {
                                request = new ShowHideLabelsRequest(false, (View)currentObj);
                            } else if (this.getParameter().equals(SHOW_PARAMETER)) {
                                request = new ShowHideLabelsRequest(true, (View)currentObj);
                            }
                            if (request != null && (tmp = current.getCommand((Request)request)) != null) {
                                cmd.add(tmp);
                            }
                        }
                        ++n2;
                    }
                }
            }
        }
        return cmd.canExecute() && !cmd.isEmpty() ? cmd : UnexecutableCommand.INSTANCE;
    }

    protected List<ConnectionEditPart> getConnections() {
        ArrayList<ConnectionEditPart> connections = new ArrayList<ConnectionEditPart>();
        for (IGraphicalEditPart current : this.getSelection()) {
            if (current instanceof DiagramEditPart && this.getSelection().size() == 1) {
                connections.addAll(((DiagramEditPart)current).getConnections());
                break;
            }
            if (!(current instanceof ConnectionEditPart)) continue;
            connections.add((ConnectionEditPart)current);
        }
        return connections;
    }

    protected boolean isLabelView(EditPart containerEditPart, View parentView, View view) {
        if ((containerEditPart instanceof ShapeNodeEditPart || containerEditPart instanceof ConnectionEditPart) && view instanceof Node) {
            LayoutConstraint lContraint;
            Node node = (Node)view;
            String nodeType = node.getType();
            if (!this.isCompartment(node) && nodeType != null && nodeType.length() > 0 && (lContraint = node.getLayoutConstraint()) instanceof Location) {
                return true;
            }
        }
        return false;
    }

    protected boolean isCompartment(Node node) {
        return node.getStyle(NotationPackage.eINSTANCE.getDrawerStyle()) != null;
    }

    @Override
    public List<IGraphicalEditPart> getSelection() {
        List<IGraphicalEditPart> selection = super.getSelection();
        ArrayList delete = new ArrayList();
        Iterator<IGraphicalEditPart> iter = selection.iterator();
        selection.removeAll(delete);
        return selection;
    }

    protected class ContentProvider
    implements ITreeContentProvider {
        private DiagramEditPart diagramEP;

        public ContentProvider(DiagramEditPart diagramEP) {
            this.diagramEP = diagramEP;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            ArrayList<View> children = new ArrayList<View>();
            if (parentElement instanceof EditPart) {
                View model = (View)((EditPart)parentElement).getModel();
                for (View childView : model.getChildren()) {
                    if (!ShowHideLabelsAction.this.isLabelView((EditPart)parentElement, model, childView)) continue;
                    children.add(childView);
                }
            }
            Collections.sort(children, new LabelRoleComparator());
            return children.toArray();
        }

        public Object getParent(Object element) {
            if (element instanceof View) {
                EditPart part = DiagramEditPartsUtil.getEditPartFromView((View)((View)element), (EditPart)this.diagramEP);
                return part.getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            Object[] children = this.getChildren(element);
            return children != null && children.length != 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class LabelRoleComparator
    implements Comparator<View> {
        @Override
        public int compare(View o1, View o2) {
            IGraphicalEditPart ep1 = EditPartService.getInstance().createGraphicEditPart(o1);
            IGraphicalEditPart ep2 = EditPartService.getInstance().createGraphicEditPart(o2);
            if (ep1 instanceof ILabelRoleProvider && ep2 instanceof ILabelRoleProvider) {
                String role1 = ((ILabelRoleProvider)ep1).getLabelRole();
                String role2 = ((ILabelRoleProvider)ep2).getLabelRole();
                return role1.compareToIgnoreCase(role2);
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ManageLabelsAction {
        protected Map<View, Boolean> viewStatus = new HashMap<View, Boolean>();
        private String title;
        private String message;
        private List<IGraphicalEditPart> editparts;

        public ManageLabelsAction(String title, String message, List<IGraphicalEditPart> editparts) {
            this.title = title;
            this.message = message;
            this.editparts = editparts;
            this.initMap();
        }

        protected Command getActionCommand() {
            CompoundCommand cmd = new CompoundCommand("Manage Conection Labels ");
            DiagramEditPart diagramEP = DiagramEditPartsUtil.getDiagramEditPart((EditPart)((EditPart)this.editparts.get(0)));
            ShowHideLabelSelectionDialog selectionDialog = new ShowHideLabelSelectionDialog(DisplayUtils.getDisplay().getActiveShell(), (ILabelProvider)new UMLLabelProvider(), new ContentProvider(diagramEP));
            selectionDialog.setTitle(this.title);
            selectionDialog.setMessage(this.message);
            selectionDialog.setContainerMode(true);
            selectionDialog.setInput(this.editparts);
            selectionDialog.setExpandedElements(this.editparts.toArray());
            selectionDialog.setInitialElementSelections(this.getInitialSelection());
            selectionDialog.open();
            if (selectionDialog.getReturnCode() == 0) {
                Object[] userSelection;
                Object[] objectArray = userSelection = selectionDialog.getResult();
                int n = userSelection.length;
                int n2 = 0;
                while (n2 < n) {
                    Object current = objectArray[n2];
                    if (!(current instanceof EditPart) && current instanceof View) {
                        this.viewStatus.put((View)current, new Boolean(true));
                    }
                    ++n2;
                }
                for (View view : this.viewStatus.keySet()) {
                    boolean newStatus;
                    boolean oldStatus = view.isVisible();
                    if (oldStatus == (newStatus = this.viewStatus.get(view).booleanValue())) continue;
                    if (oldStatus) {
                        EditPart ep = DiagramEditPartsUtil.getEditPartFromView((View)view, (EditPart)((EditPart)ShowHideLabelsAction.this.getSelection().get(0)));
                        int dummy = 0;
                        ++dummy;
                    }
                    ShowHideLabelsRequest request = new ShowHideLabelsRequest(newStatus, view);
                    EditPart ep = DiagramEditPartsUtil.getEditPartFromView((View)view, (EditPart)((EditPart)ShowHideLabelsAction.this.getSelection().get(0)));
                    Command command = ep.getParent().getCommand((Request)request);
                    if (command == null) continue;
                    cmd.add(command);
                }
                return cmd;
            }
            return UnexecutableCommand.INSTANCE;
        }

        public List<View> getInitialSelection() {
            ArrayList<View> selection = new ArrayList<View>();
            for (IGraphicalEditPart current : ShowHideLabelsAction.this.getSelection()) {
                View model = (View)current.getModel();
                for (View childView : model.getChildren()) {
                    if (!ShowHideLabelsAction.this.isLabelView((EditPart)current, model, childView) || !childView.isVisible()) continue;
                    selection.add(childView);
                }
            }
            return selection;
        }

        public void initMap() {
            this.viewStatus.clear();
            for (EditPart editPart : ShowHideLabelsAction.this.getSelection()) {
                View model = (View)((IGraphicalEditPart)editPart).getModel();
                for (View childView : model.getChildren()) {
                    if (!ShowHideLabelsAction.this.isLabelView(editPart, model, childView)) continue;
                    this.viewStatus.put(childView, new Boolean(false));
                }
            }
        }
    }
}

