/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.modelexplorer.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.papyrus.views.modelexplorer.ModelExplorerPageBookView;
import org.eclipse.papyrus.views.modelexplorer.NavigatorUtils;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.internal.navigator.filters.UpdateActiveExtensionsOperation;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.INavigatorContentService;

public class DiagramViewHandler
extends AbstractHandler {
    public static final String DIAGRAM_CONTENTS = "org.eclipse.papyrus.views.modelexplorer.DiagramNavigatorContent";
    public static final String UML_MODEL_CONTENTS = "org.eclipse.papyrus.views.modelexplorer.UMLnavigatorContent";

    protected CommonNavigator getCommonNavigator() {
        IViewPart page;
        IViewPart part = NavigatorUtils.findViewPart((String)"org.eclipse.papyrus.views.modelexplorer.modelexplorer");
        if (part instanceof ModelExplorerPageBookView && (page = ((ModelExplorerPageBookView)part).getActiveView()) instanceof CommonNavigator) {
            return (CommonNavigator)page;
        }
        return null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.getCommonNavigator() == null || this.getCommonNavigator().getCommonViewer() == null) {
            return null;
        }
        CommonViewer viewer = this.getCommonNavigator().getCommonViewer();
        String[] newContents = null;
        Object trigger = event.getTrigger();
        if (trigger instanceof Event) {
            Event triggerEvent = (Event)trigger;
            if (triggerEvent.widget instanceof ToolItem) {
                newContents = ((ToolItem)triggerEvent.widget).getSelection() ? new String[]{DIAGRAM_CONTENTS} : new String[]{UML_MODEL_CONTENTS};
            }
        }
        if (newContents == null) {
            INavigatorContentService navigatorContent = viewer.getNavigatorContentService();
            newContents = navigatorContent.isActive(DIAGRAM_CONTENTS) ? new String[]{UML_MODEL_CONTENTS} : new String[]{DIAGRAM_CONTENTS};
        }
        UpdateActiveExtensionsOperation updateExtensions = new UpdateActiveExtensionsOperation(viewer, newContents);
        updateExtensions.execute(null, null);
        return null;
    }
}

